<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Banner_Two extends Widget_Base {

    public function get_name() {
        return 'banner-two';
    }

    public function get_title() {
        return 'Banner Two';   // title to show on chariton
    }

    public function get_icon() {
        return 'fal fa-address-card'; // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
    }

    public function get_categories() {
        return [ 'chariton-elements' ];    // category of the widget
    }

    /**
     * A list of scripts that the widgets is depended in
     * @since 1.3.0
     **/

    protected function register_controls() {
        
        //start of a control box
        $this->start_controls_section(
            'section_banner_content',
            [
                'label' => esc_html__( 'Banner Content', 'chariton' ),   //section name for controler view
            ]
        );

        $this->add_control(
            'banner_bg_img',
            [
                'label' => esc_html__( 'Banner Background', 'chariton' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'banner_title',
            [
                'label' => esc_html__( 'Banner Title', 'chariton' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Need A Home For Homeless', 'chariton'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_sub_title',
            [
                'label' => esc_html__( 'Banner Sub Title', 'chariton' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Make An Impact', 'chariton'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_description',
            [
                'label' => esc_html__( 'Banner Description', 'chariton' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'We seek out world changers and difference makers around the globe, and equip them to fulfill their unique purpose.', 'chariton'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_btn1_text',
            [
                'label' => esc_html__( 'Button One Text', 'chariton' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Read More', 'chariton'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_btn1_link',
            [
                'label' => __( 'Button One Link', 'chariton' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'chariton' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'banner_btn2_text',
            [
                'label' => esc_html__( 'Button Two Text', 'chariton' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Our Approach', 'chariton'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_btn2_link',
            [
                'label' => __( 'Button Two Link', 'chariton' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'chariton' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->end_controls_section();
        //End of a control box

        $this->start_controls_section(
            'banner_title_style',
            [
                'label' => esc_html__( 'Title Style', 'chariton' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'banner_title_color',
            [
                'label' => __( 'Title Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .s-slider-content h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'banner_title_typography',
                'label' => __( 'Title Typography', 'chariton' ),
                'selector' => '{{WRAPPER}} .s-slider-content h2',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'banner_sub_title_style',
            [
                'label' => esc_html__( 'Sub Title Style', 'chariton' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'sub_title_background_color',
            [
                'label' => __( 'Background Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#00ffa8',
                'selectors' => [
                    '{{WRAPPER}} .s-slider-content h6 span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'sub_title_text_color',
            [
                'label' => __( 'Title Text Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#00ffa8',
                'selectors' => [
                    '{{WRAPPER}} .s-slider-content h6' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'banner_sub_title_typography',
                'label'    => __( 'Typography', 'chariton' ),
                'selector' => '{{WRAPPER}} .s-slider-content h6',
            ]
        );

        $this->end_controls_section();

        // Contact
        $this->start_controls_section(
            'banner_content_style',
            [
                'label' => esc_html__( 'Content Style', 'chariton' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'banner_content_color',
            [
                'label' => __( 'Content Text Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .s-slider-content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Button One Style
        $this->start_controls_section(
            'button_one_style',
            [
                'label' => esc_html__( 'Button One Style', 'chariton' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'button1_bg_color',
            [
                'label' => __( 'Background Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#a50042',
                'selectors' => [
                    '{{WRAPPER}} .slider-area .slider-btn a.a-btn' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button1_text_color',
            [
                'label' => __( 'Text Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .slider-area .slider-btn a.a-btn' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->end_controls_section();

        // Button Two Style
        $this->start_controls_section(
            'button_two_style',
            [
                'label' => esc_html__( 'Button Two Style', 'chariton' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'button2_bg_color',
            [
                'label' => __( 'Background Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .slider-area .slider-btn a.a-btn.transparent-btn' => 'background: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_control(
            'button2_bg_border_color',
            [
                'label' => __( 'Border Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .slider-area .slider-btn a.a-btn.transparent-btn' => 'border-color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_control(
            'button2_text_color',
            [
                'label' => __( 'Text Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .slider-area .slider-btn a.a-btn.transparent-btn' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_control(
            'button2_hover_bg_color',
            [
                'label' => __( 'Hover Background Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#a50042',
                'selectors' => [
                    '{{WRAPPER}} .slider-area .slider-btn a.a-btn.transparent-btn:hover' => 'background: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_control(
            'button2_hover_border_color',
            [
                'label' => __( 'Hover Border Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#a50042',
                'selectors' => [
                    '{{WRAPPER}} .slider-area .slider-btn a.a-btn.transparent-btn:hover' => 'border-color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_control(
            'button2_hover_text_color',
            [
                'label' => __( 'Hover Text Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .slider-area .slider-btn a.a-btn.transparent-btn:hover' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        
        $this->end_controls_section();

    }
    //end of control box 

    //to show on the fontend
    protected function render() {
        // Get settings for display
        $settings = $this->get_settings_for_display();

        // Prepare button attributes for Button 1
        $target1 = $settings['banner_btn1_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow1 = $settings['banner_btn1_link']['nofollow'] ? ' rel="nofollow"' : '';

        // Prepare button attributes for Button 2
        $target2 = $settings['banner_btn2_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow2 = $settings['banner_btn2_link']['nofollow'] ? ' rel="nofollow"' : '';

        // Random ID for potential dynamic content (can be used for JS or other needs)
        $randID = wp_rand();
        ?>

        <!-- Slider Section -->
        <section class="slider-area s-slider-bg slider-dark-overlay d-flex align-items-center" style="background-image:url(<?php echo esc_url($settings['banner_bg_img']['url']); ?>)">
            <div class="container">
                <div class="s-slider-overflow-x fix">
                    <div class="row">
                        <div class="col-xl-6 col-lg-8">
                            <div class="s-slider-content two">
                                <!-- Subtitle -->
                                <h6 class="wow fadeInUp" data-wow-delay=".3s">
                                    <span></span><?php echo esc_html($settings['banner_sub_title']); ?>
                                </h6>

                                <!-- Main Title -->
                                <h2 class="wow fadeInUp" data-wow-delay=".6s">
                                    <?php echo esc_html($settings['banner_title']); ?>
                                </h2>

                                <!-- Description (if available) -->
                                <?php if (!empty($settings['banner_description'])) { ?>
                                    <p class="wow fadeInUp" data-wow-delay="1s">
                                        <?php echo esc_html($settings['banner_description']); ?>
                                    </p>
                                <?php } ?>

                                <!-- Buttons -->
                                <?php if (!empty($settings['banner_btn1_link']['url']) || !empty($settings['banner_btn2_link']['url'])) { ?>
                                    <div class="slider-btn">
                                        <!-- Button 1 -->
                                        <?php if (!empty($settings['banner_btn1_link']['url'])) { ?>
                                            <a class="btn a-btn wow fadeInLeft" data-wow-delay=".8s" href="<?php echo esc_url($settings['banner_btn1_link']['url']); ?>" <?php echo $target1; ?> <?php echo $nofollow1; ?>>
                                                <?php echo esc_html($settings['banner_btn1_text']); ?>
                                            </a>
                                        <?php } ?>

                                        <!-- Button 2 -->
                                        <?php if (!empty($settings['banner_btn2_link']['url'])) { ?>
                                            <a class="btn a-btn transparent-btn wow fadeInRight" data-wow-delay=".8s" href="<?php echo esc_url($settings['banner_btn2_link']['url']); ?>" <?php echo $target2; ?> <?php echo $nofollow2; ?>>
                                                <?php echo esc_html($settings['banner_btn2_text']); ?>
                                            </a>
                                        <?php } ?>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <?php
    }

    protected function content_template() {
        ?>
        <#
        // Get settings for live preview
        var settings = settings;
        
        // Prepare button attributes for Button 1
        var target1 = settings.banner_btn1_link.is_external ? ' target="_blank"' : '';
        var nofollow1 = settings.banner_btn1_link.nofollow ? ' rel="nofollow"' : '';

        // Prepare button attributes for Button 2
        var target2 = settings.banner_btn2_link.is_external ? ' target="_blank"' : '';
        var nofollow2 = settings.banner_btn2_link.nofollow ? ' rel="nofollow"' : '';

        #>

        <!-- Slider Section -->
        <section class="slider-area s-slider-bg slider-dark-overlay d-flex align-items-center" style="background-image:url({{ settings.banner_bg_img.url }})">
            <div class="container">
                <div class="s-slider-overflow-x fix">
                    <div class="row">
                        <div class="col-xl-6 col-lg-8">
                            <div class="s-slider-content two">
                                <!-- Subtitle -->
                                <h6 class="wow fadeInUp" data-wow-delay=".3s">
                                    <span></span>{{{ settings.banner_sub_title }}}
                                </h6>

                                <!-- Main Title -->
                                <h2 class="wow fadeInUp" data-wow-delay=".6s">
                                    {{{ settings.banner_title }}}
                                </h2>

                                <!-- Description (if available) -->
                                <# if ( settings.banner_description ) { #>
                                    <p class="wow fadeInUp" data-wow-delay="1s">
                                        {{{ settings.banner_description }}}
                                    </p>
                                <# } #>

                                <!-- Buttons -->
                                <# if ( settings.banner_btn1_link.url || settings.banner_btn2_link.url ) { #>
                                    <div class="slider-btn">
                                        <!-- Button 1 -->
                                        <# if ( settings.banner_btn1_link.url ) { #>
                                            <a class="btn a-btn wow fadeInLeft" data-wow-delay=".8s" href="{{ settings.banner_btn1_link.url }}" {{ target1 }} {{ nofollow1 }}>
                                                {{{ settings.banner_btn1_text }}}
                                            </a>
                                        <# } #>

                                        <!-- Button 2 -->
                                        <# if ( settings.banner_btn2_link.url ) { #>
                                            <a class="btn a-btn transparent-btn wow fadeInRight" data-wow-delay=".8s" href="{{ settings.banner_btn2_link.url }}" {{ target2 }} {{ nofollow2 }}>
                                                {{{ settings.banner_btn2_text }}}
                                            </a>
                                        <# } #>
                                    </div>
                                <# } #>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <?php
    }

}