<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Call_Action extends Widget_Base {

	public function get_name() {
		return 'callaction-button';
	}

	public function get_title() {
		return 'Call to Action'; // title to show on chariton
	}

	public function get_icon() {
		return 'eicon-image-rollover'; // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ]; // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Call to Action', 'chariton' ),   //section name for controler view
			]
		);

		$this->add_control(
			'item_img',
			[
				'label' => esc_html__( 'Upload Background Image', 'chariton' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'item_title',
			[
				'label' => esc_html__( 'Title', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Join Art Workshop 2023', 'chariton'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'item_sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'chariton' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => __( 'There are many variations of passages of Lorem Ipsum available but the majority have suffered alteration in that some form by injected humour even slightly believable.', 'chariton'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'item_btn_title',
			[
				'label' => esc_html__( 'Button Text', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Buy Ticket', 'chariton'),
				'label_block' => true,			
			]
		);
		
		$this->add_control(
			'item_btn_link',
			[
				'label' => esc_html__( 'Button One link', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => '#',
			]
		);

		$this->add_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'chariton' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'chariton' ),
						'icon' => 'fa fa-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'chariton' ),
						'icon' => 'fa fa-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'chariton' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'text-center',
				'condition' => [
					'calltoaction_version' => '1',
				],	
				'toggle' => true,
			]
		);
		
		$this->end_controls_section();
		//End  of a control box

		/* = Item Styling
		========================================*/
		$this->start_controls_section(
			'item_title_style',
			[
				'label' => esc_html__( 'Title Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs( 'tabs_title_style' );

		$this->add_responsive_control(
			'title_color',
			[
				'label' => __( 'Title color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#001d67',
				'selectors' => [
					'{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
				],
				'condition' => [
					'calltoaction_version' => '1',
				],	
			]
		);

		$this->add_responsive_control(
			'item_twobg_color',
			[
				'label' => __( 'Item Background Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#f9f9f9',
				'selectors' => [
					'{{WRAPPER}} .advice-call-area .free-quote-wrap' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'calltoaction_version' => '2',
				],	
			]
		);

		$this->add_responsive_control(
			'title_two_color',
			[
				'label' => __( 'Title color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#d53863',
				'selectors' => [
					'{{WRAPPER}} .advice-call-area .free-quote-content h2' => 'color: {{VALUE}};',
				],
				'condition' => [
					'calltoaction_version' => '2',
				],	
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .section-title h2',
				'condition' => [
					'calltoaction_version' => '1',
				],	
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_two_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .advice-call-area .free-quote-content h2',
				'condition' => [
					'calltoaction_version' => '2',
				],					
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		/* = Item Styling
		========================================*/
		$this->start_controls_section(
			'item_subtitle_style',
			[
				'label' => esc_html__( 'Sub Title Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs( 'tabs_subtitle_style' );

		$this->add_responsive_control(
			'subtitle_color',
			[
				'label' => __( 'Sub Title Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#d53863',
				'selectors' => [
					'{{WRAPPER}} .cta-inner-wrap .section-title h6.sub-title' => 'color: {{VALUE}};',
				],
				'condition' => [
					'calltoaction_version' => '1',
				],	
			]
		);

		$this->add_responsive_control(
			'subtitle_two_color',
			[
				'label' => __( 'Sub Title Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#0a174c',
				'selectors' => [
					'{{WRAPPER}} .advice-call-area .free-quote-content h6' => 'color: {{VALUE}};',
				],
				'condition' => [
					'calltoaction_version' => '2',
				],	
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .cta-inner-wrap .section-title h6.sub-title',
				'condition' => [
					'calltoaction_version' => '1',
				],	
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_two_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .advice-call-area .free-quote-content h6',
				'condition' => [
					'calltoaction_version' => '2',
				],	
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}
	//end of control box 

	//to show on the fontend
	protected function render() { 
		$settings = $this->get_settings_for_display();
		?>
        <section class="join-area join-bg" style="background-image:url(<?php echo $settings['item_img']['url']; ?>)">
            <div class="container">
                <div class="row">
                    <div class="col-xl-8 offset-xl-2 col-lg-10 offset-lg-1 text-center">
                        <div class="join-title mb-50">
                            <h2>Join Art Workshop 2019</h2>
                            <p>There are many variations of passages of Lorem Ipsum available but the majority have suffered alteration in that some
                            form by injected humour even slightly believable.</p>
                        </div>
                        <div class="join-btn">
                            <a href="#" class="btn">Buy Ticket</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
	<?php
	}
}