<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Image_Box_Items_Two extends Widget_Base {

	public function get_name() {
		return 'image-box-items-two';
	}

	public function get_title() {
		return 'Image Box Two';   // title to show on chariton
	}

	public function get_icon() {
		return 'eicon-info-box';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Image Box Two', 'chariton' ),   //section name for controler view
			]
		);

		$this->add_control(
			'box_columns',
			[
			    'label'       => __( 'Select columns', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '4',
			    'options' => [
			     	'6'   => __( '2', 'chariton' ),
			     	'4'   => __( '3', 'chariton' ),
			     	'3'   => __( '4', 'chariton' ),
			    ],
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'box_icon',
			[
				'label' => esc_html__( 'Box Icon', 'chariton' ),
				'type' => Controls_Manager::ICON,
				'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'box_title',
			[
				'label' => esc_html__( 'Box Title', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Box Item Title', 'chariton' ),
			]
		);

		$repeater->add_control(
			'box_desc',
			[
				'label' => esc_html__( 'Box Description', 'chariton' ),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default' => __( 'Box Item Description', 'chariton' ),
			]
		);

		$repeater->add_control(
			'box_btn_text',
			[
				'label' => esc_html__( 'Box Button Text', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Know More', 'chariton' ),
			]
		);

		$repeater->add_control(
			'box_btn_link',
			[
				'label' => __( 'Box Button Link', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'default' => '#',
				'label_block' => true,
			]
		);

		$this->add_control(
			'image_box_items',
			[
				'label' => __( 'Add Items', 'chariton' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ box_title }}}',
			]
		);
		
		$this->end_controls_section();

		//End  of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_style_normal',
			[
				'label' => __( 'Normal State', 'chariton' ),
			]
		);

		$this->add_responsive_control(
			'text_box_bg_color',
			[
				'label' => __( 'Box Background Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .single-features-wrap' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_box_title_color',
			[
				'label' => __( 'Box Title Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#242424',
				'selectors' => [
					'{{WRAPPER}} .single-features-wrap .sf-content h5' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_box_desc_color',
			[
				'label' => __( 'Box Description Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#5b7d9a',
				'selectors' => [
					'{{WRAPPER}} .single-features-wrap .sf-content p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_box_icon_color',
			[
				'label' => __( 'Box Icon Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#7f7f7f',
				'selectors' => [
					'{{WRAPPER}} .single-features-wrap .features-icon i:before' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_box_btnbg_color',
			[
				'label' => __( 'Box Button Background Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fe3233',
				'selectors' => [
					'{{WRAPPER}} .single-features-wrap .sf-btn .btn' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_box_btntext_color',
			[
				'label' => __( 'Box Button Text Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .single-features-wrap .sf-btn .btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __( 'Hover State', 'chariton' ),
			]
		);

		$this->add_responsive_control(
			'text_box_hover_bg_color',
			[
				'label' => __( 'Box hover background color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-features-wrap:hover' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_box_hover_title_color',
			[
				'label' => __( 'Box hover title color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-features-wrap:hover .sf-content h5' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_box_hover_desc_color',
			[
				'label' => __( 'Box hover description color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-features-wrap:hover .sf-content p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_box_icon_hover_color',
			[
				'label' => __( 'Box Hover Icon Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#7f7f7f',
				'selectors' => [
					'{{WRAPPER}} .single-features-wrap:hover .features-icon i:before' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_box_hbtnbg_color',
			[
				'label' => __( 'Box Button Hover Background Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#0141f5',
				'selectors' => [
					'{{WRAPPER}} .single-features-wrap:hover .sf-btn .btn' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_box_hbtntext_color',
			[
				'label' => __( 'Box Button Hover Text Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .single-features-wrap:hover .sf-btn .btn' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();

	}
	//end of control box 

	protected function render() {				//to show on the fontend 
		$settings = $this->get_settings_for_display();

	?>
		<?php if ( $settings['image_box_items'] ) { ?>
			<div class="row">
				<?php foreach ( $settings['image_box_items'] as $value ) { ?>
			        <div class="col-lg-<?php echo esc_attr( $settings['box_columns'] ); ?> col-md-6">
                        <div class="single-features-wrap">
                            <div class="features-icon">
                                <i class="<?php echo $value['box_icon'] ?>"></i>
                            </div>
                            <div class="sf-content">
                                <h5><?php echo esc_html($value['box_title']); ?></h5>
                                <p><?php echo esc_html($value['box_desc']); ?></p>
                            </div>
                            <div class="sf-btn">
                                <a href="<?php echo esc_url($value['box_btn_link']); ?>" class="btn"><?php echo esc_html($value['box_btn_text']); ?></a>
                            </div>
                        </div>
			        </div>
		        <?php } ?>
		    </div>
	    <?php } ?>
	<?php
	}

	protected function content_template() {
		?>
		<# if ( settings.image_box_items ) { #>
	        <div class="row">
				<# _.each( settings.image_box_items, function( value ) { #>
				<div class="col-lg-{{{ settings.box_columns }}} col-md-6">
                    <div class="single-features-wrap">
                        <div class="features-icon">
                            <i class="{{{ value.box_icon }}}"></i>
                        </div>
                        <div class="sf-content">
                            <h5>{{{ value.box_title }}}</h5>
                            <p>{{{ value.box_desc }}}</p>
                        </div>
                        <div class="sf-btn">
                            <a href="{{ value.box_btn_link }}" class="btn">{{{ value.box_btn_text }}}</a>
                        </div>
					</div>
				</div>
				<# }); #>
        	</div>
		<# } #>
		<?php
	}
}