<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Image_Box_Items extends Widget_Base {

	public function get_name() {
		return 'image-box-items';
	}

	public function get_title() {
		return 'Image Box Items';   // title to show on chariton
	}

	public function get_icon() {
		return 'eicon-info-box';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Image Box Items', 'chariton' ),   //section name for controler view
			]
		);

        $repeater = new Repeater();

        $repeater->add_control(
            'box_image',
            [
                'type' => Controls_Manager::MEDIA,
                'label' => __('Box Image', 'chariton'),
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'image_link',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => __('Image link', 'chariton'),
                'default' => __('#', 'chariton'),
                'placeholder' => __('Type url here', 'chariton'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'box_title',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => __('Box title', 'chariton'),
                'default' => __('Pure Water & Foods', 'chariton'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'box_desc',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'label' => __('Box Description', 'chariton'),
                'default' => __('Pure Water & Foods', 'chariton'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'image_box_items',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => esc_html__('Brand Item', 'chariton'),
                'default' => [
                    [
                        'box_image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'box_image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'box_image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                ]
            ]
        );
		
		$this->end_controls_section();

		//End  of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'text_box_bg_color',
			[
				'label' => __( 'Text box background color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .services-content' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_box_title_color',
			[
				'label' => __( 'Text box title color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .services-content h4' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_box_desc_color',
			[
				'label' => __( 'Text box description color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .services-content p' => 'color: {{VALUE}};',
				],
			]
		);

		/* = Hover Styling
		========================================*/
		$this->add_control(
			'hover_hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'sub_title_heading',
			[
				'label' => __( 'Hover Style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'text_box_hover_bg_color',
			[
				'label' => __( 'Text box hover background color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-services.active .services-content' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_box_hover_title_color',
			[
				'label' => __( 'Text box hover title color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-services.active .services-content h4' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_box_hover_desc_color',
			[
				'label' => __( 'Text box hover description color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-services.active .services-content p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'btn_border_radius',
			[
				'label' => __( 'Border radius', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .video-thumb a, .pluse-animation .popup-video::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

	}
	//end of control box 

	// To display the content on the frontend
	protected function render() { 
	    // Get the settings for display
	    $settings = $this->get_settings_for_display();
	    ?>

	    <!-- Container for the image boxes -->
	    <div class="row justify-content-center">
	        <?php foreach ( $settings['image_box_items'] as $value ) { ?>
	            <div class="col-lg-4 col-md-6">
	                <div class="single-services text-center mb-30">
	                    
	                    <!-- Conditional check for image -->
	                    <?php if( !empty($value['box_image']['url']) ) { ?>
	                        <!-- Image Thumbnail -->
	                        <div class="services-thumb mb-30">
	                            <a href="<?php echo esc_url($value['image_link']); ?>">
	                                <img src="<?php echo esc_url($value['box_image']['url']); ?>" alt="<?php esc_attr_e( 'Image', 'chariton' ); ?>">
	                            </a>
	                        </div>
	                    <?php } ?>

	                    <!-- Content Section -->
	                    <div class="services-content">
	                        <h4><?php echo esc_html($value['box_title']); ?></h4>
	                        <p><?php echo esc_html($value['box_desc']); ?></p>
	                    </div>
	                </div>
	            </div>
	        <?php } ?>
	    </div>

	    <?php
	}

	// Content Template for Elementor live preview
	protected function content_template() {
	    ?>
	    <#
	    // Get the settings for live preview
	    var settings = settings;
	    #>
	    
	    <!-- Container for the image boxes -->
	    <div class="row justify-content-center">
	        <# _.each(settings.image_box_items, function(value) { #>
	            <div class="col-lg-4 col-md-6">
	                <div class="single-services text-center mb-30">
	                    
	                    <!-- Conditional check for image -->
	                    <# if ( value.box_image.url ) { #>
	                        <!-- Image Thumbnail -->
	                        <div class="services-thumb mb-30">
	                            <a href="{{ value.image_link }}">
	                                <img src="{{ value.box_image.url }}" alt="{{ value.box_title }}">
	                            </a>
	                        </div>
	                    <# } #>

	                    <!-- Content Section -->
	                    <div class="services-content">
	                        <h4>{{{ value.box_title }}}</h4>
	                        <p>{{{ value.box_desc }}}</p>
	                    </div>
	                </div>
	            </div>
	        <# }); #>
	    </div>

	    <?php
	}

}