<?php
namespace Chariton\Widgets;
// namespace Elementor;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Inline_Text extends Widget_Base {

	public function get_name() {
		return 'inline-text';
	}

	public function get_title() {
		return 'Inline Text';   // title to show on chariton
	}

	public function get_icon() {
		return 'fal fa-text-width';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Inline Text', 'chariton' ),   //section name for controler view
			]
		);

		$this->add_control(
			'inline_text',
			[
				'label' => esc_html__( 'Inline Text', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'text_animation',
			[
				'label' => __( 'Animation', 'chariton' ),
				'type' => Controls_Manager::ANIMATION,
				'label_block' => true,
			]
		);

		$this->add_control(
			'text_anim_delay',
			[
				'label' => __( 'Animation Delay', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => '0.2s',
				'options' => ifinger_anim_delay(),
				'label_block' => true,
			]
		);
		
		$this->end_controls_section();

		//End  of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'chariton_inline_style',
			[
				'label' => esc_html__( 'Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'inline_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .chariton-inline-text',
			]
		);

		$this->add_control(
			'chariton_inline_color',
			[
				'label' => __( 'Text Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .chariton-inline-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'chariton_inline_bg_color',
			[
				'label' => __( 'Banckground Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'deafult' => '',
				'range' => [
					'px' => [
						'min' => 24,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .chariton-inline-text' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'chariton_inline_margin',
			[
				'label' => __( 'Margin', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .chariton-inline-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'chariton_inline_padding',
			[
				'label' => __( 'Padding', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .chariton-inline-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

	}
	//end of control box 

	protected function render() {				//to show on the fontend 
		
		$settings = $this->get_settings_for_display();

		$animation = $settings['text_animation'];
		$anim_delay = $settings['text_anim_delay'];

		$inline_text = $settings['inline_text'];
		$this->add_inline_editing_attributes( 'inline_text' );

		if ( !empty($animation )) {
			$anim = 'class="chariton-inline-text wow '.esc_attr( $animation ).'" data-wow-delay="'.esc_attr( $anim_delay ).'"';
		} else {
			$anim =  'class="chariton-inline-text"';
		}

    	?>
        <span <?php echo $anim ?><?php echo $this->get_render_attribute_string( 'inline_text' ); ?>><?php echo esc_html( $inline_text ); ?></span>
		<?php	
	}
}