<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Brand extends Widget_Base {   //this name is added to plugin.php of the root folder

	public function get_name() {
		return 'section-brand';
	}

	public function get_title() {
		return 'Sponsors';   // title to show on elementor
	}

	public function get_icon() {
		return 'eicon-slider-push';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}
	
   	public function get_script_depends() {
		return [ 'chariton-elementor-editor' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	protected function register_controls() {
		
	//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Sponsors Settings', 'chariton' ),   //section name for controler view
			]
		);

		$this->add_control(
			'brand_columns',
			[
			    'label'       => __( 'Select columns', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '3',
			    'options' => [
			     	'6'   => __( '2', 'chariton' ),
			     	'4'   => __( '3', 'chariton' ),
			     	'3'   => __( '4', 'chariton' ),
			    ],
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'brand_image',
			[
				'label' => esc_html__( 'Upload Image', 'chariton' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);

		$this->add_control(
			'brand_items',
			[
				'label' => __( 'Add Sponsor Image', 'chariton' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'brand_item_style',
			[
				'label' => esc_html__( 'Brand Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_control(
			'item_marign_bottom',
			[
				'label' => esc_html__( 'Item Margin Bottom', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => '10px',
				'selectors' => [
					'{{WRAPPER}} .brand-sponsor-item' => 'margin-bottom: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	// To show content on the frontend
	protected function render() {
	    $settings = $this->get_settings_for_display();
	    $e_uniqid = uniqid(); // Unique ID for this instance (if needed)
	    ?>
	    
	    <!-- Check if there are brand items to display -->
	    <?php if ( ! empty( $settings['brand_items'] ) ) { ?>
	        <div class="sponsors-list style-five">
	            <div class="row">
	                <?php foreach ( $settings['brand_items'] as $value ) { ?>
	                    <div class="col-lg-<?php echo esc_attr( $settings['brand_columns'] ); ?> col-sm-6">
	                        <div class="brand-sponsor-item">
	                            <!-- Check if the image exists -->
	                            <?php if ( ! empty( $value['brand_image']['url'] ) ) { ?>
	                                <img src="<?php echo esc_url( $value['brand_image']['url'] ); ?>" alt="<?php esc_attr_e( 'Sponsors Image', 'chariton' ); ?>">
	                            <?php } ?>
	                        </div>
	                    </div>
	                <?php } ?>
	            </div>
	        </div>
	    <?php } ?>

	    <?php
	}

	// Content Template for Elementor live preview
	protected function content_template() {
	    ?>
	    <#
	    // Get the settings for live preview
	    var settings = settings;

	    // Check if there are brand items to display
	    if ( settings.brand_items ) { #>
	        <div class="sponsors-list style-five">
	            <div class="row">
	                <# _.each( settings.brand_items, function( value ) { #>
	                    <div class="col-lg-{{ settings.brand_columns }} col-sm-6">
	                        <div class="brand-sponsor-item">
	                            <!-- Check if the image exists -->
	                            <# if ( value.brand_image.url ) { #>
	                                <img src="{{ value.brand_image.url }}" alt="{{ value.brand_image.url }}">
	                            <# } #>
	                        </div>
	                    </div>
	                <# }); #>
	            </div>
	        </div>
	    <# } #>
	    <?php
	}
}