<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Causes extends Widget_Base {   //this name is added to plugin.php of the root folder

	public function get_name() {
		return 'section-cause';
	}

	public function get_title() {
		return 'Cause';   // title to show on elementor
	}

	public function get_icon() {
		return 'fal fa-calendar-star';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

    public function get_script_depends() {
		return [ 'chariton-elementor-editor' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Cause Grid', 'chariton' ),   //section name for controler view
			]
		);

		$this->add_control(
			'post_number',
			[
				'label' => esc_html__( 'Display Totall Items', 'chariton' ),
				'description' => esc_html__( 'Give -1 for all post', 'chariton' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 4,
			]
		);

		$this->add_control(
			'display_posts_cat',
			[
				'label' => __( 'Display Category Posts', 'chariton' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => chariton_cases_categories(),
				'label_block' => true,
			]
		);

		$this->add_control(
			'post_orderby',
			[
				'label' => __( 'Boder by', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => ifinger_post_orderby_options(),
				'label_block' => true,
			]
		);

		$this->add_control(
			'cause_slider',
			[
			    'label'       => __( 'Cause slider', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => 'no',
			    'options' => [
			     	'no' => __( 'No', 'chariton' ),
			     	'yes'  => __( 'Yes', 'chariton' ),
			    ],
			    'label_block' => true,
			]
		);

		$this->add_control(
			'show_item',
			[
			    'label'       => __( 'Show on large device', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '3',
			    'options' => [
			     	'2'  => __( '2', 'chariton' ),
			     	'3' => __( '3', 'chariton' ),
			     	'4' => __( '4', 'chariton' ),
			     	'6' => __( '6', 'chariton' ),
			    ],
			    'condition' => [
					'cause_slider' => 'yes',
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'show_desktop',
			[
			    'label'       => __( 'Show on desktop', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '3',
			    'options' => [
			     	'2'  => __( '2', 'chariton' ),
			     	'3' => __( '3', 'chariton' ),
			     	'4' => __( '4', 'chariton' ),
			     	'5' => __( '5', 'chariton' ),
			    ],
			    'condition' => [
					'cause_slider' => 'yes',
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'show_tablet',
			[
			    'label'       => __( 'Show on Tablet', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '2',
			    'options' => [
			     	'2'  => __( '2', 'chariton' ),
			     	'3' => __( '3', 'chariton' ),
			     	'4' => __( '4', 'chariton' ),
			     	'5' => __( '5', 'chariton' ),
			    ],
			    'condition' => [
					'cause_slider' => 'yes',
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'show_tab',
			[
			    'label'       => __( 'Show on tab', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '1',
			    'options' => [
			     	'1'  => __( '1', 'chariton' ),
			     	'2'  => __( '2', 'chariton' ),
			     	'3'  => __( '3', 'chariton' ),
			    ],
			    'condition' => [
					'cause_slider' => 'yes',
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'show_phone',
			[
			    'label'       => __( 'Show on phone', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '1',
			    'options' => [
			     	'1' => __( '1', 'chariton' ),
			     	'2' => __( '2', 'chariton' ),
			     	'3' => __( '3', 'chariton' ),
			    ],
			    'condition' => [
					'cause_slider' => 'yes',
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'cause_style',
			[
			     'label'       => __( 'Cause style', 'chariton' ),
			     'type' => Controls_Manager::SELECT,
			     'default' => '1',
			     'options' => [
			     	'1' => __( 'Style 1', 'chariton' ),
			     	'2' => __( 'Style 2', 'chariton' ),
			    ],
			    'label_block' => true,
			]
		);

		$this->add_control(
			'post_columns',
			[
				'label' => __( 'Grid Columns', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => '4',
				'options' => ifinger_grid_columns(),
				'label_block' => true,
				'condition' => [
					'cause_slider' => 'no',
				],
			]
		);

		$this->add_control(
			'cause_filter',
			[
			    'label'     => __( 'Cause Filter', 'chariton' ),
			    'type' 		=> Controls_Manager::SELECT,
			    'default' 	=> 'no',
			    'options' 	=> [
			     	'yes' 	=> __( 'Yes', 'chariton' ),
			     	'no' 	=> __( 'No', 'chariton' ),
			    ],
			    'condition' => [
					'cause_slider' => 'no',
				],
				'label_block' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_cause_menu',
			[
				'label' => esc_html__( 'Cause Filter Menu Style', 'chariton' ),   //section name for controler view
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'cause_menu_color',
			[
				'label' 	=> __( 'Menu Text Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#b2c7d9',
				'selectors' => [
					'{{WRAPPER}} .causes-menus button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'cause_menu_hover_color',
			[
				'label' 	=> __( 'Cause Menu Hover Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#78c759',
				'selectors' => [
					'{{WRAPPER}} .causes-menus button:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .causes-menus button:hover::before' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'cause_menu_active_color',
			[
				'label' 	=> __( 'Cause Menu Active Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#78c759',
				'selectors' => [
					'{{WRAPPER}} .causes-menus button.active' => 'color: {{VALUE}};',
					'{{WRAPPER}} .causes-menus button.active::before' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_cause_style',
			[
				'label' => esc_html__( 'Cause Title Style', 'chariton' ),   //section name for controler view
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'cause_title_color',
			[
				'label' 	=> __( 'Title Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#001234',
				'selectors' => [
					'{{WRAPPER}} .causes-content h3' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Title Typography', 'chariton' ),
				'selector' 	=> '{{WRAPPER}} .causes-content h3',
			]
		);

		$this->add_control(
			'cause_title_hover_color',
			[
				'label' 	=> __( 'Title Hover Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#78c759',
				'selectors' => [
					'{{WRAPPER}} .causes-content h3 a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_cause_cat',
			[
				'label' => esc_html__( 'Cause Categories Style', 'chariton' ),   //section name for controler view
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'cause_title_cat_color',
			[
				'label' 	=> __( 'Categories Title Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#78c759',
				'selectors' => [
					'{{WRAPPER}} ul.cause-categories li a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'cat_typography',
				'label' 	=> __( 'Categories Typography', 'chariton' ),
				'selector' 	=> '{{WRAPPER}} ul.cause-categories li a',
			]
		);

		$this->add_control(
			'cause_title_cat_hover_color',
			[
				'label' 	=> __( 'Categories Title Hover Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#78c759',
				'selectors' => [
					'{{WRAPPER}} .single-causes:hover ul.cause-categories li a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_cause_area',
			[
				'label' => esc_html__( 'Cause Item Style', 'chariton' ),   //section name for controler view
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'cause_area_padding',
			[
				'label' => __( 'Cause Item Padding', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' 		=> '35',
					'right' 	=> '40',
					'bottom' 	=> '35',
					'left' 		=> '40',
				],
				'selectors' => [
					'{{WRAPPER}} .single-causes .causes-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'cause_items_bg_color',
			[
				'label' 	=> __( 'Item Background Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .single-causes .causes-content' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

	}


	protected function render() {				//to show on the fontend 
		$settings = $this->get_settings_for_display();


		$display_posts_cat = $settings['display_posts_cat'];

		$cause_slider = $settings['cause_slider'];
		$show_item = $settings['show_item'];
		$show_desktop = $settings['show_desktop'];
		$show_tablet = $settings['show_tablet'];
		$show_tab = $settings['show_tab'];
		$show_phone = $settings['show_phone'];
		$cause_style = $settings['cause_style'];
		$post_columns = $settings['post_columns'];
		$cause_filter = $settings['cause_filter'];

		if ( $cause_style == 2 ) {
			$class = 's-single-causes';
		} else {
			$class = '';			
		}

        if (!empty($display_posts_cat)) {
          $args = array(
            'post_type'      => 'cause',
            'post_status'    => 'publish',
            'posts_per_page' => $settings['post_number'],
            'orderby'        => $settings['post_orderby'],
            'tax_query' => array(
              array(
                'taxonomy' => 'cause_category',
                'field' => 'id',
                'terms' => $display_posts_cat
              )
            ),
          );
        } else {
          $args = array(
            'post_type'      => 'cause',
            'post_status'    => 'publish',
            'posts_per_page' => $settings['post_number'],
            'orderby'        => $settings['post_orderby'],
            'taxonomy' => 'cause_category',
          );
        }

        $e_uniqid     = uniqid();
		 
		$grid_query = new \WP_Query( $args );

		if ( $grid_query->have_posts() ) : 


	if ( $cause_slider == 'no' ) { ?>
		<?php if ( $cause_filter == 'yes' ) { ?>
		<script>
			jQuery(window).on('load', function () {
			    jQuery('.causes-isotope').imagesLoaded( function() {
			        // portfolio - active
			        var $grid = jQuery('.causes-isotope-<?php echo esc_attr( $e_uniqid ); ?>').isotope({
			            itemSelector: '.grid-item',
			            layoutMode: 'fitRows',
			            percentPosition: true,
			        })
			        // filter items on button click
			        jQuery('.causes-menu-<?php echo esc_attr( $e_uniqid ); ?>').on('click', 'button', function () {
			            var filterValue = jQuery(this).attr('data-filter');
			            $grid.isotope({ filter: filterValue });
			        });
			        //for menu active class
			        jQuery('.causes-menu-<?php echo esc_attr( $e_uniqid ); ?> button').on('click', function (event) {
			            jQuery(this).siblings('.active').removeClass('active');
			            jQuery(this).addClass('active');
			            event.preventDefault();
			        });
			    });
			});
		</script>

		<div class="row">
		    <div class="col-lg-12 text-center">
		        <div class="causes-menus causes-menu-<?php echo esc_attr( $e_uniqid ); ?> mb-50">
		            <?php 
			            $filters = get_terms( array(
				        'taxonomy' => 'cause_category',
				        'include' => $display_posts_cat,
				        'hide_empty'  => false, 
				        'orderby'  => 'include',
				      	) );
				      	if (!empty($filters)) { ?>
				      	<button class="active" data-filter="*"><?php echo esc_html_e('All Categories', 'chariton') ?></button>
			            <?php if ( $filters && ! is_wp_error( $filters ) ) {
			              foreach ($filters as $filter) {
			                echo "<button class=\"button\" data-filter=\".$filter->slug\">$filter->name</button>";
			              }
			            }
			            ?>
		            <?php } ?>
		        </div>
		    </div>
		</div>
		<?php } ?>

		<div class="row causes-isotope-<?php echo esc_attr($e_uniqid); ?>">
			<?php while ( $grid_query->have_posts() ) : $grid_query->the_post(); global $post; 

			    $chariton_cause_info = get_post_meta( get_the_ID(), '_ifinger_cause', true );

			    if (!empty($chariton_cause_info['goal_title'])) {
			      $goal_title = $chariton_cause_info['goal_title'];
			    } else {
			      $goal_title = '';
			    }
			    if (!empty($chariton_cause_info['money_currency'])) {
			      $money_currency = $chariton_cause_info['money_currency'];
			    } else {
			      $money_currency = '';
			    }
			    if (!empty($chariton_cause_info['goal_amount'])) {
			      $goal_amount = $chariton_cause_info['goal_amount'];
			    } else {
			      $goal_amount = '';
			    }
			    if (!empty($chariton_cause_info['rise_title'])) {
			      $rise_title = $chariton_cause_info['rise_title'];
			    } else {
			      $rise_title = '';
			    }
			    if (!empty($chariton_cause_info['rise_amount'])) {
			      $rise_amount = $chariton_cause_info['rise_amount'];
			    } else {
			      $rise_amount = '';
			    }
			    if (!empty($chariton_cause_info['count_title'])) {
			      $count_title = $chariton_cause_info['count_title'];
			    } else {
			      $count_title = '';
			    }
			    if (!empty($chariton_cause_info['cause_count_down'])) {
			      $cause_count_down = $chariton_cause_info['cause_count_down'];
			    } else {
			      $cause_count_down = '';
			    }
			    
				$goal = '<li><b>'.esc_html( $goal_title ).'</b>'.esc_html( $money_currency.''.$goal_amount ).'</li>';
				$rise = '<li><b>'.esc_html( $rise_title ).'</b>'.$money_currency.'<span class="count">'.esc_html( $rise_amount ).'</span></li>';
				$countdown = '<li><b>'.esc_html( $count_title ).'</b><span data-countdown="'.esc_html( $cause_count_down ).'"></span></li>';

			    $terms = get_the_terms(get_the_ID(), 'cause_category' );          
		        if ( $terms && ! is_wp_error( $terms ) ) {
		            $draught_links = array();
		            foreach ( $terms as $term ) {
		                $draught_links[] = $term->slug;
		                $term_link = get_term_link( $term );
		            }        
		        	$cat_slug = join( " ", $draught_links );
		        }

		  	?>
		    <div class="col-lg-<?php echo esc_attr( $post_columns ); ?> col-md-6 grid-item <?php echo esc_attr( $cat_slug ); ?>">
		        <div class="single-causes <?php echo esc_attr( $class ); ?>">
		        	<?php if(has_post_thumbnail()) : ?>
		            <div class="causes-thumb">
		                <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
		            </div>
		            <?php endif; ?>
		            <div class="causes-content">
		                <?php 
			                $terms = wp_get_post_terms( $post->ID, 'cause_category');
							echo '<ul class="cause-categories">';
							foreach ($terms as $term) {
							    echo '<li><a href="'.get_term_link($term->slug, 'cause_category').'">'.$term->name.'</a></li>';
							}
							echo '</ul>'; 
						?>
		                <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
		            </div>
		            <?php if (!empty( $goal_amount ) || !empty( $rise_amount ) || !empty( $cause_count_down )) { ?>
		            <div class="causes-meta">
		                <ul class="d-flex justify-content-between">
			                <?php if (!empty( $goal_amount )) {
			                	echo $goal;
			                } if ( !empty( $rise_amount )) {
			                    echo $rise;
			                } if ( !empty( $cause_count_down )) {
			                    echo $countdown;
			                } ?>
		                </ul>
		            </div>
		        	<?php } ?>
		        </div>
		    </div>
		    <?php endwhile; wp_reset_postdata(); ?>
		</div>

		<?php } elseif ( $cause_slider == 'yes' ) { ?>
		<script type="text/javascript">
		    jQuery(document).ready(function(){

				// causes-active
				jQuery('.causes-active').slick({
				  dots: false,
				  infinite: true,
				  speed: 600,
				  prevArrow: '<button type="button" class="slick-prev"><i class="far fa-angle-left"></i></button>',
				  nextArrow: '<button type="button" class="slick-next"><i class="far fa-angle-right"></i></button>',
				  arrows: true,
				  slidesToShow: <?php echo esc_attr( $show_item ); ?>,
				  slidesToScroll: 1,
				  responsive: [
				    {
				      breakpoint: 1200,
				      settings: {
				        slidesToShow: <?php echo esc_attr( $show_desktop ); ?>,
				        slidesToScroll: 1,
				        infinite: true,
				      }
				    },
				    {
				      breakpoint: 992,
				      settings: {
				        slidesToShow: <?php echo esc_attr( $show_tablet ); ?>,
				        slidesToScroll: 1
				      }
				    },
				    {
				      breakpoint: 768,
				      settings: {
				        slidesToShow: <?php echo esc_attr( $show_tab ); ?>,
				        slidesToScroll: 1,
				        arrows: false,
				      }
				    },
				    {
				      breakpoint: 576,
				      settings: {
				        slidesToShow: <?php echo esc_attr( $show_phone ); ?>,
				        slidesToScroll: 1,
				        arrows: false,
				      }
				    },
				  ]
				});
		    });
		</script>   

		<div class="row causes-active">
			<?php while ( $grid_query->have_posts() ) : $grid_query->the_post(); global $post; 

			    $chariton_cause_info = get_post_meta( get_the_ID(), '_ifinger_cause', true );

			    if (!empty($chariton_cause_info['goal_title'])) {
			      $goal_title = $chariton_cause_info['goal_title'];
			    } else {
			      $goal_title = '';
			    }
			    if (!empty($chariton_cause_info['money_currency'])) {
			      $money_currency = $chariton_cause_info['money_currency'];
			    } else {
			      $money_currency = '';
			    }
			    if (!empty($chariton_cause_info['goal_amount'])) {
			      $goal_amount = $chariton_cause_info['goal_amount'];
			    } else {
			      $goal_amount = '';
			    }
			    if (!empty($chariton_cause_info['rise_title'])) {
			      $rise_title = $chariton_cause_info['rise_title'];
			    } else {
			      $rise_title = '';
			    }
			    if (!empty($chariton_cause_info['rise_amount'])) {
			      $rise_amount = $chariton_cause_info['rise_amount'];
			    } else {
			      $rise_amount = '';
			    }
			    if (!empty($chariton_cause_info['count_title'])) {
			      $count_title = $chariton_cause_info['count_title'];
			    } else {
			      $count_title = '';
			    }
			    if (!empty($chariton_cause_info['cause_count_down'])) {
			      $cause_count_down = $chariton_cause_info['cause_count_down'];
			    } else {
			      $cause_count_down = '';
			    }

				$goal = '<li><b>'.esc_html( $goal_title ).'</b>'.esc_html( $money_currency.''.$goal_amount ).'</li>';
				$rise = '<li><b>'.esc_html( $rise_title ).'</b>'.$money_currency.'<span class="count">'.esc_html( $rise_amount ).'</span></li>';
				$countdown = '<li><b>'.esc_html( $count_title ).'</b><span data-countdown="'.esc_html( $cause_count_down ).'"></span></li>';

		  	?>
		    <div class="col-xl-4">
		        <div class="single-causes <?php echo esc_attr( $class ); ?>">
		        	<?php if(has_post_thumbnail()) : ?>
		            <div class="causes-thumb">
		                <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
		            </div>
		            <?php endif; ?>
		            <div class="causes-content">
		                <?php 
			                $terms = wp_get_post_terms( $post->ID, 'cause_category');
							echo '<ul class="cause-categories">';
							foreach ($terms as $term) {
							    echo '<li><a href="'.get_term_link($term->slug, 'cause_category').'">'.$term->name.'</a></li>';
							}
							echo '</ul>'; 
						?>
		                <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
		            </div>
		            <?php if (!empty( $goal_amount ) || !empty( $rise_amount ) || !empty( $cause_count_down )) { ?>
		            <div class="causes-meta">
		                <ul class="d-flex justify-content-between">
		                <?php if (!empty( $goal_amount )) {
		                	echo $goal;
		                } if ( !empty( $rise_amount )) {
		                    echo $rise;
		                } if ( !empty( $cause_count_down )) {
		                    echo $countdown;
		                } ?>
		                </ul>
		            </div>
		        	<?php } ?>
		        </div>
		    </div>
		    <?php endwhile; wp_reset_postdata(); ?>
		</div>
		<?php } else { ?>
		<div class="row">
			<?php while ( $grid_query->have_posts() ) : $grid_query->the_post(); global $post; 

			    $chariton_cause_info = get_post_meta( get_the_ID(), '_ifinger_cause', true );

			    if (!empty($chariton_cause_info['goal_title'])) {
			      $goal_title = $chariton_cause_info['goal_title'];
			    } else {
			      $goal_title = '';
			    }
			    if (!empty($chariton_cause_info['money_currency'])) {
			      $money_currency = $chariton_cause_info['money_currency'];
			    } else {
			      $money_currency = '';
			    }
			    if (!empty($chariton_cause_info['goal_amount'])) {
			      $goal_amount = $chariton_cause_info['goal_amount'];
			    } else {
			      $goal_amount = '';
			    }
			    if (!empty($chariton_cause_info['rise_title'])) {
			      $rise_title = $chariton_cause_info['rise_title'];
			    } else {
			      $rise_title = '';
			    }
			    if (!empty($chariton_cause_info['rise_amount'])) {
			      $rise_amount = $chariton_cause_info['rise_amount'];
			    } else {
			      $rise_amount = '';
			    }
			    if (!empty($chariton_cause_info['count_title'])) {
			      $count_title = $chariton_cause_info['count_title'];
			    } else {
			      $count_title = '';
			    }
			    if (!empty($chariton_cause_info['cause_count_down'])) {
			      $cause_count_down = $chariton_cause_info['cause_count_down'];
			    } else {
			      $cause_count_down = '';
			    }
			    
				$goal = '<li><b>'.esc_html( $goal_title ).'</b>'.esc_html( $money_currency.''.$goal_amount ).'</li>';
				$rise = '<li><b>'.esc_html( $rise_title ).'</b>'.$money_currency.'<span class="count">'.esc_html( $rise_amount ).'</span></li>';
				$countdown = '<li><b>'.esc_html( $count_title ).'</b><span data-countdown="'.esc_html( $cause_count_down ).'"></span></li>';

		  	?>
		    <div class="col-xl-4">
		        <div class="single-causes <?php echo esc_attr( $class ); ?>">
		        	<?php if(has_post_thumbnail()) : ?>
		            <div class="causes-thumb">
		                <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
		            </div>
		            <?php endif; ?>
		            <div class="causes-content">
		                <?php 
			                $terms = wp_get_post_terms( $post->ID, 'cause_category');
							echo '<ul class="cause-categories">';
							foreach ($terms as $term) {
							    echo '<li><a href="'.get_term_link($term->slug, 'cause_category').'">'.$term->name.'</a></li>';
							}
							echo '</ul>'; 
						?>
		                <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
		            </div>
		            <?php if (!empty( $goal_amount ) || !empty( $rise_amount ) || !empty( $cause_count_down )) { ?>
		            <div class="causes-meta">
		                <ul class="d-flex justify-content-between">
		                <?php if (!empty( $goal_amount )) {
		                	echo $goal;
		                } if ( !empty( $rise_amount )) {
		                    echo $rise;
		                } if ( !empty( $cause_count_down )) {
		                    echo $countdown;
		                } ?>
		                </ul>
		            </div>
		        	<?php } ?>
		        </div>
		    </div>
		    <?php endwhile; wp_reset_postdata(); ?>
		</div>
		<?php } ?>
		<?php endif;   //main if end
	}
}