<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Contact_Cf7 extends Widget_Base {

	public function get_name() {
		return 'chariton-cf7';
	}

	public function get_title() {
		return 'Contact Form 7';   // title to show on chariton
	}

	public function get_icon() {
		return 'fal fa-link';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Contact Form 7', 'chariton' ),   //section name for controler view
			]
		);

        $this->add_control(
            'selected_form_id',
            [
                'label' => esc_html__( 'Chosse Your Form', 'chariton' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => ['' => esc_html__( '', 'chariton' ) ] + \chariton_get_cf7_forms(),
            ]
        );
		
		$this->end_controls_section();

		//End  of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Contact Form 7 Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
			'main_bg_color',
			[
				'label' => __( 'Background color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form_btn_cf7' => 'background-color: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
            'sections_padding',
            [
                'label' => esc_html__( 'Padding', 'chariton' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .form_btn_cf7' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->add_responsive_control(
			'main_input_border_color',
			[
				'label' => __( 'Input Border Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#eef2f7',
				'selectors' => [
					'{{WRAPPER}} .form_btn_cf7 input, .form_btn_cf7 textarea' => 'border-color: {{VALUE}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'main_input_bg_color',
			[
				'label' => __( 'Input Background Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form_btn_cf7 input, .form_btn_cf7 textarea' => 'background: {{VALUE}} !important;',
				],
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => __( 'Normal', 'chariton' ),
			]
		);

		$this->add_responsive_control(
			'btn_bg_color',
			[
				'label' => __( 'Background color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#39bdb2',
				'selectors' => [
					'{{WRAPPER}} .form_btn_cf7 button.btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'btn_text_color',
			[
				'label' => __( 'Font color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .form_btn_cf7 button.btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		/* = Button Hover Styling
		========================================*/
		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __( 'Hover', 'chariton' ),
			]
		);

		$this->add_responsive_control(
			'btn_h_bg_color',
			[
				'label' => __( 'Background color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#39bdb2',
				'selectors' => [
					'{{WRAPPER}} .form_btn_cf7 button.btn:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'btn_h_font_color',
			[
				'label' => __( 'Font color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .form_btn_cf7 button.btn:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'btn_h_brfore_color',
			[
				'label' => __( 'Before Broder Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .form_btn_cf7 button.btn:hover:before' => 'border-color: {{VALUE}};',
				],
			]
		);		

	}
	//end of control box 

	//to show on the fontend
	protected function render() {
		
        if ( ! class_exists('WPCF7') ) {
            return;
        }

        $settings = $this->get_settings_for_display();

        if ( ! empty( $settings['selected_form_id'] ) ) {
            echo '<div class="form_btn_cf7">';
            echo  do_shortcode( '[contact-form-7 id="'.$settings['selected_form_id'].'"]');
            echo '</div>';
        }
	}	
}