<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Event_Banner extends Widget_Base {

    public function get_name() {
        return 'event-slider-banner';
    }

    public function get_title() {
        return 'Event Banner';   // title to show on chariton
    }

    public function get_icon() {
        return 'fal fa-address-card'; // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
    }

    public function get_categories() {
        return [ 'chariton-elements' ];    // category of the widget
    }

    /**
     * A list of scripts that the widgets is depended in
     * @since 1.3.0
     **/

    protected function register_controls() {
        
        //start of a control box
        $this->start_controls_section(
            'section_banner_content',
            [
                'label' => esc_html__( 'Event Banner Settings', 'chariton' ),   //section name for controler view
            ]
        );

        $this->add_control(
            'banner_bg_img',
            [
                'label' => esc_html__( 'Banner Left Image', 'chariton' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'banner_title',
            [
                'label' => esc_html__( 'Banner Title', 'chariton' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Web Seminar 2022', 'chariton'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_sub_title',
            [
                'label' => esc_html__( 'Banner Sub Title', 'chariton' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Join Our', 'chariton'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_details',
            [
                'label' => esc_html__( 'Banner Details', 'chariton' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'There are many variations of passages of Lorem Ipsum available but the majority have suffered alteration in that some form by a injected humour randomised.', 'chariton'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_bg_img_right',
            [
                'label' => esc_html__( 'Banner Right Image', 'chariton' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'banner_count_year',
            [
                'label' => esc_html__( 'Year', 'chariton' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( '2022', 'chariton'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_count_month',
            [
                'label' => esc_html__( 'Month', 'chariton' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( '12', 'chariton'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_count_day',
            [
                'label' => esc_html__( 'Day', 'chariton' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( '01', 'chariton'),
                'label_block' => true,
            ]
        );


        $this->end_controls_section();
        //End of a control box

        $this->start_controls_section(
            'banner_title_style',
            [
                'label' => esc_html__( 'Title Style', 'chariton' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'banner_title_color',
            [
                'label' => __( 'Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .event-banner .second-slider-content h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'banner_title_typography',
                'label' => __( 'Title Typography', 'chariton' ),
                'selector' => '{{WRAPPER}} .event-banner .second-slider-content h2',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'banner_sub_title_style',
            [
                'label' => esc_html__( 'Sub Title Style', 'chariton' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'banner_sub_title_color',
            [
                'label' => __( 'Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .event-banner .second-slider-content span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'banner_sub_title_typography',
                'label'    => __( 'Title Typography', 'chariton' ),
                'selector' => '{{WRAPPER}} .event-banner .second-slider-content span',
            ]
        );

        $this->end_controls_section();

        // Social
        $this->start_controls_section(
            'banner_details_style',
            [
                'label' => esc_html__( 'Content Style', 'chariton' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'banner_details_color',
            [
                'label' => __( 'Text Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .event-banner .second-slider-content p' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'banner_details_typography',
                'label'    => __( 'Title Typography', 'chariton' ),
                'selector' => '{{WRAPPER}} .event-banner .second-slider-content p',
            ]
        );

        $this->end_controls_section();

        // Button
        $this->start_controls_section(
            'banner_counter_style',
            [
                'label' => esc_html__( 'Counter Style', 'chariton' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'banner_details_counter_color',
            [
                'label' => __( 'Counter Text Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .event-banner .time-count' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

    }
    //end of control box 

    //to show on the fontend
    protected function render() {
        $settings = $this->get_settings_for_display();
    ?>
        <section class="event-banner slider-area position-relative">
            <div class="slider-right-img" style="background-image:url(<?php echo $settings['banner_bg_img']['url']; ?>)"></div>
            <div class="second-left-slider d-flex align-items-center" style="background-image:url(<?php echo $settings['banner_bg_img_right']['url']; ?>)">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-6 col-lg-7">
                            <div class="second-slider-content">
                                <span><?php echo esc_html( $settings['banner_sub_title'] ); ?></span>
                                <h2><?php echo esc_html( $settings['banner_title'] ); ?></h2>
                                <p><?php echo esc_html( $settings['banner_details'] ); ?></p>
                            </div>
                            <div class="slider-count mt-50">
                                <div class="slider-time" data-countdown="<?php echo $settings['banner_count_year']; ?>/<?php echo $settings['banner_count_month']; ?>/<?php echo $settings['banner_count_day']; ?>"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php
    }

    protected function content_template() {
        ?>
        <section class="event-banner slider-area position-relative">
            <div class="slider-right-img" style="background-image:url({{ settings.banner_bg_img.url }})"></div>
            <div class="second-left-slider d-flex align-items-center" style="background-image:url({{ settings.banner_bg_img_right.url }})">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-6 col-lg-7">
                            <div class="second-slider-content">
                                <span>{{{ settings.banner_sub_title }}}</span>
                                <h2>{{{ settings.banner_title }}}</h2>
                                <p>{{{ settings.banner_details }}}</p>
                            </div>
                            <div class="slider-count mt-50">
                                <div class="slider-time" data-countdown="{{{ settings.banner_count_year }}}/{{{ settings.banner_count_month }}}/{{{ settings.banner_count_day }}}"></div>
                                <div class="slider-time" data-countdown="2022/11/01"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
}