<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Events extends Widget_Base {   //this name is added to plugin.php of the root folder

	public function get_name() {
		return 'section-event';
	}

	public function get_title() {
		return 'Events';   // title to show on elementor
	}

	public function get_icon() {
		return 'fal fa-calendar-star';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

    public function get_script_depends() {
		return [ 'chariton-elementor-editor' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Events', 'chariton' ),   //section name for controler view
			]
		);

		$this->add_control(
			'post_number',
			[
				'label' => esc_html__( 'Number of Item', 'chariton' ),
				'description' => esc_html__( 'Give -1 for all post', 'chariton' ),
				'type' => Controls_Manager::NUMBER,
				'default' => '-1',
			]
		);

		$this->add_control(
			'post_excerpt',
			[
				'label' => esc_html__( 'Post Excerpt', 'chariton' ),
				'description' => esc_html__( 'Post content excerpt', 'chariton' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 30,
			]
		);

		$this->add_control(
			'display_posts_cat',
			[
				'label' 	=> __( 'Choose Events Category.', 'chariton' ),
				'type' 		=> Controls_Manager::SELECT2,
				'multiple' 	=> true,
				'options' 	=> chariton_events_categories(),
				'label_block' => true,
			]
		);

		$this->add_control(
			'post_orderby',
			[
				'label' => __( 'Order by', 'chariton' ),
				'type' 	=> Controls_Manager::SELECT,
				'default' => 'date',
				'options' => ifinger_post_orderby_options(),
			]
		);

		$this->add_control(
			'post_order',
			[
				'label' => __( 'Order', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'ASC' => __( 'Ascending Order', 'chariton' ),
					'DESC' => __( 'Descending', 'chariton' ),
				],
			]
		);

		$this->add_control(
			'event_filter',
			[
			    'label'     => __( 'Event Filter Menu', 'chariton' ),
			    'type' 		=> Controls_Manager::SELECT,
			    'default' 	=> 'no',
			    'options' 	=> [
			     	'yes' 	=> __( 'Yes', 'chariton' ),
			     	'no' 	=> __( 'No', 'chariton' ),
			    ],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_event_menu',
			[
				'label' => esc_html__( 'Events Filter Menu Style', 'chariton' ),   //section name for controler view
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'event_menu_color',
			[
				'label' 	=> __( 'Menu Text Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#5b7d9a',
				'selectors' => [
					'{{WRAPPER}} .event-menus button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'event_menu_hover_color',
			[
				'label' 	=> __( 'Event Menu Hover Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#a50042',
				'selectors' => [
					'{{WRAPPER}} .event-menus button:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .event-menus button:hover::before' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'event_menu_active_color',
			[
				'label' 	=> __( 'Event Menu Active Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#a50042',
				'selectors' => [
					'{{WRAPPER}} .event-menus button.active' => 'color: {{VALUE}};',
					'{{WRAPPER}} .event-menus button.active::before' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_event_style',
			[
				'label' => esc_html__( 'Events Title Style', 'chariton' ),   //section name for controler view
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'event_title_color',
			[
				'label' 	=> __( 'Title Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#001234',
				'selectors' => [
					'{{WRAPPER}} .event-content h2' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Title Typography', 'chariton' ),
				'selector' 	=> '{{WRAPPER}} .event-content h2',
			]
		);

		$this->add_control(
			'title_hover_color',
			[
				'label' 	=> __( 'Title Hover Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#78c759',
				'selectors' => [
					'{{WRAPPER}} .event-content h2 a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_event_content',
			[
				'label' => esc_html__( 'Events Content Style', 'chariton' ),   //section name for controler view
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'event_content_color',
			[
				'label' 	=> __( 'Content Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#5b7d9a',
				'selectors' => [
					'{{WRAPPER}} .event-content p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_event_area',
			[
				'label' => esc_html__( 'Events Item Style', 'chariton' ),   //section name for controler view
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'event_areas_bg_color',
			[
				'label' 	=> __( 'Event Area Background Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#e8fbff',
				'selectors' => [
					'{{WRAPPER}} .events-wrap' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'events_area_padding',
			[
				'label' => __( 'Event Area Padding', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' 		=> '10',
					'right' 	=> '10',
					'bottom' 	=> '10',
					'left' 		=> '10',
				],
				'selectors' => [
					'{{WRAPPER}} .events-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'event_items_bg_color',
			[
				'label' 	=> __( 'Item Background Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .single-event-item' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'events_items_padding',
			[
				'label' => __( 'Event Item Padding', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' 		=> '60',
					'right' 	=> '60',
					'bottom' 	=> '60',
					'left' 		=> '60',
				],
				'selectors' => [
					'{{WRAPPER}} .single-event-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();

		if( !empty( $settings['display_posts_cat'] ) ){
			$category = !empty( $settings['display_posts_cat'] ) ? $settings['display_posts_cat'] : 'All';
	    	$args = array(
				'post_type'      => 'tp_event',
				'post_status'    => 'publish',
				'posts_per_page' => $settings['post_number'],
				'orderby'        => $settings['post_orderby'],
				'order' 		 => $settings['post_order'],
	            'tax_query'      => array(
	                array(
	                    'taxonomy'  => 'tp_event_category',
	                    'field'     => 'id', 
	                    'terms'     => $category
	                )
	            )
	    	);
		}else{
	    	$args = array(
				'post_type'      => 'tp_event',
				'post_status'    => 'publish',
				'posts_per_page' => $settings['post_number'],
				'orderby'        => $settings['post_orderby'],
				'order' 		 => $settings['post_order'],
	    	);
		}

    	$e_uniqid     = uniqid();
		 
		$grid_query = new \WP_Query( $args );

		if ( $grid_query->have_posts() ) : 
			if( function_exists('WPEMS') ): ?>

				<!-- events-area -->
			    <div class="events-area">
			    	<?php if ( $settings['event_filter'] == 'yes' ) : ?>
						<script>
							jQuery(window).on('load', function () {
							    jQuery('.event-active').imagesLoaded( function() {
							        // portfolio - active
							        var $grid = jQuery('.event-active-<?php echo esc_attr($e_uniqid); ?>').isotope({
							            itemSelector: '.grid-item',
							            layoutMode: 'fitRows',
							            percentPosition: true,
							        })
							        // filter items on button click
							        jQuery('.events-menu-<?php echo esc_attr($e_uniqid); ?>').on('click', 'button', function () {
							            var filterValue = jQuery(this).attr('data-filter');
							            $grid.isotope({ filter: filterValue });
							        });
							        //for menu active class
							        jQuery('.events-menu-<?php echo esc_attr($e_uniqid); ?> button').on('click', function (event) {
							            jQuery(this).siblings('.active').removeClass('active');
							            jQuery(this).addClass('active');
							            event.preventDefault();
							        });
							    });
							});
						</script>

						<?php if( !empty( $settings['display_posts_cat'] ) ) : ?>
					        <div class="row justify-content-center">
					            <div class="col-xl-8 col-lg-10 text-center">
					                <div class="event-menus events-menu-<?php echo esc_attr($e_uniqid); ?> mb-50">
					                <?php
							            $filters = get_terms( array(
								        'taxonomy' => 'tp_event_category',
								        'include' => $settings['display_posts_cat'],
								        'hide_empty'  => false,
								        'orderby'  => 'include',
								      	) );

								      	if (!empty($filters)) : ?>
					                        <button class="active" data-filter="*"><?php esc_html_e( '+ All Categories', 'chariton' ); ?></button>
						                    <?php 
							                    if ( $filters && ! is_wp_error( $filters ) ) :
									              	foreach ( $filters as $filter ) :
									                	echo "<button class=\"button\" data-filter=\".$filter->slug\">+ $filter->name</button>";
									              	endforeach;
									            endif;
							            	?>
					                	<?php endif; ?>
					                </div>
					            </div>
					        </div>
					    <?php endif; ?>
			        <?php endif; ?>

			        <div class="row">
			            <div class="col-12">
			                <div class="events-wrap">
			                    <div class="event-active-<?php echo esc_attr($e_uniqid); ?>">
									<?php 
										while ( $grid_query->have_posts() ) : $grid_query->the_post(); global $post;

			                            $date_start = get_post_meta( get_the_ID(), 'tp_event_date_start', true ) ? strtotime( get_post_meta( get_the_ID(), 'tp_event_date_start', true ) ) : time();
			                            $date_end   = get_post_meta( get_the_ID(), 'tp_event_date_end', true ) ? strtotime( get_post_meta( get_the_ID(), 'tp_event_date_end', true ) ) : time();
										$time_start = wpems_event_start( get_option( 'time_format' ) );
			                            $time_end   = wpems_event_end( get_option( 'time_format' ) );

			                            $date_string = '';
			                            if ( $date_start === $date_end ) {
			                                $date_string = date_i18n( get_option( 'date_format' ), $date_start );
			                            } else {
			                                $date_string = date_i18n( get_option( 'date_format' ), $date_start ) . ' - ' . date_i18n( get_option( 'date_format' ), $date_end );
			                            }

			                            $date_status =  get_post_meta( get_the_ID(), 'tp_event_status', true );

									    $terms = get_the_terms(get_the_ID(), 'tp_event_category' );
								        if ( $terms && ! is_wp_error( $terms ) ) {
								            $draught_links = array();
								            foreach ( $terms as $term ) {
								                $draught_links[] = $term->slug;
								                $term_link = get_term_link( $term );
								            }        
								        	$cat_slug = join( " ", $draught_links );
								        }
								  	?>

			                        <div class="single-event-item grid-item <?php echo esc_attr( $cat_slug ); ?> mb-10">
			                            <div class="row">
			                            	<?php if( has_post_thumbnail() ) : ?>
				                                <div class="col-lg-5">
				                                    <div class="event-thumb">
				                                        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('chariton-event-400-400'); ?></a>
				                                    </div>
				                                </div>
			                                <?php endif; ?>
			                                <div class="col-lg-7">
			                                	<?php 
			                                	$terms = wp_get_post_terms( $post->ID, 'tp_event_category');
			                                	if (!empty($terms) || !empty( $time_start ) || !empty( $time_end ) ) :
			                                	?>
			                                    <div class="event-post-tag mb-10">
			                                        <ul>
			                                        	<?php foreach ($terms as $term) {
														    echo '<li class="event-cat-list"><a href="'.get_term_link($term->slug, 'tp_event_category').'">'.$term->name.'</a></li>';
														} ?>
			                                            <?php if ( !empty( $time_start ) || !empty( $time_end ) ) : ?>
			                                             <li><?php echo esc_html( $time_start . ' - ' . $time_end ); ?></li>
			                                        	<?php endif; ?>
			                                        </ul>
			                                    </div>
			                                    <?php endif; ?>

			                                    <div class="event-content">
			                                        <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
			                                        <p><?php echo chariton_excerpt( $settings['post_excerpt'] ); ?></p>
			                                    </div>

			                                    <?php if( function_exists('acf_add_local_field_group') ): ?>
				                                    <div class="event-meta">
				                                        <ul>
				                                            <li><?php echo esc_html('Speaker:'); ?><span><?php echo esc_html( get_field( 'event_speaker' ) ); ?></span></li>
				                                        	<li><?php echo esc_html('Date:'); ?><span><?php echo esc_html( $date_string ); ?></span></li>
				                                        	<li><?php echo esc_html('Status:'); ?>
					                                        	<?php if( $date_status == 'expired' ){ ?>
					                                        		<span class="status-expired-soon"><?php echo esc_html( $date_status ); ?></span>
					                                        	<?php }else{ ?> 
					                                        		<span><?php echo esc_html( $date_status ); ?></span>
					                                        	<?php } ?>
				                                        	</li>
				                                        </ul>
				                                    </div>
			                                	<?php endif; ?>
			                                </div>
			                            </div>
			                        </div>
									<?php endwhile; wp_reset_postdata(); ?>
			                    </div>
			                </div>
			            </div>
			        </div>
			    </div>
			    <!-- events-area-end -->

		<?php endif; endif;   //main if end
	}
}