<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Head extends Widget_Base {

	public function get_name() {
		return 'section-head';
	}

	public function get_title() {
		return 'Section Head';   // title to show on chariton
	}

	public function get_icon() {
		return 'eicon-t-letter';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Section Header', 'chariton' ),   //section name for controler view
			]
		);

		$this->add_control(
			'section_head_version',
			[
				'label' => __( 'Section Head Version', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => __( 'Style 1', 'chariton' ),
					'2'  => __( 'Style 2', 'chariton' ),
					'3'  => __( 'Style 3', 'chariton' ),
					'4'  => __( 'Style 4', 'chariton' ),
				],
			]
		);

		// Title 
		$this->add_control(
			'title_text_heading',
			[
				'label' => __( 'Title', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'section_title',
			[
				'label' => esc_html__( 'Title', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'title_animation',
			[
				'label' => __( 'Title Animation', 'chariton' ),
				'type' => Controls_Manager::ANIMATION,
				'label_block' => true,
			]
		);

		$this->add_control(
			'title_anim_delay',
			[
				'label' => __( 'Animation Delay', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => '0.2s',
				'options' => ifinger_anim_delay(),
				'label_block' => true,
			]
		);

		// Sub Title
		$this->add_control(
			'subtitle_text_heading',
			[
				'label' => __( 'Sub Title Settings', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'sec_sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'subtitle_animation',
			[
				'label' => __( 'Sub Title Animation', 'chariton' ),
				'type' => Controls_Manager::ANIMATION,
				'label_block' => true,
			]
		);

		$this->add_control(
			'subtitle_anim_delay',
			[
				'label' => __( 'Animation Delay', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => '0.2s',
				'options' => ifinger_anim_delay(),
				'label_block' => true,
			]
		);

		$this->add_control(
			'background_icon_img',
			[
				'label' => esc_html__( 'Background Icon Image', 'chariton' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
				'condition' => [
					'section_head_version' => '3',
				],
			]
		);

		// Description 
		$this->add_control(
			'desc_text_heading',
			[
				'label' => __( 'Description Settings', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'section_desc',
			[
				'label' => esc_html__( 'Short Description', 'chariton' ),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);

		$this->add_control(
			'desc_animation',
			[
				'label' => __( 'Description Animation', 'chariton' ),
				'type' => Controls_Manager::ANIMATION,
				'label_block' => true,
			]
		);

		$this->add_control(
			'desc_anim_delay',
			[
				'label' => __( 'Animation Delay', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => '0.2s',
				'options' => ifinger_anim_delay(),
				'label_block' => true,
			]
		);

		$this->add_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'chariton' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'chariton' ),
						'icon' => 'fa fa-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'chariton' ),
						'icon' => 'fa fa-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'chariton' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'text-center',
				'toggle' => true,
			]
		);
		
		$this->end_controls_section();

		//End  of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_heading',
			[
				'label' => __( 'Title Style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		/* = Title Styling
		========================================*/
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .section-title h2',
			]
		);

		$this->add_control(
			'title_text_color',
			[
				'label' => __( 'Text Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
				],
			]
		);
		
		/* = Sub Title Styling
		========================================*/
		$this->add_control(
			'sub_hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'sub_title_heading',
			[
				'label' => __( 'Sub Title Style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_title_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .section-title > span, .s-section-title h6',
			]
		);

		$this->add_control(
			'sub_title_text_color',
			[
				'label' => __( 'Text Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .section-title > span, .s-section-title h6' => 'color: {{VALUE}};',
					'{{WRAPPER}} .s-section-title h6 span' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'sub_title_bg_color',
			[
				'label' => __( 'Banckground Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .section-title > span' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'section_head_version' => '1',
				],
			]
		);

		$this->add_responsive_control(
			'sub_title_padding',
			[
				'label' => __( 'Padding', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .section-title > span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'section_head_version' => '1',
				],
			]
		);

		/* = Description Styling
		========================================*/
		$this->add_control(
			'desc_hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'desc_heading',
			[
				'label' => __( 'Short Description Style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .section-title p',
			]
		);

		$this->add_control(
			'desc_text_color',
			[
				'label' => __( 'Text Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .section-title p' => 'color: {{VALUE}};',
				],
			]
		);

	}
	//end of control box 

	protected function render() {				//to show on the fontend 

		$settings = $this->get_settings_for_display();

		$text_align = $settings['text_align'];
		$section_head_version = $settings['section_head_version'];

		$t_anim = $settings['title_animation'];
		$t_delay = $settings['title_anim_delay'];

		$st_anim = $settings['subtitle_animation'];
		$st_delay = $settings['subtitle_anim_delay'];

		$desc_anim = $settings['desc_animation'];
		$desc_delay = $settings['desc_anim_delay'];


		$section_title = $settings['section_title'];
		$sec_sub_title = $settings['sec_sub_title'];
		$section_desc = $settings['section_desc'];
		
		$this->add_inline_editing_attributes( 'section_title', 'none' );
		$this->add_inline_editing_attributes( 'sec_sub_title', 'basic' );
		$this->add_inline_editing_attributes( 'section_desc', 'advanced' );

		if (!empty($t_anim)) {
			$title_anim = 'class="wow '.esc_attr( $t_anim ).'" data-wow-delay="'.esc_attr( $t_delay ).'"';
		} else {
			$title_anim = '';	
		} if (!empty($st_anim)) {
			$subtitle_anim = 'class="wow '.esc_attr( $st_anim ).'" data-wow-delay="'.esc_attr( $st_delay ).'"';
		} else {
			$subtitle_anim = '';	
		} if (!empty($desc_anim)) {
			$desc_anim = 'class="wow '.esc_attr( $desc_anim ).'" data-wow-delay="'.esc_attr( $desc_delay ).'"';
		} else {
			$desc_anim = '';
		}

		if ( $section_head_version == 1 ) { ?>
			<div class="section-title <?php echo esc_attr( $text_align ); ?>">
				<?php if (!empty($sec_sub_title)) { ?>
		        <span <?php echo $this->get_render_attribute_string( 'sec_sub_title' ); ?><?php echo $subtitle_anim; ?>><?php echo esc_html( $sec_sub_title ); ?></span>
		        <?php } if (!empty($section_title)) { ?>
		        <h2 <?php echo $this->get_render_attribute_string( 'section_title' ); ?><?php echo $title_anim; ?>><?php echo wp_kses_stripslashes( $section_title ); ?></h2>
		        <?php } if (!empty($section_desc)) { ?>
		    	<p <?php echo $this->get_render_attribute_string( 'section_desc' ); ?><?php echo $desc_anim; ?>><?php echo wp_kses_stripslashes( $section_desc ); ?></p>
		    	<?php } ?>
			</div>
		<?php } elseif ( $section_head_version == 2 ) { ?>
			<div class="section-title s-section-title mb-25">
                <h6 <?php echo $this->get_render_attribute_string( 'sec_sub_title' ); ?><?php echo $subtitle_anim; ?>><span></span><?php echo esc_html( $sec_sub_title ); ?></h6>
                <h2 <?php echo $this->get_render_attribute_string( 'section_title' ); ?><?php echo $title_anim; ?>><?php echo wp_kses_stripslashes( $section_title ); ?></h2>
            </div>
	    <?php } elseif ( $section_head_version == 3 ) {
	    	$bg_icon = $settings['background_icon_img']['url'];
	    	if (!empty($bg_icon)) {
	    		$icon_class = 'uploaded-icon';
	    	} else {
	    		$icon_class = '';
	    	}
		    ?>
	        <div class="section-title t-section-title t-features-title <?php echo esc_attr( $text_align . ' '.$icon_class ); ?>" style="background-image: url(<?php echo esc_url($bg_icon); ?>);">
	            <?php if (!empty($sec_sub_title)) { ?>
		        <span <?php echo $this->get_render_attribute_string( 'sec_sub_title' ); ?><?php echo $subtitle_anim; ?>><?php echo esc_html( $sec_sub_title ); ?></span>
		        <?php } if (!empty($section_title)) { ?>
		        <h2 <?php echo $this->get_render_attribute_string( 'section_title' ); ?><?php echo $title_anim; ?>><?php echo wp_kses_stripslashes( $section_title ); ?></h2>
		        <?php } if (!empty($section_desc)) { ?>
		    	<p <?php echo $this->get_render_attribute_string( 'section_desc' ); ?><?php echo $desc_anim; ?>><?php echo wp_kses_stripslashes( $section_desc ); ?></p>
		    	<?php } ?>
	        </div>

	    <?php } else { ?>
			<div class="section-title <?php echo esc_attr( $text_align ); ?>">
				<?php if (!empty($sec_sub_title)) { ?>
		        <span <?php echo $this->get_render_attribute_string( 'sec_sub_title' ); ?><?php echo $subtitle_anim; ?>><?php echo esc_html( $sec_sub_title ); ?></span>
		        <?php } if (!empty($section_title)) { ?>
		        <h2 <?php echo $this->get_render_attribute_string( 'section_title' ); ?><?php echo $title_anim; ?>
		        ><?php echo wp_kses_stripslashes( $section_title ); ?></h2>
		        <?php } if (!empty($section_desc)) { ?>
		    	<p <?php echo $this->get_render_attribute_string( 'section_desc' ); ?><?php echo $desc_anim; ?>><?php echo wp_kses_stripslashes( $section_desc ); ?></p>
		    	<?php } ?>
			</div>
	    <?php } ?>
	<?php
	}
}