<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Single_Counter extends Widget_Base {

	public function get_name() {
		return 'single-counter';
	}

	public function get_title() {
		return 'Single Counter';   // title to show on chariton
	}

	public function get_icon() {
		return 'fal fa-sort-numeric-up';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Single Counter', 'chariton' ),   //section name for controler view
			]
		);

		$this->add_control(
			'counter_icon_type',
			[
				'label' => __( 'Counter Icon Type', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'icon'  => __( 'Icon', 'chariton' ),
					'image'  => __( 'Image', 'chariton' ),
				],
				'default' => [ 'icon' ],

			]
		);

		$this->add_control(
			'counter_icon_font',
			[
				'label' => esc_html__( 'Font Icon', 'chariton' ),
				'type' => Controls_Manager::ICON,
				'label_block' => true,
				'condition' => [
					'counter_icon_type' => 'icon',
				],
			]
		);

		$this->add_control(
			'counter_icon_img',
			[
				'label' => esc_html__( 'Background Icon Image', 'chariton' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
				'condition' => [
					'counter_icon_type' => 'image',
				],
			]
		);

		$this->add_control(
			'count_number',
			[
				'label' => esc_html__( 'Count Number', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'number_suffix',
			[
				'label' => esc_html__( 'Number suffix', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'counter_title',
			[
				'label' => esc_html__( 'Counter Title', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'chariton' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'chariton' ),
						'icon' => 'fa fa-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'chariton' ),
						'icon' => 'fa fa-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'chariton' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'text-center',
				'toggle' => true,
			]
		);

		$this->add_control(
			'counter_style',
			[
				'label' => __( 'Style', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => __( 'Style 1', 'chariton' ),
					'2'  => __( 'Style 2', 'chariton' ),
					'3'  => __( 'Style 3', 'chariton' ),
				],
			]
		);

		$this->add_control(
			'data_percent',
			[
				'label' => __( 'Data percent', 'chariton' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 5,
				'max' => 100,
				'step' => 5,
				'default' => 75,
				'condition' => [
					'counter_style' => '2',
				],
			]
		);

		$this->add_control(
			'data_barcolor',
			[
				'label' => __( 'Data barcolor', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#a50042',
				'label_block' => true,
				'condition' => [
					'counter_style' => '2',
				],
			]
		);

		$this->add_control(
			'data_trackcolor',
			[
				'label' => __( 'Data trackcolor', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff6fa',
				'label_block' => true,
				'condition' => [
					'counter_style' => '2',
				],
			]
		);

		$this->add_control(
			'data_linewidth',
			[
				'label' => __( 'Data linewidth', 'chariton' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 3,
				'max' => 100,
				'step' => 2,
				'default' => 6,
				'condition' => [
					'counter_style' => '2',
				],
			]
		);

		$this->add_control(
			'data_barsize',
			[
				'label' => __( 'Data barsize', 'chariton' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 10,
				'max' => 500,
				'step' => 10,
				'default' => 120,
				'condition' => [
					'counter_style' => '2',
				],
			]
		);
		
		$this->end_controls_section();

		//End  of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'full_item_style',
			[
				'label' => __( 'Full item style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'item_bg_color',
			[
				'label' => __( 'Background Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-counter' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .s-single-counter' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_margin_arround',
			[
				'label' => __( 'Margin', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .single-counter' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'item_padding_arround',
			[
				'label' => __( 'Padding', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .single-counter' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'item_border_radious',
			[
				'label' => __( 'Border radius', 'chariton' ),
				'type' => Controls_Manager::SLIDER,
				'deafult' => '',
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .single-counter' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		/* = Icon or image style = */
		$this->add_control(
			'icon_style',
			[
				'label' => __( 'Icon style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'counter_icon_type' => 'icon',
				],
			]
		);

		$this->add_control(
			'image_style',
			[
				'label' => __( 'Image style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'counter_icon_type' => 'image',
				],
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => __( 'Icon Size', 'chariton' ),
				'type' => Controls_Manager::SLIDER,
				'deafult' => '',
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .single-counter i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'counter_icon_type' => 'icon',
				],
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => __( 'Icon Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-counter i' => 'color: {{VALUE}};',
				],
				'condition' => [
					'counter_icon_type' => 'icon',
				],
			]
		);

		$this->add_responsive_control(
			'image_size',
			[
				'label' => __( 'Image Size', 'chariton' ),
				'type' => Controls_Manager::SLIDER,
				'deafult' => '',
				'range' => [
					'px' => [
						'min' => 20,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .single-counter .counter-icon img' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'counter_icon_type' => 'image',
				],
			]
		);

		/* = Number style = */
		$this->add_control(
			'number_hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'number_style',
			[
				'label' => __( 'Number style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'number_color',
			[
				'label' => __( 'Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-counter h2' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'number_size',
			[
				'label' => __( 'Font Size', 'chariton' ),
				'type' => Controls_Manager::SLIDER,
				'deafult' => '',
				'range' => [
					'px' => [
						'min' => 24,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .single-counter h2' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		/* = Text style = */
		$this->add_control(
			'text_hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'text_style',
			[
				'label' => __( 'Text style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'text_color',
			[
				'label' => __( 'Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-counter p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_font_size',
			[
				'label' => __( 'Font size', 'chariton' ),
				'type' => Controls_Manager::SLIDER,
				'deafult' => '',
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .single-counter p' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_height',
			[
				'label' => __( 'Line height', 'chariton' ),
				'type' => Controls_Manager::SLIDER,
				'deafult' => '',
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .single-counter p' => 'line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);

	}
	//end of control box 

	protected function render() {
	    $settings = $this->get_settings_for_display();

	    // Define variables for settings
	    $text_align = !empty($settings['text_align']) ? $settings['text_align'] : '';
	    $counter_icon_type = $settings['counter_icon_type'];
	    $counter_icon_font = !empty($settings['counter_icon_font']) ? $settings['counter_icon_font'] : '';
	    $counter_icon_img = !empty($settings['counter_icon_img']['url']) ? esc_url($settings['counter_icon_img']['url']) : '';
	    $count_number = $settings['count_number'];
	    $number_suffix = $settings['number_suffix'];
	    $counter_title = $settings['counter_title'];
	    $counter_style = $settings['counter_style'];
	    $data_percent = $settings['data_percent'];
	    $data_barcolor = $settings['data_barcolor'];
	    $data_trackcolor = $settings['data_trackcolor'];
	    $data_linewidth = $settings['data_linewidth'];
	    $data_barsize = $settings['data_barsize'];

	    // Add inline editing attributes
	    $this->add_inline_editing_attributes('count_number', 'none');
	    $this->add_inline_editing_attributes('counter_title', 'basic');

	    // Determine counter style class
	    $counter_no = ($counter_style == 3) ? 'counter-style-five' : '';

	    // Render based on counter style
	    if ($counter_style == 3) { ?>
	        <div class="single-counter <?php echo esc_attr($counter_no . ' ' . $text_align); ?>">
	            <?php if ($counter_icon_font || $counter_icon_img) : ?>
	                <div class="counter-icon">
	                    <?php if ($counter_icon_type == 'image') : ?>
	                        <img src="<?php echo $counter_icon_img; ?>" alt="<?php esc_attr_e('img', 'chariton'); ?>">
	                    <?php else : ?>
	                        <i class="<?php echo esc_attr($counter_icon_font); ?>"></i>
	                    <?php endif; ?>
	                </div>
	            <?php endif; ?>
	            <div class="counter-content">
	                <?php if ($count_number) : ?>
	                    <h2>
	                        <span <?php echo $this->get_render_attribute_string('count_number'); ?> class="count">
	                            <?php echo esc_html($count_number); ?>
	                        </span><?php echo esc_html($number_suffix); ?>
	                    </h2>
	                <?php endif; ?>
	                <?php if ($counter_title) : ?>
	                    <p <?php echo $this->get_render_attribute_string('counter_title'); ?>>
	                        <?php echo wp_kses_stripslashes($counter_title); ?>
	                    </p>
	                <?php endif; ?>
	            </div>
	        </div>

	    <?php } elseif ($counter_style == 2) { ?>
	        <div class="s-single-counter text-center">
	            <div class="circle-wrap">
	                <div class="pie-chart position-relative d-inline-block mb-20" data-percent="<?php echo esc_attr($data_percent); ?>" data-barcolor="<?php echo esc_attr($data_barcolor); ?>" data-trackcolor="<?php echo esc_attr($data_trackcolor); ?>" data-linewidth="<?php echo esc_attr($data_linewidth); ?>" data-barsize="<?php echo esc_attr($data_barsize); ?>">
	                    <?php if ($counter_icon_font || $counter_icon_img) : ?>
	                        <div class="s-counter-icon">
	                            <?php if ($counter_icon_type != 'icon') : ?>
	                                <img src="<?php echo $counter_icon_img; ?>" alt="<?php esc_attr_e('img', 'chariton'); ?>">
	                            <?php else : ?>
	                                <i class="<?php echo esc_attr($counter_icon_font); ?>"></i>
	                            <?php endif; ?>
	                        </div>
	                    <?php endif; ?>
	                </div>
	                <div class="counter-content s-counter-content">
	                    <?php if ($count_number) : ?>
	                        <h2>
	                            <span <?php echo $this->get_render_attribute_string('count_number'); ?> class="count">
	                                <?php echo esc_html($count_number); ?>
	                            </span><?php echo esc_html($number_suffix); ?>
	                        </h2>
	                    <?php endif; ?>
	                    <?php if ($counter_title) : ?>
	                        <span <?php echo $this->get_render_attribute_string('counter_title'); ?>>
	                            <?php echo wp_kses_stripslashes($counter_title); ?>
	                        </span>
	                    <?php endif; ?>
	                </div>
	            </div>
	        </div>

	    <?php } else { ?>
	        <div class="single-counter <?php echo esc_attr($counter_no . ' ' . $text_align); ?>">
	            <?php if ($counter_icon_font || $counter_icon_img) : ?>
	                <div class="counter-icon">
	                    <?php if ($counter_icon_type == 'image') : ?>
	                        <img src="<?php echo $counter_icon_img; ?>" alt="<?php esc_attr_e('img', 'chariton'); ?>">
	                    <?php else : ?>
	                        <i class="<?php echo esc_attr($counter_icon_font); ?>"></i>
	                    <?php endif; ?>
	                </div>
	            <?php endif; ?>
	            <div class="counter-content">
	                <?php if ($count_number) : ?>
	                    <h2>
	                        <span <?php echo $this->get_render_attribute_string('count_number'); ?> class="count">
	                            <?php echo esc_html($count_number); ?>
	                        </span><?php echo esc_html($number_suffix); ?>
	                    </h2>
	                <?php endif; ?>
	                <?php if ($counter_title) : ?>
	                    <p <?php echo $this->get_render_attribute_string('counter_title'); ?>>
	                        <?php echo wp_kses_stripslashes($counter_title); ?>
	                    </p>
	                <?php endif; ?>
	            </div>
	        </div>
	    <?php }
	}

	protected function content_template() {
	    ?>
	    <#
	    var counter_no = settings.counter_style == 3 ? 'counter-style-five' : '';
	    var textAlign = settings.text_align || '';
	    var counterIcon = settings.counter_icon_type === 'image' ? settings.counter_icon_img.url : settings.counter_icon_font;
	    var iconTag = settings.counter_icon_type === 'image' ? 'img' : 'i';
	    var countNumber = settings.count_number || '';
	    var numberSuffix = settings.number_suffix || '';
	    var counterTitle = settings.counter_title || '';
	    var dataAttributes = {
	        percent: settings.data_percent,
	        barcolor: settings.data_barcolor,
	        trackcolor: settings.data_trackcolor,
	        linewidth: settings.data_linewidth,
	        barsize: settings.data_barsize
	    };

	    if (settings.counter_style == 3) { #>
	        <div class="single-counter {{ counter_no }} {{ textAlign }}">
	            <div class="counter-icon">
	                <# if (iconTag === 'img') { #>
	                    <img src="{{ counterIcon }}" alt="Icon">
	                <# } else { #>
	                    <i class="{{ counterIcon }}"></i>
	                <# } #>
	            </div>
	            <div class="counter-content">
	                <h2><span class="count">{{{ countNumber }}}</span>{{ numberSuffix }}</h2>
	                <p>{{{ counterTitle }}}</p>
	            </div>
	        </div>
	    <# } else if (settings.counter_style == 2) { #>
	        <div class="s-single-counter text-center">
	            <div class="circle-wrap">
	                <div class="pie-chart position-relative" <# _.each(dataAttributes, function(value, key) { #> data-{{ key }}="{{ value }}" <# }); #>>
	                    <div class="s-counter-icon">
	                        <# if (iconTag === 'img') { #>
	                            <img src="{{ counterIcon }}" alt="Icon">
	                        <# } else { #>
	                            <i class="{{ counterIcon }}"></i>
	                        <# } #>
	                    </div>
	                </div>
	                <div class="counter-content s-counter-content">
	                    <h2><span class="count">{{{ countNumber }}}</span>{{ numberSuffix }}</h2>
	                    <span>{{{ counterTitle }}}</span>
	                </div>
	            </div>
	        </div>
	    <# } else { #>
	        <div class="single-counter {{ textAlign }}">
	            <div class="counter-icon">
	                <# if (iconTag === 'img') { #>
	                    <img src="{{ counterIcon }}" alt="Icon">
	                <# } else { #>
	                    <i class="{{ counterIcon }}"></i>
	                <# } #>
	            </div>
	            <div class="counter-content">
	                <h2><span class="count">{{{ countNumber }}}</span>{{ numberSuffix }}</h2>
	                <p>{{{ counterTitle }}}</p>
	            </div>
	        </div>
	    <# } #>
	    <?php
	}

}