<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Single_Feature extends Widget_Base {

	public function get_name() {
		return 'single-feature';
	}

	public function get_title() {
		return 'Single Feature';   // title to show on chariton
	}

	public function get_icon() {
		return 'eicon-featured-image';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Single Feature', 'chariton' ),   //section name for controler view
			]
		);

		$this->add_control(
			'feature_icon_type',
			[
				'label' => __( 'Icon Type', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'icon'  => __( 'Icon', 'chariton' ),
					'image'  => __( 'Image', 'chariton' ),
				],
				'default' => [ 'icon' ],
			]
		);

		$this->add_control(
			'feature_icon_font',
			[
				'label' => esc_html__( 'Font Icon', 'chariton' ),
				'type' => Controls_Manager::ICON,
				'label_block' => true,
				'condition' => [
					'feature_icon_type' => 'icon',
				],
			]
		);

		$this->add_control(
			'feature_icon_img',
			[
				'label' => esc_html__( 'Icon Image', 'chariton' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
				'condition' => [
					'feature_icon_type' => 'image',
				],
			]
		);

		$this->add_control(
			'feature_title',
			[
				'label' => esc_html__( 'Feature Title', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'feature_desc',
			[
				'label' => esc_html__( 'Feature Description', 'chariton' ),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'chariton' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'chariton' ),
						'icon' => 'fa fa-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'chariton' ),
						'icon' => 'fa fa-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'chariton' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'text-center',
				'toggle' => true,
			]
		);		
		
		$this->end_controls_section();

		//End of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'full_item_style',
			[
				'label' => __( 'Full item style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'item_bg_color',
			[
				'label' => __( 'Background Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-faq-box' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_margin_arround',
			[
				'label' => __( 'Margin', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .single-faq-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'item_padding_arround',
			[
				'label' => __( 'Padding', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .single-faq-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'item_border_radious',
			[
				'label' => __( 'Border radius', 'chariton' ),
				'type' => Controls_Manager::SLIDER,
				'deafult' => '',
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .single-faq-box' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		/* = Icon or image style = */
		$this->add_control(
			'icon_style',
			[
				'label' => __( 'Icon style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'feature_icon_type' => 'icon',
				],
			]
		);

		$this->add_control(
			'image_style',
			[
				'label' => __( 'Image style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'feature_icon_type' => 'image',
				],
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => __( 'Icon Size', 'chariton' ),
				'type' => Controls_Manager::SLIDER,
				'deafult' => '',
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .single-faq-box .faq-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'feature_icon_type' => 'icon',
				],
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => __( 'Icon Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-faq-box .faq-icon i' => 'color: {{VALUE}};',
				],
				'condition' => [
					'counter_icon_type' => 'icon',
				],
			]
		);

		$this->add_responsive_control(
			'image_size',
			[
				'label' => __( 'Image Size', 'chariton' ),
				'type' => Controls_Manager::SLIDER,
				'deafult' => '',
				'range' => [
					'px' => [
						'min' => 20,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .single-faq-box .faq-icon img' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'counter_icon_type' => 'image',
				],
			]
		);

		$this->add_control(
			'icon_box_color',
			[
				'label' => __( 'Icon or image box background color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-faq-box .faq-icon ' => 'background: {{VALUE}};',
					'{{WRAPPER}} .single-faq-box .faq-icon::before ' => 'background: {{VALUE}};',
					'{{WRAPPER}} .single-faq-box .faq-icon::after ' => 'background: {{VALUE}};',
				],
			]
		);

		/* = Title style = */
		$this->add_control(
			'title_hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'title_style',
			[
				'label' => __( 'Title style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __( 'Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .faq-box-content h4' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .faq-box-content h4',
			]
		);

		/* = Description style = */
		$this->add_control(
			'desc_hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'desc_style',
			[
				'label' => __( 'Text style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'desc_color',
			[
				'label' => __( 'Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .faq-box-content p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .faq-box-content p',
			]
		);

	}
	//end of control box 

	protected function render() { // Display content on the frontend
	    $settings = $this->get_settings_for_display();

	    // Check if 'feature_icon_img' is set and retrieve its URL
	    $feature_icon_img = !empty($settings['feature_icon_img']['url']) ? $settings['feature_icon_img']['url'] : '';
	    $feature_title = !empty($settings['feature_title']) ? $settings['feature_title'] : '';
	    $feature_desc = !empty($settings['feature_desc']) ? $settings['feature_desc'] : '';

	    // Inline editing attributes
	    $this->add_inline_editing_attributes('feature_title', 'none');
	    $this->add_inline_editing_attributes('feature_desc', 'basic');
	    ?>

	    <div class="single-faq-box text-center mb-15">
	        <?php if (!empty($settings['feature_icon_font']) || !empty($feature_icon_img)) { ?>
	            <div class="faq-icon">
	                <?php if (!empty($settings['feature_icon_type']) && $settings['feature_icon_type'] == 'image' && $feature_icon_img) { ?>
	                    <img src="<?php echo esc_attr($feature_icon_img); ?>" alt="<?php echo esc_attr__('img', 'chariton'); ?>">
	                <?php } else { ?>
	                    <i class="<?php echo esc_attr($settings['feature_icon_font']); ?>"></i>
	                <?php } ?>
	            </div>
	        <?php } ?>
	        <div class="faq-box-content">
	            <h4 <?php echo $this->get_render_attribute_string('feature_title'); ?>><?php echo wp_kses_stripslashes($feature_title); ?></h4>
	            <p <?php echo $this->get_render_attribute_string('feature_desc'); ?>><?php echo wp_kses_stripslashes($feature_desc); ?></p>
	        </div>
	    </div>

	    <?php
	}	
}