<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Our_Team extends Widget_Base {   //this name is added to plugin.php of the root folder

	public function get_name() {
		return 'section-team';
	}

	public function get_title() {
		return 'Team';   // title to show on elementor
	}

	public function get_icon() {
		return 'fal fa-users-medical';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}
    
     public function get_script_depends() {
		return [ 'chariton-elementor-editor' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Team Grid', 'chariton' ),   //section name for controler view
			]
		);
		$this->add_control(
			'team_style',
			[
				'label' => __( 'Style', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => __( 'Style 1', 'chariton' ),
					'2' => __( 'Style 2', 'chariton' ),
					'3' => __( 'Style 3', 'chariton' ),
					'4' => __( 'Style 4', 'chariton' ),
				],
			]
		);
		$this->add_control(
			'post_number',
			[
				'label' => esc_html__( 'Number of team', 'chariton' ),
				'description' => esc_html__( 'Give -1 for all post', 'chariton' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 3,
			]
		);

        $this->add_control(
            'query_type',
            [
                'label' => __( 'Get Posts by cats or title', 'chariton' ),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    'cats'   => __( 'Posts by Cats', 'chariton' ),
                    'titles' => __( 'Posts by Titles', 'chariton' ),
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'postbycats',
            [
                'label' => __( 'Post By Categories', 'chariton' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => chariton_get_terms_dropdown_array([
                    'taxonomy' => 'team_category',
                    'hide_empty' => true
                ]),
                'label_block' => true,
                'condition'   => array( 'query_type' => array( 'cats' ) ),
            ]
        );

        $this->add_control(
            'postbytitle',
            [
                'label' => __( 'Post By Title', 'chariton' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => chariton_team_posts_title([
                    'taxonomy' => 'team_category',
                    'hide_empty' => true
                ]),
                'label_block' => true,
                'condition'   => array( 'query_type' => array( 'titles' ) ),
            ]
        );

		$this->add_control(
			'team_orderby',
			[
				'label' => __( 'Order by', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'date',
				'options' =>ifinger_post_orderby_options(),
			]
		);
		$this->add_control(
			'team_order',
			[
				'label' => __( 'Order', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'ASC' => __( 'Ascending Order', 'chariton' ),
					'DESC' => __( 'Descending', 'chariton' ),
				],
			]
		);
		$this->add_control(
			'team_columns',
			[
				'label' => __( 'Columns', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => '4',
				'options' => [
					'6' => __( '2', 'chariton' ),
					'4' => __( '3', 'chariton' ),
					'3' => __( '4', 'chariton' ),
					'2' => __( '6', 'chariton' ),
				],
			]
		);

		$this->end_controls_section();

        /* = Item Styling
        ========================================*/
        $this->start_controls_section(
            'team_items_style',
            [
                'label' => esc_html__( 'Team Grid Style', 'chariton' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'team_grid_item_bg_color',
            [
                'label' => __( 'Item Background Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#f8f8f8',
                'selectors' => [
                    '{{WRAPPER}} .ss-wrap.team-style-five' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'team_style' => '3',
                ],
            ]
        );

        $this->add_responsive_control(
            'team_grid_item_title_color',
            [
                'label' => __( 'Item Title Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#242424',
                'selectors' => [
                    '{{WRAPPER}} .ss-wrap.team-style-five .s-info h5' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'team_style' => '3',
                ],
            ]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'team_title_typography',
				'label' => __( 'Title Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .ss-wrap.team-style-five .s-info h5',
                'condition' => [
                    'team_style' => '3',
                ],
			]
		);

        $this->add_responsive_control(
            'team_grid_item_subtitle_color',
            [
                'label' => __( 'Item Sub Title Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#444444',
                'selectors' => [
                    '{{WRAPPER}} .ss-wrap.team-style-five .s-info span' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'team_style' => '3',
                ],
            ]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'team_subtitle_typography',
				'label' => __( 'Sub Title Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .ss-wrap.team-style-five .s-info span',
                'condition' => [
                    'team_style' => '3',
                ],
			]
		);
        $this->end_controls_section();

        /* = Item Hover Styling
        ========================================*/
        $this->start_controls_section(
            'team_items_hover_style',
            [
                'label' => esc_html__( 'Team Grid Hover Style', 'chariton' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'team_grid_item_hbg_color',
            [
                'label' => __( 'Item Background Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .ss-wrap.team-style-five:hover' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'team_style' => '3',
                ],
            ]
        );

        $this->add_responsive_control(
            'team_grid_item_htitle_color',
            [
                'label' => __( 'Item Title Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#242424',
                'selectors' => [
                    '{{WRAPPER}} .ss-wrap.team-style-five .s-info h5' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'team_style' => '3',
                ],
            ]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'team_htitle_typography',
				'label' => __( 'Title Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .ss-wrap.team-style-five .s-info h5',
                'condition' => [
                    'team_style' => '3',
                ],
			]
		);

        $this->add_responsive_control(
            'team_grid_item_hsubtitle_color',
            [
                'label' => __( 'Item Sub Title Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#444444',
                'selectors' => [
                    '{{WRAPPER}} .ss-wrap.team-style-five .s-info span' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'team_style' => '3',
                ],
            ]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'team_hsubtitle_typography',
				'label' => __( 'Sub Title Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .ss-wrap.team-style-five .s-info span',
                'condition' => [
                    'team_style' => '3',
                ],
			]
		);

        $this->add_responsive_control(
            'team_grid_item_hbefore_color',
            [
                'label' => __( 'Before Background Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#0141F5',
                'selectors' => [
                    '{{WRAPPER}} .ss-wrap.team-style-five .sp-thumb::before' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'team_style' => '3',
                ],
            ]
        );

        $this->add_responsive_control(
            'team_grid_item_hsocial_color',
            [
                'label' => __( 'Social Icon Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .ss-wrap.team-style-five .s-overlay a i' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'team_style' => '3',
                ],
            ]
        );

        $this->end_controls_section();

	}

	//to show on the fontend 
	protected function render() {
		$settings = $this->get_settings_for_display();

        if ( $settings['query_type'] == 'cats' && !empty( $settings['postbycats'] ) ) {
            $args = array(
                'post_type'      => 'team',
                'post_status'    => 'publish',
                'posts_per_page' => $settings['post_number'],
                'orderby'        => $settings['team_orderby'],
                'order'          => $settings['team_order'],
                'tax_query' => array(
                    array(
                        'taxonomy' => 'team_category',
                        'field' => 'id',
                        'terms' => $settings['postbycats']
                    )
                ),
            );
        } elseif ( $settings['query_type'] == 'titles' && !empty( $settings['postbytitle'] ) ) {
            $args = array(
                'post_type'      => 'team',
                'post_status'    => 'publish',
                'posts_per_page' => $settings['post_number'],
                'orderby'        => $settings['team_orderby'],
                'order'          => $settings['team_order'],
                'taxonomy'       => 'team_category',
                'post__in'       => $settings['postbytitle']
            );
        } else {
            $args = array(
                'post_type'      => 'team',
                'post_status'    => 'publish',
                'posts_per_page' => $settings['post_number'],
                'orderby'        => $settings['team_orderby'],
                'order'          => $settings['team_order'],
                'taxonomy'       => 'team_category'
            );
        }

		$query = new \WP_Query( $args );

		?>

        <!-- style 4 -->
        <?php if ($settings['team_style'] === '4') : ?>

            <?php if ($query->have_posts()) : ?>

                <div class="row">
                    <?php while ($query->have_posts()) : $query->the_post();
                        global $post;

						$chartiton_team_info = get_post_meta(get_the_ID(), '_chariton_team', true);
						$team_designation    = !empty($chartiton_team_info['team_designation']) ? $chartiton_team_info['team_designation'] : '';
						$team_social         = !empty($chartiton_team_info['team_social']) ? $chartiton_team_info['team_social'] : '';
						$active_member       = !empty($chartiton_team_info['active_member']) ? $chartiton_team_info['active_member'] : '';
						$team2_bg_color      = !empty($chartiton_team_info['team2_bg_color']) ? $chartiton_team_info['team2_bg_color'] : '';

			            $active_class = ($active_member == 1) ? 'active' : '';
                        ?>

                        <div class="col-lg-<?php echo esc_attr( $settings['team_columns'] ); ?>">
					        <div class="inner-single-team-item mb-30">
                            	<?php if(has_post_thumbnail()) : ?>
                                 	<?php the_post_thumbnail(); ?>
                                 <?php endif; ?>
					            <div class="team-info">
					                <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
				                    <?php if (!empty($team_designation)) : ?>
					                	<span class="position"><?php echo esc_html($team_designation); ?></span>
					            	<?php endif; ?>
					            </div>
			                    <?php if (is_array($team_social)) : ?>
				                    <ul class="socials">
				                        <?php foreach ($team_social as $key => $value) : ?>
				                        	<li><a href="<?php echo esc_url($value['link']); ?>"><i class="<?php echo esc_attr($value['icon']); ?>"></i></a></li>
				                        <?php endforeach; ?>
				                    </ul>
			                    <?php endif; ?>
					        </div>
                        </div>
                    <?php endwhile; wp_reset_query(); ?>
                </div>

            <?php endif; ?>

        <!-- style 3 -->
        <?php elseif ($settings['team_style'] === '3') : ?>

            <?php if ($query->have_posts()) : ?>

                <div class="row">
                    <?php while ($query->have_posts()) : $query->the_post();
                        global $post;

						$chartiton_team_info = get_post_meta(get_the_ID(), '_chariton_team', true);
						$team_designation    = !empty($chartiton_team_info['team_designation']) ? $chartiton_team_info['team_designation'] : '';
						$team_social         = !empty($chartiton_team_info['team_social']) ? $chartiton_team_info['team_social'] : '';
						$active_member       = !empty($chartiton_team_info['active_member']) ? $chartiton_team_info['active_member'] : '';
						$team2_bg_color      = !empty($chartiton_team_info['team2_bg_color']) ? $chartiton_team_info['team2_bg_color'] : '';

			            $active_class = ($active_member == 1) ? 'active' : '';
                        ?>

                        <div class="col-lg-<?php echo esc_attr( $settings['team_columns'] ); ?>">
                            <div class="ss-wrap team-style-five">
                                <div class="sp-thumb">
                                	<?php if(has_post_thumbnail()) : ?>
                                     	<?php the_post_thumbnail(); ?>
                                     <?php endif; ?>
				                    <?php if (is_array($team_social)) : ?>
					                    <div class="s-overlay">
					                        <?php foreach ($team_social as $key => $value) : ?>
					                        	<a href="<?php echo esc_url($value['link']); ?>"><i class="<?php echo esc_attr($value['icon']); ?>"></i></a>
					                        <?php endforeach; ?>
					                    </div>
				                    <?php endif; ?>
                                </div>
                                <div class="s-info">
                                    <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
				                    <?php if (!empty($team_designation)) : ?>
					                	<span><?php echo esc_html($team_designation); ?></span>
					            	<?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; wp_reset_query(); ?>
                </div>

            <?php endif; ?>

        <!-- style 2 -->
        <?php elseif ($settings['team_style'] === '2') : ?>

			<?php if ($query->have_posts()) : ?>

			    <div class="row">
			        <?php 
			        $index = 0; // Initialize an index counter for unique classes

			        while ($query->have_posts()) : $query->the_post();
			            global $post;

						$chartiton_team_info = get_post_meta(get_the_ID(), '_chariton_team', true);
						$team_designation    = !empty($chartiton_team_info['team_designation']) ? $chartiton_team_info['team_designation'] : '';
						$team_social         = !empty($chartiton_team_info['team_social']) ? $chartiton_team_info['team_social'] : '';
						$active_member       = !empty($chartiton_team_info['active_member']) ? $chartiton_team_info['active_member'] : '';
						$team2_bg_color      = !empty($chartiton_team_info['team2_bg_color']) ? $chartiton_team_info['team2_bg_color'] : '';
						
						$active_class        = ($active_member == 1) ? 'active' : '';
						$unique_class        = 'team-item-' . $index; // Unique class based on index
			        ?>

			        <div class="col-lg-<?php echo esc_attr($settings['team_columns']); ?>">
			            <div class="inner-single-team mb-30 <?php echo esc_attr($unique_class); ?>">
			                <?php if (has_post_thumbnail()) : ?>
			                    <div class="team-img">
			                        <?php the_post_thumbnail(); ?>
			                    </div>
			                <?php endif; ?>

			                <div class="inner-team-content <?php echo esc_attr($unique_class); ?>" <?php if ($team2_bg_color) : ?>style="background: <?php echo esc_attr($team2_bg_color); ?>"<?php endif; ?>>
			                    <?php if ($team2_bg_color) : ?>
			                        <!-- Inline styling for the ::before pseudo-element if color is set -->
			                        <style>
			                            .<?php echo esc_attr($unique_class); ?>::before {
			                                background: <?php echo esc_attr($team2_bg_color); ?>;
			                            }
			                        </style>
			                    <?php endif; ?>
			                    <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
			                    <?php if (!empty($team_designation)) : ?>
			                        <span><?php echo esc_html($team_designation); ?></span>
			                    <?php endif; ?>
			                    <?php if (is_array($team_social)) : ?>
			                        <div class="inner-team-social">
			                            <?php foreach ($team_social as $key => $value) : ?>
			                                <a href="<?php echo esc_url($value['link']); ?>"><i class="<?php echo esc_attr($value['icon']); ?>"></i></a>
			                            <?php endforeach; ?>
			                        </div>
			                    <?php endif; ?>
			                </div>
			            </div>
			        </div>

			        <?php 
			            $index++; // Increment index for the next item
			        endwhile; 
			        wp_reset_query(); 
			        ?>
			    </div>

			<?php endif; ?>

        <?php else : ?>

            <?php if ($query->have_posts()) : ?>

                <div class="row">
                    <?php while ($query->have_posts()) : $query->the_post();
                        global $post;

						$chartiton_team_info = get_post_meta(get_the_ID(), '_chariton_team', true);
						$team_designation    = !empty($chartiton_team_info['team_designation']) ? $chartiton_team_info['team_designation'] : '';
						$team_social         = !empty($chartiton_team_info['team_social']) ? $chartiton_team_info['team_social'] : '';
						$active_member       = !empty($chartiton_team_info['active_member']) ? $chartiton_team_info['active_member'] : '';
						$team2_bg_color      = !empty($chartiton_team_info['team2_bg_color']) ? $chartiton_team_info['team2_bg_color'] : '';
						$active_class        = ($active_member == 1) ? 'active' : '';

                        ?>

                        <div class="col-lg-<?php echo esc_attr( $settings['team_columns'] ); ?>">
							<div class="single-team single-team-member <?php echo esc_attr ( $active_class ); ?>">
					        	<?php if(has_post_thumbnail()) : ?>
						            <div class="team-img">
						                <?php the_post_thumbnail(); ?>
						            </div>
					            <?php endif; ?>
					            <div class="team-content">
					                <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
					                <?php if (!empty($team_designation)) : ?>
					                	<span><?php echo esc_html($team_designation); ?></span>
					            	<?php endif; ?>
					                <div class="team-overlay">
					                    <p><?php echo chariton_excerpt( 17 ); ?></p>
					                    <?php if (is_array($team_social)) : ?>
						                    <div class="team-social">
						                    	<?php foreach ($team_social as $key => $value) : ?>
						                        	<a href="<?php echo esc_url($value['link']); ?>"><i class="<?php echo esc_attr($value['icon']); ?>"></i></a>
						                        <?php endforeach; ?>
						                    </div>
					                	<?php endif; ?>
					                </div>
					            </div>
					        </div>
                        </div>

                    <?php endwhile; wp_reset_query(); ?>
                </div>

            <?php endif; ?>

        <?php endif; ?>
    <?php
	}
}