<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Video_Button extends Widget_Base {

	public function get_name() {
		return 'video-button';
	}

	public function get_title() {
		return 'Video';   // title to show on chariton
	}

	public function get_icon() {
		return 'fal fa-play-circle';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Video Setting', 'chariton' ),   //section name for controler view
			]
		);

		$this->add_control(
			'video_slider',
			[
				'label' => __( 'Video Slider', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'no'  => __( 'No', 'chariton' ),
					'yes'  => __( 'Yes', 'chariton' ),
				],
			]
		);

		$this->add_control(
			'video_bg_img',
			[
				'label' => esc_html__( 'Video background image', 'chariton' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
				'condition' => [
					'video_slider' => 'no',
				],
			]
		);

		$this->add_control(
			'video_link',
			[
				'label' => esc_html__( 'Video link', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'https://www.youtube.com/watch?v=uemObN8_dcw',
				'condition' => [
					'video_slider' => 'no',
				],
			]
		);
		
		$this->add_control(
			'video_icon',
			[
				'label' => esc_html__( 'Video icon', 'chariton' ),
				'type' => Controls_Manager::ICON,
				'label_block' => true,
				'default' => 'fas fa-play',
				'condition' => [
					'video_slider' => 'no',
				],
			]
		);

        $repeater = new Repeater();

        $repeater->add_control(
            'video_image',
            [
                'type' => Controls_Manager::MEDIA,
                'label' => __('Image', 'busnex'),
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'video_link',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => __('Video URL', 'busnex'),
                'default' => __('https://www.youtube.com/watch?v=uemObN8_dcw', 'busnex'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'video_icon',
            [
                'type' => Controls_Manager::ICON,
                'label_block' => true,
                'label' => __('Video Icon', 'busnex'),
                'default' => __('fas fa-play', 'busnex'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'video_slider_items',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => esc_html__('Video Slider Item', 'busnex'),
                'default' => [
                    [
                        'video_image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'video_image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                ]
            ]
        );
		
		$this->end_controls_section();

		//End  of a control box

		/* = Add Item Styling
		========================================*/
		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
        
		$this->add_responsive_control(
			'btn_bg_color',
			[
				'label' => __( 'Button background color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .video-thumb a, .pluse-animation .popup-video::after' => 'background: {{VALUE}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'btn_font_color',
			[
				'label' => __( 'Button icon color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .video-thumb a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'btn_border_radius',
			[
				'label' => __( 'Border radius', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .video-thumb a, .pluse-animation .popup-video::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

	}
	//end of control box 

    protected function render() {
        $settings = $this->get_settings_for_display();
        $unique_id = 'video-slider-' . $this->get_id();  // Unique ID for each instance

        if ( 'yes' === $settings['video_slider'] ) {
            ?>
            <div id="<?php echo esc_attr( $unique_id ); ?>" class="row video-active">
                <?php foreach ( $settings['video_slider_items'] as $item ) { ?>
                    <div class="col-12">
                        <div class="video-thumb position-relative pluse-animation">
                            <?php if ( !empty( $item['video_image']['url'] ) ) : ?>
                                <img src="<?php echo esc_url( $item['video_image']['url'] ); ?>" alt="<?php esc_attr_e( 'Video Image', 'chariton' ); ?>">
                            <?php endif; ?>
                            <a href="<?php echo esc_url( $item['video_link'] ); ?>" class="popup-video">
                                <i class="<?php echo esc_attr( $item['video_icon'] ); ?>"></i>
                            </a>
                        </div>
                    </div>
                <?php } ?>
            </div>

            <script>
                jQuery(document).ready(function($) {
                    function initializeSlick() {
                        $('#<?php echo esc_js( $unique_id ); ?>').slick({
                            dots: false,
                            infinite: true,
                            speed: 600,
                            prevArrow: '<button type="button" class="slick-prev"><i class="far fa-angle-left"></i></button>',
                            nextArrow: '<button type="button" class="slick-next"><i class="far fa-angle-right"></i></button>',
                            arrows: true,
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            responsive: [
                                {
                                    breakpoint: 992,
                                    settings: {
                                        slidesToShow: 1,
                                        slidesToScroll: 1,
                                    }
                                },
                                {
                                    breakpoint: 768,
                                    settings: {
                                        slidesToShow: 1,
                                        slidesToScroll: 1,
                                        arrows: false,
                                    }
                                }
                            ]
                        });
                    }

                    // Initialize slick on document ready
                    initializeSlick();

                    // Reinitialize slick in Elementor's editor to handle updates
                    if (window.elementorFrontend && window.elementorFrontend.hooks) {
                        elementorFrontend.hooks.addAction('frontend/element_ready/global', initializeSlick);
                    }
                });
            </script>
        <?php } else { ?>
            <div class="video-thumb position-relative pluse-animation">
                <?php if ( !empty( $settings['video_bg_img']['url'] ) ) { ?>
                    <img src="<?php echo esc_url( $settings['video_bg_img']['url'] ); ?>" alt="<?php esc_attr_e( 'Background Image', 'chariton' ) ?>">
                <?php } ?>
                <a href="<?php echo esc_url( $settings['video_link'] ); ?>" class="popup-video">
                    <i class="<?php echo esc_attr( $settings['video_icon'] ); ?>"></i>
                </a>
            </div>
        <?php }
    }



    protected function content_template() {
        ?>
        <#
        var uniqueId = 'video-slider-' + view.getID();
        
        if ( settings.video_slider === 'yes' ) { #>
            <div id="{{ uniqueId }}" class="row video-active">
                <# _.each( settings.video_slider_items, function( item ) { #>
                    <div class="col-12">
                        <div class="video-thumb position-relative pluse-animation">
                            <# if ( item.video_image.url ) { #>
                                <img src="{{ item.video_image.url }}" alt="<?php esc_attr_e( 'Video Image', 'chariton' ); ?>">
                            <# } #>
                            <a href="{{ item.video_link }}" class="popup-video">
                                <i class="{{ item.video_icon }}"></i>
                            </a>
                        </div>
                    </div>
                <# }); #>
            </div>
        <# } else { #>
            <div class="video-thumb position-relative pluse-animation">
                <# if ( settings.video_bg_img.url ) { #>
                    <img src="{{ settings.video_bg_img.url }}" alt="<?php esc_attr_e( 'Background Image', 'chariton' ) ?>">
                <# } #>
                <a href="{{ settings.video_link }}" class="popup-video">
                    <i class="{{ settings.video_icon }}"></i>
                </a>
            </div>
        <# } #>

        <script>
            // This script runs only inside the Elementor editor for the live preview.
            jQuery(document).ready(function($) {
                function initializeSlick() {
                    $('#' + uniqueId).slick({
                        dots: false,
                        infinite: true,
                        speed: 600,
                        prevArrow: '<button type="button" class="slick-prev"><i class="far fa-angle-left"></i></button>',
                        nextArrow: '<button type="button" class="slick-next"><i class="far fa-angle-right"></i></button>',
                        arrows: true,
                        slidesToShow: 1,
                        slidesToScroll: 1,
                        responsive: [
                            {
                                breakpoint: 992,
                                settings: {
                                    slidesToShow: 1,
                                    slidesToScroll: 1,
                                }
                            },
                            {
                                breakpoint: 768,
                                settings: {
                                    slidesToShow: 1,
                                    slidesToScroll: 1,
                                    arrows: false,
                                }
                            }
                        ]
                    });
                }

                initializeSlick();
                elementorFrontend.hooks.addAction('frontend/element_ready/global', initializeSlick);
            });
        </script>
        <?php
    }
}