<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// METABOX OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options      = array();

// -----------------------------------------
// Page Breadcrumb Options                 -
// -----------------------------------------
$options[]    = array(
  'id'        => '_custom_page_breadcrumb_options',
  'title'     => __( 'This Page Breadcrumb', 'chariton' ),
  'post_type' => 'page',
  'context'   => 'normal',
  'priority'  => 'default',
  'sections'  => array(

    array(
      'name'   => 'page_setting',
      'fields' => array(
        // If selected color is "black or white"
        array(
          'type'    => 'subheading',
          'content' => __( 'This page breadcrumb settings', 'chariton' ),
        ),
        
        array(
          'id'          => 'page_breadcrumb_switch',
          'type'        => 'switcher',
          'title'       => __( 'Enable breadcrumb for this page?', 'chariton' ),
        ),
        array(
          'id'          => 'page_breadcrumb_bg_img',
          'type'        => 'image',
          'title'       => __( 'Breadcrumb background image', 'chariton' ),
          'dependency'   => array( 'page_breadcrumb_switch', '==', 'true' ),
        ),
        array(
          'id'      => 'breadcrumb_bg_color',
          'type'    => 'color_picker',
          'title'   => __( 'Breatcrumb background color', 'chariton' ),
          'after'   => '<p class="cs-text-muted">It is breadcrumb background color.</p>',
          'default' => '#000927',
          'dependency'   => array( 'page_breadcrumb_switch', '==', 'true' ),
        ),
        array(
          'id'      => 'breadcrumb_bg_img_opacity',
          'type'    => 'select',
          'title'   => __( 'Breadcrumb Background Image Opacity', 'chariton' ),
          'options'      => array(
            '0' => '0',
            '0.2' => '0.2',
            '0.3' => '0.3',
            '0.4' => '0.4',
            '0.5' => '0.5',
            '0.6' => '0.6',
            '0.7' => '0.7',
            '0.8' => '0.8',
            '0.9' => '0.9',
            '1'   => '1',
          ),
          'dependency'   => array( 'page_breadcrumb_switch', '==', 'true' ),
        ),
        array(
          'id'      => 'breatcrumb_pt',
          'type'    => 'text',
          'title'   => __( 'Breatcrumb padding top', 'chariton' ),
          'after'   => '<p class="cs-text-muted">Breadcrumb padding top with px ( like as 350px ).</p>',
          'default' => '135px',
          'dependency'   => array( 'page_breadcrumb_switch', '==', 'true' ),
        ),
        array(
          'id'      => 'breatcrumb_pb',
          'type'    => 'text',
          'title'   => __( 'Breatcrumb padding bottom', 'chariton' ),
          'after'   => '<p class="cs-text-muted">Breadcrumb padding bottom with px ( like as 350px ).</p>',
          'default' => '145px',
          'dependency'   => array( 'page_breadcrumb_switch', '==', 'true' ),
        ),
        array(
          'id'      => 'breatcrumb_font_color',
          'type'    => 'color_picker',
          'title'   => __( 'Breatcrumb font color', 'chariton' ),
          'after'   => '<p class="cs-text-muted">It is breadcrumb font color.</p>',
          'default' => '#fff',
          'dependency'   => array( 'page_breadcrumb_switch', '==', 'true' ),
        ),
        array(
          'id'      => 'breatcrumb_hover_link_color',
          'type'    => 'color_picker',
          'title'   => __( 'Breatcrumb hover link color', 'chariton' ),
          'after'   => '<p class="cs-text-muted">It is breadcrumb link hover font color.</p>',
          'default' => '#39bdb2',
          'dependency'   => array( 'page_breadcrumb_switch', '==', 'true' ),
        ),
        array(
          'id'          => 'page_breadcrumb_title',
          'type'        => 'text',
          'title'       => __( 'Breadcrumb title', 'chariton' ),
          'dependency'   => array( 'page_breadcrumb_switch', '==', 'true' ),
        ),

      ),
    ),
    // end: a section

  ),
);


// -----------------------------------------
// Page Header Metabox Options             -
// -----------------------------------------
$options[]    = array(
  'id'        => '_custom_page_header_options',
  'title'     => __( 'Custom Page Header', 'chariton' ),
  'post_type' => 'page',
  'context'   => 'normal',
  'priority'  => 'default',
  'sections'  => array(

    array(
      'name'   => 'page_setting',
      'fields' => array(
        // If selected color is "black or white"
        // array(
        //   'type'    => 'subheading',
        //   'content' => __( 'Select Header Style', 'chariton' ),
        // ),

        array(
          'id'          => 'page_custom_logo_switch',
          'type'        => 'switcher',
          'title'       => __( 'Upload Custom Logo?', 'chariton' ),
        ),
        array(
          'id'          => 'page_custom_logo_upload',
          'type'        => 'image',
          'title'       => __( 'Upload Logo', 'chariton' ),
          'dependency'   => array( 'page_custom_logo_switch', '==', 'true' ),
        ),
        array(
          'id'          => 'page_custom_sticky_logo_upload',
          'type'        => 'image',
          'title'       => __( 'Upload Sticky Logo', 'chariton' ),
          'dependency'   => array( 'page_custom_logo_switch', '==', 'true' ),
        ),

        array(
          'id'          => 'header_style',
          'type'        => 'image_select',
          'title'       => __( 'Select Header Style', 'chariton' ),
          'options'     => array(
            'style1'    => CHARITON_PLG_URL. 'assets/imgs/header1.jpg',
            'style2'    => CHARITON_PLG_URL. 'assets/imgs/header2.jpg',
            'style3'    => CHARITON_PLG_URL. 'assets/imgs/header3.jpg',
            'style4'    => CHARITON_PLG_URL. 'assets/imgs/header4.jpg',
            'style5'    => CHARITON_PLG_URL. 'assets/imgs/header5.jpg',
          ),
        ),

        array(
          'id'          => 'header_custom_style',
          'type'        => 'select',
          'title'       => __( 'Enable Custom Color Settings', 'chariton' ),
          'options'     => array(
            'customcolor2'    => __( 'No', 'chariton' ),
            'customcolor1'    => __( 'Yes', 'chariton' ),
          ),
        ),
        array(
          'id'      => 'header_custom_bgcolor',
          'type'    => 'color_picker',
          'title'   => __( 'Menu Area Background Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'header_custom_fontcolor',
          'type'    => 'color_picker',
          'title'   => __( 'Menu Text Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'header_custom_hover_fontcolor',
          'type'    => 'color_picker',
          'title'   => __( 'Menu Text Hover Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'header_sticky_custom_bgcolor',
          'type'    => 'color_picker',
          'title'   => __( 'Sticky Menu Area Background Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'header_custom_sticky_fontcolor',
          'type'    => 'color_picker',
          'title'   => __( 'Sticky Menu Text Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'header_custom_sticky_hover_fontcolor',
          'type'    => 'color_picker',
          'title'   => __( 'Sticky Menu Text Hover Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'          => 'custom_quote_title',
          'type'        => 'text',
          'title'       => __( 'Quote Button Title', 'chariton' ),
        ),
        array(
          'id'      => 'header_custom_quote_bgcolor',
          'type'    => 'color_picker',
          'title'   => __( 'Quote Button Background Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'header_custom_quote_textcolor',
          'type'    => 'color_picker',
          'title'   => __( 'Quote Button Text Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'header_custom_hquote_bgcolor',
          'type'    => 'color_picker',
          'title'   => __( 'Quote Button Hover Background Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'header_custom_hquote_textcolor',
          'type'    => 'color_picker',
          'title'   => __( 'Quote Button Hover Text Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'header_custom_hq_iconbgcolor',
          'type'    => 'color_picker',
          'title'   => __( 'Search & Login BG Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'header_custom_hq_iconcolor',
          'type'    => 'color_picker',
          'title'   => __( 'Search & Login Icon Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'header_custom_hq_bordercolor',
          'type'    => 'color_picker',
          'title'   => __( 'Search & Login Button Border Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'header_custom_responsive_color',
          'type'    => 'color_picker',
          'title'   => __( 'Responsive Menu Icon Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'header_custom_sticky_responsive_color',
          'type'    => 'color_picker',
          'title'   => __( 'Sticky Responsive Menu Icon Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),


        array(
          'id'      => 'header_top_parts_bgcolor',
          'type'    => 'color_picker',
          'title'   => __( 'Top Part Background Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'header_top_parts_txtcolor',
          'type'    => 'color_picker',
          'title'   => __( 'Top Part Text Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),




      ),
    ),
    // end: Page Header Metabox Options 
  ),
);


// -----------------------------------------
// Page Footer Metabox Options             -
// -----------------------------------------
$options[]    = array(
  'id'        => '_custom_page_footer_options',
  'title'     => __( 'Custom Page Footer', 'chariton' ),
  'post_type' => 'page',
  'context'   => 'normal',
  'priority'  => 'default',
  'sections'  => array(

    array(
      'name'   => 'footer_page_setting',
      'fields' => array(
        // If selected color is "black or white"
        // array(
        //   'type'    => 'subheading',
        //   'content' => __( 'Select Footer Style', 'chariton' ),
        // ),
        array(
          'id'          => 'footer_style',
          'type'        => 'image_select',
          'title'       => __( 'Select Footer Style', 'chariton' ),
          'options'     => array(
            'style1'    => CHARITON_PLG_URL. 'assets/imgs/footer1.jpg',
            'style2'    => CHARITON_PLG_URL. 'assets/imgs/footer2.jpg',
          ),
        ),
        array(
          'id'      => 'footer_custom_bgcolor',
          'type'    => 'color_picker',
          'title'   => __( 'Footer Background Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'footer_custom_widgets_color',
          'type'    => 'color_picker',
          'title'   => __( 'Footer Widgets Text Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'footer_custom_widgets_content',
          'type'    => 'color_picker',
          'title'   => __( 'Footer Widgets Content Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),
        array(
          'id'      => 'footer_custom_widgets_linkcolor',
          'type'    => 'color_picker',
          'title'   => __( 'Footer Widgets Link Hover Color', 'chariton' ),
          'desc'    => __( 'Pick Color.', 'chariton' ),
          'default' => '',
        ),

      ),
    ),
    // end: Page Header Metabox Options 
  ),
);



// -----------------------------------------
// Default Post Settings                   -
// -----------------------------------------
$options[]    = array(
  'id'        => '_chariton_post',
  'title'     => __( 'Post Settings', 'chariton' ),
  'post_type' => 'post',
  'context'   => 'normal',
  'priority'  => 'default',
  'sections'  => array(

    array(
      'name'   => 'chariton_default_post',
      'fields' => array(

        array(
          'id'             => 'post_format_type',
          'type'           => 'select',
          'title'          => __( 'Custom Post Format', 'chariton' ),
          'options'        => array(
            'chariton-video'   => __( 'Video', 'chariton' ),
            'chariton-audio'   => __( 'Audio', 'chariton' ),
            'chariton-quote'   => __( 'Quote', 'chariton' ),
            'chariton-gallery' => __( 'Gallery', 'chariton' ),
          ),
          'default_option' => 'Select Custom Post Type',
        ),
        array(
          'id'    => 'video_link',
          'type'  => 'text',
          'title' => __( 'Put Video Link', 'chariton' ),
          'dependency'   => array( 'post_format_type', '==', 'chariton-video' ),
        ),
        array(
          'id'    => 'audio_link',
          'type'  => 'text',
          'title' => __( 'Put Audio Link', 'chariton' ),
          'dependency'   => array( 'post_format_type', '==', 'chariton-audio' ),
        ),
        array(
          'id'    => 'gallery_list',
          'type'  => 'gallery',
          'title' => __( 'Select gallery images', 'chariton' ),
          'dependency'   => array( 'post_format_type', '==', 'chariton-gallery' ),
        ),
        array(
          'id'    => 'chariton_quote_icon',
          'type'  => 'image',
          'title' => __( 'Quote icon img', 'chariton' ),
          'dependency'   => array( 'post_format_type', '==', 'chariton-quote' ),
        ),

      ),
    ),

  ),
);


// -----------------------------------------
// Service Post Settings                   -
// -----------------------------------------
$options[]    = array(
  'id'        => '_ifinger_service',
  'title'     => __( 'Service post settings', 'chariton' ),
  'post_type' => 'service',
  'context'   => 'normal',
  'priority'  => 'high',
  'sections'  => array(

    array(
      'name'   => 'ifinger_service_post',
      'fields' => array(

        array(
          'id'      => 'service_icon_type',
          'type'    => 'select',
          'title'   => __( 'Select service icon type', 'chariton' ),
          'options'      => array(
            'image_icon' => 'Image',
            'icon_font'  => 'Icon',
          ),
          'default_option' => 'Select icon type',
        ),
        array(
          'id'    => 'service_icon_img',
          'type'  => 'image',
          'title' => __( 'Icon image', 'chariton' ),
          'dependency'   => array( 'service_icon_type', '==', 'image_icon' ),
        ),
        array(
          'id'    => 'service_icon_font',
          'type'  => 'icon',
          'title' => __( 'Icon Font', 'chariton' ),
          'dependency'   => array( 'service_icon_type', '==', 'icon_font' ),
        ),
        array(
          'id'    => 'service_custom_class',
          'type'  => 'text',
          'title' => __( 'Custom style class', 'chariton' ),
          'desc' => __( 'Custom style class for custom css code if you need extra style for this post', 'chariton' ),
        ),

      ),
    ),

  ),
);


// -----------------------------------------
// Cause Post Settings                     -
// -----------------------------------------
$options[]    = array(
  'id'        => '_ifinger_cause',
  'title'     => __( 'Cause settings', 'chariton' ),
  'post_type' => 'cause',
  'context'   => 'normal',
  'priority'  => 'high',
  'sections'  => array(

    array(
      'name'   => 'ifinger_cause_post',
      'fields' => array(

        array(
          'id'    => 'post_author_desination',
          'type'  => 'text',
          'title' => __( 'Post author designation', 'chariton' ),
          'default' => __( 'is organizing this fundraiser.', 'chariton' ),
        ),

        array(
          'id'    => 'goal_title',
          'type'  => 'text',
          'title' => __( 'Goal title', 'chariton' ),
          'default' => __( 'Goal', 'chariton' ),
        ),
        array(
          'id'    => 'money_currency',
          'type'  => 'text',
          'title' => __( 'Put Currency Icon', 'chariton' ),
          'default' => __( '$', 'chariton' ),
        ),
        array(
          'id'    => 'goal_amount',
          'type'  => 'text',
          'title' => __( 'Goal amount', 'chariton' ),
          'attributes'    => array(
            'placeholder' => '3400.00'
          )
        ),
        array(
          'id'    => 'rise_title',
          'type'  => 'text',
          'title' => __( 'Rise title', 'chariton' ),
          'default' => __( 'Rise', 'chariton' ),
        ),
        array(
          'id'    => 'rise_amount',
          'type'  => 'text',
          'title' => __( 'Rise amount', 'chariton' ),
          'attributes'    => array(
            'placeholder' => '2350.00'
          )
        ),
        array(
          'id'    => 'count_title',
          'type'  => 'text',
          'title' => __( 'Count title', 'chariton' ),
          'default' => __( 'Left', 'chariton' ),
        ), 
        array(
          'id'    => 'cause_count_down',
          'type'  => 'text',
          'title' => __( 'Count Down time', 'chariton' ),
          'attributes'    => array(
            'placeholder' => '2022/12/20'
          )
        ),
        array(
          'id'    => 'fundraising_report_tilte',
          'type'  => 'text',
          'title' => __( 'Fundraiser report title', 'chariton' ),
        ),
        array(
          'id'    => 'fundraising_report_down_link',
          'type'  => 'text',
          'title' => __( 'Fundraiser report download link', 'chariton' ),
        ),

      ),
    ),

  ),
);


// -----------------------------------------
// Team Post Settings                      -
// -----------------------------------------
$options[]    = array(
  'id'        => '_chariton_team',
  'title'     => __( 'Team settings', 'chariton' ),
  'post_type' => 'team',
  'context'   => 'normal',
  'priority'  => 'high',
  'sections'  => array(

    array(
      'name'   => 'ifinger_team_post',
      'fields' => array(
        array(
          'id'          => 'team_designation',
          'type'        => 'text',
          'title'       => 'Team Member Designation',
        ),
        array(
          'id'              => 'team_member_info',
          'type'            => 'group',
          'title'           => 'Team Member Information',
          'button_title'    => 'Add New',
          'accordion_title' => 'Add New Information',
          'fields'          => array(
            array(
              'id'          => 'title',
              'type'        => 'text',
              'title'       => 'Info Title',
            ),
            array(
              'id'          => 'text',
              'type'        => 'text',
              'title'       => 'Info Text',
            ),
          )
        ),

        array(
          'id'              => 'team_social',
          'type'            => 'group',
          'title'           => 'Social Field',
          'button_title'    => 'Add New',
          'accordion_title' => 'Add New Social',
          'fields'          => array(
            array(
              'id'          => 'icon',
              'type'        => 'icon',
              'title'       => 'Icon',
            ),
            array(
              'id'          => 'link',
              'type'        => 'text',
              'title'       => 'Link',
            ),
          )
        ),

        array(
          'id'           => 'active_member',
          'type'         => 'switcher',
          'title'        => __( 'Active Item ? ', 'chariton' ),
        ),

        array(
          'id'    => 'team2_bg_color',
          'type'  => 'color_picker',
          'title' => __( 'Team 2 background color', 'chariton' ),
        ),

      ),
    ),

  ),
);


// -----------------------------------------
// Testimonial Post Settings                      -
// -----------------------------------------
$options[]    = array(
  'id'        => '_ifinger_testimonial',
  'title'     => __( 'Testimonial settings', 'chariton' ),
  'post_type' => 'testimonial',
  'context'   => 'normal',
  'priority'  => 'high',
  'sections'  => array(

    array(
      'name'   => 'ifinger_testimonial_post',
      'fields' => array(

        array(
          'id'    => 'designation',
          'type'  => 'text',
          'title' => __( 'Enter Designation', 'chariton' ),
        ),
        array(
          'id'       => 'rewiew_setting',
          'type'     => 'select',
          'title'    => __( 'Select Rating', 'chariton' ),
          'options'  => array(
            '1' => __( '1 Star', 'chariton' ),
            '2' => __( '2 Star', 'chariton' ),
            '3' => __( '3 Star', 'chariton' ),
            '4' => __( '4 Star', 'chariton' ),
            '5' => __( '5 Star', 'chariton' ),
          ),
          'default'  => '5',
        ),
        array(
          'id'    => 'rewiew_color',
          'type'  => 'color_picker',
          'title' => __( 'Rating color', 'chariton' ),
          'default'  => '#ffae00',
        ),

      ),
    ),

  ),
);



// -----------------------------------------
// Events Post Settings                     -
// -----------------------------------------
$options[]    = array(
  'id'        => '_ifinger_event',
  'title'     => __( 'Events settings', 'chariton' ),
  'post_type' => 'event',
  'context'   => 'normal',
  'priority'  => 'high',
  'sections'  => array(

    array(
      'name'   => 'ifinger_event_post',
      'fields' => array(
        array(
          'type'    => 'subheading',
          'content' => __( 'Event Information', 'chariton' ),
        ),
        array(
          'id'    => 'event_time',
          'type'  => 'text',
          'title' => __( 'Event Tile', 'chariton' ),
          'default' => __( '8:00 AM - 10:00 AM', 'chariton' ),
        ),
        array(
          'type'    => 'subheading',
          'content' => __( 'Event Details', 'chariton' ),
        ),
        array(
          'id'    => 'details_title',
          'type'  => 'text',
          'title' => __( 'Event Details Title', 'chariton' ),
          'default' => __( 'Event Details', 'chariton' ),
        ),
        array(
          'id'              => 'details_list',
          'type'            => 'group',
          'title'           => 'Info List Field',
          'button_title'    => 'Add New',
          'accordion_title' => 'Add New Info',
          'fields'          => array(
            array(
              'id'          => 'title',
              'type'        => 'text',
              'title'       => 'Title',
            ),
            array(
              'id'          => 'text',
              'type'        => 'text',
              'title'       => 'Text',
            ),
            array(
              'id'          => 'link',
              'type'        => 'text',
              'title'       => 'Link',
              'desc'        => 'If have link put here. (This is optional)',
            ),
          )
        ),

        array(
          'type'    => 'subheading',
          'content' => __( 'Organizer Details', 'chariton' ),
        ),
        array(
          'id'    => 'organizer_title',
          'type'  => 'text',
          'title' => __( 'Organizer Title', 'chariton' ),
          'default' => __( 'Organizer Details', 'chariton' ),
        ),
        array(
          'id'              => 'organized_list',
          'type'            => 'group',
          'title'           => 'Info List Filed',
          'button_title'    => 'Add New',
          'accordion_title' => 'Add New Info',
          'fields'          => array(
            array(
              'id'          => 'title',
              'type'        => 'text',
              'title'       => 'Title',
            ),
            array(
              'id'          => 'text',
              'type'        => 'text',
              'title'       => 'Text',
            ),
          )
        ),

        array(
          'type'    => 'subheading',
          'content' => __( 'Venue Details', 'chariton' ),
        ),
        array(
          'id'    => 'venue_title',
          'type'  => 'text',
          'title' => __( 'Venue Title', 'chariton' ),
          'default' => __( 'Venue', 'chariton' ),
        ),
        array(
          'id'              => 'venue_list',
          'type'            => 'group',
          'title'           => 'Info List Filed',
          'button_title'    => 'Add New',
          'accordion_title' => 'Add New Info',
          'fields'          => array(
            array(
              'id'          => 'title',
              'type'        => 'text',
              'title'       => 'Title',
            ),
            array(
              'id'          => 'text',
              'type'        => 'text',
              'title'       => 'Text',
            ),
          )
        ),
        array(
          'id'    => 'venue_map',
          'type'  => 'image',
          'title' => __( 'Venue Map Image', 'chariton' ),
        ),
        

      ),
    ),

  ),
);


// -----------------------------------------
// Page Breadcrumb Options                 -
// -----------------------------------------
$options[]    = array(
  'id'        => '_custom_page_breadcrumb_options',
  'title'     => __( 'Custom Page Breadcrumb', 'chariton' ),
  'post_type' => 'page',
  'context'   => 'side',
  'priority'  => 'default',
  'sections'  => array(

    array(
      'name'   => 'page_setting',
      'fields' => array(
        // If selected color is "black or white"
        // array(
        //   'type'    => 'subheading',
        //   'content' => __( 'This page breadcrumb settings', 'chariton' ),
        // ),
        array(
          'id'          => 'page_breadcrumb_bg_img',
          'type'        => 'image',
          'title'       => __( 'Breadcrumb background image', 'chariton' ),
        ),
        array(
          'id'          => 'page_breadcrumb_title',
          'type'        => 'text',
          'title'       => __( 'Breadcrumb title', 'chariton' ),
        ),
        array(
          'id'      => 'page_breadcrumb_overlay_color',
          'type'    => 'color_picker',
          'title'   => __( 'Breadcrumb overlay color', 'chariton' ),
          'after'   => '<p class="cs-text-muted">It is breadcrumb overlay color.</p>',
          'default' => '#39537E',
          'dependency'   => array( 'page_breadcrumb_bg_img', '!=', '' ),
        ),

      ),
    ),
    // end: a section

  ),
);


charitonFramework_Metabox::instance( $options );