<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
/**
 *
 * Get icons from admin ajax
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if( ! function_exists( 'chariton_get_icons' ) ) {
  function chariton_get_icons() {

    do_action( 'chariton_add_icons_before' );

    $jsons = apply_filters( 'chariton_add_icons_json', glob( chariton_DIR . '/fields/icon/*.json' ) );

    if( ! empty( $jsons ) ) {

      foreach ( $jsons as $path ) {

        $object = chariton_get_icon_fonts( 'fields/icon/'. basename( $path ) );

        if( is_object( $object ) ) {

          echo ( count( $jsons ) >= 2 ) ? '<h4 class="chariton-icon-title">'. $object->name .'</h4>' : '';

          foreach ( $object->icons as $icon ) {
            echo '<a class="chariton-icon-tooltip" data-chariton-icon="'. $icon .'" data-title="'. $icon .'"><span class="chariton-icon chariton-selector"><i class="'. $icon .'"></i></span></a>';
          }

        } else {
          echo '<h4 class="chariton-icon-title">'. esc_html__( 'Error! Can not load json file.', 'chariton-framework' ) .'</h4>';
        }

      }

    }

    do_action( 'chariton_add_icons' );
    do_action( 'chariton_add_icons_after' );

    die();
  }
  add_action( 'wp_ajax_chariton-get-icons', 'chariton_get_icons' );
}

/**
 *
 * Export options
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if( ! function_exists( 'chariton_export_options' ) ) {
  function chariton_export_options() {

    header('Content-Type: plain/text');
    header('Content-disposition: attachment; filename=backup-options-'. gmdate( 'd-m-Y' ) .'.txt');
    header('Content-Transfer-Encoding: binary');
    header('Pragma: no-cache');
    header('Expires: 0');

    echo chariton_encode_string( get_option( chariton_OPTION ) );

    die();
  }
  add_action( 'wp_ajax_chariton-export-options', 'chariton_export_options' );
}

/**
 *
 * Set icons for wp dialog
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if( ! function_exists( 'chariton_set_icons' ) ) {
  function chariton_set_icons() {

    echo '<div id="chariton-icon-dialog" class="chariton-dialog" title="'. esc_html__( 'Add Icon', 'chariton-framework' ) .'">';
    echo '<div class="chariton-dialog-header chariton-text-center"><input type="text" placeholder="'. esc_html__( 'Search a Icon...', 'chariton-framework' ) .'" class="chariton-icon-search" /></div>';
    echo '<div class="chariton-dialog-load"><div class="chariton-icon-loading">'. esc_html__( 'Loading...', 'chariton-framework' ) .'</div></div>';
    echo '</div>';

  }
  add_action( 'admin_footer', 'chariton_set_icons' );
  add_action( 'customize_controls_print_footer_scripts', 'chariton_set_icons' );
}
