<?php
/**
 * Single Form Featured Image
 *
 * Displays the featured image for the single donation form - Override this template by copying it to yourtheme/give/single-give-form/featured-image.php
 * 
 * @package       Give/Templates
 * @copyright   Copyright (c) 2016, WordImpress
 * @license     https://opensource.org/licenses/gpl-license GNU Public License
 * @since       1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

global $post;

$form_id = get_the_ID();
$form = new Give_Donate_Form( $form_id );
$progress_stats = give_goal_progress_stats($form);
$income = 0;
$goal = '';

$goal_option = give_get_meta( $form_id, '_give_goal_option', true );
if($goal_option == 'disabled' || !$goal_option){
 	$goal = 'unlimited';
 	$progress = 100;
 	$income = isset($progress_stats['actual']) ? $progress_stats['actual'] : 0;
}

if($goal == 'unlimited'){
 	$progress_label = esc_html__( 'unlimited' , 'chariton' );
 	$progress = 100;
}else{
 	$progress = isset($progress_stats['progress']) ? $progress_stats['progress'] : 100;
 	$progress_label = $progress . '%';
 	$income = isset($progress_stats['actual']) ? $progress_stats['actual'] : 0;
 	$goal = isset($progress_stats['goal']) ? $progress_stats['goal'] : 0;
   if($progress > 100) $progress = 100;
}

$color_scheme = get_post_meta($post->ID, 'oxpitan_give_color', true ) ? get_post_meta($post->ID, 'oxpitan_give_color', true ) : '';

/**
 * Fires in single form template, before the form featured image.
 *
 * Allows you to add elements before the image.
 *
 * @since 1.0
 */
do_action( 'give_pre_featured_thumbnail' );
?>

<div class="images">
	<?php //Featured Thumbnail
	if ( has_post_thumbnail() ) {
		
		$image_size = give_get_option( 'featured_image_size' );
		$image      = get_the_post_thumbnail( $post->ID, apply_filters( 'single_give_form_large_thumbnail_size', ( ! empty( $image_size ) ? $image_size : 'large' ) ) );

		echo apply_filters( 'single_give_form_image_html', $image );

	} else {

		//Placeholder Image
		echo apply_filters( 'single_give_form_image_html', sprintf( '<img src="%s" alt="%s" />', give_get_placeholder_img_src(), esc_attr__( 'Placeholder', 'chariton' ) ), $post->ID );

	} ?>

</div>

<?php
/**
 * Fires in single form template, after the form featured image.
 *
 * Allows you to add elements after the image.
 *
 * @since 1.0
 */
do_action( 'give_post_featured_thumbnail' );
?>
