<?php
/**
 * The header for our theme.
 *
 * @package chariton
 */
?>
<!DOCTYPE html>
<html <?php language_attributes();?>>
<head>
    <meta charset="<?php bloginfo('charset');?>"/>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php wp_head(); ?>
</head>

<body <?php body_class();?>>
    <?php 
        if ( ! function_exists( 'wp_body_open' ) ) {
            function wp_body_open() {
                do_action( 'wp_body_open' );
            }
        }
    ?>

    <?php 
        if (function_exists('chariton_framework_init') && chariton_get_option('chariton_preloader_enable')) :
            do_action('chariton_preloading');
        endif;
    ?>

    <!-- Start of Header 
    ============================================= -->
    <?php do_action( 'chariton_header_style' ); ?> 
    <!-- End of  Header 
    ============================================= -->
    
    <main>