<?php
// Menu Style One ( default )
if( function_exists( 'chariton_framework_init' ) ) {
    $chariton_breadcrumb_switch = chariton_get_option('chariton_breadcrumb_switch');
    $top_header = chariton_get_option('top_header');
    $sticky_menu_switch = chariton_get_option('sticky_menu_switch');
} else {
    $chariton_breadcrumb_switch = '';
    $top_header = '';
    $sticky_menu_switch = '1';
}
if( function_exists( 'chariton_framework_init' ) ) {
    if ($chariton_breadcrumb_switch == true) {
        $breadcrumb_height = 'breadcrumb_height';
    } else {
        $breadcrumb_height = 'breadcrumb_menu_height';
    }
} else {
    $breadcrumb_height = 'breadcrumb_height';
}
?>

<!-- header -->
<header class="header1">
  <?php if (!empty($top_header)) { 
    $header_language     = chariton_get_option('header_language');
    $header_contact_list = chariton_get_option('header_contact_list');
    $header_social_btn   = chariton_get_option('header_social_btn');
    $header_menu_list    = chariton_get_option('header_menu_list');
  ?>
    <div class="header-top-wrap d-md-block">
      <div class="container-fluid ht-container-p">
          <div class="row">
              <div class="col-lg-7 col-md-6">
                <?php echo do_shortcode( $header_language ); ?>
                <div class="header-contact d-inline-block">
                  <ul>
                    <?php if (is_array($header_contact_list)) {
                      foreach ($header_contact_list as $key => $value) {
                        $data_type = $value['info_text'];
                        if(filter_var($data_type, FILTER_VALIDATE_EMAIL)){
                          $href_value = 'email';
                        } elseif (filter_var($data_type, FILTER_SANITIZE_NUMBER_INT)) {
                          $href_value = 'phone';
                        } elseif (filter_var($data_type, FILTER_VALIDATE_URL)) {
                          $href_value = 'url';
                        } else {
                          $href_value = '';
                        }
                        if (!empty($href_value == 'email')) {
                    ?>
                      <li><a href="mailto:<?php echo sanitize_email($value['info_text']); ?>"><?php echo esc_html($value['title']); ?> <span><?php echo esc_html($value['info_text']); ?></span></a></li>
                    <?php } elseif (!empty($href_value == 'phone')) { 
                      $phone_no = str_replace(" ", "", $value['info_text']);
                    ?>
                      <li><a href="tel:<?php echo esc_attr($phone_no); ?>"><?php echo esc_html($value['title']); ?> <span><?php echo esc_html($value['info_text']); ?></span></a></li>
                    <?php } elseif (!empty($href_value == 'url')) { ?>
                      <li><a href="<?php echo esc_url($value['info_text']); ?>"><?php echo esc_html($value['title']); ?> <span><?php echo esc_html($value['info_text']); ?></span></a></li>
                    <?php } else { ?>
                      <li><?php echo esc_html($value['title']); ?> <span><?php echo esc_html($value['info_text']); ?></span></li>
                    <?php } 
                      }
                    } ?>
                  </ul>
                </div>
              </div>
              <div class="col-lg-5 col-md-6 d-lg-block">
                <div class="header1-top-right-items text-right">
                  <?php if (is_array($header_social_btn)) { ?>
                    <div class="header-top-social d-inline-block">
                      <?php foreach ($header_social_btn as $key => $value) { ?>
                        <a href="<?php echo esc_url($value['social_link']); ?>"><i class="<?php echo esc_attr($value['social_icon']); ?>"></i></a>
                      <?php } ?>
                    </div>
                    <?php } 
                      if (is_array($header_menu_list)) {
                    ?>
                    <div class="header-top-policy d-inline-block">
                      <ul>
                        <?php foreach ($header_menu_list as $key => $value) { ?>
                          <li><a href="<?php echo esc_url($value['menu_link']); ?>"><?php echo esc_html($value['menu_name']); ?></a></li>
                        <?php } ?>
                      </ul>
                    </div>
                  <?php } ?>
                </div>
              </div>
          </div>
      </div>
    </div>
  <?php } ?>

  <?php

  if (!empty($sticky_menu_switch)) {
    $sticky_id = 'header-sticky';
  } else {
    $sticky_id = 'header-sticky-none';
  }
  $dynamic_class =  $breadcrumb_height;

  ?>
    <div id="<?php echo esc_attr( $sticky_id ); ?>" class="main-header-wrap transparent-header s-transparent-header <?php echo esc_attr( $dynamic_class ); ?> header1">
        <div class="container-fluid s-header-container">
          <div class="row align-items-center">
            <div class="col-12">
              <div class="header-main-area">
                <?php get_template_part( 'headers/logo' ); ?>
                  <?php if(function_exists( 'chariton_framework_init' ) ) {
                      $search_btn_switch = chariton_get_option('search_btn_switch');
                      $login_btn_switch = chariton_get_option('login_btn_switch');
                      $donate_btn_switch = chariton_get_option('donate_btn_switch');
                      $donate_btn_icon_switch = chariton_get_option('donate_btn_icon_switch');
                      if ( !empty($search_btn_switch) && !empty($login_btn_switch) && !empty($donate_btn_switch) ) {
                        $menu_col = '6';
                        $sc_col = '4';
                      } elseif ( !empty($search_btn_switch) || !empty($login_btn_switch) ) {
                        $menu_col = '7';
                        $sc_col = '3';
                      } elseif ( !empty($donate_btn_switch) ) {
                        $menu_col = '7';
                        $sc_col = '3';
                      } else {
                        $menu_col = '10';
                        $sc_col = '0';
                      }

                      $donate_btn_text = chariton_get_option('donate_btn_text');
                      $donate_btn_link = chariton_get_option('donate_btn_link');
                    } else { 
                      $donate_btn_text = '';
                      $donate_btn_link = '';
                      $menu_col = '10';
                      $sc_col = '0';
                    }
                  ?>
                  <div class="header-main-menu-area">
                    <div class="menu-area text-right">
                      <div class="main-menu t-main-menu">
                        <?php get_template_part( 'headers/menu' ); ?>
                      </div>
                    </div>

                    <?php if(function_exists( 'chariton_framework_init' ) ) : ?>
                      <div class="header-one-search-area">
                        <?php get_template_part( 'headers/search' ); ?>
                        <?php get_template_part( 'headers/login' ); ?>
                        <?php get_template_part( 'headers/donation' ); ?>
                      </div>
                    <?php endif; ?>
                  </div>
              </div>
              <div class="col-12">
                  <div class="mobile-menu third-mobile-menu"></div>
              </div>
            </div>
          </div>
        </div>
    </div>
</header>
<!-- header-end -->

<div class="stricky-height-fix header1"></div>

<?php
  if(function_exists( 'chariton_framework_init' ) ) {
    if ( !empty( chariton_get_option( 'search_btn_switch' ) ) || !empty( chariton_get_option('login_btn_switch') ) ) {
      if(function_exists( 'chariton_header_search_form' ) ) { 
        do_action( 'chariton_search_form_modal' );
      } if(function_exists( 'chariton_header_login_form' ) ) {
        do_action( 'chariton_login_form' ); 
      }
    }
  }
?>