<?php
// Menu Style Two
if( function_exists( 'chariton_framework_init' ) ) {
    $chariton_breadcrumb_switch = chariton_get_option('chariton_breadcrumb_switch');
    $sticky_menu_switch = chariton_get_option('sticky_menu_switch');
} else {
    $chariton_breadcrumb_switch = '';
    $all_default_height = 'all-default-h1';
    $sticky_menu_switch = '1';
}

if( function_exists( 'chariton_framework_init' ) ) {
    if ($chariton_breadcrumb_switch == true) {
      $breadcrumb_height = 'breadcrumb_height';
    } else {
      $breadcrumb_height = 'breadcrumb_menu_height';
    }
} else {
    $breadcrumb_height = 'breadcrumb_height';
}

$chariton_header_settings = get_post_meta( get_the_ID(), '_custom_page_header_options', true );
if(!empty($chariton_header_settings['header_style'])) {
    $all_default_height = '';
} elseif(function_exists( 'chariton_framework_init' ) ) {
    $default_header_style = chariton_get_option('default_header_style');
    if($default_header_style == 'style1') {
      $all_default_height = 'all-default-h1';
    } elseif ($default_header_style == 'style2')  {
      $all_default_height = 'all-default-h2';
    } elseif ($default_header_style == 'style3')  {
      $all_default_height = 'all-default-h3';
    } else {
      $all_default_height = 'all-default-h1';
    }
} else {
    $all_default_height = 'all-default-h1';
}

if (is_home() && !is_front_page() || is_home() && is_front_page()){
  $page_custom_logo_data = get_post_meta( get_queried_object_id(), '_custom_page_header_options', true );
  if (!empty($page_custom_logo_data['page_custom_logo_switch'])) {
      $page_custom_logo_switch = $page_custom_logo_data['page_custom_logo_switch'];
  } else {
      $page_custom_logo_switch = '';
  }
  if (!empty($page_custom_logo_data['page_custom_logo_upload'])) {
      $custom_img_id  = $page_custom_logo_data['page_custom_logo_upload'];
      $attachment = wp_get_attachment_image_src( $custom_img_id, 'full' );
      $custom_page_logo     = ($attachment) ? $attachment[0] : $custom_img_id;
  }
  if (!empty($page_custom_logo_data['page_custom_sticky_logo_upload'])) {
      $custom_img_id  = $page_custom_logo_data['page_custom_sticky_logo_upload'];
      $attachment = wp_get_attachment_image_src( $custom_img_id, 'full' );
      $page_custom_sticky_logo_upload     = ($attachment) ? $attachment[0] : $custom_img_id;
  }
} else {
  $page_custom_logo_data = get_post_meta( get_queried_object_id(), '_custom_page_header_options', true );
  if (!empty($page_custom_logo_data['page_custom_logo_switch'])) {
      $page_custom_logo_switch = $page_custom_logo_data['page_custom_logo_switch'];
  } else {
      $page_custom_logo_switch = '';
  }
  if (!empty($page_custom_logo_data['page_custom_logo_upload'])) {
      $custom_img_id  = $page_custom_logo_data['page_custom_logo_upload'];
      $attachment = wp_get_attachment_image_src( $custom_img_id, 'full' );
      $custom_page_logo     = ($attachment) ? $attachment[0] : $custom_img_id;
  }
  if (!empty($page_custom_logo_data['page_custom_sticky_logo_upload'])) {
      $custom_img_id  = $page_custom_logo_data['page_custom_sticky_logo_upload'];
      $attachment = wp_get_attachment_image_src( $custom_img_id, 'full' );
      $page_custom_sticky_logo_upload     = ($attachment) ? $attachment[0] : $custom_img_id;
  }
}

if (!empty($sticky_menu_switch)) {
  $sticky_id = 'header-sticky';
} else {
  $sticky_id = 'header-sticky-none';  
}
if (display_header_text()==true) {
  $auto_class = ' have-site-desc';
} else {
  $auto_class = ' none-site-desc';
} 

$dynamic_classes = $breadcrumb_height.' '.$all_default_height; 

?>

<!-- header -->
<header id="<?php echo esc_attr( $sticky_id ); ?>" class="transparent-header <?php echo esc_attr( $dynamic_classes ); ?> header-border header2">
    <div class="container-fluid header-container-p">
        <div class="row align-items-center">
            <div class="col-lg-12">
              <div class="header-main-area">
                <div class="logo logo-bg">
                    <?php get_template_part( 'headers/logo' ); ?>
                </div>
                <div class="header-main-menu-area">
                  <?php 
                    if(function_exists( 'chariton_framework_init' ) ) { 
                      $login_btn_switch         = chariton_get_option('login_btn_switch');
                      $donate_btn_switch        = chariton_get_option('donate_btn_switch');
                      $donate_btn2_icon_switch  = chariton_get_option('donate_btn2_icon_switch');
                      if ( !empty($login_btn_switch) && !empty($donate_btn_switch) ) {
                        $menu_col = '6';
                        $sc_col = '3';
                      } elseif ( !empty( $login_btn_switch ) ) {
                        $menu_col = '8';
                        $sc_col = '1';
                      } elseif ( !empty( $donate_btn_switch ) ) {
                        $menu_col = '7';
                        $sc_col = '2';
                      } else {
                        $menu_col = '9';
                        $sc_col = '0';
                      }
                      $donate_btn_text = chariton_get_option('donate_btn_text2');
                      $donate_btn_link = chariton_get_option('donate_btn_link2');
                    } else {
                      $donate_btn_text = '';
                      $donate_btn_link = '';
                      $menu_col = '9';
                      $sc_col = '0';
                    }
                  ?>

                  <div class="menu-area text-right">
                    <div class="main-menu">
                      <?php get_template_part( 'headers/menu' ); ?>
                    </div>
                  </div>

                  <?php if(function_exists( 'chariton_framework_init' ) ) : ?>
                    <div class="header-one-search-area">
                      <?php get_template_part( 'headers/search' ); ?>
                      <?php get_template_part( 'headers/login' ); ?>
                      <?php get_template_part( 'headers/donation' ); ?>
                    </div>
                  <?php endif; ?>

                </div>
              </div>
            </div>
            <div class="col-12">
              <div class="mobile-menu"></div>
            </div>
        </div>
    </div>
</header>
<!-- header-end -->

<?php 
  if ( !empty( chariton_get_option('search_btn_switch') ) || !empty( chariton_get_option('login_btn_switch') ) ) {
    if(function_exists( 'chariton_header_search_form' ) ) { 
      do_action( 'chariton_search_form_modal' );
    } if(function_exists( 'chariton_header_login_form' ) ) {
      do_action( 'chariton_login_form' ); 
    }
  }
?>