<?php
// Menu Style Five
if( function_exists( 'chariton_framework_init' ) ) {
    $chariton_breadcrumb_switch = chariton_get_option('chariton_breadcrumb_switch');
    $sticky_menu_switch = chariton_get_option('sticky_menu_switch');
} else {
    $chariton_breadcrumb_switch = '';
    $all_default_height = 'all-default-h1';
    $sticky_menu_switch = '1';
}

if( function_exists( 'chariton_framework_init' ) ) {
    if ($chariton_breadcrumb_switch == true) {
      $breadcrumb_height = 'breadcrumb_height';
    } else {
      $breadcrumb_height = 'breadcrumb_menu_height';
    }
} else {
    $breadcrumb_height = 'breadcrumb_height';
}

$chariton_header_settings = get_post_meta( get_the_ID(), '_custom_page_header_options', true );
if(!empty($chariton_header_settings['header_style'])) {
    $all_default_height = '';
} elseif(function_exists( 'chariton_framework_init' ) ) {
    $default_header_style = chariton_get_option('default_header_style');
    if($default_header_style == 'style1') {
      $all_default_height = 'all-default-h1';
    } elseif ($default_header_style == 'style2')  {
      $all_default_height = 'all-default-h2';
    } elseif ($default_header_style == 'style3')  {
      $all_default_height = 'all-default-h3';
    } else {
      $all_default_height = 'all-default-h1';
    }
} else {
    $all_default_height = 'all-default-h1';
}

if (!empty($sticky_menu_switch)) {
  $sticky_id = 'header-sticky';
} else {
  $sticky_id = 'header-sticky-none';  
}

$dynamic_classes = $breadcrumb_height.' '.$all_default_height; 

?>

<!-- header -->
<header id="<?php echo esc_attr( $sticky_id ); ?>" class="event-header <?php echo esc_attr( $dynamic_classes ); ?> header5">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-12">
        <div class="header-main-area">
          <?php get_template_part( 'headers/logo' ); ?>
          <div class="header-main-menu-area">
            <div class="menu-area text-right">
              <div class="main-menu t-main-menu">
                <?php get_template_part( 'headers/menu' ); ?>
              </div>
            </div>
          </div>
          <?php if( function_exists( 'chariton_framework_init' ) ) : ?>
            <div class="header-five-search-area">
              <?php get_template_part( 'headers/search' ); ?>
              <?php get_template_part( 'headers/donation' ); ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
      <div class="col-12">
          <div class="mobile-menu"></div>
      </div>
    </div>
  </div>
</header>
<!-- header-end -->

<?php 
  if ( !empty( chariton_get_option( 'search_btn_switch' ) ) ) {
    if(function_exists( 'chariton_header_search_form' ) ) {
      do_action( 'chariton_search_form_modal' );
    }
  }
?>