<?php 

if ( ! defined( 'ABSPATH' ) ) {
    die( 'Direct access forbidden.' );
}

function chariton_body_fonts_url() {
  $font_url = '';
  /*
  Translators: If there are characters in your language that are not supported
  by chosen font(s), translate this to 'off'. Do not translate into your own language.
   */
  if ( 'off' !== _x( 'on', 'Google font: on or off', 'chariton' ) ) {

    if( function_exists( 'chariton_framework_init' ) ) {

      $body_typo_data = chariton_get_option('chariton_body_font');
      $heading_typo_data = chariton_get_option('chariton_heading_font');

      if( !empty($body_typo_data) || !empty($heading_typo_data)) {

        $body_font = $body_typo_data['family'];
        $heading_font = $heading_typo_data['family'];
        
        $font_url = add_query_arg( 'family', urlencode( $body_font.':400,400i,700,700i&display=swap|'. $heading_font .':400,400i,500,500i,600,700,800' ), "//fonts.googleapis.com/css" );
      } else {
        $font_url = add_query_arg( 'family', urlencode( 'Karla:400,400i,700,700i&display=swap|Barlow Condensed:400,400i,500,500i,600,700,800' ), "//fonts.googleapis.com/css" );
      }
    } else {
      $font_url = add_query_arg( 'family', urlencode( 'Karla:400,400i,700,700i&display=swap|Barlow Condensed:400,400i,500,500i,600,700,800' ), "//fonts.googleapis.com/css" );
    }
  }
  return $font_url;
}

/** Gutenberg optimization enqueue files.
--------------------------------------------------------------------------------------------------- */
add_action('enqueue_block_editor_assets', 'chariton_action_enqueue_block_editor_assets' );
function chariton_action_enqueue_block_editor_assets() {
  wp_enqueue_style( 'chariton-body-fonts',  chariton_body_fonts_url(), '', '1.0.0', 'screen' );
  wp_enqueue_style('chariton-gutenberg-editor-custom', CHARITON_CSS . '/gutenberg/gutenberg-editor-custom.css' );
  wp_enqueue_style('chariton-gutenberg-custom', CHARITON_CSS . '/gutenberg/gutenberg-custom.css' );
}

function chariton_scripts() {

  /** lifestyleblog Fonts Load.
  --------------------------------------------------------------------------------------------------- */
  wp_enqueue_style( 'chariton-body-fonts',  chariton_body_fonts_url(), '', '1.0.0', 'screen' );

  /**  css include.
  --------------------------------------------------------------------------------------------------- */
  wp_enqueue_style('bootstrap', CHARITON_CSS . 'bootstrap.min.css');
  wp_enqueue_style('animate', CHARITON_CSS . 'animate.min.css');
  wp_enqueue_style('magnific-popup', CHARITON_CSS . 'magnific-popup.css');
  wp_enqueue_style('fontawesome', CHARITON_CSS . 'fontawesome-all.min.css');
  wp_enqueue_style('aos', CHARITON_CSS . 'aos.css');
  wp_enqueue_style('meanmenu', CHARITON_CSS . 'meanmenu.css');
  wp_enqueue_style('slick', CHARITON_CSS . 'slick.css');
  wp_enqueue_style('chariton-gutenberg-custom', CHARITON_CSS . '/gutenberg/gutenberg-custom.css');
  wp_enqueue_style('chariton-default', CHARITON_CSS . 'chariton-default.css');
  wp_enqueue_style('chariton-main', CHARITON_CSS . 'chariton-main.css');
  wp_enqueue_style('chariton-responsive', CHARITON_CSS . 'chariton-responsive.css');

  //Chariton Core style
  wp_enqueue_style('chariton-style', get_stylesheet_uri() );

  /**  js include.
  --------------------------------------------------------------------------------------------------------------------*/
  wp_enqueue_script('popper', CHARITON_JS . 'popper.min.js', array('jquery'), '', true);
  wp_enqueue_script('bootstrap', CHARITON_JS . 'bootstrap.min.js', array('jquery'), '4.0.0', true);
  wp_enqueue_script('isotope', CHARITON_JS . 'isotope.pkgd.min.js', array('jquery'), '3.0.6', true);
  wp_enqueue_script('slick', CHARITON_JS . 'slick.min.js', array('jquery'), '', true);
  wp_enqueue_script('meanmenu', CHARITON_JS . 'jquery.meanmenu.min.js', array('jquery'), '', true);
  wp_enqueue_script( 'imagesloaded' );
  wp_enqueue_script('wow', CHARITON_JS . 'wow.min.js', array('jquery'), '', true);
  wp_enqueue_script('aos', CHARITON_JS . 'aos.js', array('jquery'), '', true);
  wp_enqueue_script('counterup', CHARITON_JS . 'jquery.counterup.min.js', array('jquery'), '1.0', true);
  wp_enqueue_script('countdown', CHARITON_JS . 'jquery.countdown.min.js', array('jquery'), '1.0', true);
  wp_enqueue_script('waypoints', CHARITON_JS . 'jquery.waypoints.min.js', array('jquery'), '2.0.3', true);
  wp_enqueue_script('lettering', CHARITON_JS . 'jquery.lettering.js', array('jquery'), '', true);
  wp_enqueue_script('textillate', CHARITON_JS . 'jquery.textillate.js', array('jquery'), '', true);
  wp_enqueue_script('magnific-popup', CHARITON_JS . 'jquery.magnific-popup.min.js', array('jquery'), '1.1.0', true);
  wp_enqueue_script('plugins', CHARITON_JS . 'plugins.js', array('jquery'), '', true);
  wp_enqueue_script('chariton-main', CHARITON_JS . 'chariton-main.js', array('jquery'), '1.0.0', true);

  if (is_singular() && comments_open() && get_option('thread_comments')) {
    wp_enqueue_script('comment-reply');
  }
}
add_action('wp_enqueue_scripts', 'chariton_scripts');

if ( ! did_action( 'elementor/loaded' ) ) {
  add_action( 'elementor/editor/before_enqueue_scripts', function() {
     wp_enqueue_style( 'chariton-elements-editor-rescss', CHARITON_CSS . 'chariton-responsive.css',
      [
          'elementor-editor', // dependency
      ],
      '1.0.0',
      false // in_footer
     );
  } );
}