<?php
/**
 * Custom functions that act independently of the theme templates
 *
 * Eventually, some of the functionality here could be replaced by core features
 *
 * @package chariton
 */

/*------------------------------------------------------------------------------------------------------------------*/
/*  Comments from call back function.
/*------------------------------------------------------------------------------------------------------------------*/

if(!function_exists('chariton_comment')):

    function chariton_comment($comment, $args, $depth) {
        
        $GLOBALS['comment'] = $comment;
        switch ( $comment->comment_type ) :
        case 'pingback' :
        case 'trackback' :
            // Display trackbacks differently than normal comments.
        ?>
        <li <?php comment_class(); ?> id="submited-comment">

            <p><?php esc_html_e( 'Pingback:', 'chariton' ); ?> <?php comment_author_link(); ?> <?php edit_comment_link( esc_html__( '(Edit)', 'chariton' ), '<span class="edit-link">', '</span>' ); ?></p>
            <?php
            break;
            default :

            global $post;
            ?>

            <li <?php comment_class(); ?>>

                <div class="bs-example" data-example-id="media-list"> 
                    <ul class="comments media-list">
                        <li class="comment-box clearfix" id="comment-<?php comment_ID(); ?>">
                            <article>
                                <div class="single-comment bd-comment-box">
                                    <div class="comments-avatar">
                                        <?php echo get_avatar( $comment, $args['avatar_size'] ); ?>
                                    </div>
                                    <div class="comment-text">
                                        <div class="avatar-name mb-15">
                                            <h6><?php comment_author(); ?></h6>
                                            <span><?php echo (get_comment_date() . esc_html__( ' at ', 'chariton' ) .get_comment_time()); ?></span>
                                            <?php comment_reply_link( array_merge( $args, array( 'reply_text' => '<i class="fas fa-reply"></i>'.esc_html__( 'Reply', 'chariton'), 'after' => '', 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
                                        </div>
                                        <div class="text"><?php comment_text(); ?></div>
                                    </div>
                                </div>
                            </article>
                        </li>
                    </ul>
                </div>
            <?php
        break;
        endswitch; 
    }
endif;


/*------------------------------------------------------------------------------------------------------------------*/
/*  Search
/*------------------------------------------------------------------------------------------------------------------*/
add_filter('get_search_form', 'chariton_search_form');
function chariton_search_form($form) {

    /**
     * Search form customization.
     *
     * @link http://codex.wordpress.org/Function_Reference/get_search_form
     * @since 1.0.0
     */
    $form = '<div class="ws-input"><form role="search" method="get" action="' .esc_url( home_url('/') ) . '">
                <input type="search" placeholder="'.esc_attr__( 'Enter Search Keywords', 'chariton' ).'" name="s">
                <button><i class="fa fa-search"></i></button>
            </form></div>';
    return $form;
}


/*------------------------------------------------------------------------------------------------------------------*/
/*   The excerpt
/*------------------------------------------------------------------------------------------------------------------*/
function chariton_excerpt($limit) {
    $excerpt = explode(' ', get_the_excerpt(), $limit);
    if (count($excerpt)>=$limit) {
        array_pop($excerpt);
        $excerpt = implode(" ",$excerpt).'';
    } else {
        $excerpt = implode(" ",$excerpt);
    }
    $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
    return $excerpt;
}

if(function_exists( 'chariton_framework_init' ) ) {
    /*------------------------------------------------------------------------------------------------------------------*/
    /* Category List count wrap by span
    /*------------------------------------------------------------------------------------------------------------------*/

    add_filter('wp_list_categories', 'chariton_cat_count_span');
    function chariton_cat_count_span($links) {        
        $links = str_replace('(', '<span class="pull-right">', $links);
        $links = str_replace(')', '</span>', $links);
        return $links;
    }

    /*------------------------------------------------------------------------------------------------------------------*/
    /* Archive List count wrap by span
    /*------------------------------------------------------------------------------------------------------------------*/

    add_filter('get_archives_link', 'chariton_archive_cat_count_span');
    function chariton_archive_cat_count_span($links) {        
        $links = str_replace('(', '<span class="pull-right">', $links);
        $links = str_replace(')', '</span>', $links);
        return $links;
    }

} else {
    /*------------------------------------------------------------------------------------------------------------------*/
    /* Category List count wrap by span
    /*------------------------------------------------------------------------------------------------------------------*/

    add_filter('wp_list_categories', 'chariton_cat_count_span');
    function chariton_cat_count_span($links) {        
        $links = str_replace('(', '<span class="pull-right">(', $links);
        $links = str_replace(')', ')</span>', $links);
        return $links;
    }

    /*------------------------------------------------------------------------------------------------------------------*/
    /* Archive List count wrap by span
    /*------------------------------------------------------------------------------------------------------------------*/

    add_filter('get_archives_link', 'chariton_archive_cat_count_span');
    function chariton_archive_cat_count_span($links) {        
        $links = str_replace('(', '<span class="pull-right">(', $links);
        $links = str_replace(')', ')</span>', $links);
        return $links;
    }
}

/*------------------------------------------------------------------------------------------------------------------*/
/*  Chariton Breadcrum
/*------------------------------------------------------------------------------------------------------------------*/

add_action('chariton_breadcrum', 'chariton_breadcrum_set');
function chariton_breadcrum_set() {
    if(function_exists( 'chariton_framework_init' ) ) {
        $breadcrumb_bg_condition      = chariton_get_option('breadcrumb_bg_condition');
        $blog_page_breadcrumb_title   = chariton_get_option('blog_page_breadcrumb_title');
        $page_404_breadcrumb_title    = chariton_get_option('404_breadcrumb_title');
        $shop_page_breadcrumb_title   = chariton_get_option('shop_page_breadcrumb_title');
        $shop_single_breadcrumb_title = chariton_get_option('shop_single_breadcrumb_title');

        $page_breadcrumb_data = get_post_meta( get_queried_object_id(), '_custom_page_breadcrumb_options', true );
        if (!empty($page_breadcrumb_data['page_breadcrumb_bg_img'])) {
            $bg_img_id  = $page_breadcrumb_data['page_breadcrumb_bg_img'];
            $attachment = wp_get_attachment_image_src( $bg_img_id, 'full' );
            $bg_img     = ($attachment) ? $attachment[0] : $bg_img_id;
            $breadcrumb_bg = '';
        } else {
            $bg_img_id  = chariton_get_option('breatcrumb_bg_img');
            $attachment = wp_get_attachment_image_src( $bg_img_id, 'full' );
            $bg_img     = ($attachment) ? $attachment[0] : $bg_img_id;
            if (!empty($breadcrumb_bg_condition == 'image')) {
                if ( !empty($bg_img )) {
                    $image_overlay = 'image-overlay';
                    $breadcrumb_bg = '';
                } else {
                    $image_overlay = '';
                    $breadcrumb_bg = 'breadcrumb-img-none';
                }
                $bg_img = $bg_img;
            } else {
                $image_overlay = '';
                $breadcrumb_bg = '';
                $bg_img = '';
            }
        }

        if (!empty($page_breadcrumb_data['page_breadcrumb_title'])) {
            $page_bread_title = $page_breadcrumb_data['page_breadcrumb_title'];
        } else {
            $page_bread_title = '';
        }
    }else {
        $blog_page_breadcrumb_title = esc_html__( 'Blog Posts', 'chariton' );
        $page_404_breadcrumb_title = esc_html__( '404 Error', 'chariton' );
        $shop_page_breadcrumb_title = esc_html__( 'Shop', 'chariton' );
        $shop_single_breadcrumb_title = esc_html__( 'Shop', 'chariton' );
        $breadcrumb_bg_condition = '';
        $breadcrumb_bg = '';
        $bg_img = '';
        $image_overlay = '';
        $page_bread_title = '';
    }

    if( function_exists( 'chariton_framework_init' ) ) {
        $chariton_breadcrumb_switch = chariton_get_option('chariton_breadcrumb_switch');
    } else {
        $chariton_breadcrumb_switch = '';
    }

    if( function_exists( 'chariton_framework_init' ) ) {
        if ($chariton_breadcrumb_switch == true) {
            $breadcrumb_height = 'breadcrumb_height';
        } else {
            $breadcrumb_height = 'breadcrumb_menu_height';
        }
    }else {
        $breadcrumb_height = '';
    }

    $chariton_header_settings = get_post_meta( get_the_ID(), '_custom_page_header_options', true );
    
    if(!empty($chariton_header_settings['header_style'])) {
        if($chariton_header_settings['header_style'] == 'style1') {
            $hv = 'hv1';
        } elseif ($chariton_header_settings['header_style'] == 'style2')  {
            $hv = 'hv2';
        } elseif ($chariton_header_settings['header_style'] == 'style3')  {
            $hv = 'hv3';
        } else {
            $hv = 'hv1';
        }
    }elseif(function_exists( 'chariton_framework_init' ) ) {
        $default_header_style = chariton_get_option('default_header_style');
        if($default_header_style == 'style1') {
            $hv = 'hv1';
        } elseif ($default_header_style == 'style2')  {
            $hv = 'hv2';
        } elseif ($default_header_style == 'style3')  {
            $hv = 'hv3';
        } else {
            $hv = 'hv1';
        }
    } else {
        $hv = 'hv1';
    }

    if (!empty($bg_img)) {
        $image_overlay = 'image-overlay';
    }else {
         $image_overlay = '';
    }

    $logical_class = $image_overlay.' '.$breadcrumb_bg.' '.$breadcrumb_height.' '.$hv;


    if ( is_search() ) {
        $title = esc_html__( 'Search Results for : ', 'chariton' ) . get_search_query();
    }
    elseif ( is_404() ) {
        $title = !empty( $page_404_breadcrumb_title) ? $page_404_breadcrumb_title : esc_html__( 'Page not Found', 'chariton' );
    }
    elseif (is_home() && !is_front_page() || is_home() && is_front_page()) {
        if ( get_option( 'page_for_posts' ) ) {
            $title = get_the_title( get_option( 'page_for_posts' ) );
        }
        else {
            $title = !empty( $blog_page_breadcrumb_title ) ? $blog_page_breadcrumb_title : esc_html__( 'Blog Posts', 'chariton' );
        }
    }
    elseif ( is_archive() ) {
        $title = get_the_archive_title();
    }
    else {
        $title = get_the_title();
    }

    if ( class_exists( 'WooCommerce' ) ) {
        if(is_shop() || is_product_category() || is_product_tag()){
            $title = !empty($shop_page_breadcrumb_title ) ? $shop_page_breadcrumb_title : esc_html__( 'Shop', 'chariton' );
        }
        if(is_product('product')){
            $title = !empty($shop_single_breadcrumb_title ) ? $shop_single_breadcrumb_title : esc_html__( 'Shop', 'chariton' );
        }   
    }

    $title = apply_filters( 'chariton_page_title', $title );

    ?>
    <!-- breadcrumb-area -->
    <section class="breadcrumb-area p-relative <?php echo esc_attr( $logical_class ); ?>" style="background-image: url(<?php echo esc_url($bg_img); ?>);">
        <?php
        if( function_exists( 'chariton_framework_init' ) ) {
            if ($chariton_breadcrumb_switch == true) {
                $breadcrumb_height = 'breadcrumb_height';
        ?>
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumb-wrap">
                        <?php if (!empty($page_bread_title)) { ?>
                            <h2><?php echo wp_kses_stripslashes( $page_bread_title ); ?></h2>
                        <?php } else { ?>
                            <h2><?php echo wp_kses_stripslashes( $title ); ?></h2>
                        <?php } ?>
                        <?php if ( function_exists( 'bcn_display') ) { ?>
                            <div class="bread_crumb">
                                <div class="breadcrumbs-title">
                                    <?php bcn_display(); ?>
                                </div>
                            </div>
                        <?php }else{ ?>
                            <div class="bread_crumb">
                                <nav aria-label="breadcrumb">
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item active" aria-current="page"><?php chariton_meta_breadcrumbs(); ?></li>
                                    </ol>
                                </nav>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <?php }
        } else { ?>
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumb-wrap">
                        <div class="breadcrumb-wrap">
                            <?php if (!empty($page_bread_title)) { ?>
                                <h2><?php echo wp_kses_stripslashes( $page_bread_title ); ?></h2>
                            <?php } else { ?>
                                <h2><?php echo wp_kses_stripslashes( $title ); ?></h2>
                            <?php } ?>
                            <?php if ( function_exists( 'bcn_display') ) { ?>
                                <div class="bread_crumb">
                                    <div class="breadcrumbs-title">
                                        <?php bcn_display(); ?>
                                    </div>
                                </div>
                            <?php }else{ ?>
                                <div class="bread_crumb">
                                    <nav aria-label="breadcrumb">
                                        <ol class="breadcrumb">
                                            <li class="breadcrumb-item active" aria-current="page"><?php chariton_meta_breadcrumbs(); ?></li>
                                        </ol>
                                    </nav>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php } ?>
    </section>
    <!-- breadcrumb-area-end -->
<?php 
}


/*------------------------------------------------------------------------------------------------------------------*/
/*  Header Style Load
/*------------------------------------------------------------------------------------------------------------------*/ 

add_action('chariton_header_style', 'chariton_header_style_load');

function chariton_header_style_load() {
    $chariton_header_settings = get_post_meta( get_the_ID(), '_custom_page_header_options', true );
    
    if(!empty($chariton_header_settings['header_style'])) {
        if($chariton_header_settings['header_style'] == 'style1') {
            get_template_part('headers/header', 'default' );
        } elseif ($chariton_header_settings['header_style'] == 'style2')  {
            get_template_part('headers/header', 'style2' );
        } elseif ($chariton_header_settings['header_style'] == 'style3')  {
            get_template_part('headers/header', 'style3' );
        } elseif ($chariton_header_settings['header_style'] == 'style4')  {
            get_template_part('headers/header', 'style4' );
        } elseif ($chariton_header_settings['header_style'] == 'style5')  {
            get_template_part('headers/header', 'style5' );
        } else {
            get_template_part('headers/header', 'default' );
        }
    } elseif(function_exists( 'chariton_framework_init' ) ) {
        $default_header_style = chariton_get_option('default_header_style');
        if($default_header_style == 'style1') {
            get_template_part('headers/header', 'default' );
        } elseif ($default_header_style == 'style2')  {
            get_template_part('headers/header', 'style2' );
        } elseif ($default_header_style == 'style3')  {
            get_template_part('headers/header', 'style3' );
        } elseif ($default_header_style == 'style4')  {
            get_template_part('headers/header', 'style4' );
        } elseif ($default_header_style == 'style5')  {
            get_template_part('headers/header', 'style5' );
        } else {
            get_template_part('headers/header', 'default' );
        }
    } else {
        get_template_part('headers/header', 'default' );
    }
}

/*------------------------------------------------------------------------------------------------------------------*/
/*  Footer Style Load
/*------------------------------------------------------------------------------------------------------------------*/ 

add_action('chariton_footer_style', 'chariton_footer_style_load');

function chariton_footer_style_load() {
    $chariton_footer_settings = get_post_meta( get_the_ID(), '_custom_page_footer_options', true );
    
    if(!empty($chariton_footer_settings['footer_style'])) {
        if($chariton_footer_settings['footer_style'] == 'style1') {
            get_template_part('footers/footer', 'default' );
        } elseif ($chariton_footer_settings['footer_style'] == 'style2')  {
            get_template_part('footers/footer', 'style2' );
        } else {
            get_template_part('footers/footer', 'default' );
        }
    } elseif(function_exists( 'chariton_framework_init' ) ) {
        $select_footer_style = chariton_get_option('select_footer_style');
        if($select_footer_style == 'style1') {
            get_template_part('footers/footer', 'default' );
        } elseif ($select_footer_style == 'style2')  {
            get_template_part('footers/footer', 'style2' );
        } else {
            get_template_part('footers/footer', 'default' );
        }
    } else {
        get_template_part('footers/footer', 'default' );
    }
}

/*--------------------------------------------------------------------------------------------------*/
/*  Chariton WooCommerce Product Per Pages
/*--------------------------------------------------------------------------------------------------*/

add_filter( 'loop_shop_per_page', 'chariton_loop_shop_per_page', 20 );

function chariton_loop_shop_per_page( $products ) {
    // Return the number of products you wanna show per page.
    if( function_exists( 'chariton_framework_init' ) ) {
        $shop_posts_per_page = chariton_get_option('shop_posts_per_page');
        if (!empty($shop_posts_per_page)) {
           $shop_posts_per_page = $shop_posts_per_page;
        } else {
            $shop_posts_per_page = '12';
        }
    } else {
      $shop_posts_per_page = '12';
    }
    $products = $shop_posts_per_page;
    return $products;
}


/*--------------------------------------------------------------------------------------------------*/
/*  Chariton WooCommerce Product Column Per Pages
/*--------------------------------------------------------------------------------------------------*/ 

add_filter( 'loop_shop_columns', 'chariton_loop_shop_per_columns', 999 );

function chariton_loop_shop_per_columns( $loopcolumns ) {
    // Return the number of products you wanna show per page.
    if( function_exists( 'chariton_framework_init' ) ) {
        $shop_post_col_layout       = chariton_get_option('product_col_layout');
        if (!empty($shop_post_col_layout)) {
           $shop_post_col_layout = $shop_post_col_layout;
        } else {
            $shop_post_col_layout = '4';
        }
    } else {
      $shop_post_col_layout = '4';
    }
    $loopcolumns = $shop_post_col_layout;
    return $loopcolumns;
}

/*--------------------------------------------------------------------------------------------------*/
/*  Chariton WooCommerce Related Product Column & Post Per Pages
/*--------------------------------------------------------------------------------------------------*/

function woo_related_products_limit() {
  global $product;
    
    $args['posts_per_page'] = 6;
    return $args;
}
add_filter( 'woocommerce_output_related_products_args', 'chariton_related_products_args', 20 );
  function chariton_related_products_args( $args ) {
    if( function_exists( 'chariton_framework_init' ) ) {
        $related_products_per_page       = chariton_get_option('related_products_per_page');
        $related_product_col_layout      = chariton_get_option('related_product_col_layout');
        if (!empty($related_product_col_layout)) {
           $related_product_col_layout = $related_product_col_layout;
        } else {
            $related_product_col_layout = '3';
        }
        if (!empty($related_products_per_page)) {
           $related_products_per_page = $related_products_per_page;
        } else {
            $related_products_per_page = '3';
        }
    } else {
      $related_products_per_page    = '3';
      $related_product_col_layout   = '3';
    }

    $args['posts_per_page'] = $related_products_per_page; // 4 related products
    $args['columns'] = $related_product_col_layout; // arranged in 2 columns
    return $args;
}


/*------------------------------------------------------------------------------------------------------------------*/
/* Set post views count using post meta
/*------------------------------------------------------------------------------------------------------------------*/ 

//Set the Post Custom Field in the WP dashboard as Name/Value pair 
function chariton_set_PostViews($post_ID) {
 
    //Set the name of the Posts Custom Field.
    $count_key = 'post_views_count'; 
     
    //Returns values of the custom field with the specified key from the specified post.
    $count = get_post_meta($post_ID, $count_key, true);
     
    //If the the Post Custom Field value is empty. 
    if($count == ''){
        $count = 0; // set the counter to zero.
         
        //Delete all custom fields with the specified key from the specified post. 
        delete_post_meta($post_ID, $count_key);
         
        //Add a custom (meta) field (Name/value)to the specified post.
        add_post_meta($post_ID, $count_key, '0');
        return $count;
     
    //If the the Post Custom Field value is NOT empty.
    } else {
        $count++; //increment the counter by 1.
        //Update the value of an existing meta key (custom field) for the specified post.
        update_post_meta($post_ID, $count_key, $count);
         
        //If statement, is just to have the singular form 'View' for the value '1'
        if($count == '1'){
        return $count;
        }
        //In all other cases return (count) Views
        else {
        return $count;
        }
    }
}


/*------------------------------------------------------------------------------------------------------------------*/
/* View column in dashboar post screen
/*------------------------------------------------------------------------------------------------------------------*/ 

function chariton_get_PostViews($post_ID){
    $count_key = 'post_views_count';
    $count = get_post_meta($post_ID, $count_key, true);
 
    return $count;
}
 
function post_column_views($newcolumn){
    $newcolumn['post_views'] = __('Views', 'chariton');
    return $newcolumn;
}
add_filter('manage_posts_columns', 'post_column_views');

function post_custom_column_views($column_name, $id){
     
    if($column_name === 'post_views'){
        echo chariton_get_PostViews(get_the_ID());
    }
}
add_action('manage_posts_custom_column', 'post_custom_column_views',10,2);



/*------------------------------------------------------------------------------------------------------------------*/
/*  Chariton Nav Walker
/*------------------------------------------------------------------------------------------------------------------*/ 

class Chariton_navwalker extends Walker_Nav_Menu {
    /**
     * @see Walker::start_lvl()
     * @since 1.0.0
     *
     * @param string $output Passed by reference. Used to append additional content.
     * @param int $depth Depth of page. Used for padding.
     */
    private $Chariton_megamenu_status = "";
    public function start_lvl( &$output, $depth = 0, $args = array() ) {
        $indent = str_repeat( "\t", $depth );
        if ($depth == 0 && $this->Chariton_megamenu_status == "enabled") {
            $output .= "\n$indent\n<ul class=\"mormal-menu\">\n";
        } elseif ($depth >= 1 && $this->Chariton_megamenu_status == "enabled") {
            $output .= "\n$indent<ul>\n";
        } elseif ($depth == 0 && $this->Chariton_megamenu_status != "enabled") {
            $output .= "\n$indent<ul class=\"submenu\">\n";
        } elseif ($depth >= 1 && $this->Chariton_megamenu_status != "enabled") {
            $output .= "\n$indent<ul class=\"submenu\">\n";
        } else {
            $output .= "\n$indent<ul>\n";
        }
    }
    /**
     * @see Walker::start_el()
     * @since 3.0.0
     *
     * @param string $output Passed by reference. Used to append additional content.
     * @param object $item Menu item data object.
     * @param int $depth Depth of menu item. Used for padding.
     * @param int $current_page Menu item ID.
     * @param object $args
     */
    public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
        $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
        /**
         * Dividers, Headers or Disabled
         * =============================
         * Determine whether the item is a Divider, Header, Disabled or regular
         * menu item. To prevent errors we use the strcasecmp() function to so a
         * comparison that is not case sensitive. The strcasecmp() function returns
         * a 0 if the strings are equal.
         */
        if ( strcasecmp( $item->attr_title, 'divider' ) == 0 && $depth === 1 ) {
            $output .= $indent . '<li role="presentation" class="divider">';
        } else if ( strcasecmp( $item->title, 'divider') == 0 && $depth === 1 ) {
            $output .= $indent . '<li role="presentation" class="divider">';
        } else if ( strcasecmp( $item->attr_title, 'dropdown-header') == 0 && $depth === 1 ) {
            $output .= $indent . '<li role="presentation" class="dropdown-header">' . esc_attr( $item->title );
        } else if ( strcasecmp($item->attr_title, 'disabled' ) == 0 ) {
            $output .= $indent . '<li role="presentation" class="disabled"><a href="#">' . esc_attr( $item->title ) . '</a>';
        } else {
            $class_names = $value = '';
            $classes = empty( $item->classes ) ? array() : (array) $item->classes;
            $classes[] = 'menu-item-' . $item->ID;
            $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
            if ( $args->has_children )
                $class_names .= ' submenu-area';
            if ( in_array( 'current-menu-item', $classes ) )
                $class_names .= ' active';
            $class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';
            $id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args );
            $id = $id ? ' id="' . esc_attr( $id ) . '"' : '';
            $output .= $indent . '<li' . $id . $value . $class_names .'>';
            $atts = array();
            $atts['target'] = ! empty( $item->target )  ? $item->target : '';
            $atts['rel']    = ! empty( $item->xfn )     ? $item->xfn    : '';
            $atts['href']   = ! empty( $item->url )     ? $item->url    : '';
            // If item has_children add atts to a.
            if ( $args->has_children && $depth === 0 ) {
                $atts['href'] = ! empty( $item->url ) ? $item->url : '';
                $atts['data-toggle']    = 'submenu-area';
                $atts['class']          = 'dropdown-toggle';
                $atts['aria-haspopup']  = 'true';
            } else {
                $atts['href'] = ! empty( $item->url ) ? $item->url : '';
            }
            $atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args );
            $attributes = '';
            foreach ( $atts as $attr => $value ) {
                if ( ! empty( $value ) ) {
                    $value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
                    $attributes .= ' ' . $attr . '="' . $value . '"';
                }
            }
            $item_output = $args->before;
            /*
             * Glyphicons
             * ===========
             * Since the the menu item is NOT a Divider or Header we check the see
             * if there is a value in the attr_title property. If the attr_title
             * property is NOT null we apply it as the class name for the glyphicon.
             */
            if ( ! empty( $item->attr_title ) )
                $item_output .= '<a'. $attributes .'><span class="glyphicon ' . esc_attr( $item->attr_title ) . '"></span>&nbsp;';
            else
                $item_output .= '<a'. $attributes .'>';
            $item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
            $item_output .= ( $args->has_children && 0 === $depth ) ? '</a>' : '</a>';
            $item_output .= $args->after;
            $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
        }
    }
    /**
     * Traverse elements to create list from elements.
     *
     * Display one element if the element doesn't have any children otherwise,
     * display the element and its children. Will only traverse up to the max
     * depth and no ignore elements under that depth.
     *
     * This method shouldn't be called directly, use the walk() method instead.
     *
     * @see Walker::start_el()
     * @since 2.5.0
     *
     * @param object $element Data object
     * @param array $children_elements List of elements to continue traversing.
     * @param int $max_depth Max depth to traverse.
     * @param int $depth Depth of current element.
     * @param array $args
     * @param string $output Passed by reference. Used to append additional content.
     * @return null Null on failure with no changes to parameters.
     */
    public function display_element( $element, &$children_elements, $max_depth, $depth, $args, &$output ) {
        if ( ! $element )
            return;
        $id_field = $this->db_fields['id'];
        // Display this element.
        if ( is_object( $args[0] ) )
           $args[0]->has_children = ! empty( $children_elements[ $element->$id_field ] );
        parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
    }
    /**
     * Menu Fallback
     * =============
     * If this function is assigned to the wp_nav_menu's fallback_cb variable
     * and a manu has not been assigned to the theme location in the WordPress
     * menu manager the function with display nothing to a non-logged in user,
     * and will add a link to the WordPress menu manager if logged in as an admin.
     *
     * @param array $args passed from the wp_nav_menu function.
     *
     */
    public static function fallback( $args ) {
        if ( current_user_can( 'manage_options' ) ) {
            extract( $args );
            $fb_output = null;
            if ( $container ) {
                $fb_output = '<' . $container;
                if ( $container_id )
                    $fb_output .= ' id="' . $container_id . '"';
                if ( $container_class )
                    $fb_output .= ' class="' . $container_class . '"';
                $fb_output .= '>';
            }
            $fb_output .= '<ul';
            if ( $menu_id )
                $fb_output .= ' id="' . $menu_id . '"';
            if ( $menu_class )
                $fb_output .= ' class="' . $menu_class . '"';
            $fb_output .= '>';
            $fb_output .= '<li><a href="' . admin_url( 'nav-menus.php' ) . '">'.esc_html__( 'Add a menu', 'chariton' ).'</a></li>';
            $fb_output .= '</ul>';
            if ( $container )
                $fb_output .= '</' . $container . '>';
            echo wp_kses( $fb_output );
        }
    }
}