<?php
/**
 * The template for displaying all cause single posts.
 *
 * @package chariton
 */

get_header(); 

do_action( 'chariton_breadcrum' );

if( function_exists( 'chariton_framework_init' ) ) {
  $post_share_enable = chariton_get_option('chariton_cause_social_share');
} else {
  $post_share_enable = '';
}

if ($post_share_enable) {
  $tags_list_cols = '9';
} else {
  $tags_list_cols = '12';
}

if ( is_active_sidebar( 'cause-widgets') ) {
    $wrap_cols = '8';
} else {
    $wrap_cols = '10 mx-auto';
}

?>

<!-- cause-details-area -->
<section class="cause-details-area pt-120 pb-90">
    <div class="container">
        <div class="row">
            <div class="col-lg-<?php echo esc_attr( $wrap_cols ); ?>">
                <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); 

                    $cause_info = get_post_meta( get_the_ID(), '_ifinger_cause', true );
                    if (!empty($cause_info['post_author_desination'])) {
                      $post_author_desination = $cause_info['post_author_desination'];
                    } else {
                      $post_author_desination = '';
                    }
                    if (!empty($cause_info['post_author_desination'])) {
                      $post_author_desination = $cause_info['post_author_desination'];
                    } else {
                      $post_author_desination = '';
                    }

                    if (!empty($cause_info['fundraising_report_tilte'])) {
                      $fundraising_report_tilte = $cause_info['fundraising_report_tilte'];
                    } else {
                      $fundraising_report_tilte = '';
                    }if (!empty($cause_info['fundraising_report_down_link'])) {
                      $fundraising_report_down_link = $cause_info['fundraising_report_down_link'];
                    } else {
                      $fundraising_report_down_link = '';
                    }

                    $terms = get_the_terms(get_the_ID(), 'cause_category' );          
                    if ( $terms && ! is_wp_error( $terms ) ) {
                        $draught_links = array();
                        foreach ( $terms as $term ) {
                            $draught_links[] = $term->name;
                            $term_link = get_term_link( $term );
                        }        
                        $cat_slug = join( " ", $draught_links );
                    }
                ?>
                <div class="section-title cause-details-top">
                    <span class="jazzberry-color"><?php echo esc_html( $cat_slug ); ?></span>
                </div>
                <?php if(has_post_thumbnail()) : ?>
                    <div class="cause-details-img">
                        <?php the_post_thumbnail(); ?>
                    </div>
                <?php endif; ?>
                <div class="cause-details-content">
                    <div class="cause-details-avatar">
                        <?php echo get_avatar( get_the_author_meta('email'), '30' ); ?>
                        <p><?php echo get_the_author_posts_link('display_name'); echo esc_html( ' '.$post_author_desination ); ?></p>
                    </div>
                    <div class="cause-action">
                        <ul>
                            <?php if (function_exists('ifingers_post_like_get_simple_likes_button')) { ?>
                                <li><?php echo ifingers_post_like_get_simple_likes_button( get_the_ID() ); ?></li>
                            <?php } if (!empty($fundraising_report_tilte) || !empty($fundraising_report_down_link)) { ?>
                            <li><a href="<?php echo esc_url($fundraising_report_down_link); ?>" class="cause-report"><i class="far fa-flag-alt"></i><?php echo esc_html( $fundraising_report_tilte ) ?></a></li>
                        <?php } ?>
                        </ul>
                    </div>
                    <div class="cause-details-meta">
                        <ul>
                            <li><i class="far fa-clock"></i><?php esc_html_e( 'Created ', 'chariton' ); echo esc_html( get_the_date() ); ?></li>
                            <?php
                                $terms = wp_get_post_terms( $post->ID, 'cause_category');
                                if (!empty($terms)) { 
                                ?>
                                <li><i class="far fa-tag"></i>
                                    <?php
                                        foreach ( $terms as $term ) {
                                            echo '<a href="'.get_term_link($term->slug, 'cause_category').'">'.$term->name.'</a>';
                                        }
                                    ?>
                                </li>
                            <?php } ?>
                        </ul>
                    </div>
                    <div class="cause-single-details-content">
                        <?php the_content(); ?>
                    </div>
                    <div class="c-details-meta-info">
                        <div class="row">
                            <?php 
                            $tags = get_the_tags(); 
                            if ($tags) {
                                $share_cols = '3 text-md-right';
                            ?>
                            <div class="col-md-<?php echo esc_attr( $tags_list_cols ); ?>">
                                <div class="cause-details-tag">
                                    <?php the_tags( '<h5>'.__( 'Tags', 'chariton' ).'</h5><ul class="cd-tags"><li>', '</li><li>', '</li></ul>' ); ?>
                                </div>
                            </div>
                            <?php } else {
                                $share_cols = '12 text-left text-md-left';
                            } ?>
                            <?php if ( !empty($post_share_enable) ) : ?>
                                <div class="col-md-<?php echo esc_attr( $share_cols ); ?>">
                                    <?php do_action( 'chariton_social_share_media' ); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="chariton-comments-wrapper">
                         <?php // If comments are open or we have at least one comment, load up the comment template.
                            if ( comments_open() || get_comments_number() ) :
                              comments_template();
                            endif; 
                          ?>
                    </div>
                </div>
                <?php endwhile; 
                else :
                    get_template_part( 'template-parts/content', 'none' );
                endif; 
                ?>
            </div>
            <?php if ( is_active_sidebar( 'cause-widgets') ) { ?>
                <div class="col-lg-4">
                    <aside>
                        <div class="cause-sidebar">
                            <?php dynamic_sidebar( 'cause-widgets' ); ?>
                        </div>
                    </aside>
                </div>
            <?php } ?>
        </div>
    </div>
</section>

<!-- cause-details-area-end -->
<?php get_footer(); ?>