<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package chariton
 */

get_header();

do_action('chariton_breadcrum');

?>

<!-- Page-section - start
================================================== -->
<div class="primary-bg">
    <div class="inner-blog pt-120 pb-110">
        <div class="container">
            <div class="row">
            <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); 
                $goal_stats = give_goal_progress_stats( get_the_ID() );
                if (
                    'percentage' === $goal_stats['format']
                    || !$goal_stats['goal']
                ) {
                    return;
                }

                $income = $goal_stats['raw_actual'];
                $goal   = $goal_stats['raw_goal'];
                $lack_value = give_format_amount($goal_stats['raw_goal'] - $goal_stats['raw_actual']);

                if ('amount' === $goal_stats['format']) {
                    $lack_value =  give_currency_filter($lack_value);
                }

                $goal_label         = esc_html__('Goal', 'chariton');
                $raised_label       = esc_html__('Raised', 'chariton');
                $goal_lack_label    = esc_html__('Left', 'chariton');

                $terms = get_the_terms(get_the_ID(), 'give_forms_category' );          

                ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="single-causes ">
                            <?php if(has_post_thumbnail()) : ?>
                                <div class="causes-thumb">
                                    <a href="<?php the_permalink();?>"><?php the_post_thumbnail();?></a>
                                </div>
                            <?php endif; ?>
                            <div class="causes-content">
                                <?php if ( give_is_setting_enabled( give_get_option( 'categories', 'disabled' ) ) ) { ?>
                                    <ul class="cause-categories">
                                        <?php 
                                            if ( $terms && ! is_wp_error( $terms ) ) {
                                                foreach ( $terms as $term ) {
                                                    echo '<li><a href="'.get_term_link($term->slug, 'give_forms_category').'">'.$term->name.'</a></li>';
                                                }
                                            }
                                        ?>
                                    </ul>
                                <?php } ?>
                                <h3><a href="<?php the_permalink();?>"><?php the_title(); ?></a></h3>
                            </div>
                            <div class="causes-meta">
                                <ul class="d-flex justify-content-between">
                                    <li class="fund-goal"><span class="label-name"><?php echo $goal_label; ?></span> 
                                        <?php echo $goal_stats['goal'] ?>
                                    </li>
                                    <li class="fund-raised"><span class="label-name"><?php echo $raised_label; ?></span>
                                        <?php echo $goal_stats['actual'] ?>
                                    </li>
                                    <li class="fund-lacks"><span class="label-name"><?php echo $goal_lack_label; ?></span>
                                        <?php echo $lack_value; ?>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>                            
                <?php endwhile; ?>
            <?php endif; ?>
           </div><!-- row -->
        </div><!-- container -->
    </div>
</div>
<!-- page-section - End
================================================== -->

<?php get_footer(); ?>