<?php
/**
 * Template part for displaying single posts.
 *
 * @package chariton
 */
if(function_exists('chariton_set_PostViews')) {
  chariton_set_PostViews(get_the_ID());
}

if( function_exists( 'chariton_framework_init' ) ) {
  $blog_single_post_admin     = chariton_get_option('blog_single_post_admin');
  $blog_single_post_comments  = chariton_get_option('blog_single_post_comments');
  $blog_single_post_cats      = chariton_get_option('blog_single_post_cats');
  $blog_single_post_date      = chariton_get_option('blog_single_post_date');
  $blog_single_post_tags      = chariton_get_option('blog_single_post_tags');
  $single_related_post_switch = chariton_get_option('single_related_post_switch');
  $blog_single_related_title  = chariton_get_option('blog_single_related_title');
} else {
  $blog_single_post_admin = 'true';
  $blog_single_post_comments = 'true';
  $blog_single_post_cats = 'true';
  $blog_single_post_date = 'true';
  $blog_single_post_tags = 'true';
  $single_related_post_switch = '';
  $blog_single_related_title = __( 'Releted Post', 'chariton' );
}

$tags_list = get_the_tag_list(); 
if( function_exists( 'chariton_framework_init' ) ) {
  $post_share_enable = chariton_get_option('chariton_post_details_share_enable');
} else {
  $post_share_enable = '';
}

$default_post_metadata = get_post_meta( get_the_ID(), '_chariton_post', true);

if (!empty($default_post_metadata['post_format_type'] )) {
  $post_format_type = $default_post_metadata['post_format_type'];
} else {
  $post_format_type = '';
}

if (!empty($default_post_metadata['video_type'] )) {
  $video_type = $default_post_metadata['video_type'];
} else {
  $video_type = '';
}
if (!empty($default_post_metadata['video_link'] )) {
  $video_link = $default_post_metadata['video_link'];
} else {
  $video_link = '';
}
if (!empty($default_post_metadata['audio_link'] )) {
  $audio_link = $default_post_metadata['audio_link'];
} else {
  $audio_link = '';
}

if (!empty($default_post_metadata['gallery_list'] )) {
  $gallery_list = $default_post_metadata['gallery_list'];
} else {
  $gallery_list = '';
} 

if ($gallery_list) {
    $ids = explode(",",$gallery_list);
} else {
    $ids = '';
}
?>

<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
  <div class="b-details-content">
    <?php if ($post_format_type == 'chariton-video') { ?>
      <div class="bpost-thumb position-relative">
        <?php the_post_thumbnail(); ?>
        <a href="<?php echo esc_url( $video_link ); ?>" class="video-i popup-video"><i class="fas fa-play"></i></a>
      </div>
    <?php } elseif ($post_format_type == 'chariton-gallery') { ?>
      <div class="bpost-thumb blog-thumb-active">
        <div class="slide-post">
          <?php the_post_thumbnail(); ?>
        </div>
        <?php 
          if (!empty($ids)) :
            foreach ($ids as $key => $value) :
              $src = wp_get_attachment_image_src( $value, "full" ); ?>
              <div class="slide-post">
                <img src="<?php echo esc_url($src[0]); ?>" alt="<?php esc_attr_e( 'post gallery image', 'chariton' ); ?>">
              </div>
        <?php endforeach; ?>
        <?php endif; ?>
      </div>
    <?php } elseif ($post_format_type == 'chariton-audio') { ?>
      <div class="bpost-thumb embed-responsive embed-responsive-16by9">
        <iframe src="<?php echo esc_url( $audio_link ); ?>"></iframe>
      </div>
    <?php } elseif ($post_format_type == 'chariton-tag') { ?>
      
    <?php } else { ?>
    <?php if(has_post_thumbnail()) { ?>
      <div class="blog-thumb">
        <?php the_post_thumbnail(); ?>
      </div>                                                                                        
    <?php }
    } ?>
    <div class="details-content">
      <div class="b-tag">
        <?php the_category(' '); ?>
      </div>
      <div class="bpost-meta mb-20">
        <ul>
          <li><i class="fal fa-user"></i><span><?php esc_html_e('By ', 'chariton'); ?></span><?php the_author_posts_link(); ?></li>
          <li><span><i class="fal fa-calendar-alt"></i><?php echo esc_html ( get_the_date() ); ?></span></li>
          <li><a><i class="fal fa-comments"></i><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></a></li>
        </ul>
      </div>
      <div class="the-content">
        <?php 
          the_content(); 
          wp_link_pages( array(
            'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'chariton' ),
            'after'  => '</div>',
            'link_before' => '<span>',
            'link_after'  => '</span>',
          ) );
        ?>
      </div>
      <?php if (!empty($tags_list) || !empty($post_share_enable) ) : ?>
      <div class="post-footer-meta">
        <div class="row">
          <?php
            if (!empty($post_share_enable)) {
              $post_tag_col = '6 text-md-left'; 
              $post_share_col = '6 text-md-right'; 
            } else {
              $post_tag_col = '12 text-md-left'; 
              $post_share_col = '12 text-md-left'; 
            }
            if(!empty($tags_list)){
          ?>
            <div class="col-xl-<?php echo esc_attr( $post_tag_col ); ?> col-md-7">
              <div class="d-post-tag">
                <h5><?php esc_html_e( 'Tags :', 'chariton' ) ?></h5>
                <?php the_tags( '<ul class="tags-list"><li>', ' </li> <li>', '</li></ul>' ); ?>
              </div>
            </div>
          <?php } ?>

          <?php if ( !empty($post_share_enable) ) : ?>
            <div class="col-xl-<?php echo esc_attr( $post_share_col ); ?> col-md-5">
              <?php do_action( 'chariton_social_share_media' ); ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
      <?php endif; ?>

      <?php chariton_post_nav(); ?>

      <?php if (!empty($single_related_post_switch)) : ?>
        <div class="releted-post mt-45">
          <h3><?php echo esc_html (  $blog_single_related_title ) ?></h3>
          <div class="row">
            <?php
              $related = new WP_Query(
                array(
                  'category__in'   => wp_get_post_categories( $post->ID ),
                  'posts_per_page' => 2,
                  'post__not_in'   => array( $post->ID )
                )
              );
              if( $related->have_posts() ) { 
                  while( $related->have_posts() ) { 
                      $related->the_post(); ?>
                        <div class="col-xl-6 col-lg-12 col-md-6">
                          <div class="single-rp">
                            <?php if(has_post_thumbnail()) { ?>
                            <div class="rp-thumb">
                              <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'chariton-770-460' ); ?></a>
                            </div>
                            <?php } ?>
                            <div class="rp-content">
                              <span class="rp-date"><i class="fal fa-calendar-alt"></i><?php echo esc_html ( get_the_date() ); ?></span>
                              <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                              <p><?php echo chariton_excerpt( 10 ); ?></p>
                            </div>
                          </div>
                        </div>
                <?php }
                wp_reset_postdata();
              }
            ?>
          </div>
        </div>
      <?php endif; ?>

      <?php if (get_the_author_meta('description')) : // Checking if the user has added any author descript or not. If it is added only, then lets move ahead ?>
        <div class="avatar-wrap mb-45">
          <div class="avatar-img">
            <?php echo get_avatar(get_the_author_meta('user_email'), '180'); // Display the author gravatar image with the size of 120 ?>
          </div>
          <div class="bd-avatar-info">
            <span><?php echo esc_html_e( 'Written by', 'chariton' ); ?></span>
            <h4><?php esc_html(the_author_meta('display_name')); // Displays the author name of the posts ?></h4>
            <p><?php esc_textarea(the_author_meta('description')); // Displays the author description added in Biographical Info ?></p>
          </div>
        </div>
      <?php endif; ?>
      <!-- blog Comment Section
      ============================== -->
      <?php // If comments are open or we have at least one comment, load up the comment template.
        if ( comments_open() || get_comments_number() ) :
          comments_template();
        endif; 
      ?>
    </div>
  </div>
</div>