<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @package chariton
 */

get_header(); 

do_action('chariton_breadcrum'); 

?>

<!-- blog-details-section - start
================================================== -->
<?php if( function_exists( 'chariton_framework_init' ) ) { ?>
    <!-- error-area -->
    <section class="error-area pt-85 pb-120">
        <div class="container">
            <div class="row">
                <div class="col-xl-8 text-center offset-xl-2">
                    <div class="error-content">
                        <h1><?php echo esc_html( chariton_get_option( '404_text' ) ); ?></h1>
                        <h2><?php echo esc_html( chariton_get_option( '404_page_title' ) ); ?></h2>
                        <p><?php echo esc_html( chariton_get_option( '404_page_desc' ) ); ?></p>
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="btn mt-15"><?php echo esc_html( chariton_get_option( '404_btn_txt' ) ); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- error-area-end -->
<?php } else { ?>
    <!-- error-area -->
    <section class="error-area pt-85 pb-120">
        <div class="container">
            <div class="row">
                <div class="col-xl-8 text-center offset-xl-2">
                    <div class="error-content">
                        <h1><?php esc_html_e( '404', 'chariton' ); ?></h1>
                        <h2><?php esc_html_e( 'Sorry, Page Not Found', 'chariton' ); ?></h2>
                        <p><?php esc_html_e( 'The page you are looking for was removed or might never existed.', 'chariton' ); ?></p>
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="btn mt-15"><?php esc_html_e( 'Back Home', 'chariton' ); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- error-area-end -->
<?php } ?>

<?php get_footer(); ?>