<!-- footer-section - start -->
<?php
    if (function_exists('chariton_framework_init')) {
        // Set column sizes with defaults if options are empty
        $footer2_widget1_columns = chariton_get_option('footer2_widget1_columns') ?: '4';
        $footer2_widget2_columns = chariton_get_option('footer2_widget2_columns') ?: '2';
        $footer2_widget3_columns = chariton_get_option('footer2_widget3_columns') ?: '3';
        $footer2_widget4_columns = chariton_get_option('footer2_widget4_columns') ?: '3';
    } else {
        // Default column sizes if framework function is unavailable
        $footer2_widget1_columns = $footer2_widget2_columns = $footer2_widget3_columns = $footer2_widget4_columns = '3';
    }

    // Define widget areas and set a CSS class if any widget is active
    $footer_widget_areas = [
        'footer2-widgets1' => $footer2_widget1_columns,
        'footer2-widgets2' => $footer2_widget2_columns,
        'footer2-widgets3' => $footer2_widget3_columns,
        'footer2-widgets4' => $footer2_widget4_columns,
    ];

    $footer_widget_activated = array_filter(array_keys($footer_widget_areas), 'is_active_sidebar') ? 'footer-widget-activated' : 'footer-widget-not-activated';
?>

<!-- footer-area -->
<footer class="footer-style-two black-bg <?php echo esc_attr($footer_widget_activated); ?> footer2">
    <?php if ($footer_widget_activated === 'footer-widget-activated') : ?>
        <div class="footer-main">
            <div class="container">
                <div class="row">
                    <?php foreach ($footer_widget_areas as $widget_id => $column_size) :
                        if (is_active_sidebar($widget_id)) : ?>
                            <div class="col-lg-<?php echo esc_attr($column_size); ?> col-md-6">
                                <?php dynamic_sidebar($widget_id); ?>
                            </div>
                        <?php endif;
                    endforeach; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="copyright-area-two">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="copyright-text pt-30 pb-30 text-center">
                        <?php get_template_part('footers/copyright-text'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<!-- footer-section - end -->