<?php if( function_exists( 'chariton_framework_init' ) ) {
  $logo_img_id = chariton_get_option('footer_logo');
  $attachment = wp_get_attachment_image_src( $logo_img_id, 'full' );
  $logo_img    = ($attachment) ? $attachment[0] : $logo_img_id;
  $footer_contact_list = chariton_get_option('footer_contact_list');
}else {
  $logo_img = '';
  $footer_contact_list = '';
}
?>

<?php if( function_exists( 'chariton_framework_init' ) ) { ?>
  <?php if ( !empty( chariton_get_option( 'default_ftp' ) ) ) { ?>
     <div class="footer-top">
         <div class="row">
             <div class="col-12">
                 <div class="footer-widget fix mb-40">
                     <?php if ( !empty( $logo_img ) ) { ?>
                     <div class="footer-logo mb-20">
                         <a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url( $logo_img ); ?>" alt="<?php esc_html_e( 'Logo', 'chariton' ); ?>"></a>
                     </div>
                     <?php } ?>
                     <?php if ( is_array( $footer_contact_list ) ) { ?>
                         <div class="fw-contact fix">
                             <ul>
                                 <?php foreach ($footer_contact_list as $key => $value) {
                                     $icon = $value['icon'];
                                     $title = $value['title'];
                                     $desc = $value['desc'];
                                 ?>
                                 <li>
                                     <?php if (!empty($icon)) { ?>
                                     <div class="fw-contact-icon">
                                         <i class="<?php echo esc_attr( $icon ); ?>"></i>
                                     </div>
                                     <?php } ?>
                                     <div class="fw-contact-content">
                                            <?php if (!empty($title)) : ?>
                                                <h4><?php echo esc_html( $title ); ?></h4>
                                            <?php endif; ?>
                                            
                                            <?php if (!empty($desc)) {

                                             if(filter_var($desc, FILTER_VALIDATE_EMAIL)){
                                               $href_value = 'email';
                                             } elseif (filter_var($desc, FILTER_SANITIZE_NUMBER_INT)) {
                                               $href_value = 'phone';
                                             } elseif (filter_var($desc, FILTER_VALIDATE_URL)) {
                                               $href_value = 'url';
                                             } else {
                                               $href_value = '';
                                             }
                                             if (!empty($href_value == 'phone')) {
                                                 
                                                 $phone_no = str_replace(" ", "", $desc);
                                         ?>
                                         <a href="tel:<?php echo esc_attr( $phone_no ); ?>"><?php echo esc_html( $desc ); ?></a>
                                         <?php } elseif(!empty($href_value == 'email')) { ?>
                                         <a href="mailto:<?php echo sanitize_email( $desc ); ?>"><?php echo esc_html( $desc ); ?></a>
                                         <?php } elseif(!empty($href_value == 'url')) { ?>
                                         <a href="<?php echo esc_url( $desc ); ?>"><?php echo esc_html( $desc ); ?></a>
                                         <?php } else { ?>
                                             <a><?php echo esc_html( $desc ); ?></a>
                                         <?php } 
                                         } ?>
                                     </div>
                                 </li>
                                 <?php } ?>
                             </ul>
                         </div>
                     <?php } ?>
                 </div>
             </div>
         </div>
     </div>
  <?php } ?>
<?php } ?>