<?php
// Menu Style Four
if( function_exists( 'chariton_framework_init' ) ) {
  $chariton_breadcrumb_switch    = chariton_get_option('chariton_breadcrumb_switch');

  $sticky_menu_switch            = chariton_get_option('sticky_menu_switch');
  $top_header_responsive4_device = chariton_get_option('top_header_responsive4_device');
} else {
  $chariton_breadcrumb_switch = '';
  $sticky_menu_switch = '1';
  $top_header_responsive4_device = '';
}

if( function_exists( 'chariton_framework_init' ) ) {
  if ($chariton_breadcrumb_switch == true) {
    $breadcrumb_height = 'breadcrumb_height';
  } else {
    $breadcrumb_height = 'breadcrumb_menu_height';
  }
} else {
  $breadcrumb_height = 'breadcrumb_height';
}

if (!empty($sticky_menu_switch)) {
  $sticky_id = 'header-sticky';
} else {
  $sticky_id = 'header-sticky-none';  
}

if( function_exists( 'chariton_framework_init' ) ) {
  if( $top_header_responsive4_device == true){
    $top_header_responsive4_device = 'add-transparent-area-class';
  }
}

?>

<!-- header -->
<header class="header4">
  <?php
  if(function_exists( 'chariton_framework_init' ) ) {
    if ( !empty( chariton_get_option('top_header') ) ) {
      $header_contact_list = chariton_get_option('header4_contact_list');
      $top_header4_toggle  = chariton_get_option('top_header4_toggle');
    ?>
      <div class="header-top-wrap header-top-bg d-md-block">
        <div class="container-fluid new-header-container">
            <div class="row">
                <div class="col-12">
                    <div class="header4-top-right-sections">
                        <div class="header-top-contact">
                            <ul>
                              <?php if (is_array($header_contact_list)) {
                                foreach ($header_contact_list as $key => $value) { 

                                  $data_type = $value['info_text'];

                                  if(filter_var($data_type, FILTER_VALIDATE_EMAIL)){
                                    $href_value = 'email';
                                  } elseif (filter_var($data_type, FILTER_SANITIZE_NUMBER_INT)) {
                                    $href_value = 'phone';
                                  } elseif (filter_var($data_type, FILTER_VALIDATE_URL)) {
                                    $href_value = 'url';
                                  } else {
                                    $href_value = '';
                                  }
                                  if (!empty($href_value == 'email')) {
                              ?>
                                <li>
                                    <div class="htc-icon">
                                        <i class="<?php echo esc_attr($value['icon']); ?>"></i>
                                    </div>
                                    <div class="htc-content">
                                        <h4><?php echo esc_html($value['title']); ?></h4>
                                        <a href="mailto:<?php echo sanitize_email($value['info_text']); ?>"><span><?php echo esc_html($value['info_text']); ?></span></a>
                                    </div>
                                </li>
                                <?php } elseif (!empty($href_value == 'phone')) { 
                                  $phone_no = str_replace(" ", "", $value['info_text']);
                                ?>
                                <li>
                                    <div class="htc-icon">
                                        <i class="<?php echo esc_attr($value['icon']); ?>"></i>
                                    </div>
                                    <div class="htc-content">
                                        <h4><?php echo esc_html($value['title']); ?></h4>
                                        <a href="tel:<?php echo esc_attr($phone_no); ?>"><span><?php echo esc_html($value['info_text']); ?></span></a>
                                    </div>
                                </li>
                                <?php } elseif (!empty($href_value == 'url')) { ?>
                                  <li>
                                    <div class="htc-icon">
                                      <i class="<?php echo esc_attr($value['icon']); ?>"></i>
                                    </div>
                                    <div class="htc-content">
                                      <h4><?php echo esc_html($value['title']); ?></h4>
                                      <a href="<?php echo esc_url($value['info_text']); ?>"><span><?php echo esc_html($value['info_text']); ?></span></a>
                                    </div>
                                  </li>
                                <?php } else { ?>
                                  <li>
                                    <div class="htc-icon">
                                      <i class="<?php echo esc_attr($value['icon']); ?>"></i>
                                    </div>
                                    <div class="htc-content">
                                      <h4><?php echo esc_html($value['title']); ?></h4>
                                      <span><?php echo esc_html($value['info_text']); ?></span>
                                    </div>
                                  </li>
                                <?php }
                                  } 
                                } ?>
                            </ul>
                        </div>
                        <?php if ( !empty( chariton_get_option( 'search_btn_switch' ) ) || !empty( chariton_get_option( 'top_header4_toggle' ) ) ) : ?>
                          <div class="new-header-top-link">
                            <ul> 
                              <?php if ( !empty( chariton_get_option( 'search_btn_switch' ) ) ) : ?>
                                <li><a href="#" data-toggle="modal" data-target="#search-modal"><i class="fal fa-search"></i></a></li>
                              <?php endif; ?>
                              <?php if ( !empty( chariton_get_option( 'top_header4_toggle' ) ) ) : ?>
                                <li><a href="#" class="menu-tigger"><i class="fal fa-bars"></i></a></li>
                              <?php endif; ?>
                            </ul>
                          </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
      </div>
    <?php } ?>
  <?php } ?>
  <?php
    $dynamic_class =  $breadcrumb_height;
  ?>
  <div id="<?php echo esc_attr( $sticky_id ); ?>" class="new-transparent-header <?php echo esc_attr( $top_header_responsive4_device );?> <?php echo esc_attr( $dynamic_class ); ?> header4">
      <div class="container-fluid new-header-container">
          <div class="new-main-header">
              <div class="row align-items-center">
                  <div class="col-xl-2 col-lg-3">
                    <div class="new-header-logo">
                      <?php get_template_part( 'headers/logo' ); ?>
                    </div>

                    <div class="new-header-sticky-logo s-logo">
                      <?php if( function_exists( 'chariton_framework_init' ) ) : ?>
                        <?php 
                          $chariton_logo2_img = chariton_get_option('chariton_logo2_img');
                          $attachment = wp_get_attachment_image_src( $chariton_logo2_img, 'full' );
                          $chariton_logo2_img    = ($attachment) ? $attachment[0] : $chariton_logo2_img;
                          if (!empty($chariton_logo2_img )) {
                            echo'<a href="'.esc_url(home_url('/')).'" class="navbar-brand-logo"><img alt="'.esc_attr__( 'Chariton logo', 'chariton' ).'" src="'.esc_url( $chariton_logo2_img ).'"></a>';
                          }
                        ?>
                      <?php endif; ?>
                    </div>
                  </div>
                  <?php 
                    if(function_exists( 'chariton_framework_init' ) ) {
                      $donate_btn_switch = chariton_get_option('donate_btn_switch');
                      if ( !empty( $donate_btn_switch ) ) {
                        $menu_col = '8';
                        $sc_col = '2';
                      } else {
                        $menu_col = '10';
                        $sc_col = '0';
                      }
                    } else { 
                      $menu_col = '10';
                      $sc_col = '0';
                      $donate_btn_switch = '';
                    }
                  ?>
                  <div class="col-xl-<?php echo esc_attr( $menu_col ); ?> col-lg-9">
                    <div class="menu-area text-right">
                      <div class="main-menu h4-main-menu">
                        <?php get_template_part( 'headers/menu' ); ?>
                      </div>
                    </div>
                  </div>
                  <?php if( function_exists( 'chariton_framework_init' ) ) : ?>
                    <div class="col-xl-2 d-none d-xl-block text-right">
                      <div class="new-header-btn">
                        <?php get_template_part( 'headers/donation' ); ?>
                      </div>
                    </div>
                  <?php endif; ?>
                  <div class="col-12">
                    <div class="mobile-menu"></div>
                  </div>
              </div>
          </div>
      </div>
  </div>
</header>
<!-- header-end -->

<!-- Modal box -->
<?php 
  if(function_exists( 'chariton_header_search_form' ) ) { 
    do_action( 'chariton_search_form_modal' );
  } if(function_exists( 'chariton_header_toggle_menu' ) ) {
    do_action( 'chariton_toggle_menu_modal' );
  }
?>