<?php 
/**  add action with call back function .
--------------------------------------------------------------------------------------------------- */
add_action('after_setup_theme', 'chariton_content_width', 0);
add_action('after_setup_theme', 'chariton_setup');

/*------------------------------------------------------------------------------------------------------------------*/
/*	chariton setup
/*------------------------------------------------------------------------------------------------------------------*/

if ( !function_exists('chariton_setup') ):
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
	function chariton_setup() {
		
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on widely, use a find and replace
		 * to change 'widely' to the name of your theme in all the template files
		 --------------------------------------------------------------------------------------------------- */
		load_theme_textdomain('chariton', get_template_directory() . '/languages');

		/*
		* Add default posts and comments RSS feed links to head.
		--------------------------------------------------------------------------------------------------- */
		add_theme_support('automatic-feed-links');

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		--------------------------------------------------------------------------------------------------- */
		add_theme_support( 'title-tag' );

		/* 
		 * Enable support for Post Thumbnails on posts and pages.
		 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
		--------------------------------------------------------------------------------------------------- */
		add_theme_support( 'post-thumbnails' );

		/** Gutenberg Support
		--------------------------------------------------------------------------------------------------- */
		add_theme_support( 'align-wide' );

		/** Add Custom Image Size.
		--------------------------------------------------------------------------------------------------- */
		add_image_size( 'chariton-770-460', 770, 460, TRUE );
		add_image_size( 'chariton-thumb-80-80', 80, 80, TRUE );
		add_image_size( 'chariton-portfolio-740-800', 740, 650, TRUE );
		add_image_size( 'chariton-event-400-400', 370, 350, TRUE );


		/** This theme uses wp_nav_menu() in one location..
		--------------------------------------------------------------------------------------------------- */
		register_nav_menus(array(
			'primary' => esc_html__('Primary Menu', 'chariton'),
		));

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		--------------------------------------------------------------------------------------------------- */
		add_theme_support('html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		));

		/*
		 * Enable support for Post Formats.
		 * See http://codex.wordpress.org/Post_Formats
		--------------------------------------------------------------------------------------------------- */
		add_theme_support('post-formats', array(
			'image',
			'video',
			'quote',
			'link',
		));

		/** Set up the WordPress core custom background feature.
		--------------------------------------------------------------------------------------------------- */
		add_theme_support('custom-background', apply_filters('chariton_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		)));

        // Add theme support for selective refresh for widgets.
        add_theme_support( 'customize-selective-refresh-widgets' );

        //Enable custom header
        add_theme_support( 'custom-header' );

		/* 
		 * enable custom logo support
		 * set up the WordPress custome Logo support
		--------------------------------------------------------------------------------------------------- */
		add_theme_support( 'custom-logo', array(
			'height'      => 65,
			'width'       => 245,
			'flex-height' => true,
			'header-text' => array( 'site-title', 'site-description' ),
		) );

        // Add support for Block Styles.
        add_theme_support( 'wp-block-styles' );

        // Add support for full and wide align images.
        add_theme_support( 'align-wide' );

        // Add support for editor styles.
        add_theme_support( 'editor-styles' );

        // Add support for responsive embedded content.
        add_theme_support( 'responsive-embeds' );

		/* Woocommerce Support
		--------------------------------------------------------------------------------------------------- */
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );
		
	}
endif; // chariton_setup


/*------------------------------------------------------------------------------------------------------------------*/
/*	sidebar register
/*------------------------------------------------------------------------------------------------------------------*/
/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 *
 *
**/

function chariton_widgets_init() {
	if( function_exists( 'chariton_framework_init' ) ) {
        $select_footer_columns = chariton_get_option('select_footer_columns');
        if (!empty($select_footer_columns)) {
        	$select_footer_columns = $select_footer_columns;
        } else {
        	$select_footer_columns = '3';
        }
    } else {
        $select_footer_columns = '3';
    }
	register_sidebar(array(
		'name' 			=> esc_html__('Sidebar Widgets', 'chariton'),
		'id' 			=> 'right-sidebar',
		'description' 	=> esc_html__('Widgets in this area will be shown on page Sidebar.', 'chariton'),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' 	=> '</div>',
		'before_title'  => '<div class="widget-title"><span></span><h4>',
		'after_title'   => '</h4></div>',
	));
	register_sidebar(array(
		'name' 			=> esc_html__('Footer One Widgets', 'chariton'),
		'id' 			=> 'footer-widgets1',
		'description' 	=> esc_html__('Widgets in this area will be shown on footer.', 'chariton'),
		'before_widget' => '<div id="%1$s" class="%2$s col-lg-'.esc_attr( $select_footer_columns ).' col-md-6"><div class="%2$s footer-widget mb-30">',
		'after_widget' 	=> '</div></div>',
		'before_title'  => '<div class="fw-title mb-20"><h3>',
		'after_title'   => '</h3></div>',
	));
	
	if( function_exists( 'chariton_framework_init' ) ) {
		register_sidebar(array(
			'name' 			=> esc_html__('Footer Two Widgets 01', 'chariton'),
			'id' 			=> 'footer2-widgets1',
			'description' 	=> esc_html__('Widgets in this area will be shown on footer.', 'chariton'),
			'before_widget' => '<div id="%1$s" class="%2$s"><div class="%2$s footer-widget mb-30">',
			'after_widget' 	=> '</div></div>',
			'before_title'  => '<div class="fw-title mb-20"><h3>',
			'after_title'   => '</h3></div>',
		));
		register_sidebar(array(
			'name' 			=> esc_html__('Footer Two Widgets 02', 'chariton'),
			'id' 			=> 'footer2-widgets2',
			'description' 	=> esc_html__('Widgets in this area will be shown on footer.', 'chariton'),
			'before_widget' => '<div id="%1$s" class="%2$s"><div class="%2$s footer-widget mb-30">',
			'after_widget' 	=> '</div></div>',
			'before_title'  => '<div class="fw-title mb-20"><h3>',
			'after_title'   => '</h3></div>',
		));
		register_sidebar(array(
			'name' 			=> esc_html__('Footer Two Widgets 03', 'chariton'),
			'id' 			=> 'footer2-widgets3',
			'description' 	=> esc_html__('Widgets in this area will be shown on footer.', 'chariton'),
			'before_widget' => '<div id="%1$s" class="%2$s"><div class="%2$s footer-widget mb-30">',
			'after_widget' 	=> '</div></div>',
			'before_title'  => '<div class="fw-title mb-20"><h3>',
			'after_title'   => '</h3></div>',
		));
		register_sidebar(array(
			'name' 			=> esc_html__('Footer Two Widgets 04', 'chariton'),
			'id' 			=> 'footer2-widgets4',
			'description' 	=> esc_html__('Widgets in this area will be shown on footer.', 'chariton'),
			'before_widget' => '<div id="%1$s" class="%2$s"><div class="%2$s footer-widget mb-30">',
			'after_widget' 	=> '</div></div>',
			'before_title'  => '<div class="fw-title mb-20"><h3>',
			'after_title'   => '</h3></div>',
		));
		register_sidebar(array(
			'name'      => esc_html__('Cause Details Page Widgets', 'chariton'),
			'id'      => 'cause-widgets',
			'description'   => '',
			'before_widget' => '<div id="%1$s" class="%2$s cause-widget">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="title">',
			'after_title'   => '</h4>',
		));
		register_sidebar(array(
			'name'      => esc_html__('Off Canvas Toggle Menu Widgets', 'chariton'),
			'id'      => 'offcanvas-sidebar',
			'description'   => '',
			'before_widget' => '<div id="%1$s" class="%2$s tm-widget">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="title">',
			'after_title'   => '</h4>',
		));
	}
	if ( class_exists( 'woocommerce' ) ) {
		register_sidebar(array(
			'name' 			=> esc_html__('Shop Sidebar', 'chariton'),
			'id' 			=> 'shop',
			'description' 	=> '',
			'before_widget' => '<div id="%1$s" class="sidebar-widget woo-siebar %2$s">',
			'after_widget' 	=> '</div>',
			'before_title'  => '<div class="widget-title"><span></span><h4>',
			'after_title'   => '</h4></div>',
		));
	}
}
add_action('widgets_init', 'chariton_widgets_init');

/*------------------------------------------------------------------------------------------------------------------*/
/*	  $content_width
/*------------------------------------------------------------------------------------------------------------------*/ 
  
/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function chariton_content_width() {
	$GLOBALS['content_width'] = apply_filters('chariton_content_width', 1170);
}