<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package chariton
 */

get_header(); 

do_action('chariton_breadcrum');

?>

<!-- Page-section - start
================================================== -->
<div class="primary-bg">
    <div class="inner-blog givewp-details pt-120">
        <div class="container">
            <div class="row">
                <?php 
                    if( function_exists( 'chariton_framework_init' ) ) {
                        if ( is_active_sidebar( 'give-forms-sidebar') ) {
                            $givewp_single_layout = chariton_get_option('givewp_single_layout');
                            if ( $givewp_single_layout == 'left-sidebar' ) {
                                $col   = '8';
                                $class = 'order-12';
                            } elseif ( $givewp_single_layout == 'right-sidebar' ) {
                                $col   = '8';
                                $class = '';
                             } elseif ( $givewp_single_layout == 'full-width' ) {
                                $class = '';
                                $col   = '12';
                            } else {
                                $class = '';
                                $col   = '8';
                            }
                        } else {
                            $col   = '10 mx-auto';
                            $class = '';
                        }
                        $givewp_single_layout = chariton_get_option('givewp_single_layout');
                        if ( $givewp_single_layout == 'left-sidebar' ) {
                            $sidebar_class = 'sidebar-left';
                        } elseif ( $givewp_single_layout == 'right-sidebar' ) {
                            $sidebar_class = 'sidebar-right';
                         } elseif ( $givewp_single_layout == 'full-width' ) {
                            $sidebar_class = 'sidebar-default';
                        } else {
                            $sidebar_class = 'sidebar-default';
                        }
                    } else {
                        $col   = '12';
                        $class = '';
                    }
                ?>
                <div class="col-lg-<?php echo esc_attr( $col . ' ' . $class ); ?>">
                    <div class="page-details-content mb-10">
                        <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

                        <?php give_get_template_part( 'single-give-form/content', 'single-give-form' ); ?>
                            
                        <?php endwhile; ?>

                        <?php else : ?>

                            <?php get_template_part( 'template-parts/content', 'none' ); ?>

                        <?php endif; ?>
                    </div>
                </div>
                <!-- Start Blog Sidebar -->
                <?php 
                    if( function_exists( 'chariton_framework_init' ) ) {
                        if ( is_active_sidebar( 'give-forms-sidebar') ) {
                            $givewp_single_layout = chariton_get_option('givewp_single_layout');
                            if ( $givewp_single_layout == 'left-sidebar' ||  $givewp_single_layout == 'right-sidebar' ) { ?>
                                <div class="col-lg-4">
                                    <aside class="blog-sidebar givewp <?php echo esc_attr( $sidebar_class );?>">
                                        <?php dynamic_sidebar( 'give-forms-sidebar' ); ?>
                                    </aside>
                                </div>
                            <?php } elseif ($givewp_single_layout == 'full-width') {
                                
                            } else { ?>
                                <div class="col-lg-4">
                                    <aside class="blog-sidebar givewp <?php echo esc_attr( $sidebar_class );?>">
                                        <?php dynamic_sidebar( 'give-forms-sidebar' ); ?>
                                    </aside>
                                </div>
                           <?php }
                        }
                    }
                ?>
           </div><!-- row -->
        </div><!-- container -->
    </div>
</div>

<!-- page-section - End
================================================== -->
<?php get_footer(); ?>