<?php
/**
 * The template for displaying all single posts.
 *
 * @package chariton
 */

get_header(); 

do_action( 'chariton_breadcrum' );

?>

<div class="primary-bg">
    <!-- blog-area -->
    <div class="inner-blog pt-120 pb-90">
        <div class="container">
            <div class="row">
                <?php 
                    if( function_exists( 'chariton_framework_init' ) ) {
                        if ( is_active_sidebar( 'right-sidebar') ) {
                            $blog_single_layout = chariton_get_option('blog_single_layout');
                            if ( $blog_single_layout == 'left-sidebar' ) {
                                $col   = '8';
                                $class = 'order-12';
                            } elseif ( $blog_single_layout == 'right-sidebar' ) {
                                $col   = '8';
                                $class = '';
                             } elseif ( $blog_single_layout == 'full-width' ) {
                                $class = '';
                                $col   = '10 mx-auto';
                            } else {
                                $class = '';
                                $col   = '8';
                            }
                        } else {
                            $col   = '8';
                            $class = '';
                        }
                    } else {
                        $col   = '10 mx-auto';
                        $class = '';
                    }
                ?>
                <div class="col-lg-<?php echo esc_attr( $col . ' blog-post-content ' . $class ); ?> mb-30">
                    <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

                    <?php get_template_part( 'template-parts/content', 'single' ); ?>
                            
                    <?php endwhile; ?>

                    <?php else : ?>

                        <?php get_template_part( 'template-parts/content', 'none' ); ?>

                    <?php endif; ?>
                </div>
                <?php 
                    if( function_exists( 'chariton_framework_init' ) ) {
                        if ( is_active_sidebar( 'right-sidebar') ) {
                            $blog_single_layout = chariton_get_option('blog_single_layout');
                            if ( $blog_single_layout == 'left-sidebar' ||  $blog_single_layout == 'right-sidebar' ) {
                                get_sidebar();
                            } elseif ($blog_single_layout == 'full-width') {
                                
                            } else {
                                get_sidebar();
                            }
                        }
                    }
                ?>
            </div>
        </div>
    </div>
</div>

<!-- blog-grid-end -->
<?php get_footer(); ?>