<?php
/**
 * The Template for displaying content single event.
 *
 * Override this template by copying it to chariton/wp-events-manager/content-single-event.php
 *
 * @author        Johanspond
 * @package       WP-Events-Manager/Template
 * @version       2.1.7
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

do_action( 'chariton_breadcrum' );
if( function_exists( 'chariton_framework_init' ) ) {
  $feature_img            = chariton_get_option('event_details_feature_img_switch');
  $event_details_text     = chariton_get_option('event_details_text');
  $organizer_details_text = chariton_get_option('organizer_details_text');
} else {
  $feature_img            = '';
  $event_details_text     = '';
  $organizer_details_text = '';
}
?>

<article id="tp_event-<?php the_ID(); ?>" <?php post_class( 'events-details-area pt-120 pb-120' ); ?>>

    <div class="container">
        <?php
        /**
         * tp_event_before_single_event hook
         *
         */
        do_action( 'tp_event_before_single_event' );
        ?>

        <div class="row">
            <div class="col-lg-12">
                <div class="events-wrap">
                    <div class="single-event-item mb-10">
                        <?php if (!empty($feature_img)) { ?>
                            <?php if( has_post_thumbnail() ) : ?>
                                <div class="single-event-thumb">
                                   <?php the_post_thumbnail(); ?>
                                </div>
                            <?php endif; ?>
                        <?php } ?>

                        <div class="event-post-tag mb-10">
                            <ul>
                                <?php
                                $date_start = get_post_meta( get_the_ID(), 'tp_event_date_start', true ) ? strtotime( get_post_meta( get_the_ID(), 'tp_event_date_start', true ) ) : time();
                                $date_end   = get_post_meta( get_the_ID(), 'tp_event_date_end', true ) ? strtotime( get_post_meta( get_the_ID(), 'tp_event_date_end', true ) ) : time();
                                $time_start = wpems_event_start( get_option( 'time_format' ) );
                                $time_end   = wpems_event_end( get_option( 'time_format' ) );

                                $date_string = '';
                                if ( $date_start === $date_end ) {
                                    $date_string = date_i18n( get_option( 'date_format' ), $date_start );
                                } else {
                                    $date_string = date_i18n( get_option( 'date_format' ), $date_start ) . ' - ' . date_i18n( get_option( 'date_format' ), $date_end );
                                }

                                $date_status =  get_post_meta( get_the_ID(), 'tp_event_status', true );

                                $terms = wp_get_post_terms( $post->ID, 'tp_event_category');
                                if ( !empty( $terms ) ) {
                                    foreach ($terms as $term) {
                                        echo '<li class="event-cat-list"><a href="'.get_term_link($term->slug, 'tp_event_category').'">'.$term->name.'</a></li>';
                                    }
                                }
                                ?>
                                <li><?php echo esc_html( $date_string ); ?></li>
                                <li><?php echo esc_html( $time_start . ' - ' . $time_end ); ?></li>
                                <?php if ( $date_status == 'expired' ){ ?> 
                                    <li class="event-expired"><?php echo esc_html( $date_status ); ?></li>
                                <?php }else{ ?> 
                                    <li class="event-live-status"><?php echo esc_html( $date_status ); ?></li>
                                <?php } ?>
                            </ul>
                        </div>
                    <?php
                    /**
                     * tp_event_loop_event_location hook
                     */
                    do_action( 'tp_event_loop_event_location' );
                    ?>
                    <?php the_content(); ?>
                    <?php if( function_exists('acf_add_local_field_group') ): ?>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="event-meta event-details-meta">
                                    <div class="details-meta-title mb-10">
                                        <h3><?php echo esc_html( $event_details_text, 'chariton' ); ?></h3>
                                    </div>
                                    <ul>
                                        <li><?php echo esc_html('Speaker:'); ?><span><?php echo esc_html( get_field( 'event_speaker' ) ); ?></span></li>
                                        <li><?php echo esc_html('Date:'); ?><span><?php echo esc_html( $date_string ); ?></span></li>
                                        <li><?php echo esc_html('Venue:'); ?><span><?php echo esc_html( get_field( 'event_location' ) ); ?></span></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="event-meta event-details-meta">
                                    <div class="details-meta-title mb-10">
                                        <h3><?php echo esc_html( $organizer_details_text, 'chariton' ); ?></h3>
                                    </div>
                                    <ul>
                                        <li><?php echo esc_html('Name:'); ?><span><?php echo esc_html( get_field( 'event_organizername' ) ); ?></span></li>
                                        <li><?php echo esc_html('Phone:'); ?><span><?php echo esc_html( get_field( 'event_phone' ) ); ?></span></li>
                                        <li><?php echo esc_html('Email:'); ?><span><?php echo esc_html( get_field( 'event_organizeremail' ) ); ?></span></li>
                                        <li><?php echo esc_html('Website:'); ?><span><?php echo esc_html( get_field( 'event_website' ) ); ?></span></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                        <div class="events-details-info">
                            <?php
                            /**
                             * tp_event_after_single_event hook
                             *
                             * @hooked tp_event_after_single_event - 10
                             */
                            do_action( 'tp_event_after_single_event' );
                            ?>
                        </div>

                    </div>
                </div>
            </div>
            
        </div>
    </div>

</article><!-- #product-<?php the_ID(); ?> -->