<?php
/* This loads the plugin.php file which is the main one */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
require( __DIR__ . '/helper/elements-helper.php' ); 

/**
 * Load Hello World
 *
 * Load the plugin after Elementor (and other plugins) are loaded.
 *
 * @since 1.0.0
 */
function chariton_load_elements() {
	// Load localization file
	load_plugin_textdomain( 'chariton' );

	// Notice if the Elementor is not active
	if ( ! did_action( 'elementor/loaded' ) ) {
		return;
	}

	// Check version required
	$elementor_version_required = '1.0.0';
	if ( ! version_compare( ELEMENTOR_VERSION, $elementor_version_required, '>=' ) ) {
		return;
	}

	// Require the main plugin file
	require( __DIR__ . '/plugin.php' );   //loading the main plugin
}
add_action( 'plugins_loaded', 'chariton_load_elements' );   //notiung but checking and notice