<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * A Font Icon select box.
 *
 * @property array $icons   A list of font-icon classes. [ 'class-name' => 'nicename', ... ]
 *                          Default Font Awesome icons. @see Control_Icon::get_icons().
 * @property array $include list of classes to include form the $icons property
 * @property array $exclude list of classes to exclude form the $icons property
 *
 * @since 1.0.0
 */
class Johanspond_Icon_Controler extends Elementor\Base_Data_Control {

	public function get_type() {
		return 'icon';
	}

	/**
	 * Get icons list
	 *
	 * @return array
	*/

	public static function get_icons() {

		$icons = array(
            'ifs-icon fab fa-buromobelexperte' => 'buromobelexperte',
            'ifs-icon flaticon-supermarket' => 'Flaticon Supermarket',
            'ifs-icon flaticon-powerpoint' => 'Flaticon Powerpoint',
            'ifs-icon flaticon-sketch' => 'Flaticon Sketch',
            'ifs-icon flaticon-team' => 'Flaticon Team',
            'ifs-icon flaticon-smile' => 'Flaticon Smile',
            'ifs-icon flaticon-shirt' => 'Flaticon Shirt',
            'ifs-icon flaticon-event' => 'Flaticon Event',
            'ifs-icon flaticon-wage' => 'Flaticon Wage',
            'ifs-icon flaticon-idea' => 'Flaticon Idea',
            'ifs-icon flaticon-chair' => 'Flaticon Chair',
            'ifs-icon flaticon-support' => 'Flaticon Support',
            'ifs-icon flaticon-analytics' => 'Flaticon Analytics',
            'ifs-icon flaticon-company' => 'Flaticon Company',
            'ifs-icon flaticon-industry' => 'Flaticon Industry',
            'ifs-icon flaticon-success' => 'Flaticon Success',
            'ifs-icon flaticon-rocket' => 'Flaticon Rocket',
            'ifs-icon flaticon-plane' => 'Flaticon Plane',
			'ifs-icon fas fa-burn' => 'burn',
			'ifs-icon far fa-burn' => 'burn',
			'ifs-icon fal fa-burn' => 'burn',
			'ifs-icon fas fa-bullseye' => 'bullseye',
			'ifs-icon far fa-bullseye' => 'bullseye',
			'ifs-icon fal fa-bullseye' => 'bullseye',
			'ifs-icon fas fa-bullhorn' => 'bullhorn',
			'ifs-icon far fa-bullhorn' => 'bullhorn',
			'ifs-icon fal fa-bullhorn' => 'bullhorn',
			'ifs-icon fas fa-building' => 'building',
			'ifs-icon far fa-building' => 'building',
			'ifs-icon fal fa-building' => 'building',
			'ifs-icon fas fa-bug' => 'bug',
			'ifs-icon far fa-bug' => 'bug',
			'ifs-icon fal fa-bug' => 'bug',
			'ifs-icon fab fa-btc' => 'btc',
			'ifs-icon fas fa-browser' => 'browser',
			'ifs-icon far fa-browser' => 'browser',
			'ifs-icon fal fa-browser' => 'browser',
			'ifs-icon fas fa-briefcase-medical' => 'briefcase-medical',
			'ifs-icon far fa-briefcase-medical' => 'briefcase-medical',
			'ifs-icon fal fa-briefcase-medical' => 'briefcase-medical',
			'ifs-icon fas fa-briefcase' => 'briefcase',
			'ifs-icon far fa-briefcase' => 'briefcase',
			'ifs-icon fal fa-briefcase' => 'briefcase',
			'ifs-icon fas fa-braille' => 'braille',
			'ifs-icon far fa-braille' => 'braille',
			'ifs-icon fal fa-braille' => 'braille',
			'ifs-icon fas fa-boxing-glove' => 'boxing-glove',
			'ifs-icon far fa-boxing-glove' => 'boxing-glove',
			'ifs-icon fal fa-boxing-glove' => 'boxing-glove',
			'ifs-icon fas fa-boxes-alt' => 'boxes-alt',
			'ifs-icon far fa-boxes-alt' => 'boxes-alt',
			'ifs-icon fal fa-boxes-alt' => 'boxes-alt',
			'ifs-icon fas fa-boxes' => 'boxes',
			'ifs-icon far fa-boxes' => 'boxes',
			'ifs-icon fal fa-boxes' => 'boxes',
			'ifs-icon fas fa-box-usd' => 'box-usd',
			'ifs-icon far fa-box-usd' => 'box-usd',
			'ifs-icon fal fa-box-usd' => 'box-usd',
			'ifs-icon fas fa-box-up' => 'box-up',
			'ifs-icon far fa-box-up' => 'box-up',
			'ifs-icon fal fa-box-up' => 'box-up',
			'ifs-icon fas fa-box-open' => 'box-open',
			'ifs-icon far fa-box-open' => 'box-open',
			'ifs-icon fal fa-box-open' => 'box-open',
			'ifs-icon fas fa-box-heart' => 'box-heart',
			'ifs-icon far fa-box-heart' => 'box-heart',
			'ifs-icon fal fa-box-heart' => 'box-heart',
			'ifs-icon fas fa-box-full' => 'box-full',
			'ifs-icon far fa-box-full' => 'box-full',
			'ifs-icon fal fa-box-full' => 'box-full',
			'ifs-icon fas fa-box-fragile' => 'box-fragile',
			'ifs-icon far fa-box-fragile' => 'box-fragile',
			'ifs-icon fal fa-box-fragile' => 'box-fragile',
			'ifs-icon fas fa-box-check' => 'box-check',
			'ifs-icon far fa-box-check' => 'box-check',
			'ifs-icon fal fa-box-check' => 'box-check',
			'ifs-icon fas fa-box-alt' => 'box-alt',
			'ifs-icon far fa-box-alt' => 'box-alt',
			'ifs-icon fal fa-box-alt' => 'box-alt',
			'ifs-icon fas fa-box' => 'box',
			'ifs-icon far fa-box' => 'box',
			'ifs-icon fal fa-box' => 'box',
			'ifs-icon fas fa-bowling-pins' => 'bowling-pins',
			'ifs-icon far fa-bowling-pins' => 'bowling-pins',
			'ifs-icon fal fa-bowling-pins' => 'bowling-pins',
			'ifs-icon fas fa-bowling-ball' => 'bowling-ball',
			'ifs-icon far fa-bowling-ball' => 'bowling-ball',
			'ifs-icon fal fa-bowling-ball' => 'bowling-ball',
			'ifs-icon fas fa-bookmark' => 'bookmark',
			'ifs-icon far fa-bookmark' => 'bookmark',
			'ifs-icon fal fa-bookmark' => 'bookmark',
			'ifs-icon fas fa-book-heart' => 'book-heart',
			'ifs-icon far fa-book-heart' => 'book-heart',
			'ifs-icon fal fa-book-heart' => 'book-heart',
			'ifs-icon fas fa-book' => 'book',
			'ifs-icon far fa-book' => 'book',
			'ifs-icon fal fa-book' => 'book',
			'ifs-icon fas fa-bomb' => 'bomb',
			'ifs-icon far fa-bomb' => 'bomb',
			'ifs-icon fal fa-bomb' => 'bomb',
			'ifs-icon fas fa-bolt' => 'bolt',
			'ifs-icon far fa-bolt' => 'bolt',
			'ifs-icon fal fa-bolt' => 'bolt',
			'ifs-icon fas fa-bold' => 'bold',
			'ifs-icon far fa-bold' => 'bold',
			'ifs-icon fal fa-bold' => 'bold',
			'ifs-icon fab fa-bluetooth-b' => 'bluetooth-b',
			'ifs-icon fab fa-bluetooth' => 'bluetooth',
			'ifs-icon fab fa-blogger-b' => 'blogger-b',
			'ifs-icon fab fa-blogger' => 'blogger',
			'ifs-icon fas fa-blind' => 'blind',
			'ifs-icon far fa-blind' => 'blind',
			'ifs-icon fal fa-blind' => 'blind',
			'ifs-icon fas fa-blanket' => 'blanket',
			'ifs-icon far fa-blanket' => 'blanket',
			'ifs-icon fal fa-blanket' => 'blanket',
			'ifs-icon fab fa-blackberry' => 'blackberry',
			'ifs-icon fab fa-black-tie' => 'black-tie',
			'ifs-icon fab fa-bity' => 'bity',
			'ifs-icon fab fa-bitcoin' => 'bitcoin',
			'ifs-icon fab fa-bitbucket' => 'bitbucket',
			'ifs-icon fas fa-birthday-cake' => 'birthday-cake',
			'ifs-icon far fa-birthday-cake' => 'birthday-cake',
			'ifs-icon fal fa-birthday-cake' => 'birthday-cake',
			'ifs-icon fas fa-binoculars' => 'binoculars',
			'ifs-icon far fa-binoculars' => 'binoculars',
			'ifs-icon fal fa-binoculars' => 'binoculars',
			'ifs-icon fab fa-bimobject' => 'bimobject',
			'ifs-icon fas fa-bicycle' => 'bicycle',
			'ifs-icon far fa-bicycle' => 'bicycle',
			'ifs-icon fal fa-bicycle' => 'bicycle',
			'ifs-icon fas fa-bell-slash' => 'bell-slash',
			'ifs-icon far fa-bell-slash' => 'bell-slash',
			'ifs-icon fal fa-bell-slash' => 'bell-slash',
			'ifs-icon fas fa-bell' => 'bell',
			'ifs-icon far fa-bell' => 'bell',
			'ifs-icon fal fa-bell' => 'bell',
			'ifs-icon fab fa-behance-square' => 'behance-square',
			'ifs-icon fab fa-behance' => 'behance',
			'ifs-icon fas fa-beer' => 'beer',
			'ifs-icon far fa-beer' => 'beer',
			'ifs-icon fal fa-beer' => 'beer',
			'ifs-icon fas fa-bed' => 'bed',
			'ifs-icon far fa-bed' => 'bed',
			'ifs-icon fal fa-bed' => 'bed',
			'ifs-icon fas fa-battery-three-quarters' => 'battery-three-quarters',
			'ifs-icon far fa-battery-three-quarters' => 'battery-three-quarters',
			'ifs-icon fal fa-battery-three-quarters' => 'battery-three-quarters',
			'ifs-icon fas fa-battery-slash' => 'battery-slash',
			'ifs-icon far fa-battery-slash' => 'battery-slash',
			'ifs-icon fal fa-battery-slash' => 'battery-slash',
			'ifs-icon fas fa-battery-quarter' => 'battery-quarter',
			'ifs-icon far fa-battery-quarter' => 'battery-quarter',
			'ifs-icon fal fa-battery-quarter' => 'battery-quarter',
			'ifs-icon fas fa-battery-half' => 'battery-half',
			'ifs-icon far fa-battery-half' => 'battery-half',
			'ifs-icon fal fa-battery-half' => 'battery-half',
			'ifs-icon fas fa-battery-full' => 'battery-full',
			'ifs-icon far fa-battery-full' => 'battery-full',
			'ifs-icon fal fa-battery-full' => 'battery-full',
			'ifs-icon fas fa-battery-empty' => 'battery-empty',
			'ifs-icon far fa-battery-empty' => 'battery-empty',
			'ifs-icon fal fa-battery-empty' => 'battery-empty',
			'ifs-icon fas fa-battery-bolt' => 'battery-bolt',
			'ifs-icon far fa-battery-bolt' => 'battery-bolt',
			'ifs-icon fal fa-battery-bolt' => 'battery-bolt',
			'ifs-icon fas fa-bath' => 'bath',
			'ifs-icon far fa-bath' => 'bath',
			'ifs-icon fal fa-bath' => 'bath',
			'ifs-icon fas fa-basketball-hoop' => 'basketball-hoop',
			'ifs-icon far fa-basketball-hoop' => 'basketball-hoop',
			'ifs-icon fal fa-basketball-hoop' => 'basketball-hoop',
			'ifs-icon fas fa-basketball-ball' => 'basketball-ball',
			'ifs-icon far fa-basketball-ball' => 'basketball-ball',
			'ifs-icon fal fa-basketball-ball' => 'basketball-ball',
			'ifs-icon fas fa-baseball-ball' => 'baseball-ball',
			'ifs-icon far fa-baseball-ball' => 'baseball-ball',
			'ifs-icon fal fa-baseball-ball' => 'baseball-ball',
			'ifs-icon fas fa-baseball' => 'baseball',
			'ifs-icon far fa-baseball' => 'baseball',
			'ifs-icon fal fa-baseball' => 'baseball',
			'ifs-icon fas fa-bars' => 'bars',
			'ifs-icon far fa-bars' => 'bars',
			'ifs-icon fal fa-bars' => 'bars',
			'ifs-icon fas fa-barcode-scan' => 'barcode-scan',
			'ifs-icon far fa-barcode-scan' => 'barcode-scan',
			'ifs-icon fal fa-barcode-scan' => 'barcode-scan',
			'ifs-icon fas fa-barcode-read' => 'barcode-read',
			'ifs-icon far fa-barcode-read' => 'barcode-read',
			'ifs-icon fal fa-barcode-read' => 'barcode-read',
			'ifs-icon fas fa-barcode-alt' => 'barcode-alt',
			'ifs-icon far fa-barcode-alt' => 'barcode-alt',
			'ifs-icon fal fa-barcode-alt' => 'barcode-alt',
			'ifs-icon fas fa-barcode' => 'barcode',
			'ifs-icon far fa-barcode' => 'barcode',
			'ifs-icon fal fa-barcode' => 'barcode',
			'ifs-icon fab fa-bandcamp' => 'bandcamp',
			'ifs-icon fas fa-band-aid' => 'band-aid',
			'ifs-icon far fa-band-aid' => 'band-aid',
			'ifs-icon fal fa-band-aid' => 'band-aid',
			'ifs-icon fas fa-ban' => 'ban',
			'ifs-icon far fa-ban' => 'ban',
			'ifs-icon fal fa-ban' => 'ban',
			'ifs-icon fas fa-balance-scale' => 'balance-scale',
			'ifs-icon far fa-balance-scale' => 'balance-scale',
			'ifs-icon fal fa-balance-scale' => 'balance-scale',
			'ifs-icon fas fa-badge-check' => 'badge-check',
			'ifs-icon far fa-badge-check' => 'badge-check',
			'ifs-icon fal fa-badge-check' => 'badge-check',
			'ifs-icon fas fa-badge' => 'badge',
			'ifs-icon far fa-badge' => 'badge',
			'ifs-icon fal fa-badge' => 'badge',
			'ifs-icon fas fa-backward' => 'backward',
			'ifs-icon far fa-backward' => 'backward',
			'ifs-icon fal fa-backward' => 'backward',
			'ifs-icon fas fa-user-slash' => 'user-slash',
			'ifs-icon far fa-user-slash' => 'user-slash',
			'ifs-icon fal fa-user-slash' => 'user-slash',
			'ifs-icon fas fa-user-shield' => 'user-shield',
			'ifs-icon far fa-user-shield' => 'user-shield',
			'ifs-icon fal fa-user-shield' => 'user-shield',
			'ifs-icon fas fa-user-secret' => 'user-secret',
			'ifs-icon far fa-user-secret' => 'user-secret',
			'ifs-icon fal fa-user-secret' => 'user-secret',
			'ifs-icon fas fa-user-plus' => 'user-plus',
			'ifs-icon far fa-user-plus' => 'user-plus',
			'ifs-icon fal fa-user-plus' => 'user-plus',
			'ifs-icon fas fa-user-ninja' => 'user-ninja',
			'ifs-icon far fa-user-ninja' => 'user-ninja',
			'ifs-icon fal fa-user-ninja' => 'user-ninja',
			'ifs-icon fas fa-user-minus' => 'user-minus',
			'ifs-icon far fa-user-minus' => 'user-minus',
			'ifs-icon fal fa-user-minus' => 'user-minus',
			'ifs-icon fas fa-user-md' => 'user-md',
			'ifs-icon far fa-user-md' => 'user-md',
			'ifs-icon fal fa-user-md' => 'user-md',
			'ifs-icon fas fa-user-lock' => 'user-lock',
			'ifs-icon far fa-user-lock' => 'user-lock',
			'ifs-icon fal fa-user-lock' => 'user-lock',
			'ifs-icon fas fa-user-graduate' => 'user-graduate',
			'ifs-icon far fa-user-graduate' => 'user-graduate',
			'ifs-icon fal fa-user-graduate' => 'user-graduate',
			'ifs-icon fas fa-user-friends' => 'user-friends',
			'ifs-icon far fa-user-friends' => 'user-friends',
			'ifs-icon fal fa-user-friends' => 'user-friends',
			'ifs-icon fas fa-user-edit' => 'user-edit',
			'ifs-icon far fa-user-edit' => 'user-edit',
			'ifs-icon fal fa-user-edit' => 'user-edit',
			'ifs-icon fas fa-user-cog' => 'user-cog',
			'ifs-icon far fa-user-cog' => 'user-cog',
			'ifs-icon fal fa-user-cog' => 'user-cog',
			'ifs-icon fas fa-user-clock' => 'user-clock',
			'ifs-icon far fa-user-clock' => 'user-clock',
			'ifs-icon fal fa-user-clock' => 'user-clock',
			'ifs-icon fas fa-user-circle' => 'user-circle',
			'ifs-icon far fa-user-circle' => 'user-circle',
			'ifs-icon fal fa-user-circle' => 'user-circle',
			'ifs-icon fas fa-user-check' => 'user-check',
			'ifs-icon far fa-user-check' => 'user-check',
			'ifs-icon fal fa-user-check' => 'user-check',
			'ifs-icon fas fa-user-astronaut' => 'user-astronaut',
			'ifs-icon far fa-user-astronaut' => 'user-astronaut',
			'ifs-icon fal fa-user-astronaut' => 'user-astronaut',
			'ifs-icon fas fa-user-alt-slash' => 'user-alt-slash',
			'ifs-icon far fa-user-alt-slash' => 'user-alt-slash',
			'ifs-icon fal fa-user-alt-slash' => 'user-alt-slash',
			'ifs-icon fas fa-user-alt' => 'user-alt',
			'ifs-icon far fa-user-alt' => 'user-alt',
			'ifs-icon fal fa-user-alt' => 'user-alt',
			'ifs-icon fas fa-user' => 'user',
			'ifs-icon far fa-user' => 'user',
			'ifs-icon fal fa-user' => 'user',
			'ifs-icon fas fa-users' => 'users',
			'ifs-icon far fa-users' => 'users',
			'ifs-icon fal fa-users' => 'users',
			'ifs-icon fas fa-usd-square' => 'usd-square',
			'ifs-icon far fa-usd-square' => 'usd-square',
			'ifs-icon fal fa-usd-square' => 'usd-square',
			'ifs-icon fas fa-usd-circle' => 'usd-circle',
			'ifs-icon far fa-usd-circle' => 'usd-circle',
			'ifs-icon fal fa-usd-circle' => 'usd-circle',
			'ifs-icon fab fa-usb' => 'usb',
			'ifs-icon fas fa-upload' => 'upload',
			'ifs-icon far fa-upload' => 'upload',
			'ifs-icon fal fa-upload' => 'upload',
			'ifs-icon fab fa-untappd' => 'untappd',
			'ifs-icon fas fa-unlock-alt' => 'unlock-alt',
			'ifs-icon far fa-unlock-alt' => 'unlock-alt',
			'ifs-icon fal fa-unlock-alt' => 'unlock-alt',
			'ifs-icon fas fa-unlock' => 'unlock',
			'ifs-icon far fa-unlock' => 'unlock',
			'ifs-icon fal fa-unlock' => 'unlock',
			'ifs-icon fas fa-unlink' => 'unlink',
			'ifs-icon far fa-unlink' => 'unlink',
			'ifs-icon fal fa-unlink' => 'unlink',
			'ifs-icon fas fa-university' => 'university',
			'ifs-icon far fa-university' => 'university',
			'ifs-icon fal fa-university' => 'university',
			'ifs-icon fas fa-universal-access' => 'universal-access',
			'ifs-icon far fa-universal-access' => 'universal-access',
			'ifs-icon fal fa-universal-access' => 'universal-access',
			'ifs-icon fab fa-uniregistry' => 'uniregistry',
			'ifs-icon fas fa-undo-alt' => 'undo-alt',
			'ifs-icon far fa-undo-alt' => 'undo-alt',
			'ifs-icon fal fa-undo-alt' => 'undo-alt',
			'ifs-icon fas fa-undo' => 'undo',
			'ifs-icon far fa-undo' => 'undo',
			'ifs-icon fal fa-undo' => 'undo',
			'ifs-icon fas fa-underline' => 'underline',
			'ifs-icon far fa-underline' => 'underline',
			'ifs-icon fal fa-underline' => 'underline',
			'ifs-icon fas fa-umbrella' => 'umbrella',
			'ifs-icon far fa-umbrella' => 'umbrella',
			'ifs-icon fal fa-umbrella' => 'umbrella',
			'ifs-icon fab fa-uikit' => 'uikit',
			'ifs-icon fab fa-uber' => 'uber',
			'ifs-icon fab fa-typo3' => 'typo3',
			'ifs-icon fab fa-twitter-square' => 'twitter-square',
			'ifs-icon fab fa-twitter' => 'twitter',
			'ifs-icon fab fa-twitch' => 'twitch',
			'ifs-icon fas fa-tv-retro' => 'tv-retro',
			'ifs-icon far fa-tv-retro' => 'tv-retro',
			'ifs-icon fal fa-tv-retro' => 'tv-retro',
			'ifs-icon fas fa-tv' => 'tv',
			'ifs-icon far fa-tv' => 'tv',
			'ifs-icon fal fa-tv' => 'tv',
			'ifs-icon fab fa-tumblr-square' => 'tumblr-square',
			'ifs-icon fab fa-tumblr' => 'tumblr',
			'ifs-icon fas fa-truck-ramp' => 'truck-ramp',
			'ifs-icon far fa-truck-ramp' => 'truck-ramp',
			'ifs-icon fal fa-truck-ramp' => 'truck-ramp',
			'ifs-icon fas fa-truck-moving' => 'truck-moving',
			'ifs-icon far fa-truck-moving' => 'truck-moving',
			'ifs-icon fal fa-truck-moving' => 'truck-moving',
			'ifs-icon fas fa-truck-loading' => 'truck-loading',
			'ifs-icon far fa-truck-loading' => 'truck-loading',
			'ifs-icon fal fa-truck-loading' => 'truck-loading',
			'ifs-icon fas fa-truck-couch' => 'truck-couch',
			'ifs-icon far fa-truck-couch' => 'truck-couch',
			'ifs-icon fal fa-truck-couch' => 'truck-couch',
			'ifs-icon fas fa-truck-container' => 'truck-container',
			'ifs-icon far fa-truck-container' => 'truck-container',
			'ifs-icon fal fa-truck-container' => 'truck-container',
			'ifs-icon fas fa-truck' => 'truck',
			'ifs-icon far fa-truck' => 'truck',
			'ifs-icon fal fa-truck' => 'truck',
			'ifs-icon fas fa-trophy-alt' => 'trophy-alt',
			'ifs-icon far fa-trophy-alt' => 'trophy-alt',
			'ifs-icon fal fa-trophy-alt' => 'trophy-alt',
			'ifs-icon fas fa-trophy' => 'trophy',
			'ifs-icon far fa-trophy' => 'trophy',
			'ifs-icon fal fa-trophy' => 'trophy',
			'ifs-icon fab fa-tripadvisor' => 'trophy',
			'ifs-icon fas fa-triangle' => 'trophy',
			'ifs-icon far fa-triangle' => 'trophy',
			'ifs-icon fal fa-triangle' => 'trophy',
			'ifs-icon fab fa-trello' => 'trophy',
			'ifs-icon fas fa-tree-alt' => 'tree-alt',
			'ifs-icon far fa-tree-alt' => 'tree-alt',
			'ifs-icon fal fa-tree-alt' => 'tree-alt',
			'ifs-icon fas fa-tree' => 'tree',
			'ifs-icon far fa-tree' => 'tree',
			'ifs-icon fal fa-tree' => 'tree',
			'ifs-icon fas fa-trash-alt' => 'trash-alt',
			'ifs-icon far fa-trash-alt' => 'trash-alt',
			'ifs-icon fal fa-trash-alt' => 'trash-alt',
			'ifs-icon fas fa-trash' => 'trash',
			'ifs-icon far fa-trash' => 'trash',
			'ifs-icon fal fa-trash' => 'trash',
			'ifs-icon fas fa-transgender-alt' => 'transgender-alt',
			'ifs-icon far fa-transgender-alt' => 'transgender-alt',
			'ifs-icon fal fa-transgender-alt' => 'transgender-alt',
			'ifs-icon fas fa-transgender' => 'transgender',
			'ifs-icon far fa-transgender' => 'transgender',
			'ifs-icon fal fa-transgender' => 'transgender',
			'ifs-icon fas fa-train' => 'train',
			'ifs-icon far fa-train' => 'train',
			'ifs-icon fal fa-train' => 'train',
			'ifs-icon fas fa-trademark' => 'trademark',
			'ifs-icon far fa-trademark' => 'trademark',
			'ifs-icon fal fa-trademark' => 'trademark',
			'ifs-icon fab fa-trade-federation' => 'trade-federation',
			'ifs-icon fas fa-toggle-on' => 'toggle-on',
			'ifs-icon far fa-toggle-on' => 'toggle-on',
			'ifs-icon fal fa-toggle-on' => 'toggle-on',
			'ifs-icon fas fa-toggle-off' => 'toggle-off',
			'ifs-icon far fa-toggle-off' => 'toggle-off',
			'ifs-icon fal fa-toggle-off' => 'toggle-off',
			'ifs-icon fas fa-tint' => 'tint',
			'ifs-icon far fa-tint' => 'tint',
			'ifs-icon fal fa-tint' => 'tint',
			'ifs-icon fas fa-times-square' => 'times-square',
			'ifs-icon far fa-times-square' => 'times-square',
			'ifs-icon fal fa-times-square' => 'times-square',
			'ifs-icon fas fa-times-octagon' => 'times-octagon',
			'ifs-icon far fa-times-octagon' => 'times-octagon',
			'ifs-icon fal fa-times-octagon' => 'times-octagon',
			'ifs-icon fas fa-times-hexagon' => 'times-hexagon',
			'ifs-icon far fa-times-hexagon' => 'times-hexagon',
			'ifs-icon fal fa-times-hexagon' => 'times-hexagon',
			'ifs-icon fas fa-times-circle' => 'times-circle',
			'ifs-icon far fa-times-circle' => 'times-circle',
			'ifs-icon fal fa-times-circle' => 'times-circle',
			'ifs-icon fas fa-times' => 'times',
			'ifs-icon far fa-times' => 'times',
			'ifs-icon fal fa-times' => 'times',
			'ifs-icon fas fa-ticket-alt' => 'ticket-alt',
			'ifs-icon far fa-ticket-alt' => 'ticket-alt',
			'ifs-icon fal fa-ticket-alt' => 'ticket-alt',
			'ifs-icon fas fa-ticket' => 'ticket',
			'ifs-icon far fa-ticket' => 'ticket',
			'ifs-icon fal fa-ticket' => 'ticket',
			'ifs-icon fas fa-thumbtack' => 'thumbtack',
			'ifs-icon far fa-thumbtack' => 'thumbtack',
			'ifs-icon fal fa-thumbtack' => 'thumbtack',
			'ifs-icon fas fa-thumbs-up' => 'thumbs-up',
			'ifs-icon far fa-thumbs-up' => 'thumbs-up',
			'ifs-icon fal fa-thumbs-up' => 'thumbs-up',
			'ifs-icon fas fa-thumbs-down' => 'thumbs-down',
			'ifs-icon far fa-thumbs-down' => 'thumbs-down',
			'ifs-icon fal fa-thumbs-down' => 'thumbs-down',
			'ifs-icon fas fa-thermometer-three-quarters' => 'thermometer-three-quarters',
			'ifs-icon far fa-thermometer-three-quarters' => 'thermometer-three-quarters',
			'ifs-icon fal fa-thermometer-three-quarters' => 'thermometer-three-quarters',
			'ifs-icon fas fa-thermometer-quarter' => 'thermometer-quarter',
			'ifs-icon far fa-thermometer-quarter' => 'thermometer-quarter',
			'ifs-icon fal fa-thermometer-quarter' => 'thermometer-quarter',
			'ifs-icon fas fa-thermometer-half' => 'thermometer-half',
			'ifs-icon far fa-thermometer-half' => 'thermometer-half',
			'ifs-icon fal fa-thermometer-half' => 'thermometer-half',
			'ifs-icon fas fa-thermometer-full' => 'thermometer-full',
			'ifs-icon far fa-thermometer-full' => 'thermometer-full',
			'ifs-icon fal fa-thermometer-full' => 'thermometer-full',
			'ifs-icon fas fa-thermometer-empty' => 'thermometer-empty',
			'ifs-icon far fa-thermometer-empty' => 'thermometer-empty',
			'ifs-icon fal fa-thermometer-empty' => 'thermometer-empty',
			'ifs-icon fas fa-thermometer' => 'thermometer',
			'ifs-icon far fa-thermometer' => 'thermometer',
			'ifs-icon fal fa-thermometer' => 'thermometer',
			'ifs-icon fab fa-themeisle' => 'themeisle',
			'ifs-icon fas fa-th-list' => 'th-list',
			'ifs-icon far fa-th-list' => 'th-list',
			'ifs-icon fal fa-th-list' => 'th-list',
			'ifs-icon fas fa-th-large' => 'th-large',
			'ifs-icon far fa-th-large' => 'th-large',
			'ifs-icon fal fa-th-large' => 'th-large',
			'ifs-icon fas fa-th' => 'th',
			'ifs-icon far fa-th' => 'th',
			'ifs-icon fal fa-th' => 'th',
			'ifs-icon fas fa-text-width' => 'text-width',
			'ifs-icon far fa-text-width' => 'text-width',
			'ifs-icon fal fa-text-width' => 'text-width',
			'ifs-icon fas fa-text-height' => 'text-height',
			'ifs-icon far fa-text-height' => 'text-height',
			'ifs-icon fal fa-text-height' => 'text-height',
			'ifs-icon fas fa-terminal' => 'terminal',
			'ifs-icon far fa-terminal' => 'terminal',
			'ifs-icon fal fa-terminal' => 'terminal',
			'ifs-icon fas fa-tennis-ball' => 'tennis-ball',
			'ifs-icon far fa-tennis-ball' => 'tennis-ball',
			'ifs-icon fal fa-tennis-ball' => 'tennis-ball',
			'ifs-icon fab fa-tencent-weibo' => 'tencent-weibo',
			'ifs-icon fab fa-telegram-plane' => 'telegram-plane',
			'ifs-icon fab fa-telegram' => 'telegram',
			'ifs-icon fab fa-teamspeak' => 'teamspeak',
			'ifs-icon fas fa-taxi' => 'taxi',
			'ifs-icon far fa-taxi' => 'taxi',
			'ifs-icon fal fa-taxi' => 'taxi',
			'ifs-icon fas fa-tasks' => 'tasks',
			'ifs-icon far fa-tasks' => 'tasks',
			'ifs-icon fal fa-tasks' => 'tasks',
			'ifs-icon fas fa-tape' => 'tape',
			'ifs-icon far fa-tape' => 'tape',
			'ifs-icon fal fa-tape' => 'tape',
			'ifs-icon fas fa-tags' => 'tags',
			'ifs-icon far fa-tags' => 'tags',
			'ifs-icon fal fa-tags' => 'tags',
			'ifs-icon fas fa-tag' => 'tag',
			'ifs-icon far fa-tag' => 'tag',
			'ifs-icon fal fa-tag' => 'tag',
			'ifs-icon fas fa-tachometer-alt' => 'tachometer-alt',
			'ifs-icon far fa-tachometer-alt' => 'tachometer-alt',
			'ifs-icon fal fa-tachometer-alt' => 'tachometer-alt',
			'ifs-icon fas fa-tachometer' => '',
			'ifs-icon far fa-tachometer' => 'tachometer',
			'ifs-icon fal fa-tachometer' => 'tachometer',
			'ifs-icon fas fa-tablets' => 'tablets',
			'ifs-icon far fa-tablets' => 'tablets',
			'ifs-icon fal fa-tablets' => 'tablets',
			'ifs-icon fas fa-tablet-rugged' => 'tablet-rugged',
			'ifs-icon far fa-tablet-rugged' => 'tablet-rugged',
			'ifs-icon fal fa-tablet-rugged' => 'tablet-rugged',
			'ifs-icon fas fa-tablet-android-alt' => 'tablet-android-alt',
			'ifs-icon far fa-tablet-android-alt' => 'tablet-android-alt',
			'ifs-icon fal fa-tablet-android-alt' => 'tablet-android-alt',
			'ifs-icon fas fa-tablet-android' => 'tablet-android',
			'ifs-icon far fa-tablet-android' => 'tablet-android',
			'ifs-icon fal fa-tablet-android' => 'tablet-android',
			'ifs-icon fas fa-tablet-alt' => 'tablet-alt',
			'ifs-icon far fa-tablet-alt' => 'tablet-alt',
			'ifs-icon fal fa-tablet-alt' => 'tablet-alt',
			'ifs-icon fas fa-tablet' => 'tablet',
			'ifs-icon far fa-tablet' => 'tablet',
			'ifs-icon fal fa-tablet' => 'tablet',
			'ifs-icon fas fa-table-tennis' => 'table-tennis',
			'ifs-icon far fa-table-tennis' => 'table-tennis',
			'ifs-icon fal fa-table-tennis' => 'table-tennis',
			'ifs-icon fas fa-table' => 'table',
			'ifs-icon far fa-table' => 'table',
			'ifs-icon fal fa-table' => 'table',
			'ifs-icon fas fa-syringe' => 'syringe',
			'ifs-icon far fa-syringe' => 'syringe',
			'ifs-icon fal fa-syringe' => 'syringe',
			'ifs-icon fas fa-sync-alt' => 'sync-alt',
			'ifs-icon far fa-sync-alt' => 'sync-alt',
			'ifs-icon fal fa-sync-alt' => 'sync-alt',
			'ifs-icon fas fa-sync' => 'sync',
			'ifs-icon far fa-sync' => 'sync',
			'ifs-icon fal fa-sync' => 'sync',
			'ifs-icon fab fa-supple' => 'supple',
			'ifs-icon fas fa-superscript' => 'superscript',
			'ifs-icon far fa-superscript' => 'superscript',
			'ifs-icon fal fa-superscript' => 'superscript',
			'ifs-icon fab fa-superpowers' => 'superpowers',
			'ifs-icon fas fa-sun' => 'sun',
			'ifs-icon far fa-sun' => 'sun',
			'ifs-icon fal fa-sun' => 'sun',
			'ifs-icon fas fa-suitcase' => 'suitcase',
			'ifs-icon far fa-suitcase' => 'suitcase',
			'ifs-icon fal fa-suitcase' => 'suitcase',
			'ifs-icon fas fa-subway' => 'subway',
			'ifs-icon far fa-subway' => 'subway',
			'ifs-icon fal fa-subway' => 'subway',
			'ifs-icon fas fa-subscript' => 'subscript',
			'ifs-icon far fa-subscript' => 'subscript',
			'ifs-icon fal fa-subscript' => 'subscript',
			'ifs-icon fab fa-stumbleupon-circle' => 'stumbleupon-circle',
			'ifs-icon fab fa-stumbleupon' => 'stumbleupon',
			'ifs-icon fab fa-studiovinari' => 'studiovinari',
			'ifs-icon fab fa-stripe-s' => 'stripe-s',
			'ifs-icon fab fa-stripe' => 'stripe',
			'ifs-icon fas fa-strikethrough' => 'strikethrough',
			'ifs-icon far fa-strikethrough' => 'strikethrough',
			'ifs-icon fal fa-strikethrough' => 'strikethrough',
			'ifs-icon fas fa-street-view' => 'street-view',
			'ifs-icon far fa-street-view' => 'street-view',
			'ifs-icon fal fa-street-view' => 'street-view',
			'ifs-icon fab fa-strava' => 'strava',
			'ifs-icon fas fa-stopwatch' => 'stopwatch',
			'ifs-icon far fa-stopwatch' => 'stopwatch',
			'ifs-icon fal fa-stopwatch' => 'stopwatch',
			'ifs-icon fas fa-stop-circle' => 'stop-circle',
			'ifs-icon far fa-stop-circle' => 'stop-circle',
			'ifs-icon fal fa-stop-circle' => 'stop-circle',
			'ifs-icon fas fa-stop' => 'stop',
			'ifs-icon far fa-stop' => 'stop',
			'ifs-icon fal fa-stop' => 'stop',
			'ifs-icon fas fa-sticky-note' => 'sticky-note',
			'ifs-icon far fa-sticky-note' => 'sticky-note',
			'ifs-icon fal fa-sticky-note' => 'sticky-note',
			'ifs-icon fab fa-sticker-mule' => 'sticker-mule',
			'ifs-icon fas fa-stethoscope' => 'stethoscope',
			'ifs-icon far fa-stethoscope' => 'stethoscope',
			'ifs-icon fal fa-stethoscope' => 'stethoscope',
			'ifs-icon fas fa-step-forward' => 'step-forward',
			'ifs-icon far fa-step-forward' => 'step-forward',
			'ifs-icon fal fa-step-forward' => 'step-forward',
			'ifs-icon fas fa-step-backward' => 'step-backward',
			'ifs-icon far fa-step-backward' => 'step-backward',
			'ifs-icon fal fa-step-backward' => 'step-backward',
			'ifs-icon fab fa-steam-symbol' => 'steam-symbol',
			'ifs-icon fab fa-steam-square' => 'steam-square',
			'ifs-icon fab fa-steam' => 'steam',
			'ifs-icon fab fa-staylinked' => 'staylinked',
			'ifs-icon fas fa-star-half' => 'star-half',
			'ifs-icon far fa-star-half' => 'star-half',
			'ifs-icon fal fa-star-half' => 'star-half',
			'ifs-icon fas fa-star-exclamation' => 'star-exclamation',
			'ifs-icon far fa-star-exclamation' => 'star-exclamation',
			'ifs-icon fal fa-star-exclamation' => 'star-exclamation',
			'ifs-icon fas fa-star' => 'star',
			'ifs-icon far fa-star' => 'star',
			'ifs-icon fal fa-star' => 'star',
			'ifs-icon fab fa-stack-overflow' => 'stack-overflow',
			'ifs-icon fab fa-stack-exchange' => 'stack-exchange',
			'ifs-icon fas fa-square-full' => 'square-full',
			'ifs-icon far fa-square-full' => 'square-full',
			'ifs-icon fal fa-square-full' => 'square-full',
			'ifs-icon fas fa-square' => 'square',
			'ifs-icon far fa-square' => 'square',
			'ifs-icon fal fa-square' => 'square',
			'ifs-icon fab fa-spotify' => 'spotify',
			'ifs-icon fas fa-spinner-third' => 'spinner-third',
			'ifs-icon far fa-spinner-third' => 'spinner-third',
			'ifs-icon fal fa-spinner-third' => 'spinner-third',
			'ifs-icon fas fa-spinner' => 'spinner',
			'ifs-icon far fa-spinner' => 'spinner',
			'ifs-icon fal fa-spinner' => 'spinner',
			'ifs-icon fab fa-speakap' => 'speakap',
			'ifs-icon fas fa-spade' => 'spade',
			'ifs-icon far fa-spade' => 'spade',
			'ifs-icon fal fa-spade' => 'spade',
			'ifs-icon fas fa-space-shuttle' => 'space-shuttle',
			'ifs-icon far fa-space-shuttle' => 'space-shuttle',
			'ifs-icon fal fa-space-shuttle' => 'space-shuttle',
			'ifs-icon fab fa-soundcloud' => '',
			'ifs-icon fas fa-sort-up' => 'sort-up',
			'ifs-icon far fa-sort-up' => 'sort-up',
			'ifs-icon fal fa-sort-up' => 'sort-up',
			'ifs-icon fas fa-sort-numeric-up' => 'sort-numeric-up',
			'ifs-icon far fa-sort-numeric-up' => 'sort-numeric-up',
			'ifs-icon fal fa-sort-numeric-up' => 'sort-numeric-up',
			'ifs-icon fas fa-sort-numeric-down' => 'sort-numeric-down',
			'ifs-icon far fa-sort-numeric-down' => 'sort-numeric-down',
			'ifs-icon fal fa-sort-numeric-down' => 'sort-numeric-down',
			'ifs-icon fas fa-sort-down' => 'sort-down',
			'ifs-icon far fa-sort-down' => 'sort-down',
			'ifs-icon fal fa-sort-down' => 'sort-down',
			'ifs-icon fas fa-sort-amount-up' => 'sort-amount-up',
			'ifs-icon far fa-sort-amount-up' => 'sort-amount-up',
			'ifs-icon fal fa-sort-amount-up' => 'sort-amount-up',
			'ifs-icon fas fa-sort-amount-down' => 'sort-amount-down',
			'ifs-icon far fa-sort-amount-down' => 'sort-amount-down',
			'ifs-icon fal fa-sort-amount-down' => 'sort-amount-down',
			'ifs-icon fas fa-sort-alpha-up' => 'sort-alpha-up',
			'ifs-icon far fa-sort-alpha-up' => 'sort-alpha-up',
			'ifs-icon fal fa-sort-alpha-up' => 'sort-alpha-up',
			'ifs-icon fas fa-sort-alpha-down' => 'sort-alpha-down',
			'ifs-icon far fa-sort-alpha-down' => 'sort-alpha-down',
			'ifs-icon fal fa-sort-alpha-down' => 'sort-alpha-down',
			'ifs-icon fas fa-sort' => 'sort',
			'ifs-icon far fa-sort' => 'sort',
			'ifs-icon fal fa-sort' => 'sort',
			'ifs-icon fas fa-snowflake' => 'snowflake',
			'ifs-icon far fa-snowflake' => 'snowflake',
			'ifs-icon fal fa-snowflake' => 'snowflake',
			'ifs-icon fab fa-snapchat-square' => 'snapchat-square',
			'ifs-icon fab fa-snapchat-ghost' => 'snapchat-ghost',
			'ifs-icon fab fa-snapchat' => 'snapchat',
			'ifs-icon fas fa-smoking' => 'smoking',
			'ifs-icon far fa-smoking' => 'smoking',
			'ifs-icon fal fa-smoking' => 'smoking',
			'ifs-icon fas fa-smile-plus' => 'smile-plus',
			'ifs-icon far fa-smile-plus' => 'smile-plus',
			'ifs-icon fal fa-smile-plus' => 'smile-plus',
			'ifs-icon fas fa-smile' => 'smile',
			'ifs-icon far fa-smile' => 'smile',
			'ifs-icon fal fa-smile' => 'smile',
			'ifs-icon fab fa-slideshare' => 'slideshare',
			'ifs-icon fas fa-sliders-v-square' => 'sliders-v-square',
			'ifs-icon far fa-sliders-v-square' => 'sliders-v-square',
			'ifs-icon fal fa-sliders-v-square' => 'sliders-v-square',
			'ifs-icon fas fa-sliders-v' => 'sliders-v',
			'ifs-icon far fa-sliders-v' => 'sliders-v',
			'ifs-icon fal fa-sliders-v' => 'sliders-v',
			'ifs-icon fas fa-sliders-h-square' => 'sliders-h-square',
			'ifs-icon far fa-sliders-h-square' => 'sliders-h-square',
			'ifs-icon fal fa-sliders-h-square' => 'sliders-h-square',
			'ifs-icon fas fa-sliders-h' => 'sliders-h',
			'ifs-icon far fa-sliders-h' => 'sliders-h',
			'ifs-icon fal fa-sliders-h' => 'sliders-h',
			'ifs-icon fab fa-slack-hash' => 'slack-hash',
			'ifs-icon fab fa-slack' => 'slack',
			'ifs-icon fab fa-skype' => 'skype',
			'ifs-icon fab fa-skyatlas' => 'skyatlas',
			'ifs-icon fab fa-sith' => 'sith',
			'ifs-icon fas fa-sitemap' => 'sitemap',
			'ifs-icon far fa-sitemap' => 'sitemap',
			'ifs-icon fal fa-sitemap' => 'sitemap',
			'ifs-icon fab fa-sistrix' => 'sistrix',
			'ifs-icon fab fa-simplybuilt' => 'simplybuilt',
			'ifs-icon fas fa-signal' => 'signal',
			'ifs-icon far fa-signal' => 'signal',
			'ifs-icon fal fa-signal' => 'signal',
			'ifs-icon fas fa-sign-out-alt' => 'sign-out-alt',
			'ifs-icon far fa-sign-out-alt' => 'sign-out-alt',
			'ifs-icon fal fa-sign-out-alt' => 'sign-out-alt',
			'ifs-icon fas fa-sign-out' => 'sign-out',
			'ifs-icon far fa-sign-out' => 'sign-out',
			'ifs-icon fal fa-sign-out' => 'sign-out',
			'ifs-icon fas fa-sign-language' => 'sign-language',
			'ifs-icon far fa-sign-language' => 'sign-language',
			'ifs-icon fal fa-sign-language' => 'sign-language',
			'ifs-icon fas fa-sign-in-alt' => 'sign-in-alt',
			'ifs-icon far fa-sign-in-alt' => 'sign-in-alt',
			'ifs-icon fal fa-sign-in-alt' => 'sign-in-alt',
			'ifs-icon fas fa-sign-in' => 'sign-in',
			'ifs-icon far fa-sign-in' => 'sign-in',
			'ifs-icon fal fa-sign-in' => 'sign-in',
			'ifs-icon fas fa-sign' => 'fa-sign',
			'ifs-icon far fa-sign' => 'fa-sign',
			'ifs-icon fal fa-sign' => 'fa-sign',
			'ifs-icon fas fa-shuttlecock' => 'fa-shuttlecock',
			'ifs-icon far fa-shuttlecock' => 'fa-shuttlecock',
			'ifs-icon fal fa-shuttlecock' => 'fa-shuttlecock',
			'ifs-icon fas fa-shower' => 'fa-shower',
			'ifs-icon far fa-shower' => 'fa-shower',
			'ifs-icon fal fa-shower' => 'fa-shower',
			'ifs-icon fas fa-shopping-cart' => 'shopping-cart',
			'ifs-icon far fa-shopping-cart' => 'shopping-cart',
			'ifs-icon fal fa-shopping-cart' => 'shopping-cart',
			'ifs-icon fas fa-shopping-basket' => 'shopping-basket',
			'ifs-icon far fa-shopping-basket' => 'shopping-basket',
			'ifs-icon fal fa-shopping-basket' => 'shopping-basket',
			'ifs-icon fas fa-shopping-bag' => 'shopping-bag',
			'ifs-icon far fa-shopping-bag' => 'shopping-bag',
			'ifs-icon fal fa-shopping-bag' => 'shopping-bag',
			'ifs-icon fab fa-shirtsinbulk' => 'shirtsinbulk',
			'ifs-icon fas fa-shipping-timed' => 'shipping-timed',
			'ifs-icon far fa-shipping-timed' => 'shipping-timed',
			'ifs-icon fal fa-shipping-timed' => 'shipping-timed',
			'ifs-icon fas fa-shipping-fast' => 'shipping-fast',
			'ifs-icon far fa-shipping-fast' => 'shipping-fast',
			'ifs-icon fal fa-shipping-fast' => 'shipping-fast',
			'ifs-icon fas fa-ship' => 'ship',
			'ifs-icon far fa-ship' => 'ship',
			'ifs-icon fal fa-ship' => 'ship',
			'ifs-icon fas fa-shield-check' => 'shield-check',
			'ifs-icon far fa-shield-check' => 'shield-check',
			'ifs-icon fal fa-shield-check' => 'shield-check',
			'ifs-icon fas fa-shield-alt' => 'shield-alt',
			'ifs-icon far fa-shield-alt' => 'shield-alt',
			'ifs-icon fal fa-shield-alt' => 'shield-alt',
			'ifs-icon fas fa-shield' => 'shield',
			'ifs-icon far fa-shield' => 'shield',
			'ifs-icon fal fa-shield' => 'shield',
			'ifs-icon fas fa-shekel-sign' => 'shekel-sign',
			'ifs-icon far fa-shekel-sign' => 'shekel-sign',
			'ifs-icon fal fa-shekel-sign' => 'shekel-sign',
			'ifs-icon fas fa-share-square' => 'share-square',
			'ifs-icon far fa-share-square' => 'share-square',
			'ifs-icon fal fa-share-square' => 'share-square',
			'ifs-icon fas fa-share-alt-square' => 'share-alt-square',
			'ifs-icon far fa-share-alt-square' => 'share-alt-square',
			'ifs-icon fal fa-share-alt-square' => 'share-alt-square',
			'ifs-icon fas fa-share-alt' => 'share-alt',
			'ifs-icon far fa-share-alt' => 'share-alt',
			'ifs-icon fal fa-share-alt' => 'share-alt',
			'ifs-icon fas fa-share-all' => 'share-all',
			'ifs-icon far fa-share-all' => 'share-all',
			'ifs-icon fal fa-share-all' => 'share-all',
			'ifs-icon fas fa-share' => 'share',
			'ifs-icon far fa-share' => 'share',
			'ifs-icon fal fa-share' => 'share',
			'ifs-icon fab fa-servicestack' => 'servicestack',
			'ifs-icon fas fa-server' => 'server',
			'ifs-icon far fa-server' => 'server',
			'ifs-icon fal fa-server' => 'server',
			'ifs-icon fab fa-sellsy' => 'sellsy',
			'ifs-icon fab fa-sellcast' => 'sellcast',
			'ifs-icon fas fa-seedling' => 'seedling',
			'ifs-icon far fa-seedling' => 'seedling',
			'ifs-icon fal fa-seedling' => 'seedling',
			'ifs-icon fab fa-searchengin' => 'searchengin',
			'ifs-icon fas fa-search-plus' => 'search-plus',
			'ifs-icon far fa-search-plus' => 'search-plus',
			'ifs-icon fal fa-search-plus' => 'search-plus',
			'ifs-icon fas fa-search-minus' => 'search-minus',
			'ifs-icon far fa-search-minus' => 'search-minus',
			'ifs-icon fal fa-search-minus' => 'search-minus',
			'ifs-icon fas fa-search' => 'search',
			'ifs-icon far fa-search' => 'search',
			'ifs-icon fal fa-search' => 'search',
			'ifs-icon fas fa-scrubber' => 'scrubber',
			'ifs-icon far fa-scrubber' => 'scrubber',
			'ifs-icon fal fa-scrubber' => 'scrubber',
			'ifs-icon fab fa-scribd' => 'scribd',
			'ifs-icon fab fa-schlix' => 'schlix',
			'ifs-icon fas fa-scanner-touchscreen' => 'scanner-touchscreen',
			'ifs-icon far fa-scanner-touchscreen' => 'scanner-touchscreen',
			'ifs-icon fal fa-scanner-touchscreen' => 'scanner-touchscreen',
			'ifs-icon fas fa-scanner-keyboard' => 'scanner-keyboard',
			'ifs-icon far fa-scanner-keyboard' => 'scanner-keyboard',
			'ifs-icon fal fa-scanner-keyboard' => 'scanner-keyboard',
			'ifs-icon fas fa-scanner' => 'scanner',
			'ifs-icon far fa-scanner' => 'scanner',
			'ifs-icon fal fa-scanner' => 'scanner',
			'ifs-icon fas fa-rectangle-portrait' => 'rectangle-portrait',
			'ifs-icon far fa-rectangle-portrait' => 'rectangle-portrait',
			'ifs-icon fal fa-rectangle-portrait' => 'rectangle-portrait',
			'ifs-icon fas fa-rectangle-landscape' => 'rectangle-landscape',
			'ifs-icon far fa-rectangle-landscape' => 'rectangle-landscape',
			'ifs-icon fal fa-rectangle-landscape' => 'rectangle-landscape',
			'ifs-icon fab fa-rebel' => 'rebel',
			'ifs-icon fab fa-readme' => 'readme',
			'ifs-icon fab fa-react' => 'react',
			'ifs-icon fab fa-ravelry' => 'ravelry',
			'ifs-icon fas fa-random' => 'random',
			'ifs-icon far fa-random' => 'random',
			'ifs-icon fal fa-random' => 'random',
			'ifs-icon fas fa-ramp-loading' => 'ramp-loading',
			'ifs-icon far fa-ramp-loading' => 'ramp-loading',
			'ifs-icon fal fa-ramp-loading' => 'ramp-loading',
			'ifs-icon fas fa-racquet' => 'racquet',
			'ifs-icon far fa-racquet' => 'racquet',
			'ifs-icon fal fa-racquet' => 'racquet',
			'ifs-icon fab fa-r-project' => 'r-project',
			'ifs-icon fas fa-quote-right' => 'quote-right',
			'ifs-icon far fa-quote-right' => 'quote-right',
			'ifs-icon fal fa-quote-right' => 'quote-right',
			'ifs-icon fas fa-quote-left' => 'quote-left',
			'ifs-icon far fa-quote-left' => 'quote-left',
			'ifs-icon fal fa-quote-left' => 'quote-left',
			'ifs-icon fab fa-quora' => 'quora',
			'ifs-icon fab fa-quinscape' => 'quinscape',
			'ifs-icon fas fa-quidditch' => 'quidditch',
			'ifs-icon far fa-quidditch' => 'quidditch',
			'ifs-icon fal fa-quidditch' => 'quidditch',
			'ifs-icon fas fa-question-square' => 'question-square',
			'ifs-icon far fa-question-square' => 'question-square',
			'ifs-icon fal fa-question-square' => 'question-square',
			'ifs-icon fas fa-question-circle' => 'question-circle',
			'ifs-icon far fa-question-circle' => 'question-circle',
			'ifs-icon fal fa-question-circle' => 'question-circle',
			'ifs-icon fas fa-question' => 'question',
			'ifs-icon far fa-question' => 'question',
			'ifs-icon fal fa-question' => 'question',
			'ifs-icon fas fa-qrcode' => 'qrcode',
			'ifs-icon far fa-qrcode' => 'qrcode',
			'ifs-icon fal fa-qrcode' => 'qrcode',
			'ifs-icon fab fa-qq' => 'qq',
			'ifs-icon fab fa-python' => 'python',
			'ifs-icon fas fa-puzzle-piece' => 'puzzle-piece',
			'ifs-icon far fa-puzzle-piece' => 'puzzle-piece',
			'ifs-icon fal fa-puzzle-piece' => 'puzzle-piece',
			'ifs-icon fab fa-pushed' => 'pushed',
			'ifs-icon fab fa-product-hunt' => 'product-hunt',
			'ifs-icon fas fa-procedures' => 'procedures',
			'ifs-icon far fa-procedures' => 'procedures',
			'ifs-icon fal fa-procedures' => 'procedures',
			'ifs-icon fas fa-print' => 'print',
			'ifs-icon far fa-print' => 'print',
			'ifs-icon fal fa-print' => 'print',
			'ifs-icon fas fa-prescription-bottle-alt' => 'prescription-bottle-alt',
			'ifs-icon far fa-prescription-bottle-alt' => 'prescription-bottle-alt',
			'ifs-icon fal fa-prescription-bottle-alt' => 'prescription-bottle-alt',
			'ifs-icon fas fa-prescription-bottle' => 'prescription-bottle',
			'ifs-icon far fa-prescription-bottle' => 'prescription-bottle',
			'ifs-icon fal fa-prescription-bottle' => 'prescription-bottle',
			'ifs-icon fas fa-power-off' => 'power-off',
			'ifs-icon far fa-power-off' => 'power-off',
			'ifs-icon fal fa-power-off' => 'power-off',
			'ifs-icon fas fa-pound-sign' => 'pound-sign',
			'ifs-icon far fa-pound-sign' => 'pound-sign',
			'ifs-icon fal fa-pound-sign' => 'pound-sign',
			'ifs-icon fas fa-portrait' => 'portrait',
			'ifs-icon far fa-portrait' => 'portrait',
			'ifs-icon fal fa-portrait' => 'portrait',
			'ifs-icon fas fa-poo' => 'poo',
			'ifs-icon far fa-poo' => 'poo',
			'ifs-icon fal fa-poo' => 'poo',
			'ifs-icon fas fa-podcast' => 'podcast',
			'ifs-icon far fa-podcast' => 'podcast',
			'ifs-icon fal fa-podcast' => 'podcast',
			'ifs-icon fas fa-plus-square' => 'plus-square',
			'ifs-icon far fa-plus-square' => 'plus-square',
			'ifs-icon fal fa-plus-square' => 'plus-square',
			'ifs-icon fas fa-plus-octagon' => 'plus-octagon',
			'ifs-icon far fa-plus-octagon' => 'plus-octagon',
			'ifs-icon fal fa-plus-octagon' => 'plus-octagon',
			'ifs-icon fas fa-plus-hexagon' => 'plus-hexagon',
			'ifs-icon far fa-plus-hexagon' => 'plus-hexagon',
			'ifs-icon fal fa-plus-hexagon' => 'plus-hexagon',
			'ifs-icon fas fa-plus-circle' => 'plus-circle',
			'ifs-icon far fa-plus-circle' => 'plus-circle',
			'ifs-icon fal fa-plus-circle' => 'plus-circle',
			'ifs-icon fas fa-plus' => 'plus',
			'ifs-icon far fa-plus' => 'plus',
			'ifs-icon fal fa-plus' => 'plus',
			'ifs-icon fas fa-plug' => 'plug',
			'ifs-icon far fa-plug' => 'plug',
			'ifs-icon fal fa-plug' => 'plug',
			'ifs-icon fab fa-playstation' => 'playstation',
			'ifs-icon fas fa-play-circle' => 'play-circle',
			'ifs-icon far fa-play-circle' => 'play-circle',
			'ifs-icon fal fa-play-circle' => 'play-circle',
			'ifs-icon fas fa-play' => 'play',
			'ifs-icon far fa-play' => 'play',
			'ifs-icon fal fa-play' => 'play',
			'ifs-icon fas fa-plane-alt' => 'plane-alt',
			'ifs-icon far fa-plane-alt' => 'plane-alt',
			'ifs-icon fal fa-plane-alt' => 'plane-alt',
			'ifs-icon fas fa-plane' => 'plane',
			'ifs-icon far fa-plane' => 'plane',
			'ifs-icon fal fa-plane' => 'plane',
			'ifs-icon fas fa-rocket' => 'rocket',
			'ifs-icon far fa-rocket' => 'rocket',
			'ifs-icon fal fa-rocket' => 'rocket',
			'ifs-icon fas fa-space-shuttle' => 'space shuttle',
			'ifs-icon far fa-space-shuttle' => 'space shuttle',
			'ifs-icon fal fa-space-shuttle' => 'space shuttle',
			'ifs-icon fab fa-pinterest-square' => 'pinterest-square',
			'ifs-icon fab fa-pinterest-p' => 'pinterest-p',
			'ifs-icon fab fa-pinterest' => '',
			'ifs-icon fas fa-pills' => 'pills',
			'ifs-icon far fa-pills' => 'pills',
			'ifs-icon fal fa-pills' => 'pills',
			'ifs-icon fas fa-piggy-bank' => 'piggy-bank',
			'ifs-icon far fa-piggy-bank' => 'piggy-bank',
			'ifs-icon fal fa-piggy-bank' => 'piggy-bank',
			'ifs-icon fas fa-pig' => 'pig',
			'ifs-icon far fa-pig' => 'pig',
			'ifs-icon fal fa-pig' => 'pig',
			'ifs-icon fab fa-pied-piper-pp' => 'pied-piper-pp',
			'ifs-icon fab fa-pied-piper-hat' => 'pied-piper-hat',
			'ifs-icon fab fa-pied-piper-alt' => 'pied-piper-alt',
			'ifs-icon fab fa-pied-piper' => 'pied-piper',
			'ifs-icon fab fa-php' => 'php',
			'ifs-icon fas fa-phone-volume' => 'phone-volume',
			'ifs-icon far fa-phone-volume' => 'phone-volume',
			'ifs-icon fal fa-phone-volume' => 'phone-volume',
			'ifs-icon fas fa-phone-square' => 'phone-square',
			'ifs-icon far fa-phone-square' => 'phone-square',
			'ifs-icon fal fa-phone-square' => 'phone-square',
			'ifs-icon fas fa-phone-slash' => 'phone-slash',
			'ifs-icon far fa-phone-slash' => 'phone-slash',
			'ifs-icon fal fa-phone-slash' => 'phone-slash',
			'ifs-icon fas fa-phone-plus' => 'phone-plus',
			'ifs-icon far fa-phone-plus' => 'phone-plus',
			'ifs-icon fal fa-phone-plus' => 'phone-plus',
			'ifs-icon fas fa-phone' => 'phone',
			'ifs-icon far fa-phone' => 'phone',
			'ifs-icon fal fa-phone' => 'phone',
			'ifs-icon fab fa-phoenix-squadron' => 'phoenix-squadron',
			'ifs-icon fab fa-phoenix-framework' => 'phoenix-framework',
			'ifs-icon fab fa-phabricator' => 'phabricator',
			'ifs-icon fas fa-person-dolly-empty' => 'person-dolly-empty',
			'ifs-icon far fa-person-dolly-empty' => 'person-dolly-empty',
			'ifs-icon fal fa-person-dolly-empty' => 'person-dolly-empty',
			'ifs-icon fas fa-person-dolly' => 'person-dolly',
			'ifs-icon far fa-person-dolly' => 'person-dolly',
			'ifs-icon fal fa-person-dolly' => 'person-dolly',
			'ifs-icon fas fa-person-carry' => 'person-carry',
			'ifs-icon far fa-person-carry' => 'person-carry',
			'ifs-icon fal fa-person-carry' => 'person-carry',
			'ifs-icon fab fa-periscope' => 'periscope',
			'ifs-icon fas fa-percent' => 'percent',
			'ifs-icon far fa-percent' => 'percent',
			'ifs-icon fal fa-percent' => 'percent',
			'ifs-icon fas fa-people-carry' => 'people-carry',
			'ifs-icon far fa-people-carry' => 'people-carry',
			'ifs-icon fal fa-people-carry' => 'people-carry',
			'ifs-icon fas fa-pennant' => 'pennant',
			'ifs-icon far fa-pennant' => 'pennant',
			'ifs-icon fal fa-pennant' => 'pennant',
			'ifs-icon fas fa-pencil-alt' => 'pencil-alt',
			'ifs-icon far fa-pencil-alt' => 'pencil-alt',
			'ifs-icon fal fa-pencil-alt' => 'pencil-alt',
			'ifs-icon fas fa-pencil' => 'pencil',
			'ifs-icon far fa-pencil' => 'pencil',
			'ifs-icon fal fa-pencil' => 'pencil',
			'ifs-icon fas fa-pen-square' => 'pen-square',
			'ifs-icon far fa-pen-square' => 'pen-square',
			'ifs-icon fal fa-pen-square' => 'pen-square',
			'ifs-icon fas fa-pen-alt' => 'pen-alt',
			'ifs-icon far fa-pen-alt' => 'pen-alt',
			'ifs-icon fal fa-pen-alt' => 'pen-alt',
			'ifs-icon fas fa-pen' => 'pen',
			'ifs-icon far fa-pen' => 'pen',
			'ifs-icon fal fa-pen' => 'pen',
			'ifs-icon fab fa-paypal' => 'paypal',
			'ifs-icon fas fa-paw' => 'paw',
			'ifs-icon far fa-paw' => 'paw',
			'ifs-icon fal fa-paw' => 'paw',
			'ifs-icon fas fa-pause-circle' => 'pause-circle',
			'ifs-icon far fa-pause-circle' => 'pause-circle',
			'ifs-icon fal fa-pause-circle' => 'pause-circle',
			'ifs-icon fas fa-pause' => 'pause',
			'ifs-icon far fa-pause' => 'pause',
			'ifs-icon fal fa-pause' => 'pause',
			'ifs-icon fab fa-patreon' => 'patreon',
			'ifs-icon fas fa-paste' => 'paste',
			'ifs-icon far fa-paste' => 'paste',
			'ifs-icon fal fa-paste' => 'paste',
			'ifs-icon fas fa-paragraph' => 'paragraph',
			'ifs-icon far fa-paragraph' => 'paragraph',
			'ifs-icon fal fa-paragraph' => 'paragraph',
			'ifs-icon fas fa-parachute-box' => 'parachute-box',
			'ifs-icon far fa-parachute-box' => 'parachute-box',
			'ifs-icon fal fa-parachute-box' => 'parachute-box',
			'ifs-icon fas fa-paperclip' => 'paperclip',
			'ifs-icon far fa-paperclip' => 'paperclip',
			'ifs-icon fal fa-paperclip' => 'paperclip',
			'ifs-icon fas fa-paper-plane' => 'paper-plane',
			'ifs-icon far fa-paper-plane' => 'paper-plane',
			'ifs-icon fal fa-paper-plane' => 'paper-plane',
			'ifs-icon fas fa-pallet-alt' => 'pallet-alt',
			'ifs-icon far fa-pallet-alt' => 'pallet-alt',
			'ifs-icon fal fa-pallet-alt' => 'pallet-alt',
			'ifs-icon fas fa-pallet' => 'pallet',
			'ifs-icon far fa-pallet' => 'pallet',
			'ifs-icon fal fa-pallet' => 'pallet',
			'ifs-icon fas fa-tty' => 'tty',
			'ifs-icon far fa-tty' => 'tty',
			'ifs-icon fal fa-tty' => 'tty',
			'ifs-icon fab fa-palfed' => 'palfed',
			'ifs-icon fas fa-paint-brush' => 'paint-brush',
			'ifs-icon far fa-paint-brush' => 'paint-brush',
			'ifs-icon fal fa-paint-brush' => 'paint-brush',
			'ifs-icon fab fa-pagelines' => 'pagelines',
			'ifs-icon fab fa-page4' => 'page4',
			'ifs-icon fas fa-outdent' => 'outdent',
			'ifs-icon far fa-outdent' => 'outdent',
			'ifs-icon fal fa-outdent' => 'outdent',
			'ifs-icon fab fa-osi' => 'osi',
			'ifs-icon fab fa-optin-monster' => 'optin-monster',
			'ifs-icon fab fa-opera' => 'opera',
			'ifs-icon fab fa-openid' => 'openid',
			'ifs-icon fab fa-opencart' => 'opencart',
			'ifs-icon fab fa-old-republic' => 'old-republic',
			'ifs-icon fab fa-odnoklassniki-square' => 'odnoklassniki-square',
			'ifs-icon fab fa-odnoklassniki' => 'odnoklassniki',
			'ifs-icon fas fa-octagon' => 'octagon',
			'ifs-icon far fa-octagon' => 'octagon',
			'ifs-icon fal fa-octagon' => 'octagon',
			'ifs-icon fas fa-object-ungroup' => 'object-ungroup',
			'ifs-icon far fa-object-ungroup' => 'object-ungroup',
			'ifs-icon fal fa-object-ungroup' => 'object-ungroup',
			'ifs-icon fas fa-object-group' => 'object-group',
			'ifs-icon far fa-object-group' => 'object-group',
			'ifs-icon fal fa-object-group' => 'object-group',
			'ifs-icon fab fa-nutritionix' => 'nutritionix',
			'ifs-icon fab fa-ns8' => 'ns8',
			'ifs-icon fab fa-npm' => 'npm',
			'ifs-icon fas fa-notes-medical' => 'notes-medical',
			'ifs-icon far fa-notes-medical' => 'notes-medical',
			'ifs-icon fal fa-notes-medical' => 'notes-medical',
			'ifs-icon fab fa-node-js' => 'node-js',
			'ifs-icon fab fa-node' => 'node',
			'ifs-icon fab fa-nintendo-switch' => 'nintendo-switch',
			'ifs-icon fas fa-newspaper' => 'newspaper',
			'ifs-icon far fa-newspaper' => 'newspaper',
			'ifs-icon fal fa-newspaper' => 'newspaper',
			'ifs-icon fas fa-neuter' => 'neuter',
			'ifs-icon far fa-neuter' => 'neuter',
			'ifs-icon fal fa-neuter' => 'neuter',
			'ifs-icon fab fa-napster' => 'napster',
			'ifs-icon fas fa-music' => 'music',
			'ifs-icon far fa-music' => 'music',
			'ifs-icon fal fa-music' => 'music',
			'ifs-icon fas fa-mouse-pointer' => 'mouse-pointer',
			'ifs-icon far fa-mouse-pointer' => 'mouse-pointer',
			'ifs-icon fal fa-mouse-pointer' => 'mouse-pointer',
			'ifs-icon fas fa-motorcycle' => 'motorcycle',
			'ifs-icon far fa-motorcycle' => 'motorcycle',
			'ifs-icon fal fa-motorcycle' => 'motorcycle',
			'ifs-icon fas fa-moon' => 'moon',
			'ifs-icon far fa-moon' => 'moon',
			'ifs-icon fal fa-moon' => 'moon',
			'ifs-icon fas fa-money-bill-alt' => 'money-bill-alt',
			'ifs-icon far fa-money-bill-alt' => 'money-bill-alt',
			'ifs-icon fal fa-money-bill-alt' => 'money-bill-alt',
			'ifs-icon fas fa-money-bill' => 'money-bill',
			'ifs-icon far fa-money-bill' => 'money-bill',
			'ifs-icon fal fa-money-bill' => 'money-bill',
			'ifs-icon fab fa-monero' => 'monero',
			'ifs-icon fab fa-modx' => 'modx',
			'ifs-icon fas fa-mobile-android-alt' => 'mobile-android-alt',
			'ifs-icon far fa-mobile-android-alt' => 'mobile-android-alt',
			'ifs-icon fal fa-mobile-android-alt' => 'mobile-android-alt',
			'ifs-icon fas fa-mobile-android' => 'mobile-android',
			'ifs-icon far fa-mobile-android' => 'mobile-android',
			'ifs-icon fal fa-mobile-android' => 'mobile-android',
			'ifs-icon fas fa-mobile-alt' => 'mobile-alt',
			'ifs-icon far fa-mobile-alt' => 'mobile-alt',
			'ifs-icon fal fa-mobile-alt' => 'mobile-alt',
			'ifs-icon fas fa-mobile' => 'mobile',
			'ifs-icon far fa-mobile' => 'mobile',
			'ifs-icon fal fa-mobile' => 'mobile',
			'ifs-icon fab fa-mizuni' => 'mizuni',
			'ifs-icon fab fa-mixcloud' => 'mixcloud',
			'ifs-icon fab fa-mix' => 'mix',
			'ifs-icon fas fa-minus-square' => 'minus-square',
			'ifs-icon far fa-minus-square' => 'minus-square',
			'ifs-icon fal fa-minus-square' => 'minus-square',
			'ifs-icon fas fa-minus-octagon' => 'minus-octagon',
			'ifs-icon far fa-minus-octagon' => 'minus-octagon',
			'ifs-icon fal fa-minus-octagon' => 'minus-octagon',
			'ifs-icon fas fa-minus-hexagon' => 'minus-hexagon',
			'ifs-icon far fa-minus-hexagon' => 'minus-hexagon',
			'ifs-icon fal fa-minus-hexagon' => 'minus-hexagon',
			'ifs-icon fas fa-minus-circle' => 'minus-circle',
			'ifs-icon far fa-minus-circle' => 'minus-circle',
			'ifs-icon fal fa-minus-circle' => 'minus-circle',
			'ifs-icon fas fa-minus' => 'minus',
			'ifs-icon far fa-minus' => 'minus',
			'ifs-icon fal fa-minus' => 'minus',
			'ifs-icon fab fa-microsoft' => 'microsoft',
			'ifs-icon fas fa-microphone-slash' => 'microphone-slash',
			'ifs-icon far fa-microphone-slash' => 'microphone-slash',
			'ifs-icon fal fa-microphone-slash' => 'microphone-slash',
			'ifs-icon fas fa-microphone-alt' => 'microphone-alt',
			'ifs-icon far fa-microphone-alt' => 'microphone-alt',
			'ifs-icon fal fa-microphone-alt' => 'microphone-alt',
			'ifs-icon fas fa-microphone' => 'microphone',
			'ifs-icon far fa-microphone' => 'microphone',
			'ifs-icon fal fa-microphone' => 'microphone',
			'ifs-icon fas fa-microchip' => 'microchip',
			'ifs-icon far fa-microchip' => 'microchip',
			'ifs-icon fal fa-microchip' => 'microchip',
			'ifs-icon fas fa-mercury' => 'mercury',
			'ifs-icon far fa-mercury' => 'mercury',
			'ifs-icon fal fa-mercury' => 'mercury',
			'ifs-icon fas fa-meh' => 'meh',
			'ifs-icon far fa-meh' => 'meh',
			'ifs-icon fal fa-meh' => 'meh',
			'ifs-icon fab fa-meetup' => 'meetup',
			'ifs-icon fab fa-medrt' => 'medrt',
			'ifs-icon fas fa-medkit' => 'medkit',
			'ifs-icon far fa-medkit' => 'medkit',
			'ifs-icon fal fa-medkit' => 'medkit',
			'ifs-icon fab fa-medium-m' => 'medium-m',
			'ifs-icon fab fa-medium' => 'medium',
			'ifs-icon fab fa-medapps' => 'medapps',
			'ifs-icon fab fa-maxcdn' => 'maxcdn',
			'ifs-icon fab fa-mastodon' => 'mastodon',
			'ifs-icon fas fa-mars-stroke-v' => 'mars-stroke-v',
			'ifs-icon far fa-mars-stroke-v' => 'mars-stroke-v',
			'ifs-icon fal fa-mars-stroke-v' => 'mars-stroke-v',
			'ifs-icon fas fa-mars-stroke-h' => 'mars-stroke-h',
			'ifs-icon far fa-mars-stroke-h' => 'mars-stroke-h',
			'ifs-icon fal fa-mars-stroke-h' => 'mars-stroke-h',
			'ifs-icon fas fa-mars-stroke' => 'mars-stroke',
			'ifs-icon far fa-mars-stroke' => 'mars-stroke',
			'ifs-icon fal fa-mars-stroke' => 'mars-stroke',
			'ifs-icon fas fa-mars-double' => 'mars-double',
			'ifs-icon far fa-mars-double' => 'mars-double',
			'ifs-icon fal fa-mars-double' => 'mars-double',
			'ifs-icon fas fa-mars' => 'mars',
			'ifs-icon far fa-mars' => 'mars',
			'ifs-icon fal fa-mars' => 'mars',
			'ifs-icon fas fa-map-signs' => 'map-signs',
			'ifs-icon far fa-map-signs' => 'map-signs',
			'ifs-icon fal fa-map-signs' => 'map-signs',
			'ifs-icon fas fa-map-pin' => 'map-pin',
			'ifs-icon far fa-map-pin' => 'map-pin',
			'ifs-icon fal fa-map-pin' => 'map-pin',
			'ifs-icon fas fa-map-marker-alt' => 'map-marker-alt',
			'ifs-icon far fa-map-marker-alt' => 'map-marker-alt',
			'ifs-icon fal fa-map-marker-alt' => 'map-marker-alt',
			'ifs-icon fas fa-map-marker' => 'map-marker',
			'ifs-icon far fa-map-marker' => 'map-marker',
			'ifs-icon fal fa-map-marker' => 'map-marker',
			'ifs-icon fas fa-map' => 'map',
			'ifs-icon far fa-map' => 'map',
			'ifs-icon fal fa-map' => 'map',
			'ifs-icon fab fa-mandalorian' => 'mandalorian',
			'ifs-icon fas fa-male' => 'male',
			'ifs-icon far fa-male' => 'male',
			'ifs-icon fal fa-male' => 'male',
			'ifs-icon fas fa-magnet' => 'magnet',
			'ifs-icon far fa-magnet' => 'magnet',
			'ifs-icon fal fa-magnet' => 'magnet',
			'ifs-icon fas fa-magic' => 'magic',
			'ifs-icon far fa-magic' => 'magic',
			'ifs-icon fal fa-magic' => 'magic',
			'ifs-icon fab fa-magento' => 'magento',
			'ifs-icon fab fa-lyft' => 'lyft',
			'ifs-icon fas fa-luchador' => 'luchador',
			'ifs-icon far fa-luchador' => 'luchador',
			'ifs-icon fal fa-luchador' => 'luchador',
			'ifs-icon fas fa-low-vision' => 'low-vision',
			'ifs-icon far fa-low-vision' => 'low-vision',
			'ifs-icon fal fa-low-vision' => 'low-vision',
			'ifs-icon fas fa-loveseat' => 'loveseat',
			'ifs-icon far fa-loveseat' => 'loveseat',
			'ifs-icon fal fa-loveseat' => 'loveseat',
			'ifs-icon fas fa-long-arrow-up' => 'long-arrow-up',
			'ifs-icon far fa-long-arrow-up' => 'long-arrow-up',
			'ifs-icon fal fa-long-arrow-up' => 'long-arrow-up',
			'ifs-icon fas fa-long-arrow-right' => 'long-arrow-right',
			'ifs-icon far fa-long-arrow-right' => 'long-arrow-right',
			'ifs-icon fal fa-long-arrow-right' => 'long-arrow-right',
			'ifs-icon fas fa-long-arrow-left' => 'long-arrow-left',
			'ifs-icon far fa-long-arrow-left' => 'long-arrow-left',
			'ifs-icon fal fa-long-arrow-left' => 'long-arrow-left',
			'ifs-icon fas fa-long-arrow-down' => 'long-arrow-down',
			'ifs-icon far fa-long-arrow-down' => 'long-arrow-down',
			'ifs-icon fal fa-long-arrow-down' => 'long-arrow-down',
			'ifs-icon fas fa-long-arrow-alt-up' => 'long-arrow-alt-up',
			'ifs-icon far fa-long-arrow-alt-up' => 'long-arrow-alt-up',
			'ifs-icon fal fa-long-arrow-alt-up' => 'long-arrow-alt-up',
			'ifs-icon fas fa-long-arrow-alt-right' => 'long-arrow-alt-right',
			'ifs-icon far fa-long-arrow-alt-right' => 'long-arrow-alt-right',
			'ifs-icon fal fa-long-arrow-alt-right' => 'long-arrow-alt-right',
			'ifs-icon fas fa-long-arrow-alt-left' => 'long-arrow-alt-left',
			'ifs-icon far fa-long-arrow-alt-left' => 'long-arrow-alt-left',
			'ifs-icon fal fa-long-arrow-alt-left' => 'long-arrow-alt-left',
			'ifs-icon fas fa-long-arrow-alt-down' => 'long-arrow-alt-down',
			'ifs-icon far fa-long-arrow-alt-down' => 'long-arrow-alt-down',
			'ifs-icon fal fa-long-arrow-alt-down' => 'long-arrow-alt-down',
			'ifs-icon fas fa-lock-open-alt' => 'lock-open-alt',
			'ifs-icon far fa-lock-open-alt' => 'lock-open-alt',
			'ifs-icon fal fa-lock-open-alt' => 'lock-open-alt',
			'ifs-icon fas fa-lock-open' => 'lock-open',
			'ifs-icon far fa-lock-open' => 'lock-open',
			'ifs-icon fal fa-lock-open' => 'lock-open',
			'ifs-icon fas fa-lock-alt' => 'lock-alt',
			'ifs-icon far fa-lock-alt' => 'lock-alt',
			'ifs-icon fal fa-lock-alt' => 'lock-alt',
			'ifs-icon fas fa-lock' => 'lock',
			'ifs-icon far fa-lock' => 'lock',
			'ifs-icon fal fa-lock' => 'lock',
			'ifs-icon fas fa-location-arrow' => 'location-arrow',
			'ifs-icon far fa-location-arrow' => 'location-arrow',
			'ifs-icon fal fa-location-arrow' => 'location-arrow',
			'ifs-icon fas fa-list-ul' => 'list-ul',
			'ifs-icon far fa-list-ul' => 'list-ul',
			'ifs-icon fal fa-list-ul' => 'list-ul',
			'ifs-icon fas fa-list-ol' => 'list-ol',
			'ifs-icon far fa-list-ol' => 'list-ol',
			'ifs-icon fal fa-list-ol' => 'list-ol',
			'ifs-icon fas fa-list-alt' => 'list-alt',
			'ifs-icon far fa-list-alt' => 'list-alt',
			'ifs-icon fal fa-list-alt' => 'list-alt',
			'ifs-icon fas fa-list' => 'list',
			'ifs-icon far fa-list' => 'list',
			'ifs-icon fal fa-list' => 'list',
			'ifs-icon fas fa-lira-sign' => 'lira-sign',
			'ifs-icon far fa-lira-sign' => 'lira-sign',
			'ifs-icon fal fa-lira-sign' => 'lira-sign',
			'ifs-icon fab fa-linux' => 'linux',
			'ifs-icon fab fa-linode' => 'linode',
			'ifs-icon fab fa-linkedin-in' => 'linkedin-in',
			'ifs-icon fab fa-linkedin' => 'linkedin',
			'ifs-icon fas fa-link' => 'link',
			'ifs-icon far fa-link' => 'link',
			'ifs-icon fal fa-link' => 'link',
			'ifs-icon fab fa-line' => 'line',
			'ifs-icon fas fa-lightbulb' => 'lightbulb',
			'ifs-icon far fa-lightbulb' => 'lightbulb',
			'ifs-icon fal fa-lightbulb' => 'lightbulb',
			'ifs-icon fas fa-life-ring' => 'life-ring',
			'ifs-icon far fa-life-ring' => 'life-ring',
			'ifs-icon fal fa-life-ring' => 'life-ring',
			'ifs-icon fas fa-level-up-alt' => 'level-up-alt',
			'ifs-icon far fa-level-up-alt' => 'level-up-alt',
			'ifs-icon fal fa-level-up-alt' => 'level-up-alt',
			'ifs-icon fas fa-level-up' => 'level-up',
			'ifs-icon far fa-level-up' => 'level-up',
			'ifs-icon fal fa-level-up' => 'level-up',
			'ifs-icon fas fa-level-down-alt' => 'level-down-alt',
			'ifs-icon far fa-level-down-alt' => 'level-down-alt',
			'ifs-icon fal fa-level-down-alt' => 'level-down-alt',
			'ifs-icon fas fa-level-down' => 'level-down',
			'ifs-icon far fa-level-down' => 'level-down',
			'ifs-icon fal fa-level-down' => 'level-down',
			'ifs-icon fab fa-less' => 'less',
			'ifs-icon fas fa-lemon' => 'lemon',
			'ifs-icon far fa-lemon' => 'lemon',
			'ifs-icon fal fa-lemon' => 'lemon',
			'ifs-icon fab fa-leanpub' => 'leanpub',
			'ifs-icon fas fa-leaf-heart' => 'leaf-heart',
			'ifs-icon far fa-leaf-heart' => 'leaf-heart',
			'ifs-icon fal fa-leaf-heart' => 'leaf-heart',
			'ifs-icon fas fa-leaf' => 'leaf',
			'ifs-icon far fa-leaf' => 'leaf',
			'ifs-icon fal fa-leaf' => 'leaf',
			'ifs-icon fab fa-lastfm-square' => 'lastfm-square',
			'ifs-icon fab fa-lastfm' => 'lastfm',
			'ifs-icon fab fa-laravel' => 'laravel',
			'ifs-icon fas fa-laptop' => 'laptop',
			'ifs-icon far fa-laptop' => 'laptop',
			'ifs-icon fal fa-laptop' => 'laptop',
			'ifs-icon fas fa-language' => 'language',
			'ifs-icon far fa-language' => 'language',
			'ifs-icon fal fa-language' => 'language',
			'ifs-icon fas fa-lamp' => 'lamp',
			'ifs-icon far fa-lamp' => 'lamp',
			'ifs-icon fal fa-lamp' => 'lamp',
			'ifs-icon fab fa-korvue' => 'korvue',
			'ifs-icon fab fa-kickstarter-k' => 'kickstarter-k',
			'ifs-icon fab fa-kickstarter' => 'kickstarter',
			'ifs-icon fab fa-keycdn' => 'keycdn',
			'ifs-icon fas fa-keyboard' => 'keyboard',
			'ifs-icon far fa-keyboard' => 'keyboard',
			'ifs-icon fal fa-keyboard' => 'keyboard',
			'ifs-icon fab fa-keybase' => 'keybase',
			'ifs-icon fas fa-key' => 'key',
			'ifs-icon far fa-key' => 'key',
			'ifs-icon fal fa-key' => 'key',
			'ifs-icon fab fa-jsfiddle' => 'jsfiddle',
			'ifs-icon fab fa-js-square' => 'js-square',
			'ifs-icon fab fa-js' => 'js',
			'ifs-icon fab fa-joomla' => 'joomla',
			'ifs-icon fab fa-joget' => 'joget',
			'ifs-icon fab fa-jenkins' => 'jenkins',
			'ifs-icon fab fa-jedi-orderjedi' => '',
			'ifs-icon fab fa-java' => 'java',
			'ifs-icon fas fa-jack-o-lantern' => 'jack-o-lantern',
			'ifs-icon far fa-jack-o-lantern' => 'jack-o-lantern',
			'ifs-icon fal fa-jack-o-lantern' => 'jack-o-lantern',
			'ifs-icon fab fa-itunes-note' => 'itunes-note',
			'ifs-icon fab fa-itunes' => 'itunes',
			'ifs-icon fas fa-italic' => 'italic',
			'ifs-icon far fa-italic' => 'italic',
			'ifs-icon fal fa-italic' => 'italic',
			'ifs-icon fab fa-ioxhost' => 'ioxhost',
			'ifs-icon fas fa-inventory' => 'inventory',
			'ifs-icon far fa-inventory' => 'inventory',
			'ifs-icon fal fa-inventory' => 'inventory',
			'ifs-icon fab fa-internet-explorer' => 'internet-explorer',
			'ifs-icon fab fa-instagram' => 'instagram',
			'ifs-icon fas fa-info-square' => 'info-square',
			'ifs-icon far fa-info-square' => 'info-square',
			'ifs-icon fal fa-info-square' => 'info-square',
			'ifs-icon fas fa-info-circle' => 'info-circle',
			'ifs-icon far fa-info-circle' => 'info-circle',
			'ifs-icon fal fa-info-circle' => 'info-circle',
			'ifs-icon fas fa-info' => 'info',
			'ifs-icon far fa-info' => 'info',
			'ifs-icon fal fa-info' => 'info',
			'ifs-icon fas fa-industry-alt' => 'industry-alt',
			'ifs-icon far fa-industry-alt' => 'industry-alt',
			'ifs-icon fal fa-industry-alt' => 'industry-alt',
			'ifs-icon fas fa-industry' => 'industry',
			'ifs-icon far fa-industry' => 'industry',
			'ifs-icon fal fa-industry' => 'industry',
			'ifs-icon fas fa-indent' => 'indent',
			'ifs-icon far fa-indent' => 'indent',
			'ifs-icon fal fa-indent' => 'indent',
			'ifs-icon fas fa-inbox-out' => 'inbox-out',
			'ifs-icon far fa-inbox-out' => 'inbox-out',
			'ifs-icon fal fa-inbox-out' => 'inbox-out',
			'ifs-icon fas fa-inbox-in' => 'inbox-in',
			'ifs-icon far fa-inbox-in' => 'inbox-in',
			'ifs-icon fal fa-inbox-in' => 'inbox-in',
			'ifs-icon fas fa-inbox' => 'inbox',
			'ifs-icon far fa-inbox' => 'inbox',
			'ifs-icon fal fa-inbox' => 'inbox',
			'ifs-icon fab fa-imdb' => 'imdb',
			'ifs-icon fas fa-images' => 'images',
			'ifs-icon far fa-images' => 'images',
			'ifs-icon fal fa-images' => 'images',
			'ifs-icon fas fa-image' => 'image',
			'ifs-icon far fa-image' => 'image',
			'ifs-icon fal fa-image' => 'image',
			'ifs-icon fas fa-id-card-alt' => 'id-card-alt',
			'ifs-icon far fa-id-card-alt' => 'id-card-alt',
			'ifs-icon fal fa-id-card-alt' => 'id-card-alt',
			'ifs-icon fas fa-id-card' => 'id-card',
			'ifs-icon far fa-id-card' => 'id-card',
			'ifs-icon fal fa-id-card' => 'id-card',
			'ifs-icon fas fa-id-badge' => 'id-badge',
			'ifs-icon far fa-id-badge' => 'id-badge',
			'ifs-icon fal fa-id-badge' => 'id-badge',
			'ifs-icon fas fa-i-cursor' => 'i-cursor',
			'ifs-icon far fa-i-cursor' => 'i-cursor',
			'ifs-icon fal fa-i-cursor' => 'i-cursor',
			'ifs-icon fab fa-hubspot' => 'hubspot',
			'ifs-icon fab fa-html5' => 'html5',
			'ifs-icon fab fa-houzz' => 'houzz',
			'ifs-icon fas fa-hourglass-start' => 'hourglass-start',
			'ifs-icon far fa-hourglass-start' => 'hourglass-start',
			'ifs-icon fal fa-hourglass-start' => 'hourglass-start',
			'ifs-icon fas fa-hourglass-half' => 'hourglass-half',
			'ifs-icon far fa-hourglass-half' => 'hourglass-half',
			'ifs-icon fal fa-hourglass-half' => 'hourglass-half',
			'ifs-icon fas fa-hourglass-end' => 'hourglass-end',
			'ifs-icon far fa-hourglass-end' => 'hourglass-end',
			'ifs-icon fal fa-hourglass-end' => 'hourglass-end',
			'ifs-icon fas fa-hourglass' => 'hourglass',
			'ifs-icon far fa-hourglass' => 'hourglass',
			'ifs-icon fal fa-hourglass' => 'hourglass',
			'ifs-icon fab fa-hotjar' => 'hotjar',
			'ifs-icon fas fa-hospital-symbol' => 'hospital-symbol',
			'ifs-icon far fa-hospital-symbol' => 'hospital-symbol',
			'ifs-icon fal fa-hospital-symbol' => 'hospital-symbol',
			'ifs-icon fas fa-hospital-alt' => 'hospital-alt',
			'ifs-icon far fa-hospital-alt' => 'hospital-alt',
			'ifs-icon fal fa-hospital-alt' => 'hospital-alt',
			'ifs-icon fas fa-hospital' => 'hospital',
			'ifs-icon far fa-hospital' => 'hospital',
			'ifs-icon fal fa-hospital' => 'hospital',
			'ifs-icon fab fa-hooli' => 'hooli',
			'ifs-icon fas fa-home-heart' => 'home-heart',
			'ifs-icon far fa-home-heart' => 'home-heart',
			'ifs-icon fal fa-home-heart' => 'home-heart',
			'ifs-icon fas fa-home' => 'home',
			'ifs-icon far fa-home' => 'home',
			'ifs-icon fal fa-home' => 'home',
			'ifs-icon fas fa-hockey-sticks' => 'hockey-sticks',
			'ifs-icon far fa-hockey-sticks' => 'hockey-sticks',
			'ifs-icon fal fa-hockey-sticks' => 'hockey-sticks',
			'ifs-icon fas fa-hockey-puck' => 'hockey-puck',
			'ifs-icon far fa-hockey-puck' => 'hockey-puck',
			'ifs-icon fal fa-hockey-puck' => 'hockey-puck',
			'ifs-icon fas fa-history' => 'history',
			'ifs-icon far fa-history' => 'history',
			'ifs-icon fal fa-history' => 'history',
			'ifs-icon fab fa-hire-a-helper' => 'hire-a-helper',
			'ifs-icon fab fa-hips' => 'hips',
			'ifs-icon fas fa-hexagon' => 'hexagon',
			'ifs-icon far fa-hexagon' => 'hexagon',
			'ifs-icon fal fa-hexagon' => 'hexagon',
			'ifs-icon fas fa-heartbeat' => 'heartbeat',
			'ifs-icon far fa-heartbeat' => 'heartbeat',
			'ifs-icon fal fa-heartbeat' => 'heartbeat',
			'ifs-icon fas fa-heart-square' => 'heart-square',
			'ifs-icon far fa-heart-square' => 'heart-square',
			'ifs-icon fal fa-heart-square' => 'heart-square',
			'ifs-icon fas fa-heart-circle' => 'heart-circle',
			'ifs-icon far fa-heart-circle' => 'heart-circle',
			'ifs-icon fal fa-heart-circle' => 'heart-circle',
			'ifs-icon fas fa-heart' => 'heart',
			'ifs-icon far fa-heart' => 'heart',
			'ifs-icon fal fa-heart' => 'heart',
			'ifs-icon fas fa-headphones' => 'headphones',
			'ifs-icon far fa-headphones' => 'headphones',
			'ifs-icon fal fa-headphones' => 'headphones',
			'ifs-icon fas fa-heading' => 'heading',
			'ifs-icon far fa-heading' => 'heading',
			'ifs-icon fal fa-heading' => 'heading',
			'ifs-icon fas fa-hdd' => 'hdd',
			'ifs-icon far fa-hdd' => 'hdd',
			'ifs-icon fal fa-hdd' => 'hdd',
			'ifs-icon fas fa-hashtag' => 'hashtag',
			'ifs-icon far fa-hashtag' => 'hashtag',
			'ifs-icon fal fa-hashtag' => 'hashtag',
			'ifs-icon fas fa-handshake-alt' => 'handshake-alt',
			'ifs-icon far fa-handshake-alt' => 'handshake-alt',
			'ifs-icon fal fa-handshake-alt' => 'handshake-alt',
			'ifs-icon fas fa-handshake' => 'handshake',
			'ifs-icon far fa-handshake' => 'handshake',
			'ifs-icon fal fa-handshake' => 'handshake',
			'ifs-icon fas fa-hands-usd' => 'hands-usd',
			'ifs-icon far fa-hands-usd' => 'hands-usd',
			'ifs-icon fal fa-hands-usd' => 'hands-usd',
			'ifs-icon fas fa-hands-helping' => 'hands-helping',
			'ifs-icon far fa-hands-helping' => 'hands-helping',
			'ifs-icon fal fa-hands-helping' => 'hands-helping',
			'ifs-icon fas fa-hands-heart' => 'hands-heart',
			'ifs-icon far fa-hands-heart' => 'hands-heart',
			'ifs-icon fal fa-hands-heart' => 'hands-heart',
			'ifs-icon fas fa-hands' => 'hands',
			'ifs-icon far fa-hands' => 'hands',
			'ifs-icon fal fa-hands' => 'hands',
			'ifs-icon fas fa-hand-spock' => 'hand-spock',
			'ifs-icon far fa-hand-spock' => 'hand-spock',
			'ifs-icon fal fa-hand-spock' => 'hand-spock',
			'ifs-icon fas fa-hand-scissors' => 'hand-scissors',
			'ifs-icon far fa-hand-scissors' => 'hand-scissors',
			'ifs-icon fal fa-hand-scissors' => 'hand-scissors',
			'ifs-icon fas fa-hand-rock' => 'hand-rock',
			'ifs-icon far fa-hand-rock' => 'hand-rock',
			'ifs-icon fal fa-hand-rock' => 'hand-rock',
			'ifs-icon fas fa-hand-receiving' => 'hand-receiving',
			'ifs-icon far fa-hand-receiving' => 'hand-receiving',
			'ifs-icon fal fa-hand-receiving' => 'hand-receiving',
			'ifs-icon fas fa-hand-pointer' => 'hand-pointer',
			'ifs-icon far fa-hand-pointer' => 'hand-pointer',
			'ifs-icon fal fa-hand-pointer' => 'hand-pointer',
			'ifs-icon fas fa-hand-point-up' => 'hand-point-up',
			'ifs-icon far fa-hand-point-up' => 'hand-point-up',
			'ifs-icon fal fa-hand-point-up' => 'hand-point-up',
			'ifs-icon fas fa-hand-point-right' => 'hand-point-right',
			'ifs-icon far fa-hand-point-right' => 'hand-point-right',
			'ifs-icon fal fa-hand-point-right' => 'hand-point-right',
			'ifs-icon fas fa-hand-point-left' => 'hand-point-left',
			'ifs-icon far fa-hand-point-left' => 'hand-point-left',
			'ifs-icon fal fa-hand-point-left' => 'hand-point-left',
			'ifs-icon fas fa-hand-point-down' => 'hand-point-down',
			'ifs-icon far fa-hand-point-down' => 'hand-point-down',
			'ifs-icon fal fa-hand-point-down' => 'hand-point-down',
			'ifs-icon fas fa-hand-peace' => 'hand-peace',
			'ifs-icon far fa-hand-peace' => 'hand-peace',
			'ifs-icon fal fa-hand-peace' => 'hand-peace',
			'ifs-icon fas fa-hand-paper' => 'hand-paper',
			'ifs-icon far fa-hand-paper' => 'hand-paper',
			'ifs-icon fal fa-hand-paper' => 'hand-paper',
			'ifs-icon fas fa-hand-lizard' => 'hand-lizard',
			'ifs-icon far fa-hand-lizard' => 'hand-lizard',
			'ifs-icon fal fa-hand-lizard' => 'hand-lizard',
			'ifs-icon fas fa-hand-holding-water' => 'hand-holding-water',
			'ifs-icon far fa-hand-holding-water' => 'hand-holding-water',
			'ifs-icon fal fa-hand-holding-water' => 'hand-holding-water',
			'ifs-icon fas fa-hand-holding-usd' => 'hand-holding-usd',
			'ifs-icon far fa-hand-holding-usd' => 'hand-holding-usd',
			'ifs-icon fal fa-hand-holding-usd' => 'hand-holding-usd',
			'ifs-icon fas fa-hand-holding-seedling' => 'hand-holding-seedling',
			'ifs-icon far fa-hand-holding-seedling' => 'hand-holding-seedling',
			'ifs-icon fal fa-hand-holding-seedling' => 'hand-holding-seedling',
			'ifs-icon fas fa-hand-holding-heart' => 'hand-holding-heart',
			'ifs-icon far fa-hand-holding-heart' => 'hand-holding-heart',
			'ifs-icon fal fa-hand-holding-heart' => 'hand-holding-heart',
			'ifs-icon fas fa-hand-holding-box' => 'hand-holding-box',
			'ifs-icon far fa-hand-holding-box' => 'hand-holding-box',
			'ifs-icon fal fa-hand-holding-box' => 'hand-holding-box',
			'ifs-icon fas fa-hand-holding' => 'hand-holding',
			'ifs-icon far fa-hand-holding' => 'hand-holding',
			'ifs-icon fal fa-hand-holding' => 'hand-holding',
			'ifs-icon fas fa-hand-heart' => 'hand-heart',
			'ifs-icon far fa-hand-heart' => 'hand-heart',
			'ifs-icon fal fa-hand-heart' => 'hand-heart',
			'ifs-icon fab fa-hacker-news-square' => 'hacker-news-square',
			'ifs-icon fab fa-hacker-news' => 'hacker-news',
			'ifs-icon fas fa-h3' => 'h3',
			'ifs-icon far fa-h3' => 'h3',
			'ifs-icon fal fa-h3' => 'h3',
			'ifs-icon fas fa-h2' => 'h2',
			'ifs-icon far fa-h2' => 'h2',
			'ifs-icon fal fa-h2' => 'h2',
			'ifs-icon fas fa-h1' => 'h1',
			'ifs-icon far fa-h1' => 'h1',
			'ifs-icon fal fa-h1' => 'h1',
			'ifs-icon fas fa-h-square' => 'h-square',
			'ifs-icon far fa-h-square' => 'h-square',
			'ifs-icon fal fa-h-square' => 'h-square',
			'ifs-icon fab fa-gulp' => 'gulp',
			'ifs-icon fab fa-grunt' => 'grunt',
			'ifs-icon fab fa-gripfire' => 'gripfire',
			'ifs-icon fab fa-grav' => 'grav',
			'ifs-icon fab fa-gratipay' => 'gratipay',
			'ifs-icon fas fa-graduation-cap' => 'graduation-cap',
			'ifs-icon far fa-graduation-cap' => 'graduation-cap',
			'ifs-icon fal fa-graduation-cap' => 'graduation-cap',
			'ifs-icon fab fa-google-wallet' => 'google-wallet',
			'ifs-icon fab fa-google-plus-square' => 'google-plus-square',
			'ifs-icon fab fa-google-plus-g' => 'google-plus-g',
			'ifs-icon fab fa-google-plus' => 'google-plus',
			'ifs-icon fab fa-google-play' => 'google-play',
			'ifs-icon fab fa-google-drive' => 'google-drive',
			'ifs-icon fab fa-google' => 'google',
			'ifs-icon fab fa-goodreads-g' => 'goodreads-g',
			'ifs-icon fab fa-goodreads' => 'goodreads',
			'ifs-icon fas fa-golf-club' => 'golf-club',
			'ifs-icon far fa-golf-club' => 'golf-club',
			'ifs-icon fal fa-golf-club' => 'golf-club',
			'ifs-icon fas fa-golf-ball' => 'golf-ball',
			'ifs-icon far fa-golf-ball' => 'golf-ball',
			'ifs-icon fal fa-golf-ball' => 'golf-ball',
			'ifs-icon fab fa-gofore' => 'gofore',
			'ifs-icon fas fa-globe' => 'globe',
			'ifs-icon far fa-globe' => 'globe',
			'ifs-icon fal fa-globe' => 'globe',
			'ifs-icon fab fa-glide-g' => 'glide-g',
			'ifs-icon fab fa-glide' => 'glide',
			'ifs-icon fas fa-glass-martini' => 'glass-martini',
			'ifs-icon far fa-glass-martini' => 'glass-martini',
			'ifs-icon fal fa-glass-martini' => 'glass-martini',
			'ifs-icon fab fa-gitter' => 'gitter',
			'ifs-icon fab fa-gitlab' => 'gitlab',
			'ifs-icon fab fa-gitkraken' => 'gitkraken',
			'ifs-icon fab fa-github-square' => 'github-square',
			'ifs-icon fab fa-github-alt' => 'github-alt',
			'ifs-icon fab fa-github' => 'github',
			'ifs-icon fab fa-git-square' => 'git-square',
			'ifs-icon fab fa-git' => 'git',
			'ifs-icon fas fa-gift' => 'gift',
			'ifs-icon far fa-gift' => 'gift',
			'ifs-icon fal fa-gift' => 'gift',
			'ifs-icon fab fa-gg-circle' => 'gg-circle',
			'ifs-icon fab fa-gg' => 'gg',
			'ifs-icon fab fa-get-pocket' => 'get-pocket',
			'ifs-icon fas fa-genderless' => 'genderless',
			'ifs-icon far fa-genderless' => 'genderless',
			'ifs-icon fal fa-genderless' => 'genderless',
			'ifs-icon fas fa-gem' => 'gem',
			'ifs-icon far fa-gem' => 'gem',
			'ifs-icon fal fa-gem' => 'gem',
			'ifs-icon fas fa-gavel' => 'gavel',
			'ifs-icon far fa-gavel' => 'gavel',
			'ifs-icon fal fa-gavel' => 'gavel',
			'ifs-icon fas fa-gamepad' => 'gamepad',
			'ifs-icon far fa-gamepad' => 'gamepad',
			'ifs-icon fal fa-gamepad' => 'gamepad',
			'ifs-icon fab fa-galactic-senate' => 'galactic-senate',
			'ifs-icon fab fa-galactic-republic' => 'galactic-republic',
			'ifs-icon fas fa-futbol' => 'futbol',
			'ifs-icon far fa-futbol' => 'futbol',
			'ifs-icon fal fa-futbol' => 'futbol',
			'ifs-icon fab fa-fulcrum' => 'fulcrum',
			'ifs-icon fas fa-frown' => 'frown',
			'ifs-icon far fa-frown' => 'frown',
			'ifs-icon fal fa-frown' => 'frown',
			'ifs-icon fab fa-freebsd' => 'freebsd',
			'ifs-icon fab fa-free-code-camp' => 'free-code-camp',
			'ifs-icon fas fa-fragile' => 'fragile',
			'ifs-icon far fa-fragile' => 'fragile',
			'ifs-icon fal fa-fragile' => 'fragile',
			'ifs-icon fab fa-foursquare' => 'foursquare',
			'ifs-icon fas fa-forward' => 'forward',
			'ifs-icon far fa-forward' => 'forward',
			'ifs-icon fal fa-forward' => 'forward',
			'ifs-icon fab fa-forumbee' => 'forumbee',
			'ifs-icon fab fa-fort-awesome-alt' => 'fort-awesome-alt',
			'ifs-icon fab fa-fort-awesome' => 'fort-awesome',
			'ifs-icon fas fa-forklift' => 'forklift',
			'ifs-icon far fa-forklift' => 'forklift',
			'ifs-icon fal fa-forklift' => 'forklift',
			'ifs-icon fas fa-football-helmet' => 'football-helmet',
			'ifs-icon far fa-football-helmet' => 'football-helmet',
			'ifs-icon fal fa-football-helmet' => 'football-helmet',
			'ifs-icon fas fa-football-ball' => 'football-ball',
			'ifs-icon far fa-football-ball' => 'football-ball',
			'ifs-icon fal fa-football-ball' => 'football-ball',
			'ifs-icon fab fa-fonticons-fi' => 'fonticons-fi',
			'ifs-icon fab fa-fonticons' => 'fonticons',
			'ifs-icon fas fa-font-awesome-logo-full' => 'font-awesome-logo-full',
			'ifs-icon far fa-font-awesome-logo-full' => 'font-awesome-logo-full',
			'ifs-icon fal fa-font-awesome-logo-full' => 'font-awesome-logo-full',
			'ifs-icon fab fa-font-awesome-logo-full' => 'font-awesome-logo-full',
			'ifs-icon fab fa-font-awesome-flag' => 'font-awesome-flag',
			'ifs-icon fab fa-font-awesome-alt' => 'font-awesome-alt',
			'ifs-icon fab fa-font-awesome' => 'font-awesome',
			'ifs-icon fas fa-font' => 'font',
			'ifs-icon far fa-font' => 'font',
			'ifs-icon fal fa-font' => 'font',
			'ifs-icon fas fa-folder-open' => 'folder-open',
			'ifs-icon far fa-folder-open' => 'folder-open',
			'ifs-icon fal fa-folder-open' => 'folder-open',
			'ifs-icon fas fa-folder' => 'folder',
			'ifs-icon far fa-folder' => 'folder',
			'ifs-icon fal fa-folder' => 'folder',
			'ifs-icon fab fa-fly' => 'fly',
			'ifs-icon fab fa-flipboard' => 'flipboard',
			'ifs-icon fab fa-flickr' => 'flickr',
			'ifs-icon fas fa-flask' => 'flask',
			'ifs-icon far fa-flask' => 'flask',
			'ifs-icon fal fa-flask' => 'flask',
			'ifs-icon fas fa-flag-checkered' => 'flag-checkered',
			'ifs-icon far fa-flag-checkered' => 'flag-checkered',
			'ifs-icon fal fa-flag-checkered' => 'flag-checkered',
			'ifs-icon fas fa-flag' => 'flag',
			'ifs-icon far fa-flag' => 'flag',
			'ifs-icon fal fa-flag' => 'flag',
			'ifs-icon fab fa-firstdraft' => 'firstdraft',
			'ifs-icon fab fa-first-order-alt' => 'first-order-alt',
			'ifs-icon fab fa-first-order' => 'first-order',
			'ifs-icon fas fa-first-aid' => 'first-aid',
			'ifs-icon far fa-first-aid' => 'first-aid',
			'ifs-icon fal fa-first-aid' => 'first-aid',
			'ifs-icon fab fa-firefox' => 'firefox',
			'ifs-icon fas fa-fire-extinguisher' => 'fire-extinguisher',
			'ifs-icon far fa-fire-extinguisher' => 'fire-extinguisher',
			'ifs-icon fal fa-fire-extinguisher' => 'fire-extinguisher',
			'ifs-icon fas fa-fire' => 'fire',
			'ifs-icon far fa-fire' => 'fire',
			'ifs-icon fal fa-fire' => 'fire',
			'ifs-icon fas fa-filter' => 'filter',
			'ifs-icon far fa-filter' => 'filter',
			'ifs-icon fal fa-filter' => 'filter',
			'ifs-icon fas fa-film-alt' => 'film-alt',
			'ifs-icon far fa-film-alt' => 'film-alt',
			'ifs-icon fal fa-film-alt' => 'film-alt',
			'ifs-icon fas fa-film' => 'film',
			'ifs-icon far fa-film' => 'film',
			'ifs-icon fal fa-film' => 'film',
			'ifs-icon fas fa-file-word' => 'file-word',
			'ifs-icon far fa-file-word' => 'file-word',
			'ifs-icon fal fa-file-word' => 'file-word',
			'ifs-icon fas fa-file-video' => 'file-video',
			'ifs-icon far fa-file-video' => 'file-video',
			'ifs-icon fal fa-file-video' => 'file-video',
			'ifs-icon fas fa-file-times' => 'file-times',
			'ifs-icon far fa-file-times' => 'file-times',
			'ifs-icon fal fa-file-times' => 'file-times',
			'ifs-icon fas fa-file-powerpoint' => 'file-powerpoint',
			'ifs-icon far fa-file-powerpoint' => 'file-powerpoint',
			'ifs-icon fal fa-file-powerpoint' => 'file-powerpoint',
			'ifs-icon fas fa-file-plus' => 'file-plus',
			'ifs-icon far fa-file-plus' => 'file-plus',
			'ifs-icon fal fa-file-plus' => 'file-plus',
			'ifs-icon fas fa-file-pdf' => 'file-pdf',
			'ifs-icon far fa-file-pdf' => 'file-pdf',
			'ifs-icon fal fa-file-pdf' => 'file-pdf',
			'ifs-icon fas fa-file-minus' => 'file-minus',
			'ifs-icon far fa-file-minus' => 'file-minus',
			'ifs-icon fal fa-file-minus' => 'file-minus',
			'ifs-icon fas fa-file-medical-alt' => 'file-medical-alt',
			'ifs-icon far fa-file-medical-alt' => 'file-medical-alt',
			'ifs-icon fal fa-file-medical-alt' => 'file-medical-alt',
			'ifs-icon fas fa-file-medical' => 'file-medical',
			'ifs-icon far fa-file-medical' => 'file-medical',
			'ifs-icon fal fa-file-medical' => 'file-medical',
			'ifs-icon fas fa-file-image' => 'file-image',
			'ifs-icon far fa-file-image' => 'file-image',
			'ifs-icon fal fa-file-image' => 'file-image',
			'ifs-icon fas fa-file-exclamation' => 'file-exclamation',
			'ifs-icon far fa-file-exclamation' => 'file-exclamation',
			'ifs-icon fal fa-file-exclamation' => 'file-exclamation',
			'ifs-icon fas fa-file-excel' => 'file-excel',
			'ifs-icon far fa-file-excel' => 'file-excel',
			'ifs-icon fal fa-file-excel' => 'file-excel',
			'ifs-icon fas fa-file-edit' => 'file-edit',
			'ifs-icon far fa-file-edit' => 'file-edit',
			'ifs-icon fal fa-file-edit' => 'file-edit',
			'ifs-icon fas fa-file-code' => 'file-code',
			'ifs-icon far fa-file-code' => 'file-code',
			'ifs-icon fal fa-file-code' => 'file-code',
			'ifs-icon fas fa-file-check' => 'file-check',
			'ifs-icon far fa-file-check' => 'file-check',
			'ifs-icon fal fa-file-check' => 'file-check',
			'ifs-icon fas fa-file-audio' => 'file-audio',
			'ifs-icon far fa-file-audio' => 'file-audio',
			'ifs-icon fal fa-file-audio' => 'file-audio',
			'ifs-icon fas fa-file-archive' => 'file-archive',
			'ifs-icon far fa-file-archive' => 'file-archive',
			'ifs-icon fal fa-file-archive' => 'file-archive',
			'ifs-icon fas fa-file-alt' => 'file-alt',
			'ifs-icon far fa-file-alt' => 'file-alt',
			'ifs-icon fal fa-file-alt' => 'file-alt',
			'ifs-icon fas fa-file' => 'file',
			'ifs-icon far fa-file' => 'file',
			'ifs-icon fal fa-file' => 'file',
			'ifs-icon fas fa-fighter-jet' => 'fighter-jet',
			'ifs-icon far fa-fighter-jet' => 'fighter-jet',
			'ifs-icon fal fa-fighter-jet' => 'fighter-jet',
			'ifs-icon fas fa-field-hockey' => 'field-hockey',
			'ifs-icon far fa-field-hockey' => 'field-hockey',
			'ifs-icon fal fa-field-hockey' => 'field-hockey',
			'ifs-icon fas fa-female' => 'female',
			'ifs-icon far fa-female' => 'female',
			'ifs-icon fal fa-female' => 'female',
			'ifs-icon fas fa-fax' => 'fax',
			'ifs-icon far fa-fax' => 'fax',
			'ifs-icon fal fa-fax' => 'fax',
			'ifs-icon fas fa-fast-forward' => 'fast-forward',
			'ifs-icon far fa-fast-forward' => 'fast-forward',
			'ifs-icon fal fa-fast-forward' => 'fast-forward',
			'ifs-icon fas fa-fast-backward' => 'fast-backward',
			'ifs-icon far fa-fast-backward' => 'fast-backward',
			'ifs-icon fal fa-fast-backward' => 'fast-backward',
			'ifs-icon fab fa-facebook-square' => 'facebook-square',
			'ifs-icon fab fa-facebook-messenger' => 'facebook-messenger',
			'ifs-icon fab fa-facebook-f' => 'facebook-f',
			'ifs-icon fab fa-facebook' => 'facebook',
			'ifs-icon fab fa-youtube' => 'youtube',
			'ifs-icon fab fa-youtube-square' => 'youtube-square',
			'ifs-icon fas fa-eye-slash' => 'eye-slash',
			'ifs-icon far fa-eye-slash' => 'eye-slash',
			'ifs-icon fal fa-eye-slash' => 'eye-slash',
			'ifs-icon fas fa-eye-dropper' => 'eye-dropper',
			'ifs-icon far fa-eye-dropper' => 'eye-dropper',
			'ifs-icon fal fa-eye-dropper' => 'eye-dropper',
			'ifs-icon fas fa-eye' => 'eye',
			'ifs-icon far fa-eye' => 'eye',
			'ifs-icon fal fa-eye' => 'eye',
			'ifs-icon fas fa-external-link-square-alt' => 'external-link-square-alt',
			'ifs-icon far fa-external-link-square-alt' => 'external-link-square-alt',
			'ifs-icon fal fa-external-link-square-alt' => 'external-link-square-alt',
			'ifs-icon fas fa-external-link-square' => 'external-link-square',
			'ifs-icon far fa-external-link-square' => 'external-link-square',
			'ifs-icon fal fa-external-link-square' => 'external-link-square',
			'ifs-icon fas fa-external-link-alt' => 'external-link-alt',
			'ifs-icon far fa-external-link-alt' => 'external-link-alt',
			'ifs-icon fal fa-external-link-alt' => 'external-link-alt',
			'ifs-icon fas fa-external-link' => 'external-link',
			'ifs-icon far fa-external-link' => 'external-link',
			'ifs-icon fal fa-external-link' => 'external-link',
			'ifs-icon fab fa-expeditedssl' => 'expeditedssl',
			'ifs-icon fas fa-expand-wide' => 'expand-wide',
			'ifs-icon far fa-expand-wide' => 'expand-wide',
			'ifs-icon fal fa-expand-wide' => 'expand-wide',
			'ifs-icon fas fa-expand-arrows-alt' => 'expand-arrows-alt',
			'ifs-icon far fa-expand-arrows-alt' => 'expand-arrows-alt',
			'ifs-icon fal fa-expand-arrows-alt' => 'expand-arrows-alt',
			'ifs-icon fas fa-expand-arrows' => 'expand-arrows',
			'ifs-icon far fa-expand-arrows' => 'expand-arrows',
			'ifs-icon fal fa-expand-arrows' => 'expand-arrows',
			'ifs-icon fas fa-expand-alt' => 'expand-alt',
			'ifs-icon far fa-expand-alt' => 'expand-alt',
			'ifs-icon fal fa-expand-alt' => 'expand-alt',
			'ifs-icon fas fa-expand' => 'expand',
			'ifs-icon far fa-expand' => 'expand',
			'ifs-icon fal fa-expand' => 'expand',
			'ifs-icon fas fa-exclamation-triangle' => 'exclamation-triangle',
			'ifs-icon far fa-exclamation-triangle' => 'exclamation-triangle',
			'ifs-icon fal fa-exclamation-triangle' => 'exclamation-triangle',
			'ifs-icon fas fa-exclamation-square' => 'exclamation-square',
			'ifs-icon far fa-exclamation-square' => 'exclamation-square',
			'ifs-icon fal fa-exclamation-square' => 'exclamation-square',
			'ifs-icon fas fa-exclamation-circle' => 'exclamation-circle',
			'ifs-icon far fa-exclamation-circle' => 'exclamation-circle',
			'ifs-icon fal fa-exclamation-circle' => 'exclamation-circle',
			'ifs-icon fas fa-exclamation' => 'exclamation',
			'ifs-icon far fa-exclamation' => 'exclamation',
			'ifs-icon fal fa-exclamation' => 'exclamation',
			'ifs-icon fas fa-exchange-alt' => 'exchange-alt',
			'ifs-icon far fa-exchange-alt' => 'exchange-alt',
			'ifs-icon fal fa-exchange-alt' => 'exchange-alt',
			'ifs-icon fas fa-exchange' => 'exchange',
			'ifs-icon far fa-exchange' => 'exchange',
			'ifs-icon fal fa-exchange' => 'exchange',
			'ifs-icon fas fa-euro-sign' => 'euro-sign',
			'ifs-icon far fa-euro-sign' => 'euro-sign',
			'ifs-icon fal fa-euro-sign' => 'euro-sign',
			'ifs-icon fab fa-etsy' => 'etsy',
			'ifs-icon fab fa-ethereum' => 'ethereum',
			'ifs-icon fab fa-erlang' => 'erlang',
			'ifs-icon fas fa-eraser' => 'eraser',
			'ifs-icon far fa-eraser' => 'eraser',
			'ifs-icon fal fa-eraser' => 'eraser',
			'ifs-icon fab fa-envira' => 'envira',
			'ifs-icon fas fa-envelope-square' => 'envelope-square',
			'ifs-icon far fa-envelope-square' => 'envelope-square',
			'ifs-icon fal fa-envelope-square' => 'envelope-square',
			'ifs-icon fas fa-envelope-open' => 'envelope-open',
			'ifs-icon far fa-envelope-open' => 'envelope-open',
			'ifs-icon fal fa-envelope-open' => 'envelope-open',
			'ifs-icon fas fa-envelope' => 'envelope',
			'ifs-icon far fa-envelope' => 'envelope',
			'ifs-icon fal fa-envelope' => 'envelope',
			'ifs-icon fab fa-empire' => 'empire',
			'ifs-icon fab fa-ember' => 'ember',
			'ifs-icon fas fa-ellipsis-v-alt' => 'ellipsis-v-alt',
			'ifs-icon far fa-ellipsis-v-alt' => 'ellipsis-v-alt',
			'ifs-icon fal fa-ellipsis-v-alt' => 'ellipsis-v-alt',
			'ifs-icon fas fa-ellipsis-v' => 'ellipsis-v',
			'ifs-icon far fa-ellipsis-v' => 'ellipsis-v',
			'ifs-icon fal fa-ellipsis-v' => 'ellipsis-v',
			'ifs-icon fas fa-ellipsis-h-alt' => 'ellipsis-h-alt',
			'ifs-icon far fa-ellipsis-h-alt' => 'ellipsis-h-alt',
			'ifs-icon fal fa-ellipsis-h-alt' => 'ellipsis-h-alt',
			'ifs-icon fas fa-ellipsis-h' => 'ellipsis-h',
			'ifs-icon far fa-ellipsis-h' => 'ellipsis-h',
			'ifs-icon fal fa-ellipsis-h' => 'ellipsis-h',
			'ifs-icon fab fa-elementor' => 'elementor',
			'ifs-icon fas fa-eject' => 'eject',
			'ifs-icon far fa-eject' => 'eject',
			'ifs-icon fal fa-eject' => 'eject',
			'ifs-icon fas fa-edit' => 'edit',
			'ifs-icon far fa-edit' => 'edit',
			'ifs-icon fal fa-edit' => 'edit',
			'ifs-icon fab fa-edge' => 'edge',
			'ifs-icon fab fa-ebay' => 'ebay',
			'ifs-icon fab fa-earlybirds' => 'earlybirds',
			'ifs-icon fab fa-dyalog' => 'dyalog',
			'ifs-icon fas fa-dumbbell' => 'dumbbell',
			'ifs-icon far fa-dumbbell' => 'dumbbell',
			'ifs-icon fal fa-dumbbell' => 'dumbbell',
			'ifs-icon fab fa-drupal' => 'drupal',
			'ifs-icon fab fa-dropbox' => 'dropbox',
			'ifs-icon fab fa-dribbble-square' => 'dribbble-square',
			'ifs-icon fab fa-dribbble' => 'dribbble',
			'ifs-icon fab fa-draft2digital' => 'draft2digital',
			'ifs-icon fas fa-download' => 'download',
			'ifs-icon far fa-download' => 'download',
			'ifs-icon fal fa-download' => 'download',
			'ifs-icon fas fa-dove' => 'dove',
			'ifs-icon far fa-dove' => 'dove',
			'ifs-icon fal fa-dove' => 'dove',
			'ifs-icon fas fa-dot-circle' => 'dot-circle',
			'ifs-icon far fa-dot-circle' => 'dot-circle',
			'ifs-icon fal fa-dot-circle' => 'dot-circle',
			'ifs-icon fas fa-donate' => 'donate',
			'ifs-icon far fa-donate' => 'donate',
			'ifs-icon fal fa-donate' => 'donate',
			'ifs-icon fas fa-dolly-flatbed-empty' => 'dolly-flatbed-empty',
			'ifs-icon far fa-dolly-flatbed-empty' => 'dolly-flatbed-empty',
			'ifs-icon fal fa-dolly-flatbed-empty' => 'dolly-flatbed-empty',
			'ifs-icon fas fa-dolly-flatbed-alt' => 'dolly-flatbed-alt',
			'ifs-icon far fa-dolly-flatbed-alt' => 'dolly-flatbed-alt',
			'ifs-icon fal fa-dolly-flatbed-alt' => 'dolly-flatbed-alt',
			'ifs-icon fas fa-dolly-flatbed' => 'dolly-flatbed',
			'ifs-icon far fa-dolly-flatbed' => 'dolly-flatbed',
			'ifs-icon fal fa-dolly-flatbed' => 'dolly-flatbed',
			'ifs-icon fas fa-dolly-empty' => 'dolly-empty',
			'ifs-icon far fa-dolly-empty' => 'dolly-empty',
			'ifs-icon fal fa-dolly-empty' => 'dolly-empty',
			'ifs-icon fas fa-dolly' => 'dolly',
			'ifs-icon far fa-dolly' => 'dolly',
			'ifs-icon fal fa-dolly' => 'dolly',
			'ifs-icon fas fa-dollar-sign' => 'dollar-sign',
			'ifs-icon far fa-dollar-sign' => 'dollar-sign',
			'ifs-icon fal fa-dollar-sign' => 'dollar-sign',
			'ifs-icon fab fa-docker' => 'docker',
			'ifs-icon fab fa-dochub' => 'dochub',
			'ifs-icon fas fa-dna' => 'dna',
			'ifs-icon far fa-dna' => 'dna',
			'ifs-icon fal fa-dna' => 'dna',
			'ifs-icon fab fa-discourse' => 'discourse',
			'ifs-icon fab fa-discord' => 'discord',
			'ifs-icon fab fa-digital-ocean' => 'digital-ocean',
			'ifs-icon fab fa-digg' => 'digg',
			'ifs-icon fas fa-diamond' => 'diamond',
			'ifs-icon far fa-diamond' => 'diamond',
			'ifs-icon fal fa-diamond' => 'diamond',
			'ifs-icon fas fa-diagnoses' => 'diagnoses',
			'ifs-icon far fa-diagnoses' => 'diagnoses',
			'ifs-icon fal fa-diagnoses' => 'diagnoses',
			'ifs-icon fab fa-deviantart' => 'deviantart',
			'ifs-icon fas fa-desktop-alt' => 'desktop-alt',
			'ifs-icon far fa-desktop-alt' => 'desktop-alt',
			'ifs-icon fal fa-desktop-alt' => 'desktop-alt',
			'ifs-icon fas fa-desktop' => 'desktop',
			'ifs-icon far fa-desktop' => 'desktop',
			'ifs-icon fal fa-desktop' => 'desktop',
			'ifs-icon fab fa-deskpro' => 'deskpro',
			'ifs-icon fab fa-deploydog' => 'deploydog',
			'ifs-icon fab fa-delicious' => 'delicious',
			'ifs-icon fas fa-deaf' => 'deaf',
			'ifs-icon far fa-deaf' => 'deaf',
			'ifs-icon fal fa-deaf' => 'deaf',
			'ifs-icon fas fa-database' => 'database',
			'ifs-icon far fa-database' => 'database',
			'ifs-icon fal fa-database' => 'database',
			'ifs-icon fab fa-dashcube' => 'dashcube',
			'ifs-icon fab fa-d-and-d' => 'd-and-d',
			'ifs-icon fab fa-cuttlefish' => 'cuttlefish',
			'ifs-icon fas fa-cut' => 'cut',
			'ifs-icon far fa-cut' => 'cut',
			'ifs-icon fal fa-cut' => 'cut',
			'ifs-icon fas fa-curling' => 'curling',
			'ifs-icon far fa-curling' => 'curling',
			'ifs-icon fal fa-curling' => 'curling',
			'ifs-icon fas fa-cubes' => 'cubes',
			'ifs-icon far fa-cubes' => 'cubes',
			'ifs-icon fal fa-cubes' => 'cubes',
			'ifs-icon fas fa-cube' => 'cube',
			'ifs-icon far fa-cube' => 'cube',
			'ifs-icon fal fa-cube' => 'cube',
			'ifs-icon fab fa-css3-alt' => 'css3-alt',
			'ifs-icon fab fa-css3' => 'css3',
			'ifs-icon fas fa-crosshairs' => 'crosshairs',
			'ifs-icon far fa-crosshairs' => 'crosshairs',
			'ifs-icon fal fa-crosshairs' => 'crosshairs',
			'ifs-icon fas fa-crop' => 'crop',
			'ifs-icon far fa-crop' => 'crop',
			'ifs-icon fal fa-crop' => 'crop',
			'ifs-icon fas fa-cricket' => 'cricket',
			'ifs-icon far fa-cricket' => 'cricket',
			'ifs-icon fal fa-cricket' => 'cricket',
			'ifs-icon fas fa-credit-card-front' => 'credit-card-front',
			'ifs-icon far fa-credit-card-front' => 'credit-card-front',
			'ifs-icon fal fa-credit-card-front' => 'credit-card-front',
			'ifs-icon fas fa-credit-card-blank' => 'credit-card-blank',
			'ifs-icon far fa-credit-card-blank' => 'credit-card-blank',
			'ifs-icon fal fa-credit-card-blank' => 'credit-card-blank',
			'ifs-icon fas fa-credit-card' => 'credit-card',
			'ifs-icon far fa-credit-card' => 'credit-card',
			'ifs-icon fal fa-credit-card' => 'credit-card',
			'ifs-icon fab fa-creative-commons-zero' => 'creative-commons-zero',
			'ifs-icon fab fa-creative-commons-share' => 'creative-commons-share',
			'ifs-icon fab fa-creative-commons-sampling-plus' => 'creative-commons-sampling-plus',
			'ifs-icon fab fa-creative-commons-sampling' => 'creative-commons-sampling',
			'ifs-icon fab fa-creative-commons-sa' => 'creative-commons-sa',
			'ifs-icon fab fa-creative-commons-remix' => 'creative-commons-remix',
			'ifs-icon fab fa-creative-commons-pd-alt' => 'creative-commons-pd-alt',
			'ifs-icon fab fa-creative-commons-pd' => 'creative-commons-pd',
			'ifs-icon fab fa-creative-commons-nd' => 'creative-commons-nd',
			'ifs-icon fab fa-creative-commons-nc-jp' => 'creative-commons-nc-jp',
			'ifs-icon fab fa-creative-commons-nc-eu' => 'creative-commons-nc-eu',
			'ifs-icon fab fa-creative-commons-nc' => 'creative-commons-nc',
			'ifs-icon fab fa-creative-commons-by' => 'creative-commons-by',
			'ifs-icon fab fa-creative-commons' => 'creative-commons',
			'ifs-icon fab fa-cpanel' => 'cpanel',
			'ifs-icon fas fa-couch' => 'couch',
			'ifs-icon far fa-couch' => 'couch',
			'ifs-icon fal fa-couch' => 'couch',
			'ifs-icon fas fa-copyright' => 'copyright',
			'ifs-icon far fa-copyright' => 'copyright',
			'ifs-icon fal fa-copyright' => 'copyright',
			'ifs-icon fas fa-copy' => 'copy',
			'ifs-icon far fa-copy' => 'copy',
			'ifs-icon fal fa-copy' => 'copy',
			'ifs-icon fas fa-conveyor-belt-alt' => 'conveyor-belt-alt',
			'ifs-icon far fa-conveyor-belt-alt' => 'conveyor-belt-alt',
			'ifs-icon fal fa-conveyor-belt-alt' => 'conveyor-belt-alt',
			'ifs-icon fas fa-conveyor-belt' => 'conveyor-belt',
			'ifs-icon far fa-conveyor-belt' => 'conveyor-belt',
			'ifs-icon fal fa-conveyor-belt' => 'conveyor-belt',
			'ifs-icon fab fa-contao' => 'contao',
			'ifs-icon fas fa-container-storage' => 'container-storage',
			'ifs-icon far fa-container-storage' => 'container-storage',
			'ifs-icon fal fa-container-storage' => 'container-storage',
			'ifs-icon fab fa-connectdevelop' => 'connectdevelop',
			'ifs-icon fas fa-compress-wide' => 'compress-wide',
			'ifs-icon far fa-compress-wide' => 'compress-wide',
			'ifs-icon fal fa-compress-wide' => 'compress-wide',
			'ifs-icon fas fa-compress-alt' => 'compress-alt',
			'ifs-icon far fa-compress-alt' => 'compress-alt',
			'ifs-icon fal fa-compress-alt' => 'compress-alt',
			'ifs-icon fas fa-compress' => 'compress',
			'ifs-icon far fa-compress' => 'compress',
			'ifs-icon fal fa-compress' => 'compress',
			'ifs-icon fas fa-compass' => 'compass',
			'ifs-icon far fa-compass' => 'compass',
			'ifs-icon fal fa-compass' => 'compass',
			'ifs-icon fas fa-comments-alt' => 'comments-alt',
			'ifs-icon far fa-comments-alt' => 'comments-alt',
			'ifs-icon fal fa-comments-alt' => 'comments-alt',
			'ifs-icon fas fa-comments' => 'comments',
			'ifs-icon far fa-comments' => 'comments',
			'ifs-icon fal fa-comments' => 'comments',
			'ifs-icon fas fa-comment-times' => 'comment-times',
			'ifs-icon far fa-comment-times' => 'comment-times',
			'ifs-icon fal fa-comment-times' => 'comment-times',
			'ifs-icon fas fa-comment-smile' => 'comment-smile',
			'ifs-icon far fa-comment-smile' => 'comment-smile',
			'ifs-icon fal fa-comment-smile' => 'comment-smile',
			'ifs-icon fas fa-comment-slash' => 'comment-slash',
			'ifs-icon far fa-comment-slash' => 'comment-slash',
			'ifs-icon fal fa-comment-slash' => 'comment-slash',
			'ifs-icon fas fa-comment-plus' => 'comment-plus',
			'ifs-icon far fa-comment-plus' => 'comment-plus',
			'ifs-icon fal fa-comment-plus' => 'comment-plus',
			'ifs-icon fas fa-comment-minus' => 'comment-minus',
			'ifs-icon far fa-comment-minus' => 'comment-minus',
			'ifs-icon fal fa-comment-minus' => 'comment-minus',
			'ifs-icon fas fa-comment-lines' => 'comment-lines',
			'ifs-icon far fa-comment-lines' => 'comment-lines',
			'ifs-icon fal fa-comment-lines' => 'comment-lines',
			'ifs-icon fas fa-comment-exclamation' => 'comment-exclamation',
			'ifs-icon far fa-comment-exclamation' => 'comment-exclamation',
			'ifs-icon fal fa-comment-exclamation' => 'comment-exclamation',
			'ifs-icon fas fa-comment-edit' => 'comment-edit',
			'ifs-icon far fa-comment-edit' => 'comment-edit',
			'ifs-icon fal fa-comment-edit' => 'comment-edit',
			'ifs-icon fas fa-comment-dots' => 'comment-dots',
			'ifs-icon far fa-comment-dots' => 'comment-dots',
			'ifs-icon fal fa-comment-dots' => 'comment-dots',
			'ifs-icon fas fa-comment-check' => 'comment-check',
			'ifs-icon far fa-comment-check' => 'comment-check',
			'ifs-icon fal fa-comment-check' => 'comment-check',
			'ifs-icon fas fa-comment-alt-times' => 'comment-alt-times',
			'ifs-icon far fa-comment-alt-times' => 'comment-alt-times',
			'ifs-icon fal fa-comment-alt-times' => 'comment-alt-times',
			'ifs-icon fas fa-comment-alt-smile' => 'comment-alt-smile',
			'ifs-icon far fa-comment-alt-smile' => 'comment-alt-smile',
			'ifs-icon fal fa-comment-alt-smile' => 'comment-alt-smile',
			'ifs-icon fas fa-comment-alt-slash' => 'comment-alt-slash',
			'ifs-icon far fa-comment-alt-slash' => 'comment-alt-slash',
			'ifs-icon fal fa-comment-alt-slash' => 'comment-alt-slash',
			'ifs-icon fas fa-comment-alt-plus' => 'comment-alt-plus',
			'ifs-icon far fa-comment-alt-plus' => 'comment-alt-plus',
			'ifs-icon fal fa-comment-alt-plus' => 'comment-alt-plus',
			'ifs-icon fas fa-comment-alt-minus' => 'comment-alt-minus',
			'ifs-icon far fa-comment-alt-minus' => 'comment-alt-minus',
			'ifs-icon fal fa-comment-alt-minus' => 'comment-alt-minus',
			'ifs-icon fas fa-comment-alt-lines' => 'comment-alt-lines',
			'ifs-icon far fa-comment-alt-lines' => 'comment-alt-lines',
			'ifs-icon fal fa-comment-alt-lines' => 'comment-alt-lines',
			'ifs-icon fas fa-comment-alt-exclamation' => 'comment-alt-exclamation',
			'ifs-icon far fa-comment-alt-exclamation' => 'comment-alt-exclamation',
			'ifs-icon fal fa-comment-alt-exclamation' => 'comment-alt-exclamation',
			'ifs-icon fas fa-comment-alt-edit' => 'comment-alt-edit',
			'ifs-icon far fa-comment-alt-edit' => 'comment-alt-edit',
			'ifs-icon fal fa-comment-alt-edit' => 'comment-alt-edit',
			'ifs-icon fas fa-comment-alt-dots' => 'comment-alt-dots',
			'ifs-icon far fa-comment-alt-dots' => 'comment-alt-dots',
			'ifs-icon fal fa-comment-alt-dots' => 'comment-alt-dots',
			'ifs-icon fas fa-comment-alt-check' => 'comment-alt-check',
			'ifs-icon far fa-comment-alt-check' => 'comment-alt-check',
			'ifs-icon fal fa-comment-alt-check' => 'comment-alt-check',
			'ifs-icon fas fa-comment-alt' => 'comment-alt',
			'ifs-icon far fa-comment-alt' => 'comment-alt',
			'ifs-icon fal fa-comment-alt' => 'comment-alt',
			'ifs-icon fas fa-comment' => 'comment',
			'ifs-icon far fa-comment' => 'comment',
			'ifs-icon fal fa-comment' => 'comment',
			'ifs-icon fas fa-columns' => 'columns',
			'ifs-icon far fa-columns' => 'columns',
			'ifs-icon fal fa-columns' => 'columns',
			'ifs-icon fas fa-cogs' => 'cogs',
			'ifs-icon far fa-cogs' => 'cogs',
			'ifs-icon fal fa-cogs' => 'cogs',
			'ifs-icon fas fa-cog' => 'cog',
			'ifs-icon far fa-cog' => 'cog',
			'ifs-icon fal fa-cog' => 'cog',
			'ifs-icon fas fa-coffee' => 'coffee',
			'ifs-icon far fa-coffee' => 'coffee',
			'ifs-icon fal fa-coffee' => 'coffee',
			'ifs-icon fab fa-codiepie' => 'codiepie',
			'ifs-icon fab fa-codepen' => 'codepen',
			'ifs-icon fas fa-code-merge' => 'code-merge',
			'ifs-icon far fa-code-merge' => 'code-merge',
			'ifs-icon fal fa-code-merge' => 'code-merge',
			'ifs-icon fas fa-code-commit' => 'code-commit',
			'ifs-icon far fa-code-commit' => 'code-commit',
			'ifs-icon fal fa-code-commit' => 'code-commit',
			'ifs-icon fas fa-code-branch' => 'code-branch',
			'ifs-icon far fa-code-branch' => 'code-branch',
			'ifs-icon fal fa-code-branch' => 'code-branch',
			'ifs-icon fas fa-code' => 'code',
			'ifs-icon far fa-code' => 'code',
			'ifs-icon fal fa-code' => 'code',
			'ifs-icon fas fa-club' => 'club',
			'ifs-icon far fa-club' => 'club',
			'ifs-icon fal fa-club' => 'club',
			'ifs-icon fab fa-cloudversify' => 'cloudversify',
			'ifs-icon fab fa-cloudsmith' => 'cloudsmith',
			'ifs-icon fab fa-cloudscale' => 'cloudscale',
			'ifs-icon fas fa-cloud-upload-alt' => 'cloud-upload-alt',
			'ifs-icon far fa-cloud-upload-alt' => 'cloud-upload-alt',
			'ifs-icon fal fa-cloud-upload-alt' => 'cloud-upload-alt',
			'ifs-icon fas fa-cloud-upload' => 'cloud-upload',
			'ifs-icon far fa-cloud-upload' => 'cloud-upload',
			'ifs-icon fal fa-cloud-upload' => 'cloud-upload',
			'ifs-icon fas fa-cloud-download-alt' => 'cloud-download-alt',
			'ifs-icon far fa-cloud-download-alt' => 'cloud-download-alt',
			'ifs-icon fal fa-cloud-download-alt' => 'cloud-download-alt',
			'ifs-icon fas fa-cloud-download' => 'cloud-download',
			'ifs-icon far fa-cloud-download' => 'cloud-download',
			'ifs-icon fal fa-cloud-download' => 'cloud-download',
			'ifs-icon fas fa-cloud' => 'cloud',
			'ifs-icon far fa-cloud' => 'cloud',
			'ifs-icon fal fa-cloud' => 'cloud',
			'ifs-icon fas fa-closed-captioning' => 'closed-captioning',
			'ifs-icon far fa-closed-captioning' => 'closed-captioning',
			'ifs-icon fal fa-closed-captioning' => 'closed-captioning',
			'ifs-icon fas fa-clone' => 'clone',
			'ifs-icon far fa-clone' => 'clone',
			'ifs-icon fal fa-clone' => 'clone',
			'ifs-icon fas fa-clock' => 'clock',
			'ifs-icon far fa-clock' => 'clock',
			'ifs-icon fal fa-clock' => 'clock',
			'ifs-icon fas fa-clipboard-list' => 'clipboard-list',
			'ifs-icon far fa-clipboard-list' => 'clipboard-list',
			'ifs-icon fal fa-clipboard-list' => 'clipboard-list',
			'ifs-icon fas fa-clipboard-check' => 'clipboard-check',
			'ifs-icon far fa-clipboard-check' => 'clipboard-check',
			'ifs-icon fal fa-clipboard-check' => 'clipboard-check',
			'ifs-icon fas fa-clipboard' => 'clipboard',
			'ifs-icon far fa-clipboard' => 'clipboard',
			'ifs-icon fal fa-clipboard' => 'clipboard',
			'ifs-icon fas fa-circle-notch' => 'circle-notch',
			'ifs-icon far fa-circle-notch' => 'circle-notch',
			'ifs-icon fal fa-circle-notch' => 'circle-notch',
			'ifs-icon fas fa-circle' => 'circle',
			'ifs-icon far fa-circle' => 'circle',
			'ifs-icon fal fa-circle' => 'circle',
			'ifs-icon fab fa-chrome' => 'chrome',
			'ifs-icon fas fa-child' => 'child',
			'ifs-icon far fa-child' => 'child',
			'ifs-icon fal fa-child' => 'child',
			'ifs-icon fas fa-chevron-up' => 'chevron-up',
			'ifs-icon far fa-chevron-up' => 'chevron-up',
			'ifs-icon fal fa-chevron-up' => 'chevron-up',
			'ifs-icon fas fa-chevron-square-up' => 'chevron-square-up',
			'ifs-icon far fa-chevron-square-up' => 'chevron-square-up',
			'ifs-icon fal fa-chevron-square-up' => 'chevron-square-up',
			'ifs-icon fas fa-chevron-square-right' => 'chevron-square-right',
			'ifs-icon far fa-chevron-square-right' => 'chevron-square-right',
			'ifs-icon fal fa-chevron-square-right' => 'chevron-square-right',
			'ifs-icon fas fa-chevron-square-left' => 'chevron-square-left',
			'ifs-icon far fa-chevron-square-left' => 'chevron-square-left',
			'ifs-icon fal fa-chevron-square-left' => 'chevron-square-left',
			'ifs-icon fas fa-chevron-square-down' => 'chevron-square-down',
			'ifs-icon far fa-chevron-square-down' => 'chevron-square-down',
			'ifs-icon fal fa-chevron-square-down' => 'chevron-square-down',
			'ifs-icon fas fa-chevron-right' => 'chevron-right',
			'ifs-icon far fa-chevron-right' => 'chevron-right',
			'ifs-icon fal fa-chevron-right' => 'chevron-right',
			'ifs-icon fas fa-chevron-left' => 'chevron-left',
			'ifs-icon far fa-chevron-left' => 'chevron-left',
			'ifs-icon fal fa-chevron-left' => 'chevron-left',
			'ifs-icon fas fa-chevron-down' => 'chevron-down',
			'ifs-icon far fa-chevron-down' => 'chevron-down',
			'ifs-icon fal fa-chevron-down' => 'chevron-down',
			'ifs-icon fas fa-chevron-double-up' => 'chevron-double-up',
			'ifs-icon far fa-chevron-double-up' => 'chevron-double-up',
			'ifs-icon fal fa-chevron-double-up' => 'chevron-double-up',
			'ifs-icon fas fa-chevron-double-right' => 'chevron-double-right',
			'ifs-icon far fa-chevron-double-right' => 'chevron-double-right',
			'ifs-icon fal fa-chevron-double-right' => 'chevron-double-right',
			'ifs-icon fas fa-chevron-double-left' => 'chevron-double-left',
			'ifs-icon far fa-chevron-double-left' => 'chevron-double-left',
			'ifs-icon fal fa-chevron-double-left' => 'chevron-double-left',
			'ifs-icon fas fa-chevron-double-down' => 'chevron-double-down',
			'ifs-icon far fa-chevron-double-down' => 'chevron-double-down',
			'ifs-icon fal fa-chevron-double-down' => 'chevron-double-down',
			'ifs-icon fas fa-chevron-circle-up' => 'chevron-circle-up',
			'ifs-icon far fa-chevron-circle-up' => 'chevron-circle-up',
			'ifs-icon fal fa-chevron-circle-up' => 'chevron-circle-up',
			'ifs-icon fas fa-chevron-circle-right' => 'chevron-circle-right',
			'ifs-icon far fa-chevron-circle-right' => 'chevron-circle-right',
			'ifs-icon fal fa-chevron-circle-right' => 'chevron-circle-right',
			'ifs-icon fas fa-chevron-circle-left' => 'chevron-circle-left',
			'ifs-icon far fa-chevron-circle-left' => 'chevron-circle-left',
			'ifs-icon fal fa-chevron-circle-left' => 'chevron-circle-left',
			'ifs-icon fas fa-chevron-circle-down' => 'chevron-circle-down',
			'ifs-icon far fa-chevron-circle-down' => 'chevron-circle-down',
			'ifs-icon fal fa-chevron-circle-down' => 'chevron-circle-down',
			'ifs-icon fas fa-chess-rook-alt' => 'chess-rook-alt',
			'ifs-icon far fa-chess-rook-alt' => 'chess-rook-alt',
			'ifs-icon fal fa-chess-rook-alt' => 'chess-rook-alt',
			'ifs-icon fas fa-chess-rook' => 'chess-rook',
			'ifs-icon far fa-chess-rook' => 'chess-rook',
			'ifs-icon fal fa-chess-rook' => 'chess-rook',
			'ifs-icon fas fa-chess-queen-alt' => 'chess-queen-alt',
			'ifs-icon far fa-chess-queen-alt' => 'chess-queen-alt',
			'ifs-icon fal fa-chess-queen-alt' => 'chess-queen-alt',
			'ifs-icon fas fa-chess-queen' => 'chess-queen',
			'ifs-icon far fa-chess-queen' => 'chess-queen',
			'ifs-icon fal fa-chess-queen' => 'chess-queen',
			'ifs-icon fas fa-chess-pawn-alt' => 'chess-pawn-alt',
			'ifs-icon far fa-chess-pawn-alt' => 'chess-pawn-alt',
			'ifs-icon fal fa-chess-pawn-alt' => 'chess-pawn-alt',
			'ifs-icon fas fa-chess-pawn' => 'chess-pawn',
			'ifs-icon far fa-chess-pawn' => 'chess-pawn',
			'ifs-icon fal fa-chess-pawn' => 'chess-pawn',
			'ifs-icon fas fa-chess-knight-alt' => 'chess-knight-alt',
			'ifs-icon far fa-chess-knight-alt' => 'chess-knight-alt',
			'ifs-icon fal fa-chess-knight-alt' => 'chess-knight-alt',
			'ifs-icon fas fa-chess-knight' => 'chess-knight',
			'ifs-icon far fa-chess-knight' => 'chess-knight',
			'ifs-icon fal fa-chess-knight' => 'chess-knight',
			'ifs-icon fas fa-chess-king-alt' => 'chess-king-alt',
			'ifs-icon far fa-chess-king-alt' => 'chess-king-alt',
			'ifs-icon fal fa-chess-king-alt' => 'chess-king-alt',
			'ifs-icon fas fa-chess-king' => 'chess-king',
			'ifs-icon far fa-chess-king' => 'chess-king',
			'ifs-icon fal fa-chess-king' => 'chess-king',
			'ifs-icon fas fa-chess-clock-alt' => 'chess-clock-alt',
			'ifs-icon far fa-chess-clock-alt' => 'chess-clock-alt',
			'ifs-icon fal fa-chess-clock-alt' => 'chess-clock-alt',
			'ifs-icon fas fa-chess-clock' => 'chess-clock',
			'ifs-icon far fa-chess-clock' => 'chess-clock',
			'ifs-icon fal fa-chess-clock' => 'chess-clock',
			'ifs-icon fas fa-chess-board' => 'chess-board',
			'ifs-icon far fa-chess-board' => 'chess-board',
			'ifs-icon fal fa-chess-board' => 'chess-board',
			'ifs-icon fas fa-chess-bishop-alt' => 'chess-bishop-alt',
			'ifs-icon far fa-chess-bishop-alt' => 'chess-bishop-alt',
			'ifs-icon fal fa-chess-bishop-alt' => 'chess-bishop-alt',
			'ifs-icon fas fa-chess-bishop' => 'chess-bishop',
			'ifs-icon far fa-chess-bishop' => 'chess-bishop',
			'ifs-icon fal fa-chess-bishop' => 'chess-bishop',
			'ifs-icon fas fa-chess' => 'chess',
			'ifs-icon far fa-chess' => 'chess',
			'ifs-icon fal fa-chess' => 'chess',
			'ifs-icon fas fa-check-square' => 'check-square',
			'ifs-icon far fa-check-square' => 'check-square',
			'ifs-icon fal fa-check-square' => 'check-square',
			'ifs-icon fas fa-check-circle' => 'check-circle',
			'ifs-icon far fa-check-circle' => 'check-circle',
			'ifs-icon fal fa-check-circle' => 'check-circle',
			'ifs-icon fas fa-check' => 'check',
			'ifs-icon far fa-check' => 'check',
			'ifs-icon fal fa-check' => 'check',
			'ifs-icon fas fa-chart-pie' => 'chart-pie',
			'ifs-icon far fa-chart-pie' => 'chart-pie',
			'ifs-icon fal fa-chart-pie' => 'chart-pie',
			'ifs-icon fas fa-chart-line' => 'chart-line',
			'ifs-icon far fa-chart-line' => 'chart-line',
			'ifs-icon fal fa-chart-line' => 'chart-line',
			'ifs-icon fas fa-chart-bar' => 'chart-bar',
			'ifs-icon far fa-chart-bar' => 'chart-bar',
			'ifs-icon fal fa-chart-bar' => 'chart-bar',
			'ifs-icon fas fa-chart-area' => 'chart-area',
			'ifs-icon far fa-chart-area' => 'chart-area',
			'ifs-icon fal fa-chart-area' => 'chart-area',
			'ifs-icon fas fa-certificate' => 'certificate',
			'ifs-icon far fa-certificate' => 'certificate',
			'ifs-icon fal fa-certificate' => 'certificate',
			'ifs-icon fab fa-centercode' => 'centercode',
			'ifs-icon fab fa-cc-visa' => 'cc-visa',
			'ifs-icon fab fa-cc-stripe' => 'cc-stripe',
			'ifs-icon fab fa-cc-paypal' => 'cc-paypal',
			'ifs-icon fab fa-cc-mastercard' => 'cc-mastercard',
			'ifs-icon fab fa-cc-jcb' => 'cc-jcb',
			'ifs-icon fab fa-cc-discover' => 'cc-discover',
			'ifs-icon fab fa-cc-diners-club' => 'cc-diners-club',
			'ifs-icon fab fa-cc-apple-pay' => 'cc-apple-pay',
			'ifs-icon fab fa-cc-amex' => 'cc-amex',
			'ifs-icon fab fa-cc-amazon-pay' => 'cc-amazon-pay',
			'ifs-icon fas fa-cart-plus' => 'cart-plus',
			'ifs-icon far fa-cart-plus' => 'cart-plus',
			'ifs-icon fal fa-cart-plus' => 'cart-plus',
			'ifs-icon fas fa-cart-arrow-down' => 'cart-arrow-down',
			'ifs-icon far fa-cart-arrow-down' => 'cart-arrow-down',
			'ifs-icon fal fa-cart-arrow-down' => 'cart-arrow-down',
			'ifs-icon fas fa-caret-up' => 'caret-up',
			'ifs-icon far fa-caret-up' => 'caret-up',
			'ifs-icon fal fa-caret-up' => 'caret-up',
			'ifs-icon fas fa-caret-square-up' => 'caret-square-up',
			'ifs-icon far fa-caret-square-up' => 'caret-square-up',
			'ifs-icon fal fa-caret-square-up' => 'caret-square-up',
			'ifs-icon fas fa-caret-square-right' => 'caret-square-right',
			'ifs-icon far fa-caret-square-right' => 'caret-square-right',
			'ifs-icon fal fa-caret-square-right' => 'caret-square-right',
			'ifs-icon fas fa-caret-square-left' => 'caret-square-left',
			'ifs-icon far fa-caret-square-left' => 'caret-square-left',
			'ifs-icon fal fa-caret-square-left' => 'caret-square-left',
			'ifs-icon fas fa-caret-square-down' => 'caret-square-down',
			'ifs-icon far fa-caret-square-down' => 'caret-square-down',
			'ifs-icon fal fa-caret-square-down' => 'caret-square-down',
			'ifs-icon fas fa-caret-right' => 'caret-right',
			'ifs-icon far fa-caret-right' => 'caret-right',
			'ifs-icon fal fa-caret-right' => 'caret-right',
			'ifs-icon fas fa-caret-left' => 'caret-left',
			'ifs-icon far fa-caret-left' => 'caret-left',
			'ifs-icon fal fa-caret-left' => 'caret-left',
			'ifs-icon fas fa-caret-down' => 'caret-down',
			'ifs-icon far fa-caret-down' => 'caret-down',
			'ifs-icon fal fa-caret-down' => 'caret-down',
			'ifs-icon fas fa-caret-circle-up' => 'caret-circle-up',
			'ifs-icon far fa-caret-circle-up' => 'caret-circle-up',
			'ifs-icon fal fa-caret-circle-up' => 'caret-circle-up',
			'ifs-icon fas fa-caret-circle-right' => 'caret-circle-right',
			'ifs-icon far fa-caret-circle-right' => 'caret-circle-right',
			'ifs-icon fal fa-caret-circle-right' => 'caret-circle-right',
			'ifs-icon fas fa-caret-circle-left' => 'caret-circle-left',
			'ifs-icon far fa-caret-circle-left' => 'caret-circle-left',
			'ifs-icon fal fa-caret-circle-left' => 'caret-circle-left',
			'ifs-icon fas fa-caret-circle-down' => 'caret-circle-down',
			'ifs-icon far fa-caret-circle-down' => 'caret-circle-down',
			'ifs-icon fal fa-caret-circle-down' => 'caret-circle-down',
			'ifs-icon fas fa-car' => 'car',
			'ifs-icon far fa-car' => 'car',
			'ifs-icon fal fa-car' => 'car',
			'ifs-icon fas fa-capsules' => 'capsules',
			'ifs-icon far fa-capsules' => 'capsules',
			'ifs-icon fal fa-capsules' => 'capsules',
			'ifs-icon fas fa-camera-retro' => 'camera-retro',
			'ifs-icon far fa-camera-retro' => 'camera-retro',
			'ifs-icon fal fa-camera-retro' => 'camera-retro',
			'ifs-icon fas fa-camera-alt' => 'camera-alt',
			'ifs-icon far fa-camera-alt' => 'camera-alt',
			'ifs-icon fal fa-camera-alt' => 'camera-alt',
			'ifs-icon fas fa-camera' => 'camera',
			'ifs-icon far fa-camera' => 'camera',
			'ifs-icon fal fa-camera' => 'camera',
			'ifs-icon fas fa-calendar-times' => 'calendar-times',
			'ifs-icon far fa-calendar-times' => 'calendar-times',
			'ifs-icon fal fa-calendar-times' => 'calendar-times',
			'ifs-icon fas fa-calendar-plus' => 'calendar-plus',
			'ifs-icon far fa-calendar-plus' => 'calendar-plus',
			'ifs-icon fal fa-calendar-plus' => 'calendar-plus',
			'ifs-icon fas fa-calendar-minus' => 'calendar-minus',
			'ifs-icon far fa-calendar-minus' => 'calendar-minus',
			'ifs-icon fal fa-calendar-minus' => 'calendar-minus',
			'ifs-icon fas fa-calendar-exclamation' => 'calendar-exclamation',
			'ifs-icon far fa-calendar-exclamation' => 'calendar-exclamation',
			'ifs-icon fal fa-calendar-exclamation' => 'calendar-exclamation',
			'ifs-icon fas fa-calendar-edit' => 'calendar-edit',
			'ifs-icon far fa-calendar-edit' => 'calendar-edit',
			'ifs-icon fal fa-calendar-edit' => 'calendar-edit',
			'ifs-icon fas fa-calendar-check' => 'calendar-check',
			'ifs-icon far fa-calendar-check' => 'calendar-check',
			'ifs-icon fal fa-calendar-check' => 'calendar-check',
			'ifs-icon fas fa-calendar-alt' => 'calendar-alt',
			'ifs-icon far fa-calendar-alt' => 'calendar-alt',
			'ifs-icon fal fa-calendar-alt' => 'calendar-alt',
			'ifs-icon fas fa-calendar' => 'calendar',
			'ifs-icon far fa-calendar' => 'calendar',
			'ifs-icon fal fa-calendar' => 'calendar',
			'ifs-icon fas fa-calculator' => 'calculator',
			'ifs-icon far fa-calculator' => 'calculator',
			'ifs-icon fal fa-calculator' => 'calculator',
			'ifs-icon fab fa-buysellads' => 'buysellads',
			'ifs-icon fas fa-bus' => 'bus',
			'ifs-icon far fa-bus' => 'bus',
			'ifs-icon fal fa-bus' => 'bus'
		);

		return $icons;
	}

	/**
	 * Retrieve icons control default settings.
	 *
	 * Get the default settings of the icons control. Used to return the default
	 * settings while initializing the icons control.
	 *
	 * @since 1.0.0
	 * @access protected
	 *
	 * @return array Control default settings.
	 */

	protected function get_default_settings() {
		return [
			'options' => self::get_icons(),
		];
	}

	/**
	 * Render icons control output in the editor.
	 *
	 * Used to generate the control HTML in the editor using Underscore JS
	 * template. The variables for the class are available using `data` JS
	 * object.
	 *
	 * @since 1.0.0
	 * @access public
	 */

	public function content_template() {
		?>
		<div class="elementor-control-field">
			<label class="elementor-control-title">{{{ data.label }}}</label>
			<div class="elementor-control-input-wrapper">
				<select class="elementor-control-icon" data-setting="{{ data.name }}" data-placeholder="<?php esc_attr_e( 'Select Icon', 'chariton' ); ?>">
					<option value=""><?php esc_html_e( 'Select Icon', 'chariton' ); ?></option>
					<# _.each( data.options, function( option_title, option_value ) { #>
					<option value="{{ option_value }}">{{{ option_title }}}</option>
					<# } ); #>
				</select>
			</div>
		</div>
		<# if ( data.description ) { #>
		<div class="elementor-control-field-description">{{ data.description }}</div>
		<# } #>
		<?php
	}
}