<?php 
/* - For Custom Icon Loading
==========================================================*/

function custom_get_flat_icons() {
  return [
    /* - Flat Icons*/
    'chariton-flaticon fab fa-buromobelexperte'=>'fab fa-buromobelexperte',
    'chariton-flaticon flaticon-digital-marketing'=>'flaticon-digital-marketing',
    'chariton-flaticon flaticon-group'=>'flaticon-group',
    'chariton-flaticon flaticon-analytics'=>'flaticon-analytics',
    'chariton-flaticon flaticon-website'=>'flaticon-website',
    'chariton-flaticon flaticon-research'=>'Flaticon Transport',
    'chariton-flaticon flaticon-market'=>'Flaticon Safebox',
    'chariton-flaticon flaticon-software'=>'flaticon-software',
    'chariton-flaticon flaticon-analysis'=>'flaticon-analysis',
    'chariton-flaticon flaticon-pie-chart'=>'flaticon-pie-chart',
    'chariton-flaticon flaticon-value'=>'flaticon-value',
    'chariton-flaticon flaticon-digital-marketing-1'=>'flaticon-digital-marketing-1',
    'chariton-flaticon flaticon-award'=>'flaticon-award',
    'chariton-flaticon flaticon-support'=>'flaticon-support',
    'chariton-flaticon flaticon-contract'=>'flaticon-contract',
    'chariton-flaticon flaticon-analytics-1'=>'flaticon-analytics-1',
    'chariton-flaticon flaticon-award-1'=>'flaticon-award-1',
    'chariton-flaticon flaticon-tea'=>'flaticon-tea',
    'chariton-flaticon flaticon-mouse'=>'flaticon-mouse',
  ];
}

function custom_get_flat_icons_includes() {
  return [
    /* - Flat Icons*/
    'chariton-flaticon fab fa-buromobelexperte',
    'chariton-flaticon flaticon-digital-marketing',
    'chariton-flaticon flaticon-group',
    'chariton-flaticon flaticon-analytics',
    'chariton-flaticon flaticon-website',
    'chariton-flaticon flaticon-research',
    'chariton-flaticon flaticon-market',
    'chariton-flaticon flaticon-software',
    'chariton-flaticon flaticon-analysis',
    'chariton-flaticon flaticon-pie-chart',
    'chariton-flaticon flaticon-value',
    'chariton-flaticon flaticon-digital-marketing-1',
    'chariton-flaticon flaticon-award',
    'chariton-flaticon flaticon-support',
    'chariton-flaticon flaticon-contract',
    'chariton-flaticon flaticon-analytics-1',
    'chariton-flaticon flaticon-award-1',
    'chariton-flaticon flaticon-tea',
    'chariton-flaticon flaticon-mouse',
  ];
}
function font_weight() {
  return [
    '100' => __( '100', 'chariton' ),
    '200' => __( '200', 'chariton' ),
    '300' => __( '300', 'chariton' ),
    '400' => __( '400', 'chariton' ),
    '500' => __( '500', 'chariton' ),
    '600' => __( '600', 'chariton' ),
    '700' => __( '700', 'chariton' ),
    '800' => __( '800', 'chariton' ),
    '900' => __( '900', 'chariton' ),
  ];
  
}

function ifinger_post_orderby_options(){
    $orderby = array(
      'ID'            => 'Post Id',
      'author'        => 'Post Author',
      'title'         => 'Title',
      'date'          => 'Date',
      'modified'      => 'Last Modified Date',
      'parent'        => 'Parent Id',
      'rand'          => 'Random',
      'comment_count' => 'Comment Count',
      'menu_order'    => 'Menu Order',
    );
    return $orderby;
}


/**  Shortcodes | Image compatibility.
--------------------------------------------------------------------------------------------------- */
function ifinger_grid_columns() {
  return [
    '6'=>'Columns 2',
    '4'=>'Columns 3',
    '3'=>'Columns 4',
  ];
}


/**  Shortcodes | Image compatibility.
--------------------------------------------------------------------------------------------------- */
function ifinger_anim_delay() {
  return [
    '0.2s'=>'0.2s',
    '0.4s'=>'0.4s',
    '0.6s'=>'0.6s',
    '0.8s'=>'0.8s',
    '1s'=>'1s',
    '1.2s'=>'1.2s',
    '1.4s'=>'1.4s',
    '1.6s'=>'1.6s',
    '1.8s'=>'1.8s',
    '2s'=>'2s',
    '2.2s'=>'2.2s',
    '2.4s'=>'2.4s',
    '2.6s'=>'2.6s',
    '2.8s'=>'2.8s',
    '3s'=>'3s',
    '3.2s'=>'3.2s',
    '3.4s'=>'3.4s',
    '3.6s'=>'3.6s',
    '3.8s'=>'3.8s'
  ];
}



/* - For category
==========================================================*/
function chariton_get_category_post(){

  $categories = get_categories( array(
    'orderby' => 'name',
    'parent'  => 0
  ) );
  
  $catlist=[];

  foreach ( $categories as $category ) {
    (int)$catlist[$category->term_id] = $category->name;
  }

  return $catlist;

}


/* - For Contact Form 7
==========================================================*/
if ( ! function_exists( 'team_posts_options' ) ) :

  function team_posts_options(){

  $args = array('post_type' => 'team', 'posts_per_page' => -1);

    // $teamlist=[];

    $teamlist = array(esc_html__('-- Select Post --', 'chariton')=> '');
    
    if( $teams = get_posts($args)){
    	foreach ( $teams as $team ) {
    		(int)$teamlist[$team->ID] = $team->post_title;
    	}
    } else{
        (int)$teamlist['0'] = esc_html__('None Found, Install & Make Contact forms', 'chariton');
    }
    return $teamlist;
  }

endif;


/* - For custom category slug & category name
==========================================================*/

if ( ! function_exists( 'chariton_causes_categories_slug_no_comma' ) ) :
  /**
   * Getting Custome taxanomy for project - category- single project for filtering
   */
  function chariton_causes_categories_slug_no_comma() {
    $categories = get_the_terms( get_the_ID(), 'cause_category' );
      if(!empty($categories)){
        foreach( $categories as $category ) {
            echo $category->slug.' ';
        }
      }
  }
endif;


if ( ! function_exists( 'chariton_cases_categories' ) ) :
  /**
   * Getting Custome taxanomy for project - category- single project
   */
  function chariton_cases_categories() {
      $terms = get_terms( 'cause_category' );
      if(!empty($terms)){
      $category_links = array();
      foreach ($terms as $key => $value) {
        $category_links[$value->term_id] = $value->name;  
      }
      return $category_links;
    }
  }
endif;


/* - For custom category slug & category name
==========================================================*/

if ( ! function_exists( 'chariton_faq_categories_slug_no_comma' ) ) :
  /**
   * Getting Custome taxanomy for gallery - category- single gallery for filtering
   */
  function chariton_faq_categories_slug_no_comma() {
      $categories = get_the_terms( get_the_ID(), 'faq_tax' );
      if(!empty($categories)){
      foreach( $categories as $category ) {
          echo $category->slug.' ';
      }
    }
  }
endif;


/* - For custom category slug & category name
==========================================================*/
if ( ! function_exists( 'chariton_events_categories' ) ) :
  /**
   * Getting Custome taxanomy for project - category- single project
   */
  function chariton_events_categories() {
    if( function_exists('WPEMS') ):
      $terms = get_terms( 'tp_event_category' );

      if(!empty($terms)){
      $category_links = array();

      foreach ($terms as $key => $value) {
        $category_links[$value->term_id] = $value->name;  
      }
      return $category_links;
    }
    endif;
  }
endif;


if ( ! function_exists( 'chariton_get_terms_dropdown_array' ) ) :

// get terms dropdown
function chariton_get_terms_dropdown_array($args = [], $key = 'term_id', $value = 'name') {
  $options = [];
  $terms = get_terms($args);

  if (is_wp_error($terms)) {
    return [];
  }

  foreach ((array) $terms as $term) {
    $options[$term->{$key}] = $term->{$value};
  }
  return $options;
}
endif;



if ( ! function_exists( 'chariton_get_cf7_forms' ) ) {
    /**
     * Get a list of all CF7 forms
     *
     * @return array
     */
    function chariton_get_cf7_forms() {
        $forms = get_posts( [
            'post_type'      => 'wpcf7_contact_form',
            'post_status'    => 'publish',
            'posts_per_page' => -1,
            'orderby'        => 'title',
            'order'          => 'ASC',
        ] );

        if ( ! empty( $forms ) ) {
            return wp_list_pluck( $forms, 'post_title', 'ID' );
        }
        return [];
    }
}


if ( ! function_exists( 'chariton_get_terms_dropdown_array' ) ) :

  // get terms dropdown
  function chariton_get_terms_dropdown_array($args = [], $key = 'term_id', $value = 'name') {
    $options = [];
    $terms = get_terms($args);

    if (is_wp_error($terms)) {
      return [];
    }

    foreach ((array) $terms as $term) {
      $options[$term->{$key}] = $term->{$value};
    }
    return $options;
  }
  
endif;


if ( ! function_exists( 'chariton_team_posts_title' ) ) :
  // get terms dropdown
  function chariton_team_posts_title() {
    $args = array(
        'post_type'      => 'team',
        'post_status'    => 'publish',
        'posts_per_page' => -1,
        'taxonomy'       => 'team_category'
    );
    $post_title = array();
    $grid_query = new \WP_Query( $args );
    if ( $grid_query->have_posts() ) : 
        while ( $grid_query->have_posts() ) : $grid_query->the_post();
        $post_title[get_the_ID()] = get_the_title();
        endwhile; wp_reset_postdata();
    endif;
    return $post_title;
  }
  
endif;