<?php
namespace Chariton;  //main namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
global $void_widgets;
$void_widgets= array_map('basename', glob(dirname( __FILE__ ) . '/widgets/*.php'));

/* - Path define same as class name of the widget
====================================================================================================*/

use Chariton\Widgets\Section_Head;
use Chariton\Widgets\Section_Head_Two;
use Chariton\Widgets\Banner_One;
use Chariton\Widgets\Banner_Two;
use Chariton\Widgets\Banner_Three;
use Chariton\Widgets\Chariton_Button;
use Chariton\Widgets\Section_Inline_Text;
use Chariton\Widgets\Single_Counter;
use Chariton\Widgets\Section_Services;
use Chariton\Widgets\Video_Button;
use Chariton\Widgets\Section_Causes;
use Chariton\Widgets\Photo_Gallery;
use Chariton\Widgets\Single_Team;
use Chariton\Widgets\Our_Team;
use Chariton\Widgets\Testimonial;
use Chariton\Widgets\Image_Box_Items;
use Chariton\Widgets\Image_Box_Items_Two;
use Chariton\Widgets\Breadcrumb;
use Chariton\Widgets\Section_Blog;
use Chariton\Widgets\Section_Events;
use Chariton\Widgets\Section_Events_Two;
use Chariton\Widgets\Single_Feature;
use Chariton\Widgets\Single_Contact;
use Chariton\Widgets\Section_Donation;
use Chariton\Widgets\Section_Portfolios;
use Chariton\Widgets\Section_Event_Banner;
use Chariton\Widgets\Section_Brand;
use Chariton\Widgets\Call_Action;
use Chariton\Widgets\Section_Contact_Cf7;

/* - End Of path define same as class name of the widget
====================================================================================================*/

// Add a custom category for panel widgets
add_action( 'elementor/init', function() {
   \Elementor\Plugin::$instance->elements_manager->add_category( 
   	'chariton-elements', [
   		'title' => __( 'Chariton', 'chariton' ),
   		'icon' => 'fa fa-header', //default icon
   	],
   	5 // position
   );
} );

/**
 * Main Plugin Class
 *
 * Register new elementor widget.
 *
 * @since 1.0.0
 */
class Plugin {

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	
	public function __construct() {
		$this->add_actions();
		add_action('elementor/controls/controls_registered', array( $this, 'johanspond_icon_pack' ), 11 );
		add_action( 'elementor/editor/after_enqueue_styles', array( $this, 'editor_enqueue_styles' ) );
	}


	/**
     * Enqueue editor styles
     *
     * @return void
     */

    public function editor_enqueue_styles() {
        wp_enqueue_style( 'chariton-elements-editor', CHARITON_PLG_URL.'assets/css/chariton-admin-style.css',null, CHARITON_VERSION );
        wp_enqueue_style( 'johanspond-icon-elementor', CHARITON_PLG_URL.'assets/css/fontawesome-all.min.css',null, CHARITON_VERSION );
    }


	/**
     * Extend Icon pack core controls.
     *
     * @param  object $controls_manager Controls manager instance.
     * @return void
     */

    public function johanspond_icon_pack( $controls_manager ) {

        require_once CHARITON_PLG_DIR. '/chariton-elements/controls/johanspond-icon.php';

        $controls = array(
            $controls_manager::ICON => 'Johanspond_Icon_Controler',
        );

        foreach ( $controls as $control_id => $class_name ) {
            $controls_manager->unregister_control( $control_id );
            $controls_manager->register_control( $control_id, new $class_name() );
        }

    }

	/**
	 * Add Actions
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function add_actions() {
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'on_widgets_registered' ] );
		add_action( 'elementor/frontend/after_register_scripts', function() {
			wp_register_script( 'chariton-elementor-editor', plugins_url( '../assets/js/chariton-elementor-editor.js', __FILE__), [ 'jquery' ], true, true );
		} );
	}

	/**
	 * On Widgets Registered
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function on_widgets_registered() {
		$this->includes();
		$this->register_widget();
	}

	/**
	 * Includes
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function includes() {
		global $void_widgets;              //include the widgets here
		foreach($void_widgets as $key => $value){
   			require __DIR__ . '/widgets/'.$value;
		}
	}


	/* - Register all elements widget
	====================================================================================================*/

	/**
	 * Register Widget
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function register_widget() {   
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Head() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Head_Two() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Banner_One() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Banner_Two() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Banner_Three() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Chariton_Button() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Inline_Text() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Single_Counter() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Services() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Video_Button() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Causes() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Photo_Gallery() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Single_Team() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Our_Team() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Testimonial() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Image_Box_Items() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Image_Box_Items_Two() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Breadcrumb() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Blog() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Events() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Events_Two() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Single_Feature() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Single_Contact() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Donation() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Portfolios() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Event_Banner() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Brand() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Call_Action() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Section_Contact_Cf7() );
	}
}
new Plugin();