<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Breadcrumb extends Widget_Base {

	public function get_name() {
		return 'section-breadcrumb';
	}

	public function get_title() {
		return 'Breadcrumb';   // title to show on chariton
	}

	public function get_icon() {
		return 'fal fa-browser';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Breadcrumb', 'chariton' ),   //section name for controler view
			]
		);

		$this->add_control(
			'breadcrumb_title',
			[
				'label' => esc_html__( 'Title', 'chariton' ),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);

		$this->add_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'chariton' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'chariton' ),
						'icon' => 'fa fa-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'chariton' ),
						'icon' => 'fa fa-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'chariton' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'text-center',
				'toggle' => true,
			]
		);
		
		$this->end_controls_section();

		//End  of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_heading',
			[
				'label' => __( 'Title Style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		/* = Title Styling
		========================================*/
		$this->add_control(
			'title_text_color',
			[
				'label' => __( 'Text Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .breadcrumb-wrap h2' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .breadcrumb-wrap h2',
			]
		);

		/* = Meta Styling
		========================================*/
		$this->add_control(
			'meta_hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'breadcrumb_meta_style',
			[
				'label' => __( 'Meta Style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'meta_text_color',
			[
				'label' => __( 'Text Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .breadcrumb li, .breadcrumb li a, .breadcrumb-item + .breadcrumb-item::before' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'meta_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .breadcrumb li, .breadcrumb li a',
			]
		);

		/* = Meta Hover Styling
		========================================*/
		$this->add_control(
			'meta_hover_hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'breadcrumb_hover_style',
			[
				'label' => __( 'Meta Hover Style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'meta_hover_color',
			[
				'label' => __( 'Hover Link Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .breadcrumb li a:hover' => 'color: {{VALUE}};',
				],
			]
		);
	}
	//end of control box 

	protected function render() {				//to show on the fontend 
		$settings = $this->get_settings_for_display();

		$breadcrumb_title = $settings['breadcrumb_title'];
		$this->add_inline_editing_attributes( 'breadcrumb_title', 'none' );
		?>

		<!-- breadcrumb -->
	    <section class="custom-breadcrumb-area <?php echo esc_attr( $settings['text_align'] ); ?>">
	        <div class="breadcrumb-wrap">
	            <h2 <?php echo $this->get_render_attribute_string( 'breadcrumb_title' ); ?>><?php echo esc_html( $breadcrumb_title ); ?></h2>
	            <nav aria-label="breadcrumb">
	                <ol class="breadcrumb">
	                    <li class="breadcrumb-item active" aria-current="page"><?php chariton_meta_breadcrumbs(); ?></li>
	                </ol>
	            </nav>
	        </div>
	    </section>
		<?php
	}
}