<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Chariton_Button extends Widget_Base {

	public function get_name() {
		return 'chariton-button';
	}

	public function get_title() {
		return 'Chariton Button';   // title to show on chariton
	}

	public function get_icon() {
		return 'fal fa-link';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Chariton Setting', 'chariton' ),   //section name for controler view
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' => esc_html__( 'Button text', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'Apply Here',
			]
		);

		$this->add_control(
			'button_link',
			[
				'label' => __( 'Link', 'chariton' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'chariton' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);

		$this->add_control(
			'button_icon',
			[
				'label' => esc_html__( 'Button icon', 'chariton' ),
				'type' => Controls_Manager::ICON,
				'label_block' => true,
			]
		);
		
		$this->end_controls_section();

		//End  of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} a.chariton-btn',
			]
		);

		$this->add_responsive_control(
			'btn_font_color',
			[
				'label' => __( 'Font color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.chariton-btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'btn_bg_color',
			[
				'label' => __( 'Background color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.chariton-btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border',
				'label' => __( 'Border', 'chariton' ),
				'selector' => '{{WRAPPER}} a.chariton-btn',
			]
		);

		$this->add_control(
			'btn_border_radius',
			[
				'label' => __( 'Border radius', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} a.chariton-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'chariton_btn_margin',
			[
				'label' => __( 'Margin', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} a.chariton-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'chariton_btn_padding',
			[
				'label' => __( 'Padding', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} a.chariton-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => __( 'Box Shadow', 'chariton' ),
				'selector' => '{{WRAPPER}} a.chariton-btn',
			]
		);

		/* = Sub Title Styling
		========================================*/
		$this->add_control(
			'hover_hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'hover_heading',
			[
				'label' => __( 'Hover State', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'btn_h_font_color',
			[
				'label' => __( 'Font color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.chariton-btn:hover' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'btn_h_bg_color',
			[
				'label' => __( 'Background color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.chariton-btn:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'h_border',
				'label' => __( 'Border', 'chariton' ),
				'selector' => '{{WRAPPER}} a.chariton-btn:hover',
			]
		);
		

	}
	//end of control box 

	protected function render() {
	    $settings = $this->get_settings_for_display();

	    // Get button settings
	    $button_text = !empty($settings['button_text']) ? $settings['button_text'] : '';
	    $button_link = !empty($settings['button_link']['url']) ? esc_url($settings['button_link']['url']) : '#';
	    $button_icon = !empty($settings['button_icon']) ? $settings['button_icon'] : '';

	    // Add inline editing attributes
	    $this->add_inline_editing_attributes('button_text', 'none');

	    // Set target and rel attributes
	    $target = !empty($settings['button_link']['is_external']) ? ' target="_blank"' : '';
	    $nofollow = !empty($settings['button_link']['nofollow']) ? ' rel="nofollow"' : '';

	    // Output button HTML
	    echo sprintf(
	        '<a href="%s"%s%s class="chariton-btn btn"><i class="%s"></i> %s</a>',
	        $button_link,
	        $target,
	        $nofollow,
	        esc_attr($button_icon),
	        esc_html($button_text)
	    );
	}

	protected function content_template() {
	    ?>
	    <#
	    var button_text = settings.button_text || '';
	    var button_link = settings.button_link.url || '#';
	    var button_icon = settings.button_icon || '';
	    var target = settings.button_link.is_external ? ' target="_blank"' : '';
	    var nofollow = settings.button_link.nofollow ? ' rel="nofollow"' : '';
	    #>

	    <a href="{{ button_link }}"{{ target }}{{ nofollow }} class="chariton-btn btn">
	        <i class="{{ button_icon }}"></i> {{{ button_text }}}
	    </a>
	    <?php
	}

}