<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Photo_Gallery extends Widget_Base {

	public function get_name() {
		return 'photo-gallery';
	}

	public function get_title() {
		return 'Photo Gallery';   // title to show on chariton
	}

	public function get_icon() {
		return 'fal fa-images';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Photo Gallery', 'chariton' ),   //section name for controler view
			]
		);

        $this->add_control(
            'gallery_showcase_style',
            [
                'label'       => __( 'Gallery Style', 'chariton' ),
                'type' => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1'   => __( 'Gallery Style 1', 'chariton' ),
                    '2'   => __( 'Gallery Style 2', 'chariton' ),
                ],
            ]
        );

		$this->add_control(
			'gallery',
			[
				'label' => __( 'Add Images', 'chariton' ),
				'type' => Controls_Manager::GALLERY,
				'default' => [],
			]
		);

		$this->add_control(
			'gallery_columns',
			[
				'label' => __( 'Columns', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => '4',
				'options' => [
					'6' => __( '2', 'chariton' ),
					'4' => __( '3', 'chariton' ),
					'3' => __( '4', 'chariton' ),
					'2' => __( '6', 'chariton' ),
				],
			]
		);
		
		$this->end_controls_section();

		//End  of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'btn_border_radius',
			[
				'label' => __( 'Border radius', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .video-thumb a, .pluse-animation .popup-video::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
            'gallery_before_bg_color',
            [
                'label' => __( 'Before Background Color', 'chariton' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#0141f5',
                'selectors' => [
                    '{{WRAPPER}} .single-gallery-thumb-five.fix a::before' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'gallery_showcase_style' => '2',
                ],
            ]
        );

	}
	//end of control box

	// Display content on the frontend
	protected function render() {
	    $settings = $this->get_settings_for_display();
	    ?>
	    
	    <!-- Render style 2 if selected, otherwise default style -->
	    <?php if ( $settings['gallery_showcase_style'] == 2 ) { ?>
	        <div class="s-gallery-wrap">
	            <div class="row">
	                <?php foreach ( $settings['gallery'] as $image ) { ?>
	                    <div class="col-lg-<?php echo esc_attr( $settings['gallery_columns'] ); ?> col-md-6 custom-gallery-five">
	                        <div class="single-gallery-thumb-five fix">
	                            <?php if ( ! empty( $image['url'] ) ) { ?>
	                                <a href="<?php echo esc_url( $image['url'] ); ?>">
	                                    <img src="<?php echo esc_url( $image['url'] ); ?>" alt="<?php esc_attr_e( 'Gallery Image', 'chariton' ); ?>">
	                                </a>
	                            <?php } ?>
	                        </div>
	                    </div>
	                <?php } ?>
	            </div>
	        </div>
	    <?php } else { ?>
	        <div class="row">
	            <?php foreach ( $settings['gallery'] as $image ) { ?>
	                <div class="col-lg-<?php echo esc_attr( $settings['gallery_columns'] ); ?> col-md-6 custom-gallery-p">
	                    <div class="single-gallery-thumb fix mb-10">
	                        <?php if ( ! empty( $image['url'] ) ) { ?>
	                            <a href="<?php echo esc_url( $image['url'] ); ?>">
	                                <img src="<?php echo esc_url( $image['url'] ); ?>" alt="<?php esc_attr_e( 'Gallery Image', 'chariton' ); ?>">
	                            </a>
	                        <?php } ?>
	                    </div>
	                </div>
	            <?php } ?>
	        </div>
	    <?php } ?>

	    <?php
	}

	// Live preview template for Elementor editor
	protected function content_template() {
	    ?>
	    <#
	    var settings = settings;

	    if ( settings.gallery_showcase_style == 2 ) { #>
	        <div class="s-gallery-wrap">
	            <div class="row">
	                <# _.each( settings.gallery, function( image ) { #>
	                    <div class="col-lg-{{ settings.gallery_columns }} col-md-6 custom-gallery-five">
	                        <div class="single-gallery-thumb-five fix">
	                            <# if ( image.url ) { #>
	                                <a href="{{ image.url }}">
	                                    <img src="{{ image.url }}" alt="<?php esc_attr_e( 'Gallery Image', 'chariton' ); ?>">
	                                </a>
	                            <# } #>
	                        </div>
	                    </div>
	                <# }); #>
	            </div>
	        </div>
	    <# } else { #>
	        <div class="row">
	            <# _.each( settings.gallery, function( image ) { #>
	                <div class="col-lg-{{ settings.gallery_columns }} col-md-6 custom-gallery-p">
	                    <div class="single-gallery-thumb fix mb-10">
	                        <# if ( image.url ) { #>
	                            <a href="{{ image.url }}">
	                                <img src="{{ image.url }}" alt="<?php esc_attr_e( 'Gallery Image', 'chariton' ); ?>">
	                            </a>
	                        <# } #>
	                    </div>
	                </div>
	            <# }); #>
	        </div>
	    <# } #>
	    <?php
	}
}