<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Blog extends Widget_Base {   //this name is added to plugin.php of the root folder

	public function get_name() {
		return 'section-blog';
	}

	public function get_title() {
		return 'Blog';   // title to show on elementor
	}

	public function get_icon() {
		return 'fal fa-edit';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

    public function get_script_depends() {
		return [ 'chariton-elementor-editor' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	protected function register_controls() {
		
	//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Blog Grid', 'chariton' ),   //section name for controler view
			]
		);
	
		$this->add_control(
			'post_number',
			[
				'label' => esc_html__( 'Number of Item', 'chariton' ),
				'description' => esc_html__( 'Give -1 for all post', 'chariton' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 4,
			]
		);

		$this->add_control(
			'post_excerpt',
			[
				'label' => esc_html__( 'Post Excerpt', 'chariton' ),
				'description' => esc_html__( 'Post content excerpt', 'chariton' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 20,
			]
		);

		$this->add_control(
			'post_orderby',
			[
				'label' => __( 'Order by', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'date',
				'options' =>ifinger_post_orderby_options(),
			]
		);

		$this->add_control(
			'post_order',
			[
				'label' => __( 'Order', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'ASC' => __( 'Ascending Order', 'chariton' ),
					'DESC' => __( 'Descending', 'chariton' ),
				],
			]
		);

		$this->add_control(
			  'blog_style',
			  [
			     'label'       => __( 'Blog Style', 'chariton' ),
			     'type' => Controls_Manager::SELECT,
			     'default' => '1',
			     'options' => [
			     	'1'   => __( 'Style 1', 'chariton' ),
			     	'2'  => __( 'Style 2', 'chariton' ),
			     	'3'  => __( 'Style 3', 'chariton' ),
			     ],
			  ]
		);

		$this->add_control(
			  'blog_slider',
			  [
			     'label'       => __( 'Blog slider', 'chariton' ),
			     'type' => Controls_Manager::SELECT,
			     'default' => 'no',
			     'options' => [
			     	'no'   => __( 'No', 'chariton' ),
			     	'yes'  => __( 'Yes', 'chariton' ),
			     ],
			  ]
		);

		$this->add_control(
			'blog_columns',
			[
			    'label'       => __( 'Blog columns', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '4',
			    'options' => [
			     	'6'   => __( '2', 'chariton' ),
			     	'4'   => __( '3', 'chariton' ),
			     	'3'   => __( '4', 'chariton' ),
			    ],
			    'condition' => [
					'blog_slider' => 'no',
				],
			]
		);

		$this->add_control(
			  'blog_scode_tag',
			  [
			     'label'       => __( 'Show Tag', 'chariton' ),
			     'type' => Controls_Manager::SELECT,
			     'default' => 'no',
			     'options' => [
			     	'yes'  => __( 'Yes', 'chariton' ),
			     	'no'   => __( 'No', 'chariton' ),
			     ],
			  ]
		);

		$this->add_control(
			  'blog_scode_date',
			  [
			     'label'       => __( 'Show Date', 'chariton' ),
			     'type' => Controls_Manager::SELECT,
			     'default' => 'no',
			     'options' => [
			     	'yes'  => __( 'Yes', 'chariton' ),
			     	'no'   => __( 'No', 'chariton' ),
			     ],
			  ]
		);

		$this->add_control(
			  'blog_scode_comments',
			  [
			     'label'       => __( 'Show Comments', 'chariton' ),
			     'type' => Controls_Manager::SELECT,
			     'default' => 'no',
			     'options' => [
			     	'yes'  => __( 'Yes', 'chariton' ),
			     	'no'   => __( 'No', 'chariton' ),
			     ],
			  ]
		);

		$this->add_control(
			'show_item',
			[
			    'label'       => __( 'Show on large device', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '3',
			    'options' => [
			     	'2'  => __( '2', 'chariton' ),
			     	'3' => __( '3', 'chariton' ),
			     	'4' => __( '4', 'chariton' ),
			     	'6' => __( '6', 'chariton' ),
			    ],
			    'condition' => [
					'blog_slider' => 'yes',
				],
			]
		);

		$this->add_control(
			'show_desktop',
			[
			    'label'       => __( 'Show on desktop', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '3',
			    'options' => [
			     	'2'  => __( '2', 'chariton' ),
			     	'3' => __( '3', 'chariton' ),
			     	'4' => __( '4', 'chariton' ),
			     	'5' => __( '5', 'chariton' ),
			    ],
			    'condition' => [
					'blog_slider' => 'yes',
				],
			]
		);

		$this->add_control(
			'show_tablet',
			[
			    'label'       => __( 'Show on Tablet', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '2',
			    'options' => [
			     	'2' => __( '2', 'chariton' ),
			     	'3' => __( '3', 'chariton' ),
			     	'4' => __( '4', 'chariton' ),
			     	'5' => __( '5', 'chariton' ),
			    ],
			    'condition' => [
					'blog_slider' => 'yes',
				],
			]
		);

		$this->add_control(
			'show_tab',
			[
			    'label'       => __( 'Show on tab', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '1',
			    'options' => [
			     	'1'  => __( '1', 'chariton' ),
			     	'2'  => __( '2', 'chariton' ),
			     	'3' => __( '3', 'chariton' ),
			    ],
			    'condition' => [
					'blog_slider' => 'yes',
				],
			]
		);

		$this->add_control(
			'show_phone',
			[
			    'label'       => __( 'Show on phone', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '1',
			    'options' => [
			     	'1' => __( '1', 'chariton' ),
			     	'2' => __( '2', 'chariton' ),
			     	'3' => __( '3', 'chariton' ),
			    ],
			    'condition' => [
					'blog_slider' => 'yes',
				],
			]
		);

		$this->end_controls_section();


		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_blog_style',
			[
				'label' => esc_html__( 'Blog Style Settings', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_heading',
			[
				'label' => __( 'Blog Title Style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
			]
		);

		/* = Title Styling
		========================================*/
		$this->add_control(
			'title_text_color',
			[
				'label' => __( 'Blog Title Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#001234',
				'selectors' => [
					'{{WRAPPER}} .blog-shortcode .bpost-content h2 a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .single-blog-wrap .blog-content-three h5' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'label' => __( 'Blog Title Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .blog-shortcode .bpost-content h2, .single-blog-wrap .blog-content-three h5',
			]
		);

		$this->add_control(
			'title_text_hover_color',
			[
				'label' => __( 'Blog Title Hover Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ff4b57',
				'selectors' => [
					'{{WRAPPER}} .blog-shortcode .bpost-content h2 a:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .single-blog-wrap .blog-content-three h5 a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_readmore_style',
			[
				'label' => esc_html__( 'Blog Read More Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_control(
			'readmore_text_color',
			[
				'label' => __( 'Read More Text Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#152136',
				'selectors' => [
					'{{WRAPPER}} .single-blog-wrap .blog-content-three .b-readmore a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'readmore_text_hover_color',
			[
				'label' => __( 'Read More Hover Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#39bdb2',
				'selectors' => [
					'{{WRAPPER}} .single-blog-wrap .blog-content-three .b-readmore a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		
		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__( 'Blog Content Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'content_text_color',
			[
				'label' => __( 'Blog Content Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#5b7d9a',
				'selectors' => [
					'{{WRAPPER}} .single-blog-wrap .blog-content-three p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'Blog Content Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .single-blog-wrap .blog-content-three p',
			]
		);

		$this->end_controls_section();
	}


	protected function render() {				//to show on the fontend 
		$settings = $this->get_settings_for_display();
		$content_excerpt = $settings['post_excerpt'];
		$blog_style = $settings['blog_style'];
		$blog_scode_tag = $settings['blog_scode_tag'];
		$blog_scode_date = $settings['blog_scode_date'];
		$blog_scode_comments = $settings['blog_scode_comments'];

		if ( $settings['blog_slider'] == 'yes' ) {
			$slider_class = 'blog-active';
		} else {
			$slider_class = '';			
		}

		if ($settings['blog_columns'] == '6') {
		  $crop_img = 'chariton-770-460';
		} elseif ($settings['blog_columns'] == '4') {
		  $crop_img = 'chariton-770-460';
		} elseif ($settings['blog_columns'] == '3') {
		  $crop_img = 'chariton-770-460';
		} else {
		  $crop_img = 'full';
		}

		$grid_query= null;
	    $args = array(
	       'post_type'      => 'post',
	       'post_status'    => 'publish',
	       'orderby' => $settings['post_orderby'],
	       'order' => $settings['post_order'],
	       'posts_per_page' => $settings['post_number'],
	    );
		 
		$grid_query = new \WP_Query( $args );

		if ( $grid_query->have_posts() ) : 
			if ($settings['blog_slider'] == 'yes') { ?>
				<script type="text/javascript">
				    jQuery(document).ready(function(){
						// blog-active
						jQuery('.blog-active').slick({
						  dots: false,
						  infinite: true,
						  speed: 600,
						  prevArrow: '<button type="button" class="slick-prev"><i class="fal fa-arrow-left"></i></button>',
						  nextArrow: '<button type="button" class="slick-next"><i class="fal fa-arrow-right"></i></button>',
						  arrows: true,
						  slidesToShow: <?php echo esc_attr( $settings['show_item'] ); ?>,
						  slidesToScroll: 1,
						  responsive: [
						    {
						      breakpoint: 1200,
						      settings: {
						        slidesToShow: <?php echo esc_attr( $settings['show_desktop'] ); ?>,
						        slidesToScroll: 1,
						        infinite: true,
						      }
						    },
						    {
						      breakpoint: 992,
						      settings: {
						        slidesToShow: <?php echo esc_attr( $settings['show_tablet'] ); ?>,
						        slidesToScroll: 1
						      }
						    },
						    {
						      breakpoint: 768,
						      settings: {
						        slidesToShow: <?php echo esc_attr( $settings['show_tab'] ); ?>,
						        slidesToScroll: 1,
						        arrows: false,
						      }
						    },
						    {
						      breakpoint: 576,
						      settings: {
						        slidesToShow: <?php echo esc_attr( $settings['show_phone'] ); ?>,
						        slidesToScroll: 1,
						        arrows: false,
						      }
						    },
						  ]
						});
				    });
				</script>  
			<?php } ?>
			<script type="text/javascript">
			    jQuery(document).ready(function(){
					// blog
					jQuery('.blog-post-thumb-active').slick({
						autoplay:true,
						autoplaySpeed:1500,
						dots: false,
						infinite: true,
						arrows: true,
						speed: 1500,
						slidesToShow: 1,
						slidesToScroll: 1,
						fade: true,
						prevArrow: '<button type="button" class="slick-prev"><i class="fas fa-arrow-left"></i></button>',
						nextArrow: '<button type="button" class="slick-next"><i class="fas fa-arrow-right"></i></button>',
					});
			    });
			</script>

<?php if ( $blog_style == '3' ) { ?>
	<div class="row">
		<?php while ( $grid_query->have_posts() ) : $grid_query->the_post(); global $post; 
			if(!empty($settings['post_excerpt'])){
				$limit = $settings['post_excerpt'];
			}
			else{
				$limit = 20;
			}
	  	?>

		<div class="col-lg-<?php echo esc_attr( $settings['blog_columns'] ); ?> blog-shortcode">
		  <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		    <div class="single-blog-wrap mb-30">
		        <?php if(has_post_thumbnail()) { ?>
		          <div class="blog-thumb blog-overlay">
		            <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( $crop_img ); ?></a>
		          </div>                                                                                        
			    <?php
			        $have_thumb = 'have-thumb';
			    	} else {
			    		$have_thumb = 'no-thumb'; 
			    	}
		    	?>
		        <div class="blog-content-three <?php echo esc_attr( $have_thumb ); ?>">
	                <div class="blog-meta mb-10">
	                    <ul>
	                    	<?php if ($blog_scode_date == 'yes') : ?>
	                        <li><i class="far fa-calendar-alt"></i><?php echo esc_html ( get_the_date() ); ?></li>
	                        <?php endif; ?>
	                        <?php if ($blog_scode_comments == 'yes') : ?>
	                        <li><i class="far fa-comments"></i><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></li>
	                    	<?php endif; ?>
	                    </ul>
	                </div>
	                <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
	                <p><?php echo wp_trim_words( get_the_content(), $limit, '...' ); ?></p>
		          	<div class="b-readmore">
		            	<a href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read More', 'chariton' ); ?><i class="fal fa-arrow-right"></i></a>
		          	</div>
	            </div>
		    </div>
		  </article>
		</div>
	    <?php endwhile; wp_reset_postdata(); ?>
	</div>
<?php } elseif ( $blog_style == '2' ) { ?>

<div class="row <?php echo esc_attr( $slider_class ); ?>">
	<?php while ( $grid_query->have_posts() ) : $grid_query->the_post(); global $post; 

	    $default_post_metadata = get_post_meta( get_the_ID(), '_chariton_post', true);

		if (!empty($default_post_metadata['post_format_type'] )) {
		  $post_format_type = $default_post_metadata['post_format_type'];
		} else {
		  $post_format_type = '';
		}

		if (!empty($default_post_metadata['video_type'] )) {
		  $video_type = $default_post_metadata['video_type'];
		} else {
		  $video_type = '';
		}
		if (!empty($default_post_metadata['video_link'] )) {
		  $video_link = $default_post_metadata['video_link'];
		} else {
		  $video_link = '';
		}
		if (!empty($default_post_metadata['audio_link'] )) {
		  $audio_link = $default_post_metadata['audio_link'];
		} else {
		  $audio_link = '';
		}  
		if (!empty($default_post_metadata['chariton_quote_icon'] )) {
		  $chariton_quote_icon = $default_post_metadata['chariton_quote_icon'];
		} else {
		  $chariton_quote_icon = '';
		}  

		if (!empty($default_post_metadata['gallery_list'] )) {
		  $gallery_list = $default_post_metadata['gallery_list'];
		} else {
		  $gallery_list = '';
		} 

		if ($gallery_list) {
		    $ids = explode(",",$gallery_list);
		} else {
		    $ids = '';
		}
	    
  	?>

	<div class="col-lg-4 blog-shortcode">
	  <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	    <div class="single-blog-post mb-30">

	    <?php if ($post_format_type == 'chariton-video') { ?>
	    	<?php if(has_post_thumbnail()) : ?>
			    <div class="bpost-thumb position-relative pluse-animation">
		          <?php the_post_thumbnail( $crop_img ); ?>
		          <a href="<?php echo esc_url( $video_link ); ?>" class="video-i popup-video"><i class="fas fa-play"></i></a>
		        </div>
	    	<?php endif; ?>
	        <div class="blog-content">
                <div class="blog-meta mb-10">
                    <ul>
                    	<?php if ($blog_scode_date == 'yes') : ?>
                        	<li><i class="far fa-calendar-alt"></i><?php echo esc_html ( get_the_date() ); ?></li>
                        <?php endif; ?>
                        <?php if ($blog_scode_comments == 'yes') : ?>
                        	<li><i class="far fa-comments"></i><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></li>
                    	<?php endif; ?>
                    </ul>
                </div>
                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                <p><?php echo chariton_excerpt( $content_excerpt ); ?></p>
                <div class="blog-avatar">
                    <div class="blog-avatar-img">
                        <?php echo get_avatar( get_the_author_meta('email'), '40' ); ?>
                    </div>
                    <div class="blog-avatar-info">
                        <p><?php esc_html_e('By ', 'chariton'); ?><?php the_author_posts_link(); ?></p>
                    </div>
                </div>
                <?php if (function_exists('ifingers_post_like_get_simple_likes_button')) { ?>
                <div class="blog-post-react">
                    <?php echo ifingers_post_like_get_simple_likes_button( get_the_ID() ); ?>
                </div>
                <?php } ?>
            </div>

	    <?php } elseif ($post_format_type == 'chariton-gallery') { ?>

	        <div class="single-blog-post blog-post-thumb-active">
	          	<div class="slide-post">
	            	<?php the_post_thumbnail( $crop_img ); ?>
	          	</div>
				<?php if (!empty($ids)) : ?>
				    <?php foreach ($ids as $key => $value) :
				        $src = wp_get_attachment_image_src($value, "chariton-770-460");
				        if (!empty($src) && is_array($src)) : ?>
				            <div class="slide-post">
				                <img src="<?php echo esc_url($src[0]); ?>" alt="<?php esc_attr_e('post gallery image', 'chariton'); ?>">
				            </div>
				        <?php endif; ?>
				    <?php endforeach; ?>
				<?php endif; ?>
	        </div>
	        <div class="blog-content">
                <div class="blog-meta mb-10">
                    <ul>
                    	<?php if ($blog_scode_date == 'yes') : ?>
                        <li><i class="far fa-calendar-alt"></i><?php echo esc_html ( get_the_date() ); ?></li>
                        <?php endif; ?> 
                        <?php if ($blog_scode_comments == 'yes') : ?>
                        <li><i class="far fa-comments"></i><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></li>
                    	<?php endif; ?>
                    </ul>
                </div>
                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                <p><?php echo chariton_excerpt( $content_excerpt ); ?></p>
                <div class="blog-avatar">
                    <div class="blog-avatar-img">
                        <?php echo get_avatar( get_the_author_meta('email'), '40' ); ?>
                    </div>
                    <div class="blog-avatar-info">
                        <p><?php esc_html_e('By ', 'chariton'); ?><?php the_author_posts_link(); ?></p>
                    </div>
                </div>
                <?php if (function_exists('ifingers_post_like_get_simple_likes_button')) : ?>
	                <div class="blog-post-react">
	                    <?php echo ifingers_post_like_get_simple_likes_button( get_the_ID() ); ?>
	                </div>
                <?php endif; ?>
            </div>

	    <?php } elseif ($post_format_type == 'chariton-audio') { ?>

	        <div class="single-blog-post embed-responsive embed-responsive-16by9">
	            <iframe src="<?php echo esc_url( $audio_link ); ?>"></iframe>
	        </div>

	        <div class="blog-content">
                <div class="blog-meta mb-10">
                    <ul>
                    	<?php if ($blog_scode_date == 'yes') : ?>
                        	<li><i class="far fa-calendar-alt"></i><?php echo esc_html ( get_the_date() ); ?></li>
                        <?php endif; ?>
                        <?php if ($blog_scode_comments == 'yes') : ?>
                        	<li><i class="far fa-comments"></i><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></li>
                    	<?php endif; ?>
                    </ul>
                </div>
                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                <p><?php echo chariton_excerpt( $content_excerpt ); ?></p>
                <div class="blog-avatar">
                    <div class="blog-avatar-img">
                        <?php echo get_avatar( get_the_author_meta('email'), '40' ); ?>
                    </div>
                    <div class="blog-avatar-info">
                        <p><?php esc_html_e('By ', 'chariton'); ?><?php the_author_posts_link(); ?></p>
                    </div>
                </div>
                <?php if (function_exists('ifingers_post_like_get_simple_likes_button')) : ?>
	                <div class="blog-post-react">
	                    <?php echo ifingers_post_like_get_simple_likes_button( get_the_ID() ); ?>
	                </div>
                <?php endif; ?>
            </div>

	    <?php } elseif( $post_format_type == 'chariton-quote' ) { ?>

		    <?php 
		    	$src = get_the_post_thumbnail_url();
		    	$attachment = wp_get_attachment_image_src( $chariton_quote_icon, 'full' );
		        $icon_img    = ($attachment) ? $attachment[0] : $chariton_quote_icon;
		    ?>
	        <div class="blog-content quote-post" data-background="<?php echo esc_url( $src ); ?>">
	        	<div class="quote-icon">
	            	<img src="<?php echo esc_url( $icon_img ); ?>" alt="<?php esc_html_e( 'quote icon', 'chariton' ); ?>">
	        	</div>
	        	<div class="fix">
		            <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
		            <div class="bpost-meta">
		              <ul>
		                <?php if ($blog_scode_date == 'yes') : ?>
		                  	<li><span><i class="fal fa-calendar-alt"></i><?php echo esc_html ( get_the_date() ); ?></span></li>
		                <?php endif; ?>
		                <?php if ($blog_scode_comments == 'yes') : ?>
		                  	<li><a href="<?php the_permalink(); ?>"><i class="fal fa-comments"></i><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></a></li>
		                <?php endif; ?>
		              </ul>
		            </div>
		        </div>
	        </div>

	      <?php } else { ?>

	        <?php if(has_post_thumbnail()) { ?>
	          <div class="blog-thumb">
	            <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( $crop_img ); ?></a>
	          </div>
	        <?php
	        $have_thumb = 'have-thumb';
	    	} else { $have_thumb = 'no-thumb'; } ?>
		        <div class="blog-content <?php echo esc_attr( $have_thumb ); ?>">
	                <div class="blog-meta mb-10">
	                    <ul>
	                    	<?php if ($blog_scode_date == 'yes') : ?>
	                        	<li><i class="far fa-calendar-alt"></i><?php echo esc_html ( get_the_date() ); ?></li>
	                        <?php endif; ?>
	                        <?php if ($blog_scode_comments == 'yes') : ?>
	                        	<li><i class="far fa-comments"></i><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></li>
	                    	<?php endif; ?>
	                    </ul>
	                </div>
	                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
	                <p><?php echo chariton_excerpt( $content_excerpt ); ?></p>
	                <div class="blog-avatar">
	                    <div class="blog-avatar-img">
	                        <?php echo get_avatar( get_the_author_meta('email'), '40' ); ?>
	                    </div>
	                    <div class="blog-avatar-info">
	                        <p><?php esc_html_e('By ', 'chariton'); ?><?php the_author_posts_link(); ?></p>
	                    </div>
	                </div>
	                <?php if (function_exists('ifingers_post_like_get_simple_likes_button')) : ?>
		                <div class="blog-post-react">
		                    <?php echo ifingers_post_like_get_simple_likes_button( get_the_ID() ); ?>
		                </div>
	                <?php endif; ?>
	            </div>
	      <?php } ?>
	      <?php if ( is_sticky() ) {
	        echo '<sup class="meta-featured-post"> <i class="fal fa-thumbtack"></i> ' . esc_html__( 'Sticky', 'chariton' ) . ' </sup>';
	      } ?>
	    </div>
	  </article>
	</div>

    <?php endwhile; wp_reset_postdata(); ?>
</div>

<?php } elseif ( $blog_style == '1' ) { ?> 
	
<div class="row <?php echo esc_attr( $slider_class ); ?> blog-shortcode">
	<?php while ( $grid_query->have_posts() ) : $grid_query->the_post(); global $post; 

	    $default_post_metadata = get_post_meta( get_the_ID(), '_chariton_post', true);

		if (!empty($default_post_metadata['post_format_type'] )) {
		  $post_format_type = $default_post_metadata['post_format_type'];
		} else {
		  $post_format_type = '';
		}

		if (!empty($default_post_metadata['video_type'] )) {
		  $video_type = $default_post_metadata['video_type'];
		} else {
		  $video_type = '';
		}
		if (!empty($default_post_metadata['video_link'] )) {
		  $video_link = $default_post_metadata['video_link'];
		} else {
		  $video_link = '';
		}
		if (!empty($default_post_metadata['audio_link'] )) {
		  $audio_link = $default_post_metadata['audio_link'];
		} else {
		  $audio_link = '';
		}  
		if (!empty($default_post_metadata['chariton_quote_icon'] )) {
		  $chariton_quote_icon = $default_post_metadata['chariton_quote_icon'];
		} else {
		  $chariton_quote_icon = '';
		}  

		if (!empty($default_post_metadata['gallery_list'] )) {
		  $gallery_list = $default_post_metadata['gallery_list'];
		} else {
		  $gallery_list = '';
		} 

		if ($gallery_list) {
		    $ids = explode(",",$gallery_list);
		} else {
		    $ids = '';
		}

  	?>
    <div class="col-lg-<?php echo esc_attr( $settings['blog_columns'] ); ?> col-md-6">
	  <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	    <div class="bsingle-post shortcode-panel mb-30">
	      <?php if ($post_format_type == 'chariton-video') { ?>

	        <div class="bpost-thumb position-relative">
	          <?php the_post_thumbnail( $crop_img ); ?>
	          <a href="<?php echo esc_url( $video_link ); ?>" class="video-i popup-video"><i class="fas fa-play"></i></a>
	        </div>
	        <div class="bpost-content">
	        	<?php if ($blog_scode_tag == 'yes') : ?>
		          	<div class="b-tag">
		            	<?php the_category(' '); ?>
		          	</div>
	      		<?php endif; ?>
	          	<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
		        <div class="bpost-meta">
		            <ul>
		              	<?php if ($blog_scode_date == 'yes') : ?>
		                	<li><span><i class="fal fa-calendar-alt"></i><?php echo esc_html ( get_the_date() ); ?></span></li>
		              	<?php endif; ?>
		              	<?php if ($blog_scode_comments == 'yes') : ?>
		                	<li><a href="<?php the_permalink(); ?>"><i class="fal fa-comments"></i><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></a></li>
		              	<?php endif; ?>
		            </ul>
		        </div>
	          	<p><?php echo chariton_excerpt( $content_excerpt ); ?></p>
	            <div class="bpost-avatar">
	              <div class="bavatar-img">
	                <?php echo get_avatar( get_the_author_meta('email'), '40' ); ?>
	              </div>
	              <div class="bavatar-info">
	                <p><?php esc_html_e('By ', 'chariton'); ?><?php the_author_posts_link(); ?></p>
	              </div>
	            </div>
		        <div class="b-readmore">
		        	<a href="<?php the_permalink(); ?>"><i class="fal fa-arrow-right"></i><?php esc_html_e( 'Read More', 'chariton' ); ?></a>
		        </div>
	        </div>
	      <?php } elseif ($post_format_type == 'chariton-gallery') { ?>
	        <div class="bpost-thumb blog-post-thumb-active">
	          	<div class="slide-post">
	            	<?php the_post_thumbnail( $crop_img ); ?>
	          	</div>
				<?php if (!empty($ids)) : ?>
				    <?php foreach ($ids as $key => $value) :
				        $src = wp_get_attachment_image_src($value, "chariton-770-460");
				        if (!empty($src) && is_array($src)) : ?>
				            <div class="slide-post">
				                <img src="<?php echo esc_url($src[0]); ?>" alt="<?php esc_attr_e('post gallery image', 'chariton'); ?>">
				            </div>
				        <?php endif; ?>
				    <?php endforeach; ?>
				<?php endif; ?>
	        </div>
	        <div class="bpost-content">
	        	<?php if ($blog_scode_tag == 'yes') : ?>
					<div class="b-tag">
						<?php the_category(' '); ?>
					</div>
	      		<?php endif; ?>
	          	<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
		        <div class="bpost-meta">
		            <ul>
		              	<?php if ($blog_scode_date == 'yes') : ?>
		                	<li><span><i class="fal fa-calendar-alt"></i><?php echo esc_html ( get_the_date() ); ?></span></li>
		            	<?php endif; ?>
		              	<?php if ($blog_scode_comments == 'yes') : ?>
		                	<li><a href="<?php the_permalink(); ?>"><i class="fal fa-comments"></i><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></a></li>
		              	<?php endif; ?>
		            </ul>
		        </div>
	          	<p><?php echo chariton_excerpt( $content_excerpt ); ?></p>
	            <div class="bpost-avatar">
	              <div class="bavatar-img">
	                <?php echo get_avatar( get_the_author_meta('email'), '40' ); ?>
	              </div>
	              <div class="bavatar-info">
	                <p><?php esc_html_e('By ', 'chariton'); ?><?php the_author_posts_link(); ?></p>
	              </div>
	            </div>
		        <div class="b-readmore">
		            <a href="<?php the_permalink(); ?>"><i class="fal fa-arrow-right"></i><?php esc_html_e( 'Read More', 'chariton' ); ?></a>
		        </div>
	        </div>
	      <?php } elseif ($post_format_type == 'chariton-audio') { ?>
	        <div class="bpost-thumb embed-responsive embed-responsive-16by9">
	            <iframe src="<?php echo esc_url( $audio_link ); ?>"></iframe>
	        </div>
	        <div class="bpost-content">
	        	<?php if ($blog_scode_tag == 'yes') : ?>
		          <div class="b-tag">
		            <?php the_category(' '); ?>
		          </div>
	      		<?php endif; ?>
	          <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
	          <div class="bpost-meta">
	            <ul>
	              	<?php if ($blog_scode_date == 'yes') : ?>
	                	<li><span><i class="fal fa-calendar-alt"></i><?php echo esc_html ( get_the_date() ); ?></span></li>
	              	<?php endif; ?>
	          		<?php if ($blog_scode_comments == 'yes') : ?>
	                	<li><a href="<?php the_permalink(); ?>"><i class="fal fa-comments"></i><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></a></li>
	              	<?php endif; ?>
	            </ul>
	          </div>
	          <p><?php echo chariton_excerpt( $content_excerpt ); ?></p>
	            <div class="bpost-avatar">
	              	<div class="bavatar-img">
	                	<?php echo get_avatar( get_the_author_meta('email'), '40' ); ?>
	              	</div>
	              	<div class="bavatar-info">
	                	<p><?php esc_html_e('By ', 'chariton'); ?><?php the_author_posts_link(); ?></p>
	              	</div>
	            </div>
		        <div class="b-readmore">
		        	<a href="<?php the_permalink(); ?>"><i class="fal fa-arrow-right"></i><?php esc_html_e( 'Read More', 'chariton' ); ?></a>
		        </div>
	        </div>
	      <?php } elseif ($post_format_type == 'chariton-quote') { 
	        $src = get_the_post_thumbnail_url();
	        $attachment = wp_get_attachment_image_src( $chariton_quote_icon, 'full' );
	        $icon_img    = ($attachment) ? $attachment[0] : $chariton_quote_icon;
	      ?>
	        <div class="bpost-content quote-post" data-background="<?php echo esc_url( $src ); ?>">
	          <div class="quote-icon">
	            <img src="<?php echo esc_url( $icon_img ); ?>" alt="<?php esc_html_e( 'quote icon', 'chariton' ); ?>">
	          </div>
	          <div class="fix">
	            <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
	          </div>
	        </div>
	    <?php } else { ?>
	        <?php if(has_post_thumbnail()) : ?>
	          <div class="blog-thumb">
	            <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( $crop_img ); ?></a>
	          </div>                                                                                        
	        <?php endif; ?>
	        <div class="bpost-content">
	        	<?php if ($blog_scode_tag == 'yes') : ?>
		          	<div class="b-tag">
		            	<?php the_category(' '); ?>
		          	</div>
	      		<?php endif; ?>
	          <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
	          <div class="bpost-meta">
	            <ul>
	              <?php if ($blog_scode_date == 'yes') : ?>
	                <li><span><i class="fal fa-calendar-alt"></i><?php echo esc_html ( get_the_date() ); ?></span></li>
	              <?php endif; ?>
	              <?php if ($blog_scode_comments == 'yes') : ?>
	                <li><a href="<?php the_permalink(); ?>"><i class="fal fa-comments"></i><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></a></li>
	              <?php endif; ?>
	            </ul>
	          </div>
	          <p><?php echo chariton_excerpt( $content_excerpt ); ?></p>
	            <div class="bpost-avatar">
	              <div class="bavatar-img">
	                <?php echo get_avatar( get_the_author_meta('email'), '40' ); ?>
	              </div>
	              <div class="bavatar-info">
	                <p><?php esc_html_e('By ', 'chariton'); ?><?php the_author_posts_link(); ?></p>
	              </div>
	            </div>
	          	<div class="b-readmore">
	            	<a href="<?php the_permalink(); ?>"><i class="fal fa-arrow-right"></i><?php esc_html_e( 'Read More', 'chariton' ); ?></a>
	          	</div>
	        </div>
	      <?php } ?>
	      <?php if ( is_sticky() ) {
	        echo '<sup class="meta-featured-post"> <i class="fal fa-thumbtack"></i> ' . esc_html__( 'Sticky', 'chariton' ) . ' </sup>';
	      } ?>
	    </div>
	  </article>
	</div>
    <?php endwhile; wp_reset_postdata(); ?>
</div>

<?php } else { ?>

<div class="row">
	<?php while ( $grid_query->have_posts() ) : $grid_query->the_post(); global $post; 

	    $default_post_metadata = get_post_meta( get_the_ID(), '_chariton_post', true);

		if (!empty($default_post_metadata['post_format_type'] )) {
		  $post_format_type = $default_post_metadata['post_format_type'];
		} else {
		  $post_format_type = '';
		}

		if (!empty($default_post_metadata['video_type'] )) {
		  $video_type = $default_post_metadata['video_type'];
		} else {
		  $video_type = '';
		}
		if (!empty($default_post_metadata['video_link'] )) {
		  $video_link = $default_post_metadata['video_link'];
		} else {
		  $video_link = '';
		}
		if (!empty($default_post_metadata['audio_link'] )) {
		  $audio_link = $default_post_metadata['audio_link'];
		} else {
		  $audio_link = '';
		}  
		if (!empty($default_post_metadata['chariton_quote_icon'] )) {
		  $chariton_quote_icon = $default_post_metadata['chariton_quote_icon'];
		} else {
		  $chariton_quote_icon = '';
		}  

		if (!empty($default_post_metadata['gallery_list'] )) {
		  $gallery_list = $default_post_metadata['gallery_list'];
		} else {
		  $gallery_list = '';
		} 

		if ($gallery_list) {
		    $ids = explode(",",$gallery_list);
		} else {
		    $ids = '';
		}
  	?>

	<div class="col-lg-<?php echo esc_attr( $settings['blog_columns'] ); ?> blog-shortcode">
	  <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	    <div class="single-blog-post mb-30">
	    <?php if ($post_format_type == 'chariton-video') { ?>
	    	<?php if(has_post_thumbnail()) : ?>
			    <div class="bpost-thumb position-relative">
		          <?php the_post_thumbnail( $crop_img ); ?>
		          <a href="<?php echo esc_url( $video_link ); ?>" class="video-i popup-video"><i class="fas fa-play"></i></a>
		        </div>
	    	<?php endif; ?>
	        <div class="blog-content">
                <div class="blog-meta mb-10">
                    <ul>
                    	<?php if (!empty($blog_post_date)) : ?>
                        	<li><i class="far fa-calendar-alt"></i><?php echo esc_html ( get_the_date() ); ?></li>
                        <?php endif; ?>
                        <?php if (!empty($blog_post_comments)) : ?>
                        	<li><i class="far fa-comments"></i><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></li>
                    	<?php endif; ?>
                    </ul>
                </div>
                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                <p><?php echo chariton_excerpt( $content_excerpt ); ?></p>
                <div class="blog-avatar">
                    <div class="blog-avatar-img">
                        <?php echo get_avatar( get_the_author_meta('email'), '40' ); ?>
                    </div>
                    <div class="blog-avatar-info">
                        <p><?php esc_html_e('By ', 'chariton'); ?><?php the_author_posts_link(); ?></p>
                    </div>
                </div>
                <div class="blog-post-react">
                    <a href="#!"><i class="fal fa-heart"></i></a>
                </div>
            </div>

	    <?php } elseif ($post_format_type == 'chariton-gallery') { ?>
	        <div class="single-blog-post blog-post-thumb-active">
		        <div class="slide-post">
		            <?php the_post_thumbnail( $crop_img ); ?>
		        </div>
				<?php if (!empty($ids)) : ?>
				    <?php foreach ($ids as $key => $value) :
				        $src = wp_get_attachment_image_src($value, "chariton-770-460");
				        if (!empty($src) && is_array($src)) : ?>
				            <div class="slide-post">
				                <img src="<?php echo esc_url($src[0]); ?>" alt="<?php esc_attr_e('post gallery image', 'chariton'); ?>">
				            </div>
				        <?php endif; ?>
				    <?php endforeach; ?>
				<?php endif; ?>
	        </div>
	        <div class="blog-content">
                <div class="blog-meta mb-10">
                    <ul>
                    	<?php if (!empty($blog_post_date)) : ?>
                        	<li><i class="far fa-calendar-alt"></i><?php echo esc_html ( get_the_date() ); ?></li>
                        <?php endif; ?>

                        <?php if (!empty($blog_post_comments)) : ?>
                        	<li><i class="far fa-comments"></i><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></li>
                    	<?php endif; ?>
                    </ul>
                </div>
                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                <p><?php echo chariton_excerpt( $content_excerpt ); ?></p>
                <div class="blog-avatar">
                    <div class="blog-avatar-img">
                        <?php echo get_avatar( get_the_author_meta('email'), '40' ); ?>
                    </div>
                    <div class="blog-avatar-info">
                        <p><?php esc_html_e('By ', 'chariton'); ?><?php the_author_posts_link(); ?></p>
                    </div>
                </div>
                <div class="blog-post-react">
                    <a href="#!"><i class="fal fa-heart"></i></a>
                </div>
            </div>
	    <?php } elseif ($post_format_type == 'chariton-audio') { ?>
	        <div class="single-blog-post embed-responsive embed-responsive-16by9">
	            <iframe src="<?php echo esc_url( $audio_link ); ?>"></iframe>
	        </div>
	        <div class="blog-content">
                <div class="blog-meta mb-10">
                    <ul>
                    	<?php if (!empty($blog_post_date)) : ?>
                        	<li><i class="far fa-calendar-alt"></i><?php echo esc_html ( get_the_date() ); ?></li>
                        <?php endif; ?>
                        <?php if (!empty($blog_post_comments)) : ?>
                        	<li><i class="far fa-comments"></i><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></li>
                    	<?php endif; ?>
                    </ul>
                </div>
                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                <p><?php echo chariton_excerpt( $content_excerpt ); ?></p>
                <div class="blog-avatar">
                    <div class="blog-avatar-img">
                        <?php echo get_avatar( get_the_author_meta('email'), '40' ); ?>
                    </div>
                    <div class="blog-avatar-info">
                        <p><?php esc_html_e('By ', 'chariton'); ?><?php the_author_posts_link(); ?></p>
                    </div>
                </div>
                <div class="blog-post-react">
                    <a href="#"><i class="fal fa-heart"></i></a>
                </div>
            </div>
	    <?php } elseif( $post_format_type == 'chariton-quote' ) { ?>
		    <?php 
		    	$src = get_the_post_thumbnail_url();
		    	$attachment = wp_get_attachment_image_src( $chariton_quote_icon, 'full' );
		        $icon_img    = ($attachment) ? $attachment[0] : $chariton_quote_icon;
		    ?>
	        <div class="blog-content quote-post" data-background="<?php echo esc_url( $src ); ?>">
	        	<div class="quote-icon">
	            	<img src="<?php echo esc_url( $icon_img ); ?>" alt="<?php esc_html_e( 'quote icon', 'chariton' ); ?>">
	        	</div>
	        	<div class="fix">
		            <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
		            <div class="bpost-meta">
		              	<ul>
			                <?php if (!empty($blog_post_date)) : ?>
			                  <li><span><i class="fal fa-calendar-alt"></i><?php echo esc_html ( get_the_date() ); ?></span></li>
			                <?php endif; ?>
			                <?php if (!empty($blog_post_views)) : ?>
			                	<?php if(function_exists('chariton_set_PostViews')) : ?>
			                  		<li><span><i class="fal fa-eye"></i><?php echo chariton_get_PostViews(get_the_ID()); ?> <?php esc_html_e( 'Views', 'chariton' ); ?></span></li>
			                	<?php endif; ?>
			                <?php endif; ?>
			                <?php if (!empty($blog_post_comments)) : ?>
			                  <li><a href="<?php the_permalink(); ?>"><i class="fal fa-comments"></i><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></a></li>
			                <?php endif; ?>
		              	</ul>
		            </div>
	          	</div>
	        </div>
	    <?php } else { ?>
	        <?php if(has_post_thumbnail()) { ?>
	          <div class="blog-thumb">
	            <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( $crop_img ); ?></a>
	          </div>                                                                                        
	        <?php 
	        $have_thumb = 'have-thumb';
	    	} else { $have_thumb = 'no-thumb'; } ?>
	        <div class="blog-content <?php echo esc_attr( $have_thumb ); ?>">
                <div class="blog-meta mb-10">
                    <ul>
                    	<?php if (!empty($blog_post_date)) : ?>
                        <li><i class="far fa-calendar-alt"></i><?php echo esc_html ( get_the_date() ); ?></li>
                        <?php endif; ?>
                        <?php if (!empty($blog_post_comments)) : ?>
                        <li><i class="far fa-comments"></i><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></li>
                    	<?php endif; ?>
                    </ul>
                </div>
                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                <p><?php echo chariton_excerpt( $content_excerpt ); ?></p>
                <div class="blog-avatar">
                    <div class="blog-avatar-img">
                        <?php echo get_avatar( get_the_author_meta('email'), '40' ); ?>
                    </div>
                    <div class="blog-avatar-info">
                        <p><?php esc_html_e('By ', 'chariton'); ?><?php the_author_posts_link(); ?></p>
                    </div>
                </div>
                <div class="blog-post-react">
                    <a href="#"><i class="fal fa-heart"></i></a>
                </div>
            </div>
	      <?php } ?>
	      <?php if ( is_sticky() ) {
	        echo '<sup class="meta-featured-post"> <i class="fal fa-thumbtack"></i> ' . esc_html__( 'Sticky', 'chariton' ) . ' </sup>';
	      } ?>
	    </div>
	  </article>
	</div>

    <?php endwhile; wp_reset_postdata(); ?>
</div>

<?php } ?>
<?php endif;   //main if end

	}

}