<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Donation extends Widget_Base {   //this name is added to plugin.php of the root folder

	public function get_name() {
		return 'section-give-forms';
	}

	public function get_title() {
		return 'GiveWP';   // title to show on elementor
	}

	public function get_icon() {
		return 'fal fa-edit';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

    public function get_script_depends() {
		return [ 'chariton-elementor-editor' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	protected function register_controls() {
		
	//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'General', 'chariton' ),   //section name for controler view
			]
		);

	     $this->add_control(
	        'category',
			[
				'label' => esc_html__( 'Select Category', 'chariton' ),
				'type' => Controls_Manager::SELECT2, 
				'title' => esc_html__( 'Select a category', 'chariton' ),
				'multiple' => true,
				'options' => chariton_get_terms_dropdown_array(
					[
			   		'taxonomy' => 'give_forms_category',
			   		'hide_empty' => false,
					]
				),
			]
	    );

		$this->add_control(
			'give_style_types',
			[
			    'label'       => __( 'Choose Style', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => 'no',
			    'options' => [
			     	'no' 	=> __( 'Grid', 'chariton' ),
			     	'yes'  	=> __( 'Slider', 'chariton' ),
			    ],
			]
		);

		$this->add_control(
			'cause_filter',
			[
			    'label'     => __( 'Give Filter Menu', 'chariton' ),
			    'type' 		=> Controls_Manager::SELECT,
			    'default' 	=> 'no',
			    'options' 	=> [
			     	'yes' 	=> __( 'Yes', 'chariton' ),
			     	'no' 	=> __( 'No', 'chariton' ),
			    ],
			    'condition' => [
					'give_style_types' => 'no',
				],
			]
		);

		$this->add_control(
			'cgive_columns',
			[
			    'label'       => __( 'Grid Columns Amount', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '4',
			    'options' => [
			     	'6'   => __( '2', 'chariton' ),
			     	'4'   => __( '3', 'chariton' ),
			     	'3'   => __( '4', 'chariton' ),
			    ],
			    'condition' => [
					'give_style_types' => 'no',
				],
			]
		);

		$this->add_control(
			'cgive_number',
			[
				'label' => esc_html__( 'Number of Item', 'chariton' ),
				'description' => esc_html__( 'Give -1 for all posts', 'chariton' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 9,
			]
		);

		$this->add_control(
			'post_orderby',
			[
				'label' => __( 'Order by', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'date',
				'options' =>ifinger_post_orderby_options(),
			]
		);

		$this->add_control(
			'post_order',
			[
				'label' => __( 'Order', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'ASC' => __( 'Ascending Order', 'chariton' ),
					'DESC' => __( 'Descending', 'chariton' ),
				],
			]
		);

		$this->add_control(
			'hide_cgive_thumb',
			[
				'label' => __( 'Clickable Thumbnail', 'chariton' ),
				'type'  => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'chariton' ),
				'label_off' => __( 'Hide', 'chariton' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_give_slider',
			[
				'label' => esc_html__( 'Slider Settings', 'chariton' ),   //section name for controler view
			    'condition' => [
					'give_style_types' => 'yes',
				],				
			]
		);

		$this->add_control(
			'slider_autoplay',
			[
			    'label'       => __( 'Slider Autoplay', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => 'true',
			    'options' => [
			     	'true'  => __( 'Yes', 'chariton' ),
			     	'false' => __( 'No', 'chariton' ),
			    ],
			]
		);

		$this->add_control(
			'slider_infinite',
			[
			    'label'       => __( 'Slider Infinite', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => 'true',
			    'options' => [
			     	'true'  => __( 'Yes', 'chariton' ),
			     	'false' => __( 'No', 'chariton' ),
			    ],
			]
		);

		$this->add_control(
			'slider_arrows',
			[
			    'label'       => __( 'Slider Arrow', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => 'true',
			    'options' => [
			     	'true'  => __( 'Yes', 'chariton' ),
			     	'false' => __( 'No', 'chariton' ),
			    ],
			]
		);

		$this->add_control(
			'slider_arrows_height',
			[
			    'label'       => __( 'Slider Arrow Margin Top', 'chariton' ),
			    'type' => Controls_Manager::TEXT,
			    'default' => '70px',
				'selectors' => [
					'{{WRAPPER}} .causes-active .slick-arrow' => 'margin-top: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'show_item',
			[
			    'label'       => __( 'Show on large device', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '3',
			    'options' => [
			     	'2'  => __( '2', 'chariton' ),
			     	'3' => __( '3', 'chariton' ),
			     	'4' => __( '4', 'chariton' ),
			     	'6' => __( '6', 'chariton' ),
			    ],
			]
		);

		$this->add_control(
			'show_desktop',
			[
			    'label'       => __( 'Show on desktop', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '3',
			    'options' => [
			     	'2'  => __( '2', 'chariton' ),
			     	'3' => __( '3', 'chariton' ),
			     	'4' => __( '4', 'chariton' ),
			     	'5' => __( '5', 'chariton' ),
			    ],
			]
		);

		$this->add_control(
			'show_tablet',
			[
			    'label'       => __( 'Show on Tablet', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '2',
			    'options' => [
			     	'2'  => __( '2', 'chariton' ),
			     	'3' => __( '3', 'chariton' ),
			     	'4' => __( '4', 'chariton' ),
			     	'5' => __( '5', 'chariton' ),
			    ],
			]
		);

		$this->add_control(
			'show_tab',
			[
			    'label'       => __( 'Show on tab', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '1',
			    'options' => [
			     	'1'  => __( '1', 'chariton' ),
			     	'2'  => __( '2', 'chariton' ),
			     	'3'  => __( '3', 'chariton' ),
			    ],
			]
		);

		$this->add_control(
			'show_phone',
			[
			    'label'       => __( 'Show on phone', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '1',
			    'options' => [
			     	'1' => __( '1', 'chariton' ),
			     	'2' => __( '2', 'chariton' ),
			     	'3' => __( '3', 'chariton' ),
			    ],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_filter_styling',
			[
				'label' => esc_html__( 'Filter Menu Settings', 'chariton' ),   //section name for controler view
			    'condition' => [
					'cause_filter' => 'yes',
					'give_style_types' => 'no',
				],				
			]
		);

		$this->add_control(
			'filter_menu_border_color',
			[
				'label' => __( 'Menu Border Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#dde9ff',
				'selectors' => [
					'{{WRAPPER}} .causes-menus' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'filter_font_color',
			[
				'label' => __( 'Menu Font Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#b2c7d9',
				'selectors' => [
					'{{WRAPPER}} .causes-menus button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'filter_font_hover_color',
			[
				'label' => __( 'Filter Menu Hover Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#78c759',
				'selectors' => [
					'{{WRAPPER}} .causes-menus button:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .causes-menus button:hover::before' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'filter_menu_active_color',
			[
				'label' => __( 'Filter Menu Active Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#78c759',
				'selectors' => [
					'{{WRAPPER}} .causes-menus button.active' => 'color: {{VALUE}};',
					'{{WRAPPER}} .causes-menus button.active::before' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		/* = Post Styling
		========================================*/
		$this->start_controls_section(
			'givewp_main_style',
			[
				'label' => esc_html__( 'Items', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		/* = Title Styling
		========================================*/
        $this->add_responsive_control(
            'givemain_padding',
            [
                'label' => esc_html__('Padding', 'chariton'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', 'rem'],
                'default' => [
                    'top' => 35,
                    'right' => 35,
                    'bottom' => 35,
                    'left' => 35,
                ],
                'selectors' => [
                    '{{WRAPPER}} .causes-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'givemain_margin',
            [
                'label' => esc_html__('Margin', 'chariton'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', 'rem'],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 30,
                    'left' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .single-causes' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_section();

		/* = Post Styling
		========================================*/
		$this->start_controls_section(
			'givewp_title_style',
			[
				'label' => esc_html__( 'Title Style', 'chariton' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		/* = Title Styling
		========================================*/
		$this->add_control(
			'title_font_color',
			[
				'label' => __( 'Font Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#001234',
				'selectors' => [
					'{{WRAPPER}} .single-causes .causes-content h3' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .single-causes .causes-content h3',
			]
		);

		$this->add_control(
			'title_hover_color',
			[
				'label' => __( 'Title Hover Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#78c759',
				'selectors' => [
					'{{WRAPPER}} .single-causes:hover .causes-content h3 a' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_section();

		/* = Post Styling
		========================================*/
		$this->start_controls_section(
			'givewp_cat_style',
			[
				'label' => esc_html__( 'Categories Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		/* = Title Styling
		========================================*/
		$this->add_control(
			'givemain_cat_text_color',
			[
				'label' => __( 'Categories Text Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#78c759',
				'selectors' => [
					'{{WRAPPER}} ul.cause-categories li a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'givemain_cat_text_hover_color',
			[
				'label' => __( 'Categories Text Hover Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#001234',
				'selectors' => [
					'{{WRAPPER}} ul.cause-categories li a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'give_cat_typography',
				'label' => __( 'Categories Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} ul.cause-categories li a',
			]
		);

		$this->end_controls_section();


		/* = Post Styling
		========================================*/
		$this->start_controls_section(
			'givewp_donategoal_style',
			[
				'label' => esc_html__( 'Goal Box', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		/* = Title Styling
		========================================*/
		$this->add_control(
			'givemain_donategola_bg',
			[
				'label' => __( 'Goal Background Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#39bdb2',
				'selectors' => [
					'{{WRAPPER}} .causes-meta ul li.fund-goal' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'givemain_donategola_text',
			[
				'label' => __( 'Text Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .causes-meta ul li.fund-goal' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();


		/* = Post Styling
		========================================*/
		$this->start_controls_section(
			'givewp_donateraised_style',
			[
				'label' => esc_html__( 'Raised Box', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		/* = Title Styling
		========================================*/
		$this->add_control(
			'givemain_donateraised_bg',
			[
				'label' => __( 'Raised Background Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ff566e',
				'selectors' => [
					'{{WRAPPER}} .causes-meta ul li.fund-raised' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'givemain_donateraised_text',
			[
				'label' => __( 'Text Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .causes-meta ul li.fund-raised' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();


		/* = Post Styling
		========================================*/
		$this->start_controls_section(
			'givewp_donateleft_style',
			[
				'label' => esc_html__( 'Left Box', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		/* = Title Styling
		========================================*/
		$this->add_control(
			'givemain_donateleft_bg',
			[
				'label' => __( 'Left Background Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#a50042',
				'selectors' => [
					'{{WRAPPER}} .causes-meta ul li.fund-lacks' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'givemain_donateleft_text',
			[
				'label' => __( 'Text Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .causes-meta ul li.fund-lacks' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

	}

	//to show on the fontend 
	protected function render() {
		$settings = $this->get_settings_for_display();
		$categories       = get_terms( 'give_forms_category', apply_filters( 'give_forms_category_dropdown', array() ) );
		if ( give_is_setting_enabled( give_get_option( 'categories' ) ) && ! is_wp_error( $categories ) ) {
			if( !empty( $settings['category'] ) ){
				$category = !empty( $settings['category'] ) ? $settings['category'] : 'All';
				$grid_query= null;
			    $args = array(
			       'post_type'      => 'give_forms',
			       'post_status'    => 'publish',
			       'posts_per_page' => $settings['cgive_number'],
			       'order' 			=> $settings['post_order'],
			       'orderby' 		=> $settings['post_orderby'],
		            'tax_query'     => array(
		                 array(
		                     'taxonomy'  => 'give_forms_category',
		                     'field'     => 'id', 
		                     'terms'     => $category
		                 )
		             )
			    );
			}else{
				$grid_query= null;
			   	$args = array(
			      'post_type'      => 'give_forms',
			      'post_status'    => 'publish',
			      'posts_per_page' => $settings['cgive_number'],
			      'order' => $settings['post_order'],
			      'orderby' => $settings['post_orderby'],
			   	);
			}
		}else{
			$grid_query= null;
		   	$args = array(
		      'post_type'      => 'give_forms',
		      'post_status'    => 'publish',
		      'posts_per_page' => $settings['cgive_number'],
		      'order' => $settings['post_order'],
		      'orderby' => $settings['post_orderby'],
		   	);
		}

		$e_uniqid     = uniqid();
		 
		$grid_query = new \WP_Query( $args ); ?>

	<?php if ( $settings['give_style_types'] == 'yes' ) { ?>
		<script type="text/javascript">
		    jQuery(document).ready(function(){
				// causes-active
				jQuery('.causes-active').slick({
				  autoplay: <?php echo $settings['slider_autoplay']?>,
				  dots: false,
				  infinite: <?php echo $settings['slider_infinite']?>,
				  speed: 600,
				  prevArrow: '<button type="button" class="slick-prev"><i class="far fa-angle-left"></i></button>',
				  nextArrow: '<button type="button" class="slick-next"><i class="far fa-angle-right"></i></button>',
				  arrows: <?php echo $settings['slider_arrows'] ?>,
				  slidesToShow: <?php echo esc_attr( $settings['show_item'] ); ?>,
				  slidesToScroll: 1,
				  responsive: [
				    {
				      breakpoint: 1200,
				      settings: {
				        slidesToShow: <?php echo esc_attr( $settings['show_desktop'] ); ?>,
				        slidesToScroll: 1,
				        infinite: <?php echo $settings['slider_infinite']?>,
				      }
				    },
				    {
				      breakpoint: 992,
				      settings: {
				        slidesToShow: <?php echo esc_attr( $settings['show_tablet'] ); ?>,
				        slidesToScroll: 1
				      }
				    },
				    {
				      breakpoint: 768,
				      settings: {
				        slidesToShow: <?php echo esc_attr( $settings['show_tab'] ); ?>,
				        slidesToScroll: 1,
				        arrows: false,
				      }
				    },
				    {
				      breakpoint: 576,
				      settings: {
				        slidesToShow: <?php echo esc_attr( $settings['show_phone'] ); ?>,
				        slidesToScroll: 1,
				        arrows: false,
				      }
				    },
				  ]
				});
		    });
		</script>   

		<div class="row causes-active">
			<?php while ( $grid_query->have_posts() ) : $grid_query->the_post();

				global $post;

				// Fetch meta data
				$goal_option = get_post_meta(get_the_ID(), '_give_goal_option', true);
				$goal_stats = give_goal_progress_stats(get_the_ID());

				// Validate goal stats format
				if ('percentage' === $goal_stats['format'] || !$goal_stats['goal']) {
					continue;
				}

				$income = $goal_stats['raw_actual'];
				$goal = $goal_stats['raw_goal'];
				$lack_value = give_format_amount($goal - $income);

				if ('amount' === $goal_stats['format']) {
					$lack_value = give_currency_filter($lack_value);
				}

				// Labels
				$goal_label      = esc_html__('Goal', 'chariton');
				$raised_label    = esc_html__('Raised', 'chariton');
				$goal_lack_label = esc_html__('Left', 'chariton');


				// Retrieve terms
				$terms = get_the_terms(get_the_ID(), 'give_forms_category');
				$cat_slug = '';
				if ($terms && !is_wp_error($terms)) {
					$draught_links = array_map(function ($term) {
						return $term->slug;
					}, $terms);
					$cat_slug = join(" ", $draught_links);
				}

				$goal_raised = get_post_meta(get_the_ID(), '_give_form_earnings', true);   

			?>

				<div class="col-xl-4">
					<div class="single-causes ">
						<?php if (has_post_thumbnail()) : ?>
							<div class="causes-thumb">
								<?php if ($settings['hide_cgive_thumb']) : ?>
									<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
								<?php else : ?>
									<?php the_post_thumbnail(); ?>
								<?php endif; ?>
							</div>
						<?php else : ?>
							<div class="causes-thumb">
								<?php echo apply_filters('single_give_form_image_html', sprintf('<img src="%s" alt="%s" />', give_get_placeholder_img_src(), esc_attr__('Placeholder', 'chariton')), $post->ID); ?>
							</div>
						<?php endif; ?>

						<div class="causes-content">
							<?php if (give_is_setting_enabled(give_get_option('categories', 'disabled')) && $terms && !is_wp_error($terms)) : ?>
								<ul class="cause-categories">
									<?php foreach ($terms as $term) : ?>
										<li><a href="<?php echo esc_url(get_term_link($term->slug, 'give_forms_category')); ?>"><?php echo esc_html($term->name); ?></a></li>
									<?php endforeach; ?>
								</ul>
							<?php endif; ?>
							<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
						</div><!-- /causes content end -->

						<div class="causes-meta">
							<ul class="d-flex justify-content-between">
								<li class="fund-goal"><span class="label-name"><?php echo $goal_label; ?></span><?php echo $goal_stats['goal']; ?></li>
								<li class="fund-raised"><span class="label-name"><?php echo $raised_label; ?></span>
									<div><?php echo give_currency_symbol(); ?><span class="count"><?php echo give_format_amount($goal_raised); ?></span></div>
								</li>
								<li class="fund-lacks"><span class="label-name"><?php echo $goal_lack_label; ?></span><?php echo $lack_value; ?></li>
							</ul>
						</div>

					</div>
				</div>
			<?php endwhile; wp_reset_postdata(); ?>
		</div>


	<?php }else{ ?>

		<?php if ( $settings['cause_filter'] == 'yes' ) { ?>
			<script>
				jQuery(window).on('load', function () {
				    jQuery('.gives-isotope').imagesLoaded( function() {
				        // portfolio - active
				        var $grid = jQuery('.gives-isotope-<?php echo esc_attr( $e_uniqid ); ?>').isotope({
				            itemSelector: '.grid-item',
				            layoutMode: 'fitRows',
				            percentPosition: true,
				        })
				        // filter items on button click
				        jQuery('.gives-menu-<?php echo esc_attr( $e_uniqid ); ?>').on('click', 'button', function () {
				            var filterValue = jQuery(this).attr('data-filter');
				            $grid.isotope({ filter: filterValue });
				        });
				        //for menu active class
				        jQuery('.gives-menu-<?php echo esc_attr( $e_uniqid ); ?> button').on('click', function (event) {
				            jQuery(this).siblings('.active').removeClass('active');
				            jQuery(this).addClass('active');
				            event.preventDefault();
				        });
				    });
				});
			</script>

			<div class="row">
			    <div class="col-lg-12 text-center">
			        <div class="causes-menus gives-menu-<?php echo esc_attr($e_uniqid); ?> mb-50">
			            <?php 
			                $filters = get_terms(array(
			                    'taxonomy' => 'give_forms_category',
			                    'include' => $settings['category'],
			                    'hide_empty' => false,
			                    'orderby' => 'include',
			                ));
			                
			                if (!empty($filters)) : ?>
			                    <button class="active" data-filter="*"><?php echo esc_html__('All Categories', 'chariton'); ?></button>
			                    <?php foreach ($filters as $filter) : ?>
			                        <button class="button" data-filter=".<?php echo esc_attr($filter->slug); ?>">
			                            <?php echo esc_html($filter->name); ?>
			                        </button>
			                    <?php endforeach; ?>
			            <?php endif; ?>
			        </div>
			    </div>
			</div>

		<?php } ?>

		<div class="row gives-isotope-<?php echo esc_attr($e_uniqid); ?>">
			<?php while ( $grid_query->have_posts() ) : $grid_query->the_post();

				global $post;

				// Fetch meta data
				$goal_option = get_post_meta(get_the_ID(), '_give_goal_option', true);
				$goal_stats = give_goal_progress_stats(get_the_ID());

				// Validate goal stats format
				if ('percentage' === $goal_stats['format'] || !$goal_stats['goal']) {
					continue;
				}

				$income = $goal_stats['raw_actual'];
				$goal = $goal_stats['raw_goal'];
				$lack_value = give_format_amount($goal - $income);

				if ('amount' === $goal_stats['format']) {
					$lack_value = give_currency_filter($lack_value);
				}

				// Labels
				$goal_label      = esc_html__('Goal', 'chariton');
				$raised_label    = esc_html__('Raised', 'chariton');
				$goal_lack_label = esc_html__('Left', 'chariton');


				// Retrieve terms
				$terms = get_the_terms(get_the_ID(), 'give_forms_category');
				$cat_slug = '';
				if ($terms && !is_wp_error($terms)) {
					$draught_links = array_map(function ($term) {
						return $term->slug;
					}, $terms);
					$cat_slug = join(" ", $draught_links);
				}

			    // Calculate the progress percentage based on income and goal
				$progress = ($goal > 0) ? min(100, ($income / $goal) * 100) : 0;

				$goal_raised = get_post_meta(get_the_ID(), '_give_form_earnings', true);
			?>

				<div class="col-lg-<?php echo esc_attr($settings['cgive_columns']); ?> col-md-6 grid-item <?php echo esc_attr($cat_slug); ?>">
					<div class="single-causes ">
						<?php if (has_post_thumbnail()) : ?>
							<div class="causes-thumb">
								<?php if ($settings['hide_cgive_thumb']) : ?>
									<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
								<?php else : ?>
									<?php the_post_thumbnail(); ?>
								<?php endif; ?>
							</div>
						<?php else : ?>
							<div class="causes-thumb">
								<?php echo apply_filters('single_give_form_image_html', sprintf('<img src="%s" alt="%s" />', give_get_placeholder_img_src(), esc_attr__('Placeholder', 'chariton')), $post->ID); ?>
							</div>
						<?php endif; ?>

						<div class="causes-content">
							<?php if (give_is_setting_enabled(give_get_option('categories', 'disabled')) && $terms && !is_wp_error($terms)) : ?>
								<ul class="cause-categories">
									<?php foreach ($terms as $term) : ?>
										<li><a href="<?php echo esc_url(get_term_link($term->slug, 'give_forms_category')); ?>"><?php echo esc_html($term->name); ?></a></li>
									<?php endforeach; ?>
								</ul>
							<?php endif; ?>
							<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
						</div><!-- /causes content end -->

						<div class="causes-meta">
							<ul class="d-flex justify-content-between">
								<li class="fund-goal"><span class="label-name"><?php echo $goal_label; ?></span><?php echo $goal_stats['goal']; ?></li>
								<li class="fund-raised"><span class="label-name"><?php echo $raised_label; ?></span>
									<div><?php echo give_currency_symbol(); ?><span class="count"><?php echo give_format_amount($goal_raised); ?></span></div>
								</li>
								<li class="fund-lacks"><span class="label-name"><?php echo $goal_lack_label; ?></span><?php echo $lack_value; ?></li>
							</ul>
						</div>

					</div>
				</div>
			<?php endwhile; wp_reset_postdata(); ?>
		</div>
	<?php }
	}
}