<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Events_Two extends Widget_Base {   //this name is added to plugin.php of the root folder

	public function get_name() {
		return 'section-event-two';
	}

	public function get_title() {
		return 'Events Two';   // title to show on elementor
	}

	public function get_icon() {
		return 'fal fa-calendar-star';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

    public function get_script_depends() {
		return [ 'chariton-elementor-editor' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Event Style Two', 'chariton' ),   //section name for controler view
			]
		);

		$this->add_control(
			'post_number',
			[
				'label' => esc_html__( 'Number of Item', 'chariton' ),
				'description' => esc_html__( 'Give -1 for all post', 'chariton' ),
				'type' => Controls_Manager::NUMBER,
				'default' => '-1',
			]
		);

		$this->add_control(
			'post_excerpt',
			[
				'label' => esc_html__( 'Post Excerpt', 'chariton' ),
				'description' => esc_html__( 'Post content excerpt', 'chariton' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 30,
			]
		);

		$this->add_control(
			'display_posts_cat',
			[
				'label' 	=> __( 'Choose Events Category.', 'chariton' ),
				'type' 		=> Controls_Manager::SELECT2,
				'multiple' 	=> true,
				'options' 	=> chariton_events_categories(),
				'label_block' => true,
			]
		);

		$this->add_control(
			'post_orderby',
			[
				'label' => __( 'Order by', 'chariton' ),
				'type' 	=> Controls_Manager::SELECT,
				'default' => 'date',
				'options' => ifinger_post_orderby_options(),
			]
		);

		$this->add_control(
			'event_thumb',
			[
			    'label'     => __( 'Event Thumbnail', 'chariton' ),
			    'type' 		=> Controls_Manager::SELECT,
			    'default' 	=> 'no',
			    'options' 	=> [
			     	'yes' 	=> __( 'Yes', 'chariton' ),
			     	'no' 	=> __( 'No', 'chariton' ),
			    ],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_event_style',
			[
				'label' => esc_html__( 'Events Title Style', 'chariton' ),   //section name for controler view
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'event_title_color',
			[
				'label' 	=> __( 'Title Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#001234',
				'selectors' => [
					'{{WRAPPER}} .s-schedule-wrap .s-schedule h5 a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Title Typography', 'chariton' ),
				'selector' 	=> '{{WRAPPER}} .s-schedule-wrap .s-schedule h5',
			]
		);

		$this->add_control(
			'title_hover_color',
			[
				'label' 	=> __( 'Title Hover Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#fe3233',
				'selectors' => [
					'{{WRAPPER}} .s-schedule-wrap .s-schedule h5 a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_event_content',
			[
				'label' => esc_html__( 'Events Content Style', 'chariton' ),   //section name for controler view
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'event_content_color',
			[
				'label' 	=> __( 'Content Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#5b7d9a',
				'selectors' => [
					'{{WRAPPER}} .s-schedule-wrap .second-schedule-list p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'event_content_date_color',
			[
				'label' 	=> __( 'Date Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#8d8c8c',
				'selectors' => [
					'{{WRAPPER}} .s-schedule-wrap .s-schedule span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'event_content_time_color',
			[
				'label' 	=> __( 'Time Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#fe3233',
				'selectors' => [
					'{{WRAPPER}} .s-schedule-wrap .second-schedule-list li' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_event_area',
			[
				'label' => esc_html__( 'Events Item Style', 'chariton' ),   //section name for controler view
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'event_areas_bg_color',
			[
				'label' 	=> __( 'Event Area Background Color', 'chariton' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .s-schedule-wrap' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();

		if( !empty( $settings['display_posts_cat'] ) ){
			$category = !empty( $settings['display_posts_cat'] ) ? $settings['display_posts_cat'] : 'All';
	    	$args = array(
				'post_type'      => 'tp_event',
				'post_status'    => 'publish',
				'posts_per_page' => $settings['post_number'],
				'orderby'        => $settings['post_orderby'],
	            'tax_query'     => array(
	                array(
	                    'taxonomy'  => 'tp_event_category',
	                    'field'     => 'id', 
	                    'terms'     => $category
	                )
	            )
	    	);
		}else{
	    	$args = array(
				'post_type'      => 'tp_event',
				'post_status'    => 'publish',
				'posts_per_page' => $settings['post_number'],
				'orderby'        => $settings['post_orderby'],
	    	);
		}

    	$e_uniqid     = uniqid();
		 
		$grid_query = new \WP_Query( $args );

		if ( $grid_query->have_posts() ) : 
			if( function_exists('WPEMS') ): ?>

			<!-- events-area -->
		    <div class="events-area">
		        <div class="row">
					<?php 
						while ( $grid_query->have_posts() ) : $grid_query->the_post(); global $post;

		                $date_start = get_post_meta( get_the_ID(), 'tp_event_date_start', true ) ? strtotime( get_post_meta( get_the_ID(), 'tp_event_date_start', true ) ) : time();
		                $date_end   = get_post_meta( get_the_ID(), 'tp_event_date_end', true ) ? strtotime( get_post_meta( get_the_ID(), 'tp_event_date_end', true ) ) : time();
						$time_start = wpems_event_start( get_option( 'time_format' ) );
		                $time_end   = wpems_event_end( get_option( 'time_format' ) );

		                $date_string = '';
		                if ( $date_start === $date_end ) {
		                    $date_string = date_i18n( get_option( 'date_format' ), $date_start );
		                } else {
		                    $date_string = date_i18n( get_option( 'date_format' ), $date_start ) . ' - ' . date_i18n( get_option( 'date_format' ), $date_end );
		                }

		                $date_status =  get_post_meta( get_the_ID(), 'tp_event_status', true );
				  	?>

		            <div class="col-xl-4 col-lg-4 col-md-6">
		                <div class="s-schedule-wrap mb-30">
		                	<?php if( has_post_thumbnail() ) : ?>
		                		<?php if ( $settings['event_thumb'] == 'yes' ) { ?>
		                            <div class="event-thumb">
		                                <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('chariton-event-400-400'); ?></a>
		                            </div>
		                    	<?php } ?>
		                    <?php endif; ?>
		                	<div class="s-schedule">
		                		<h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
		                        <span><?php echo esc_html( get_the_date( 'j F Y' ) ); ?></span>
		                	</div>
		                    <div class="second-schedule-list">
		                        <?php if (!empty($terms) || !empty( $time_start ) || !empty( $time_end ) ) { ?>
		                            <?php if ( !empty( $time_start ) || !empty( $time_end ) ) { ?> 
		                             <li><?php echo esc_html( $time_start . ' - ' . $time_end ); ?></li>
		                        	<?php } ?>
		                        <?php } ?>
		                        <p><?php echo chariton_excerpt( $settings['post_excerpt'] ); ?></p>
		                        <?php if( function_exists('acf_add_local_field_group') ): ?>
		                            <div class="event-meta">
		                                <ul>
		                                    <li><?php echo esc_html('Speaker:'); ?><span><?php echo esc_html( get_field( 'event_speaker' ) ); ?></span></li>
		                                </ul>
		                            </div>
		                    	<?php endif; ?>
		                    </div>
		                </div>
		            </div>
					<?php endwhile; wp_reset_postdata(); ?>
		        </div>
		    </div>
		    <!-- events-area-end -->

	<?php endif; endif;   //main if end
	}
}