<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Head_Two extends Widget_Base {

	public function get_name() {
		return 'section-head-two';
	}

	public function get_title() {
		return 'Section Head Two';   // title to show on chariton
	}

	public function get_icon() {
		return 'eicon-t-letter';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Section Head Two', 'chariton' ),   //section name for controler view
			]
		);

		$this->add_control(
			'section_title',
			[
				'label' => esc_html__( 'Title', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'sec_sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'background_icon_img',
			[
				'label' => esc_html__( 'Upload Before Image', 'chariton' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'chariton' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'chariton' ),
						'icon' => 'fa fa-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'chariton' ),
						'icon' => 'fa fa-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'chariton' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'text-center',
				'toggle' => true,
			]
		);
		
		$this->end_controls_section();

		//End  of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_heading',
			[
				'label' => __( 'Title Style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		/* = Title Styling
		========================================*/
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .section-title-event h2',
			]
		);

		$this->add_control(
			'title_text_color',
			[
				'label' => __( 'Text Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#242424',
				'selectors' => [
					'{{WRAPPER}} .section-title-event h2' => 'color: {{VALUE}};',
				],
			]
		);
		/* = Sub Title Styling
		========================================*/
		$this->add_control(
			'sub_hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'sub_title_heading',
			[
				'label' => __( 'Sub Title Style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_title_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .section-title-event p',
			]
		);

		$this->add_control(
			'sub_title_text_color',
			[
				'label' => __( 'Text Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#242424',
				'selectors' => [
					'{{WRAPPER}} .section-title-event p' => 'color: {{VALUE}};',
				],
			]
		);
	}
	//end of control box 

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		<div class="section-title-event <?php echo esc_attr( $settings['text_align'] ); ?>">
			<?php if (!empty($settings['section_title'])) { ?>
				 <h2> <?php echo esc_html( $settings['section_title'] ); ?></h2>
			<?php } ?>
			<?php if (!empty($settings['background_icon_img']['url'])) { ?>
				 <img src="<?php echo $settings['background_icon_img']['url']; ?>">
			<?php } ?>
			<?php if (!empty($settings['sec_sub_title'])) { ?>
	        	<p><?php echo esc_html( $settings['sec_sub_title'] ); ?></p>
	        <?php } ?>
		</div>
	<?php
	}
}