<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Portfolios extends Widget_Base {   //this name is added to plugin.php of the root folder

	public function get_name() {
		return 'section-portfolios';
	}

	public function get_title() {
		return 'Portfolios';   // title to show on elementor
	}

	public function get_icon() {
		return 'eicon-gallery-grid';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

     public function get_script_depends() {
		return [ 'chariton-elementor-editor' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	protected function register_controls() {
		
	//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'General', 'chariton' ),   //section name for controler view
			]
		);

	    $this->add_control(
	        'category',
			[
				'label' => esc_html__( 'Select Category', 'chariton' ),
				'type' => Controls_Manager::SELECT2, 
				'title' => esc_html__( 'Select a category', 'chariton' ),
				'multiple' => true,
				'options' => chariton_get_terms_dropdown_array(
					[
			   		'taxonomy' => 'portfolio_category',
			   		'hide_empty' => false,
					]
				),
			]
	    );

		$this->add_control(
			'portfolios_filter',
			[
			    'label'     => __( 'Portfolio Filter Menu', 'chariton' ),
			    'type' 		=> Controls_Manager::SELECT,
			    'default' 	=> 'no',
			    'options' 	=> [
			     	'yes' 	=> __( 'Yes', 'chariton' ),
			     	'no' 	=> __( 'No', 'chariton' ),
			    ],
			]
		);

		$this->add_control(
			'portfolios_columns',
			[
			    'label'       => __( 'Portfolio Columns Amount', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '4',
			    'options' => [
			     	'6'   => __( '2', 'chariton' ),
			     	'4'   => __( '3', 'chariton' ),
			     	'3'   => __( '4', 'chariton' ),
			    ],
			]
		);

		$this->add_control(
			'portfolios_number',
			[
				'label' => esc_html__( 'Number of Item', 'chariton' ),
				'description' => esc_html__( 'Give -1 for all posts', 'chariton' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 9,
			]
		);

		$this->add_control(
			'post_orderby',
			[
				'label' => __( 'Order by', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'date',
				'options' =>ifinger_post_orderby_options(),
			]
		);

		$this->add_control(
			'post_order',
			[
				'label' => __( 'Order', 'chariton' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'ASC' => __( 'Ascending Order', 'chariton' ),
					'DESC' => __( 'Descending', 'chariton' ),
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_filter_styling',
			[
				'label' => esc_html__( 'Filter Menu Settings', 'chariton' ),   //section name for controler view
			    'condition' => [
					'portfolios_filter' => 'yes',
				],				
			]
		);

		$this->add_control(
			'filter_menu_border_color',
			[
				'label' => __( 'Menu Border Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#eeeeee',
				'selectors' => [
					'{{WRAPPER}} .portfolios-menus' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'filter_font_color',
			[
				'label' => __( 'Menu Font Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#000d38',
				'selectors' => [
					'{{WRAPPER}} .portfolios-menus button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'filter_font_hover_color',
			[
				'label' => __( 'Filter Menu Hover Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#39bdb2',
				'selectors' => [
					'{{WRAPPER}} .portfolios-menus button:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .portfolios-menus button:hover::before' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'filter_menu_activebg_color',
			[
				'label' => __( 'Filter Menu Active BG Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#39bdb2',
				'selectors' => [
					'{{WRAPPER}} .portfolios-menus button.active' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'filter_menu_active_color',
			[
				'label' => __( 'Filter Menu Active Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .portfolios-menus button.active' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		/* = Post Styling
		========================================*/
		$this->start_controls_section(
			'portfolios_main_style',
			[
				'label' => esc_html__( 'Items', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_responsive_control(
            'portfolios_main_margin',
            [
                'label' => esc_html__('Margin', 'chariton'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', 'rem'],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 30,
                    'left' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .single-gallery-items' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_section();

		/* = Post Styling
		========================================*/
		$this->start_controls_section(
			'portfolios_title_style',
			[
				'label' => esc_html__( 'Item Hover Style', 'chariton' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		/* = Title Styling
		========================================*/
		$this->add_control(
			'portfolio_hoverbg_color',
			[
				'label' => __( 'Hover Background Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#000927',
				'selectors' => [
					'{{WRAPPER}} .single-gallery-item-icon' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'portfolio_hoverbg_opacity',
			[
				'label' => __( 'Hover Background Opacity', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'default' => '0.8',
				'selectors' => [
					'{{WRAPPER}} .single-gallery-items:hover .single-gallery-item-icon' => 'opacity: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'portfolio_hovericon_color',
			[
				'label' => __( 'Hover Icon Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .single-gallery-item-icon a' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_section();

	}

	//to show on the fontend 
	protected function render() {
		$settings = $this->get_settings_for_display();

		if( !empty( $settings['category'] ) ){
			$category = !empty( $settings['category'] ) ? $settings['category'] : 'All';
			$grid_query= null;
		    $args = array(
		       'post_type'      => 'portfolio',
		       'post_status'    => 'publish',
		       'posts_per_page' => $settings['portfolios_number'],
		       'order' 			=> $settings['post_order'],
		       'orderby' 		=> $settings['post_orderby'],
	            'tax_query'     => array(
	                 array(
	                     'taxonomy'  => 'portfolio_category',
	                     'field'     => 'id', 
	                     'terms'     => $category
	                 )
	             )
		    );
		}else{
			$grid_query= null;
		   	$args = array(
		      'post_type'      => 'portfolio',
		      'post_status'    => 'publish',
		      'posts_per_page' => $settings['portfolios_number'],
		      'order' => $settings['post_order'],
		      'orderby' => $settings['post_orderby'],
		   	);
		}

		$e_uniqid     = uniqid();
		 
		$grid_query = new \WP_Query( $args ); ?>

		<?php if ( $settings['portfolios_filter'] == 'yes' ) { ?>
			<script>
				jQuery(window).on('load', function () {
				    jQuery('.portfolios-isotope').imagesLoaded( function() {
				        // portfolio - active
				        var $grid = jQuery('.portfolios-isotope-<?php echo esc_attr( $e_uniqid ); ?>').isotope({
				            itemSelector: '.grid-item',
				            layoutMode: 'fitRows',
				            percentPosition: true,
				        })
				        // filter items on button click
				        jQuery('.portfolios-menu-<?php echo esc_attr( $e_uniqid ); ?>').on('click', 'button', function () {
				            var filterValue = jQuery(this).attr('data-filter');
				            $grid.isotope({ filter: filterValue });
				        });
				        //for menu active class
				        jQuery('.portfolios-menu-<?php echo esc_attr( $e_uniqid ); ?> button').on('click', function (event) {
				            jQuery(this).siblings('.active').removeClass('active');
				            jQuery(this).addClass('active');
				            event.preventDefault();
				        });
				    });
				});
			</script>

			<div class="row">
			    <div class="col-lg-12 text-center">
			        <div class="portfolios-menus portfolios-menu-<?php echo esc_attr( $e_uniqid ); ?> mb-50">
			            <?php 
				            $filters = get_terms( array(
					        'taxonomy' => 'portfolio_category',
					        'include' => $settings['category'],
					        'hide_empty'  => false, 
					        'orderby'  => 'include',
					      	) );
					      	if (!empty($filters)) { ?>
					      	<button class="active" data-filter="*"><?php echo esc_html_e('All', 'chariton') ?></button>
				            <?php if ( $filters && ! is_wp_error( $filters ) ) {
				              foreach ($filters as $filter) {
				                echo "<button class=\"button\" data-filter=\".$filter->slug\">$filter->name</button>";
				              }
				            }
				            ?>
			            <?php } ?>
			        </div>
			    </div>
			</div>
		<?php } ?>

		<div class="row portfolios-isotope-<?php echo esc_attr($e_uniqid); ?>">
			<?php while ( $grid_query->have_posts() ) : $grid_query->the_post();
				global $post;
			    $terms = get_the_terms(get_the_ID(), 'portfolio_category' );          
		        if ( $terms && ! is_wp_error( $terms ) ) {
		            $draught_links = array();
		            foreach ( $terms as $term ) {
		                $draught_links[] = $term->slug;
		                $term_link = get_term_link( $term );
		            }        
		        	$cat_slug = join( " ", $draught_links );
		        }
				$thumb_url = get_the_post_thumbnail_url(get_the_ID(),'full');
				?>
				<div class="col-lg-<?php echo esc_attr( $settings['portfolios_columns'] );?> col-md-6 grid-item <?php echo esc_attr( $cat_slug ); ?>">
					<?php if( has_post_thumbnail() ) : ?>
						<div class="single-gallery-items">
							<div class="single-gallery-items-thumb">
								<?php the_post_thumbnail('chariton-portfolio-740-800');?>
							</div>
							<div class="single-gallery-item-icon"><a href="<?php echo esc_url( $thumb_url );?>"><i class="fa fa-camera"></i></a></div>
						</div>
					<?php endif; ?>
				</div>
			<?php endwhile; wp_reset_postdata(); ?>
		</div>
	<?php
	}
}