<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Services extends Widget_Base {   //this name is added to plugin.php of the root folder

	public function get_name() {
		return 'section-service';
	}

	public function get_title() {
		return 'Service Post';   // title to show on elementor
	}

	public function get_icon() {
		return 'fal fa-business-time';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

    public function get_script_depends() {
		return [ 'chariton-section-service' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_layouts',
			[
				'label' => esc_html__( 'Design Layout', 'chariton' ),   //section name for controler view
			]
		);

		$this->add_control(
			'service_styles',
			[
			    'label'       => __( 'Select Style', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'options' => [
			     	'1' => __( 'Style 1', 'chariton' ),
			     	'2'  => __( 'Style 2', 'chariton' ),
			    ],
			    'default' => '1',
			]
		);

		$this->end_controls_section();

		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Service Post Query', 'chariton' ),   //section name for controler view
			]
		);
	
		$this->add_control(
			'post_number',
			[
				'label' => esc_html__( 'Number of Item', 'chariton' ),
				'description' => esc_html__( 'Give -1 for all post', 'chariton' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 4,
			]
		);

		$this->add_control(
            'orderby',
            [
                'label' => esc_html__( 'Order By', 'chariton' ),
                'type' => Controls_Manager::SELECT,
                'options' => ifinger_post_orderby_options(),
                'default' => 'rand',

            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__( 'Order', 'chariton' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => 'Ascending',
                    'DESC' => 'Descending'
                ],
                'default' => 'DESC',
            ]
        );

		$this->add_control(
			'post_columns',
			[
			    'label'       => __( 'Columns', 'chariton' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '4',
			    'options' => [
			     	'6' => __( '2', 'chariton' ),
			     	'4' => __( '3', 'chariton' ),
			     	'3' => __( '4', 'chariton' ),
			    ],
			]
		);
		
		$this->add_control(
		  'gatter',
		  [
		     'label'       => __( 'Column gap around ?', 'chariton' ),
		     'type' => Controls_Manager::SWITCHER,
		     'default' => '',
			 'label_on' => __( 'Yes', 'chariton' ),
			 'label_off' => __( 'No', 'chariton' ),
			 'return_value' => '1',
		  ]
		);

        $this->add_control(
            'tp_post_content',
            [
                'label' => __('Content', 'chariton'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'chariton'),
                'label_off' => __('Hide', 'chariton'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $this->add_control(
            'post_excerpt',
            [
                'label' => __('Content Limit', 'chariton'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '15',
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'tp_post_content' => 'yes'
                ]
            ]
        );

		$this->add_control(
			'service_animation',
			[
				'label' => __( 'Item Animation', 'chariton' ),
				'type' => Controls_Manager::ANIMATION,
				'prefix_class' => 'animated ',
			]
		);

        $this->add_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'chariton' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'chariton' ),
						'icon' => 'fa fa-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'chariton' ),
						'icon' => 'fa fa-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'chariton' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'text-center',
				'toggle' => true,
			]
		);

		$this->end_controls_section();
	}


	protected function render() {				//to show on the fontend 
		$settings = $this->get_settings_for_display();

		$text_align        = $settings['text_align'];
		$service_animation = $settings['service_animation'];

		$grid_query= null;
	    $args = array(
	       'post_type'      => 'service',
	       'post_status'    => 'publish',
	       'orderby' => $settings['orderby'],
	       'order' => $settings['order'],
	       'posts_per_page' => $settings['post_number'],
	    );

		if($settings['gatter'] == 1){
	    	$gutters = 'no-gutters';
	    	$bottom_margin = 'mb-30';
		} else {
		    $gutters = '';
		    $bottom_margin = '';
		}

		$grid_query = new \WP_Query( $args );

		if ( $grid_query->have_posts() ) : ?>

			<div class="row <?php echo esc_attr( $gutters ); ?> features-wrapper">
				<?php while ( $grid_query->have_posts() ) : $grid_query->the_post(); 
					global $post; 

				    $service_info = get_post_meta( get_the_ID(), '_ifinger_service', true );

				    if (!empty($service_info['service_custom_class'])) {
				      $service_custom_class = $service_info['service_custom_class'];
				    } else {
				      $service_custom_class = '';
				    }
				    if (!empty($service_info['service_icon_type'])) {
				      $service_icon_type = $service_info['service_icon_type'];
				    } else {
				      $service_icon_type = '';
				    }
				    if (!empty($service_info['service_icon_img'])) {
				      	$icon_img_id = $service_info['service_icon_img'];
				      	$attachment = wp_get_attachment_image_src( $icon_img_id, 'full' );
						$icon_img    = ($attachment) ? $attachment[0] : $icon_img_id;
				    } else {
				      $icon_img = '';
				    }
				    if (!empty($service_info['service_icon_font'])) {
				      $service_icon_font = '<i class="'. esc_attr( $service_info['service_icon_font'] ).'"></i>';
				    } else {
				      $service_icon_font = '';
			    	}

			    	$style_class = $bottom_margin.' '.$text_align. ' '.$service_custom_class;
			  	?>
			    <div class="col-lg-<?php echo esc_attr( $settings['post_columns'] ); ?> col-md-6 wow <?php echo esc_attr( $service_animation ); ?>" >
			    	<?php if ( $settings['service_styles'] == '1' ) { ?>
				        <div class="single-features <?php echo esc_attr( $style_class ); ?>">
				        	<?php if ( !empty($icon_img) || !empty($service_icon_font)) { ?>
				            <div class="features-icon mb-45">
				            	<?php if ( $service_icon_type == 'image_icon' ) { ?>
				                <img src="<?php echo esc_url( $icon_img ); ?>" alt="<?php esc_attr_e( 'icon', 'chariton' ); ?>">
				            	<?php } else {
				            		echo $service_icon_font;
				            	} ?>
				            </div>
				            <?php } ?>
				            <div class="features-content">
				                <h2><?php the_title(); ?></h2>
	                            <?php if (!empty($settings['tp_post_content'])) :
	                                $post_excerpt = (!empty($settings['post_excerpt'])) ? $settings['post_excerpt'] : '';
	                            ?>
	                                <p><?php print wp_trim_words(get_the_excerpt(get_the_ID()), $post_excerpt, ''); ?></p>
	                            <?php endif; ?>
				                <a href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read More', 'chariton' ); ?></a>
				            </div>
				        </div>
			        <?php } elseif ( $settings['service_styles'] == '2' ) { ?>
				        <div class="single-features s-single-features <?php echo esc_attr( $style_class ); ?>">
			                <div class="s-features-head mb-30">
			                	<?php if ( !empty($icon_img) || !empty($service_icon_font)) { ?>
			                    <div class="s-features-icon">
			                        <?php if ( $service_icon_type == 'image_icon' ) { ?>
					                <img src="<?php echo esc_url( $icon_img ); ?>" alt="<?php esc_attr_e( 'icon', 'chariton' ); ?>">
					            	<?php } else {
					            		echo $service_icon_font;
					            	} ?>
			                    </div>
			                    <?php } ?>
			                    <h3><?php the_title(); ?></h3>
			                </div>
			                <div class="features-content">
	                            <?php if (!empty($settings['tp_post_content'])) :
	                                $post_excerpt = (!empty($settings['post_excerpt'])) ? $settings['post_excerpt'] : '';
	                            ?>
	                                <p><?php print wp_trim_words(get_the_excerpt(get_the_ID()), $post_excerpt, ''); ?></p>
	                            <?php endif; ?>
			                    <a href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read More', 'chariton' ); ?></a>
			               	</div>
			            </div>
			        <?php } else { ?>
						<div class="single-features <?php echo esc_attr( $style_class ); ?>">
				        	<?php if ( !empty($icon_img) || !empty($service_icon_font)) { ?>
				            <div class="features-icon mb-45">
				            	<?php if ( $service_icon_type == 'image_icon' ) { ?>
				                <img src="<?php echo esc_url( $icon_img ); ?>" alt="<?php esc_attr_e( 'icon', 'chariton' ); ?>">
				            	<?php } else {
				            		echo $service_icon_font;
				            	} ?>
				            </div>
				            <?php } ?>
				            <div class="features-content">
				                <h2><?php the_title(); ?></h2>
	                            <?php if (!empty($settings['tp_post_content'])) :
	                                $post_excerpt = (!empty($settings['post_excerpt'])) ? $settings['post_excerpt'] : '';
	                            ?>
	                                <p><?php print wp_trim_words(get_the_excerpt(get_the_ID()), $post_excerpt, ''); ?></p>
	                            <?php endif; ?>
				                <a href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read More', 'chariton' ); ?></a>
				            </div>
				        </div>
			        <?php } ?>
			    </div>
				<?php endwhile; wp_reset_postdata(); ?>
			</div>

		<?php 
		endif;   //main if end
	}
}