<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Single_Contact extends Widget_Base {

	public function get_name() {
		return 'single-contact';
	}

	public function get_title() {
		return 'Single Contact';   // title to show on chariton
	}

	public function get_icon() {
		return 'fal fa-id-card-alt';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Single Contact', 'chariton' ),   //section name for controler view
			]
		);

		$this->add_control(
			'contact_icon_img',
			[
				'label' => esc_html__( 'Icon Image', 'chariton' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);

		$this->add_control(
			'contact_icon_font',
			[
				'label' => esc_html__( 'Font Icon', 'chariton' ),
				'type' => Controls_Manager::ICON,
				'label_block' => true,
			]
		);

		$this->add_control(
			'contact_title',
			[
				'label' => esc_html__( 'Contact Title', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'contact_text',
			[
				'label' => esc_html__( 'Contact Text', 'chariton' ),
				'type' => Controls_Manager::WYSIWYG,
				'default' => __( 'Contact text here', 'chariton' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'chariton' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'chariton' ),
						'icon' => 'fa fa-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'chariton' ),
						'icon' => 'fa fa-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'chariton' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'text-center',
				'toggle' => true,
			]
		);		
		
		$this->end_controls_section();

		//End of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'full_item_style',
			[
				'label' => __( 'Full item style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'item_bg_color',
			[
				'label' => __( 'Background Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-contact-box' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_margin_arround',
			[
				'label' => __( 'Margin', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .single-contact-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'item_padding_arround',
			[
				'label' => __( 'Padding', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .single-contact-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'item_border_radious',
			[
				'label' => __( 'Border radius', 'chariton' ),
				'type' => Controls_Manager::SLIDER,
				'deafult' => '',
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .single-contact-box' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'item_hb_color',
			[
				'label' => __( 'Hover Border Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-contact-box::before' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .single-contact-box::after' => 'border-color: {{VALUE}};',
				],
			]
		);

		/* = Icon or image style = */
		$this->add_control(
			'image_style',
			[
				'label' => __( 'Image style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'image_size',
			[
				'label' => __( 'Image Size', 'chariton' ),
				'type' => Controls_Manager::SLIDER,
				'deafult' => '',
				'range' => [
					'px' => [
						'min' => 30,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .contact-icon img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'icon_style',
			[
				'label' => __( 'Icon style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => __( 'Icon Size', 'chariton' ),
				'type' => Controls_Manager::SLIDER,
				'deafult' => '',
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .contact-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'icon_color',
			[
				'label' => __( 'Icon Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-icon i' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_box_color',
			[
				'label' => __( 'Icon background color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-icon i' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'icon_box_width',
			[
				'label' => __( 'Icon box width', 'chariton' ),
				'type' => Controls_Manager::SLIDER,
				'deafult' => '',
				'range' => [
					'px' => [
						'min' => 20,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .contact-icon i' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'icon_box_height',
			[
				'label' => __( 'Icon box height', 'chariton' ),
				'type' => Controls_Manager::SLIDER,
				'deafult' => '',
				'range' => [
					'px' => [
						'min' => 20,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .contact-icon i' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'icon_box_lineheight',
			[
				'label' => __( 'Icon box line height', 'chariton' ),
				'type' => Controls_Manager::SLIDER,
				'deafult' => '',
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .contact-icon i' => 'line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		/* = Title style = */
		$this->add_control(
			'title_hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'title_style',
			[
				'label' => __( 'Title style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __( 'Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-info h4' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .contact-info h4',
			]
		);

		/* = Description style = */
		$this->add_control(
			'desc_hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'desc_style',
			[
				'label' => __( 'Text style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'desc_color',
			[
				'label' => __( 'Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-info span' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .contact-info span',
			]
		);
		

	}
	//end of control box 

	protected function render() {
		// Retrieve settings for display
		$settings = $this->get_settings_for_display();
		
		// Extract settings with fallbacks
		$contact_icon_font = !empty($settings['contact_icon_font']) ? esc_attr($settings['contact_icon_font']) : '';
		$contact_icon_img = !empty($settings['contact_icon_img']['url']) ? esc_url($settings['contact_icon_img']['url']) : '';
		$contact_text = !empty($settings['contact_text']) ? wp_kses_stripslashes($settings['contact_text']) : '';
		$contact_title = !empty($settings['contact_title']) ? wp_kses_stripslashes($settings['contact_title']) : '';

		// Add inline editing attributes for title and text
		$this->add_inline_editing_attributes('contact_title', 'none');
		$this->add_inline_editing_attributes('contact_text', 'basic');

		?>

		<div class="single-contact-box <?php echo esc_attr($settings['text_align'] ?? ''); ?>">
			<div class="contact-icon">
				<?php if ($contact_icon_img): ?>
					<img src="<?php echo $contact_icon_img; ?>" alt="<?php esc_attr_e('Contact icon', 'chariton'); ?>">
				<?php endif; ?>
				<i class="<?php echo $contact_icon_font; ?>"></i>
			</div>
			<div class="contact-info">
				<h4 <?php echo $this->get_render_attribute_string('contact_title'); ?>>
					<?php echo $contact_title; ?>
				</h4>
				<div class="contact-text" <?php echo $this->get_render_attribute_string('contact_text'); ?>>
					<?php echo $contact_text; ?>
				</div>
			</div>
		</div>

		<?php
	}

	protected function content_template() {
	    ?>
	    <#
	    var iconImgUrl = settings.contact_icon_img.url || '';
	    var iconFontClass = settings.contact_icon_font || '';
	    var contactTitle = settings.contact_title || '';
	    var contactText = settings.contact_text || '';
	    var textAlign = settings.text_align || 'left';
	    #>
	    
	    <div class="single-contact-box {{ textAlign }}">
	        <div class="contact-icon">
	            <# if (iconImgUrl) { #>
	                <img src="{{ iconImgUrl }}" alt="{{ settings.contact_icon_img.alt || 'Contact Icon' }}">
	            <# } #>
	            <i class="{{ iconFontClass }}"></i>
	        </div>
	        <div class="contact-info">
	            <h4 class="contact-title">{{{ contactTitle }}}</h4>
	            <div class="contact-text">{{{ contactText }}}</div>
	        </div>
	    </div>
	    <?php
	}

}