<?php
namespace Chariton\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Single_Team extends Widget_Base {

	public function get_name() {
		return 'single-team';
	}

	public function get_title() {
		return 'Single Team';   // title to show on chariton
	}

	public function get_icon() {
		return 'fal fa-user-cog'; // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'chariton-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Single Team', 'chariton' ),   //section name for controler view
			]
		);

		$this->add_control(
			'team_style',
			[
			    'label'   => __( 'Team Style', 'chariton' ),
			    'type'    => Controls_Manager::SELECT,
			    'default' => '1',
			    'options' => [
			     	'1'   => __( 'Style 1', 'chariton' ),
			     	'2'   => __( 'Style 2', 'chariton' ),
			     	'3'   => __( 'Style 3', 'chariton' ),
			    ],
			]
		);

		$this->add_control(
			'team_img',
			[
				'label' => esc_html__( 'Team Image', 'chariton' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);

		$this->add_control(
			'team_name',
			[
				'label' => esc_html__( 'Name', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

        $this->add_control(
            'tp_btn_link_type',
            [
                'label' => esc_html__('Member Link Type', 'chariton'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '2',
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tp_btn_link',
            [
                'label' => esc_html__('Member link', 'chariton'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('https://your-link.com', 'chariton'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'condition' => [
                    'tp_btn_link_type' => '1',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'tp_btn_page_link',
            [
                'label' => esc_html__('Select Member Page', 'chariton'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => team_posts_options(),
                'condition' => [
                    'tp_btn_link_type' => '2',
                ]
            ]
        );

		$this->add_control(
			'team_desi',
			[
				'label' => esc_html__( 'Team Designation', 'chariton' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'team_desc',
			[
				'label' => esc_html__( 'Team Description', 'chariton' ),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'condition' => [
					'team_style' => '1',
				],
			]
		);

		$this->add_control(
			'team_social',
			[
				'label' => __( 'Team Social', 'chariton' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name' => 'social_icon',
						'label' => __( 'Social Icon', 'chariton' ),
						'type' => Controls_Manager::ICON,
					],
					[
						'name' => 'social_link',
						'label' => __( 'Social Link', 'chariton' ),
						'type' => Controls_Manager::TEXT,
						'default' => __( '#', 'chariton' ),
						'label_block' => true,
					],
				],
				'title_field' => '{{{ social_link }}}',
			]
		);

		$this->add_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'chariton' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'chariton' ),
						'icon' => 'fa fa-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'chariton' ),
						'icon' => 'fa fa-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'chariton' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'text-center',
				'toggle' => true,
			]
		);

		$this->add_control(
			'active_member',
			[
				'label' => __( 'Active On?', 'chariton' ),
				'type'  => Controls_Manager::SWITCHER,
				'on'    => __( 'On', 'chariton' ),
				'off' 	=> __( 'Off', 'chariton' ),
				'return_value' => 'yes',
				'default'   => 'off',
				'condition' => [
					'team_style' => '1',
				],
			]
		);

		$this->end_controls_section();

		/* = Add Item Styling
		========================================*/
		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'chariton' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'full_item_style',
			[
				'label' => __( 'Text Part Style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'item_bg_color',
			[
				'label' => __( 'Background Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-team-member .team-content' => 'background: {{VALUE}};',
					'{{WRAPPER}} .inner-single-team .inner-team-content' => 'background: {{VALUE}};',
					'{{WRAPPER}} .inner-single-team .inner-team-content::before' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_font_color',
			[
				'label' => __( 'Font Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .inner-team-content, .inner-team-content h3 a:hover, .inner-team-content span, .inner-team-social a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_padding_arround',
			[
				'label' => __( 'Padding', 'chariton' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .inner-team-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		/* = Title style = */
		$this->add_control(
			'title_style',
			[
				'label' => __( 'Name Style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __( 'Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .inner-team-content h3 a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .single-team-member .team-content h3 a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .inner-single-team-item .team-info h3 a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .single-team-member .team-content h3 a, .inner-team-content h3 a, .inner-single-team-item .team-info h3 a',
			]
		);

		/* = Designation style = */
		$this->add_control(
			'desig_style',
			[
				'label' => __( 'Designation Style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'desig_color',
			[
				'label' => __( 'Designation Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-team-member .team-content .team_desi' => 'color: {{VALUE}};',
					'{{WRAPPER}} .inner-single-team-item .team-info .position' => 'color: {{VALUE}};',
					'{{WRAPPER}} .inner-single-team .inner-team-content .team_desi' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'desig_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .single-team-member .team-content .team_desi, .inner-single-team-item .team-info .position, .inner-single-team .inner-team-content .team_desi',
			]
		);

		/* = Content style = */
		$this->add_control(
			'cont_style',
			[
				'label' => __( 'Content Style', 'chariton' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'cont_color',
			[
				'label' => __( 'Content Color', 'chariton' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-team-member .team-content p.team_desc' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'cont_typography',
				'label' => __( 'Typography', 'chariton' ),
				'selector' => '{{WRAPPER}} .single-team-member .team-content p.team_desc',
			]
		);
		
	}
	//end of control box 

	protected function render() {			//to show on the fontend

		$settings = $this->get_settings_for_display();


		$text_align 	= $settings['text_align'];
		$team_social 	= $settings['team_social'];
		$team_img 		= $settings['team_img']['url'];
		$team_name 		= $settings['team_name'];
		$team_desi 		= $settings['team_desi'];
		$team_desc 		= $settings['team_desc'];

		$img_id = attachment_url_to_postid( $team_img );
		$attachment_title = get_the_title($img_id);
		$attachment_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

		if (!empty($attachment_alt)) {
			$alt = $attachment_alt;
		} elseif (!empty($attachment_title)) {
			$alt = $attachment_title;
		} else {
			$alt = __( 'Team Picture', 'chariton' );
		}

        // Link
        if ('2' == $settings['tp_btn_link_type']) {
            $this->add_render_attribute('team_name', 'href', get_permalink($settings['tp_btn_page_link']));
            $this->add_render_attribute('team_name', 'target', '_self');
            $this->add_render_attribute('team_name', 'rel', 'nofollow');
        } else {
            if (!empty($settings['tp_btn_link']['url'])) {
                $this->add_link_attributes('team_name', $settings['tp_btn_link']);
            }
        }

		if ( $settings['team_style'] == 1 ) {
			$active_member = $settings['active_member'];
			if ($active_member == 'yes') {
				$active_class = 'active';
			} else {
				$active_class = '';
			}
			?>

			<div class="single-team-member <?php echo esc_attr ( $active_class. ' '.$text_align ); ?>">
	        	<?php if ( !empty( $team_img ) ) : ?>
		            <div class="team-img">
		               <img src="<?php echo esc_attr( $team_img ); ?>" alt="<?php echo esc_attr( $alt ); ?>">
		            </div>
	            <?php endif; ?>
	            <div class="team-content">
	            	<h3><a <?php echo $this->get_render_attribute_string('team_name'); ?>><?php echo wp_kses_stripslashes( $team_name ); ?></a></h3>
	                <?php if ( !empty( $team_desi ) ) : ?>
	                	<span class="team_desi"><?php echo $team_desi; ?></span>
	            	<?php endif; ?>
	                <div class="team-overlay">
		                <?php if ( !empty( $team_desc ) ) : ?>
		                	<p class="team_desc"><?php echo $team_desc; ?></p>
		            	<?php endif; ?>
	                    <?php if ( is_array($team_social ) ) : ?>
		                    <div class="team-social">
		                    	<?php foreach ( $team_social as $key => $value ) : ?>
		                        	<a href="<?php echo esc_url($value['social_link']); ?>"><i class="<?php echo esc_attr($value['social_icon']); ?>"></i></a>
		                        <?php endforeach; ?>
		                    </div>
	                	<?php endif; ?>
	                </div>
	            </div>
	        </div>
		<?php } elseif ( $settings['team_style'] == 3 ) { ?>
	        <div class="inner-single-team-item">
	        	<?php if (!empty($team_img)) : ?>
	            	<img src="<?php echo esc_attr( $team_img ); ?>" alt="<?php echo esc_attr( $alt ); ?>">
	            <?php endif; ?>
	            <div class="team-info">
	                <h3><a <?php echo $this->get_render_attribute_string('team_name'); ?>><?php echo wp_kses_stripslashes( $team_name ); ?></a></h3>
	                <?php if ( !empty( $team_desi ) ) : ?>
	                <span class="position"><?php echo $team_desi; ?></span>
	                <?php endif; ?>
	            </div>
	            <?php if (is_array($team_social)) : ?>
		            <ul class="socials">
		            	<?php foreach ($team_social as $key => $value) : ?>
		                <li><a href="<?php echo esc_url($value['social_link']); ?>"><i class="<?php echo esc_attr($value['social_icon']); ?>"></i></a></li>
		            	<?php endforeach; ?>
		            </ul>
	            <?php endif; ?>
	        </div>
		<?php } else { ?>
	        <div class="inner-single-team mb-30 <?php echo esc_attr( $text_align ); ?>">
	            <?php if ( !empty( $team_img ) ) : ?>
		            <div class="team-img">
		                <img src="<?php echo esc_attr( $team_img ); ?>" alt="<?php echo esc_attr_e( 'img', 'chariton' ); ?>">
		            </div>
	            <?php endif; ?>
	            <div class="inner-team-content">
	                <h3><a <?php echo $this->get_render_attribute_string('team_name'); ?>><?php echo wp_kses_stripslashes( $team_name ); ?></a></h3>

	                <?php if ( !empty( $team_desi ) ) : ?>
	                	<span class="team_desi"><?php echo $team_desi; ?></span>
	            	<?php endif; ?>

	                <?php if ( is_array( $team_social ) ) : ?>
		                <div class="inner-team-social">
		                    <?php foreach ( $team_social as $key => $value ) : ?>
		                    	<a href="<?php echo esc_url( $value['social_link'] ); ?>"><i class="<?php echo esc_attr( $value['social_icon'] ); ?>"></i></a>
		                    <?php endforeach; ?>
		                </div>
	                <?php endif; ?>
	            </div>
	        </div>
		<?php
		}
	}	
}